/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.strategy;

import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MaxGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MeanGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.MinGlobalStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.PropertiesStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SumGlobalStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.AbstractJanusGraphMixedIndexAggStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphStepStrategy;

public class JanusGraphMixedIndexAggStrategy
extends AbstractJanusGraphMixedIndexAggStrategy {
    private static final JanusGraphMixedIndexAggStrategy INSTANCE = new JanusGraphMixedIndexAggStrategy();
    private static final Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> PRIORS = Collections.singleton(JanusGraphStepStrategy.class);

    private JanusGraphMixedIndexAggStrategy() {
    }

    @Override
    protected Aggregation getAggregation(GraphStep originalGraphStep) {
        String[] propertyKeys;
        Step currentStep = originalGraphStep.getNextStep();
        while (this.isEligibleToSkip(currentStep)) {
            currentStep = currentStep.getNextStep();
        }
        if (currentStep instanceof PropertiesStep && (propertyKeys = ((PropertiesStep)currentStep).getPropertyKeys()).length == 1) {
            String fieldName = propertyKeys[0];
            currentStep = currentStep.getNextStep();
            while (this.isEligibleToSkip(currentStep)) {
                currentStep = currentStep.getNextStep();
            }
            if (currentStep instanceof MaxGlobalStep) {
                return Aggregation.MAX(fieldName);
            }
            if (currentStep instanceof MinGlobalStep) {
                return Aggregation.MIN(fieldName);
            }
            if (currentStep instanceof MeanGlobalStep) {
                return Aggregation.AVG(fieldName);
            }
            if (currentStep instanceof SumGlobalStep) {
                return Aggregation.SUM(fieldName);
            }
        }
        return null;
    }

    public static JanusGraphMixedIndexAggStrategy instance() {
        return INSTANCE;
    }

    public Set<Class<? extends TraversalStrategy.ProviderOptimizationStrategy>> applyPrior() {
        return PRIORS;
    }
}

