/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.BaseTransactionConfigurable;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexInformation;
import org.janusgraph.diskstorage.indexing.IndexMutation;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.graphdb.tinkerpop.optimize.step.Aggregation;

public interface IndexProvider
extends IndexInformation {
    public static final char REPLACEMENT_CHAR = '\u2022';

    public static void checkKeyValidity(String key) {
        Preconditions.checkArgument((!StringUtils.containsAny((CharSequence)key, (char[])new char[]{'\u2022'}) ? 1 : 0) != 0, (String)"Invalid key name containing reserved character %c provided: %s", (char)'\u2022', (Object)key);
    }

    public void register(String var1, String var2, KeyInformation var3, BaseTransaction var4) throws BackendException;

    public void mutate(Map<String, Map<String, IndexMutation>> var1, KeyInformation.IndexRetriever var2, BaseTransaction var3) throws BackendException;

    public void restore(Map<String, Map<String, List<IndexEntry>>> var1, KeyInformation.IndexRetriever var2, BaseTransaction var3) throws BackendException;

    public Number queryAggregation(IndexQuery var1, KeyInformation.IndexRetriever var2, BaseTransaction var3, Aggregation var4) throws BackendException;

    public Stream<String> query(IndexQuery var1, KeyInformation.IndexRetriever var2, BaseTransaction var3) throws BackendException;

    public Stream<RawQuery.Result<String>> query(RawQuery var1, KeyInformation.IndexRetriever var2, BaseTransaction var3) throws BackendException;

    public Long totals(RawQuery var1, KeyInformation.IndexRetriever var2, BaseTransaction var3) throws BackendException;

    public BaseTransactionConfigurable beginTransaction(BaseTransactionConfig var1) throws BackendException;

    public void close() throws BackendException;

    public void clearStorage() throws BackendException;

    public void clearStore(String var1) throws BackendException;

    public boolean exists() throws BackendException;
}

