/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import java.util.HashSet;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.Profiling;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.EdgeVertexStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.MutableMetrics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphMultiVertexQuery;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.tinkerpop.optimize.JanusGraphTraversalUtil;
import org.janusgraph.graphdb.tinkerpop.profile.TP3ProfileWrapper;

public class JanusGraphEdgeVertexStep
extends EdgeVertexStep
implements Profiling {
    private boolean initialized = false;
    private QueryProfiler queryProfiler = QueryProfiler.NO_OP;
    private final int txVertexCacheSize;

    public JanusGraphEdgeVertexStep(EdgeVertexStep originalStep, int txVertexCacheSize) {
        super(originalStep.getTraversal(), originalStep.getDirection());
        originalStep.getLabels().forEach(arg_0 -> ((JanusGraphEdgeVertexStep)this).addLabel(arg_0));
        this.txVertexCacheSize = txVertexCacheSize;
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        if (!this.starts.hasNext()) {
            throw FastNoSuchElementException.instance();
        }
        if (this.txVertexCacheSize < 2) {
            return;
        }
        ArrayList<Traverser.Admin> edges = new ArrayList<Traverser.Admin>();
        HashSet<Vertex> vertices = new HashSet<Vertex>();
        do {
            Traverser.Admin e = this.starts.next();
            edges.add(e);
            if (vertices.size() >= this.txVertexCacheSize) continue;
            if (Direction.IN.equals((Object)this.direction)) {
                vertices.add(((Edge)e.get()).inVertex());
                continue;
            }
            if (Direction.OUT.equals((Object)this.direction)) {
                vertices.add(((Edge)e.get()).outVertex());
                continue;
            }
            if (!Direction.BOTH.equals((Object)this.direction)) continue;
            vertices.add(((Edge)e.get()).inVertex());
            vertices.add(((Edge)e.get()).outVertex());
        } while (this.starts.hasNext());
        if (vertices.size() > 1) {
            JanusGraphMultiVertexQuery<? extends JanusGraphMultiVertexQuery> multiQuery = JanusGraphTraversalUtil.getTx(this.traversal).multiQuery(new JanusGraphVertex[0]);
            ((BasicVertexCentricQueryBuilder)((Object)multiQuery)).profiler(this.queryProfiler);
            multiQuery.addAllVertices(vertices).preFetch();
        }
        this.starts.add(edges.iterator());
    }

    protected Traverser.Admin<Vertex> processNextStart() {
        if (!this.initialized) {
            this.initialize();
        }
        return super.processNextStart();
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public JanusGraphEdgeVertexStep clone() {
        JanusGraphEdgeVertexStep clone = (JanusGraphEdgeVertexStep)super.clone();
        clone.initialized = false;
        return clone;
    }

    public void setMetrics(MutableMetrics metrics) {
        this.queryProfiler = new TP3ProfileWrapper(metrics);
    }
}

