/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.Callable;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendOperation {
    private static final Logger log = LoggerFactory.getLogger(BackendOperation.class);
    private static final Random random = new Random();
    private static final Duration BASE_REATTEMPT_TIME = Duration.ofMillis(50L);
    private static final double PERTURBATION_PERCENTAGE = 0.2;

    private static Duration pertubTime(Duration duration) {
        Duration newDuration = duration.dividedBy((int)(2.0 / (1.0 + (random.nextDouble() * 2.0 - 1.0) * 0.2)));
        assert (!duration.isZero()) : duration;
        return newDuration;
    }

    public static <V> V execute(Callable<V> exe, Duration totalWaitTime) throws JanusGraphException {
        try {
            return BackendOperation.executeDirect(exe, totalWaitTime);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not execute operation due to backend exception", e);
        }
    }

    public static <V> V executeDirect(Callable<V> exe, Duration totalWaitTime) throws BackendException {
        Preconditions.checkArgument((!totalWaitTime.isZero() ? 1 : 0) != 0, (String)"Need to specify a positive waitTime: %s", (Object)totalWaitTime);
        long maxTime = System.currentTimeMillis() + totalWaitTime.toMillis();
        Duration waitTime = BackendOperation.pertubTime(BASE_REATTEMPT_TIME);
        while (true) {
            try {
                return exe.call();
            }
            catch (Throwable e) {
                Throwable ex = e;
                BackendException storeEx = null;
                do {
                    if (!(ex instanceof BackendException)) continue;
                    storeEx = (BackendException)ex;
                } while ((ex = ex.getCause()) != null);
                if (storeEx == null || !(storeEx instanceof TemporaryBackendException)) {
                    if (e instanceof BackendException) {
                        throw (BackendException)e;
                    }
                    throw new PermanentBackendException("Permanent exception while executing backend operation " + exe.toString(), e);
                }
                BackendException lastException = storeEx;
                assert (lastException != null);
                if (System.currentTimeMillis() + waitTime.toMillis() < maxTime) {
                    log.info("Temporary exception during backend operation [" + exe.toString() + "]. Attempting backoff retry.", (Throwable)lastException);
                    try {
                        Thread.sleep(waitTime.toMillis());
                    }
                    catch (InterruptedException r) {
                        Thread.currentThread().interrupt();
                        throw new PermanentBackendException("Interrupted while waiting to retry failed backend operation", r);
                    }
                    waitTime = BackendOperation.pertubTime(waitTime.multipliedBy(2L));
                    continue;
                }
                throw new TemporaryBackendException("Could not successfully complete backend operation due to repeated temporary exceptions after " + totalWaitTime, lastException);
            }
            break;
        }
    }

    public static <R> R execute(Transactional<R> exe, TransactionalProvider provider, TimestampProvider times) throws BackendException {
        StoreTransaction txh = null;
        try {
            txh = provider.openTx();
            if (!txh.getConfiguration().hasCommitTime()) {
                txh.getConfiguration().setCommitTime(times.getTime());
            }
            R r = exe.call(txh);
            return r;
        }
        catch (BackendException e) {
            if (txh != null) {
                txh.rollback();
            }
            txh = null;
            throw e;
        }
        finally {
            if (txh != null) {
                txh.commit();
            }
        }
    }

    public static <R> R execute(final Transactional<R> exe, final TransactionalProvider provider, final TimestampProvider times, Duration maxTime) throws JanusGraphException {
        return (R)BackendOperation.execute(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return BackendOperation.execute(exe, provider, times);
            }

            public String toString() {
                return exe.toString();
            }
        }, maxTime);
    }

    public static interface TransactionalProvider {
        public StoreTransaction openTx() throws BackendException;

        public void close() throws BackendException;
    }

    public static interface Transactional<R> {
        public R call(StoreTransaction var1) throws BackendException;
    }
}

