/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.io.File;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.apache.tinkerpop.gremlin.structure.Transaction;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class BerkeleyInterruptionTest {
    @Test
    public void interruptedEnvironmentShouldBeRestarted(@TempDir File dir) {
        try (JanusGraph graph = JanusGraphFactory.open((String)("berkeleyje:" + dir.getAbsolutePath()));){
            Assertions.assertThrows(JanusGraphException.class, () -> {
                Transaction tx = graph.tx();
                GraphTraversalSource gtx = (GraphTraversalSource)tx.begin();
                gtx.addV().iterate();
                Thread.currentThread().interrupt();
                tx.commit();
            });
            while (true) {
                try {
                    graph.traversal().addV().iterate();
                }
                catch (TraversalInterruptedException traversalInterruptedException) {
                    continue;
                }
                break;
            }
            Assertions.assertEquals((long)1L, (Long)((Long)graph.traversal().V(new Object[0]).count().next()));
        }
    }
}

