/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.berkeleyje;

import com.google.common.base.Preconditions;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.List;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.common.AbstractStoreTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyJETx
extends AbstractStoreTransaction {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJETx.class);
    private volatile Transaction tx;
    private volatile boolean isOpen;
    private final List<Cursor> openCursors = new ArrayList<Cursor>();
    private final LockMode lockMode;
    private final CacheMode cacheMode;

    public BerkeleyJETx(Transaction t, LockMode lockMode, CacheMode cacheMode, BaseTransactionConfig config) {
        super(config);
        this.tx = t;
        this.lockMode = lockMode;
        this.cacheMode = cacheMode;
        this.isOpen = true;
        Preconditions.checkNotNull((Object)this.lockMode);
    }

    public Transaction getTransaction() {
        return this.tx;
    }

    Cursor openCursor(Database db) throws BackendException {
        List<Cursor> list = this.openCursors;
        synchronized (list) {
            if (!this.isOpen) {
                throw new PermanentBackendException("Transaction already closed");
            }
            try {
                Cursor cursor = db.openCursor(this.tx, null);
                this.openCursors.add(cursor);
                return cursor;
            }
            catch (ThreadInterruptedException e) {
                Thread.currentThread().interrupt();
                throw (TraversalInterruptedException)new TraversalInterruptedException().initCause((Throwable)e);
            }
            catch (EnvironmentFailureException e) {
                throw new TemporaryBackendException((Throwable)e);
            }
            catch (DatabaseException e) {
                throw new PermanentBackendException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeCursor(Cursor cursor) throws BackendException {
        List<Cursor> list = this.openCursors;
        synchronized (list) {
            try {
                cursor.close();
            }
            catch (ThreadInterruptedException e) {
                Thread.currentThread().interrupt();
                throw (TraversalInterruptedException)new TraversalInterruptedException().initCause((Throwable)e);
            }
            catch (EnvironmentFailureException e) {
                throw new TemporaryBackendException((Throwable)e);
            }
            catch (DatabaseException e) {
                throw new PermanentBackendException((Throwable)e);
            }
            finally {
                this.openCursors.remove(cursor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOpenCursors() {
        List<Cursor> list = this.openCursors;
        synchronized (list) {
            this.openCursors.forEach(Cursor::close);
        }
    }

    CacheMode getCacheMode() {
        return this.cacheMode;
    }

    LockMode getLockMode() {
        return this.lockMode;
    }

    public synchronized void rollback() throws BackendException {
        super.rollback();
        if (this.tx == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("{} rolled back", (Object)this, (Object)new TransactionClose(this.toString()));
        }
        try {
            this.isOpen = false;
            this.closeOpenCursors();
            this.tx.abort();
            this.tx = null;
        }
        catch (ThreadInterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (EnvironmentFailureException e) {
        }
        catch (IllegalStateException e) {
            if (!e.getMessage().equals("Database was closed.") && !e.getMessage().equals("Environment is closed.")) {
                throw e;
            }
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public synchronized void commit() throws BackendException {
        super.commit();
        if (this.tx == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("{} committed", (Object)this, (Object)new TransactionClose(this.toString()));
        }
        try {
            this.isOpen = false;
            this.closeOpenCursors();
            this.tx.commit();
            this.tx = null;
        }
        catch (ThreadInterruptedException e) {
            Thread.currentThread().interrupt();
            throw (TraversalInterruptedException)new TraversalInterruptedException().initCause((Throwable)e);
        }
        catch (EnvironmentFailureException e) {
            throw new TemporaryBackendException((Throwable)e);
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException((Throwable)e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + (null == this.tx ? "nulltx" : this.tx.toString());
    }

    private static class TransactionClose
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TransactionClose(String msg) {
            super(msg);
        }
    }
}

