/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.berkeleyje;

import com.google.common.base.Preconditions;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalInterruptedException;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.PermanentBackendException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.TemporaryBackendException;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJEKeyValueStore;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJETx;
import org.janusgraph.diskstorage.common.LocalStoreManager;
import org.janusgraph.diskstorage.configuration.ConfigNamespace;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.MergedConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StandardStoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KVMutation;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.KeyValueEntry;
import org.janusgraph.diskstorage.keycolumnvalue.keyvalue.OrderedKeyValueStoreManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.PreInitializeConfigOptions;
import org.janusgraph.graphdb.transaction.TransactionConfiguration;
import org.janusgraph.util.system.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreInitializeConfigOptions
public class BerkeleyJEStoreManager
extends LocalStoreManager
implements OrderedKeyValueStoreManager {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyJEStoreManager.class);
    public static final ConfigNamespace BERKELEY_NS = new ConfigNamespace(GraphDatabaseConfiguration.STORAGE_NS, "berkeleyje", "BerkeleyDB JE configuration options");
    public static final ConfigOption<Integer> JVM_CACHE = new ConfigOption(BERKELEY_NS, "cache-percentage", "Percentage of JVM heap reserved for BerkeleyJE's cache", ConfigOption.Type.MASKABLE, (Object)65, ConfigOption.positiveInt());
    public static final ConfigOption<Boolean> SHARED_CACHE = new ConfigOption(BERKELEY_NS, "shared-cache", "If true, the shared cache is used for all graph instances", ConfigOption.Type.MASKABLE, (Object)true);
    public static final ConfigOption<String> LOCK_MODE = new ConfigOption(BERKELEY_NS, "lock-mode", "The BDB record lock mode used for read operations", ConfigOption.Type.MASKABLE, String.class, (Object)LockMode.DEFAULT.toString(), ConfigOption.disallowEmpty(String.class));
    public static final ConfigOption<String> CACHE_MODE = new ConfigOption(BERKELEY_NS, "cache-mode", "Modes that can be specified for control over caching of records in the JE in-memory cache", ConfigOption.Type.MASKABLE, String.class, (Object)CacheMode.DEFAULT.toString(), ConfigOption.disallowEmpty(String.class));
    public static final ConfigOption<String> ISOLATION_LEVEL = new ConfigOption(BERKELEY_NS, "isolation-level", "The isolation level used by transactions", ConfigOption.Type.MASKABLE, String.class, (Object)IsolationLevel.REPEATABLE_READ.toString(), ConfigOption.disallowEmpty(String.class));
    private final ConcurrentMap<String, BerkeleyJEKeyValueStore> stores = new ConcurrentHashMap<String, BerkeleyJEKeyValueStore>();
    protected volatile Environment environment;
    protected final StoreFeatures features;
    private static final Transaction NULL_TRANSACTION = null;

    public BerkeleyJEStoreManager(Configuration configuration) throws BackendException {
        super(configuration);
        this.initialize();
        this.features = new StandardStoreFeatures.Builder().orderedScan(true).transactional(this.transactional).keyConsistent((Configuration)GraphDatabaseConfiguration.buildGraphConfiguration()).locking(true).keyOrdered(true).scanTxConfig((Configuration)GraphDatabaseConfiguration.buildGraphConfiguration().set(ISOLATION_LEVEL, (Object)IsolationLevel.READ_UNCOMMITTED.toString(), new String[0])).supportsInterruption(true).cellTTL(true).optimisticLocking(false).build();
    }

    private synchronized void initialize() throws BackendException {
        try {
            if (this.environment != null && this.environment.isValid()) {
                return;
            }
            this.close(true);
            int cachePercent = (Integer)this.storageConfig.get(JVM_CACHE, new String[0]);
            boolean sharedCache = (Boolean)this.storageConfig.get(SHARED_CACHE, new String[0]);
            CacheMode cacheMode = (CacheMode)ConfigOption.getEnumValue((String)((String)this.storageConfig.get(CACHE_MODE, new String[0])), CacheMode.class);
            EnvironmentConfig envConfig = new EnvironmentConfig();
            envConfig.setAllowCreate(true);
            envConfig.setTransactional(this.transactional);
            envConfig.setCachePercent(cachePercent);
            envConfig.setSharedCache(sharedCache);
            envConfig.setCacheMode(cacheMode);
            if (this.batchLoading) {
                envConfig.setConfigParam("je.env.runCheckpointer", "false");
                envConfig.setConfigParam("je.env.runCleaner", "false");
            }
            this.environment = new Environment(this.directory, envConfig);
            for (String storeName : this.stores.keySet()) {
                this.openDatabase(storeName, true);
            }
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException("Error during BerkeleyJE initialization: ", (Throwable)e);
        }
    }

    private synchronized void reInitialize(DatabaseException exception) throws BackendException {
        this.initialize();
        if (exception instanceof ThreadInterruptedException) {
            Thread.currentThread().interrupt();
            throw (TraversalInterruptedException)new TraversalInterruptedException().initCause((Throwable)exception);
        }
    }

    public StoreFeatures getFeatures() {
        return this.features;
    }

    public List<KeyRange> getLocalKeyPartition() throws BackendException {
        throw new UnsupportedOperationException();
    }

    private BerkeleyJETx beginTransaction(BaseTransactionConfig txCfg, boolean retryEnvironmentFailure) throws BackendException {
        try {
            Transaction tx = null;
            MergedConfiguration effectiveCfg = new MergedConfiguration(txCfg.getCustomOptions(), this.getStorageConfig());
            if (this.transactional) {
                TransactionConfig txnConfig = new TransactionConfig();
                ((IsolationLevel)ConfigOption.getEnumValue((String)((String)effectiveCfg.get(ISOLATION_LEVEL, new String[0])), IsolationLevel.class)).configure(txnConfig);
                tx = this.environment.beginTransaction(null, txnConfig);
            } else if (txCfg instanceof TransactionConfiguration && !((TransactionConfiguration)txCfg).isSingleThreaded()) {
                throw new PermanentBackendException("BerkeleyJE does not support non-transactional for multi threaded tx");
            }
            BerkeleyJETx btx = new BerkeleyJETx(tx, (LockMode)ConfigOption.getEnumValue((String)((String)effectiveCfg.get(LOCK_MODE, new String[0])), LockMode.class), (CacheMode)ConfigOption.getEnumValue((String)((String)effectiveCfg.get(CACHE_MODE, new String[0])), CacheMode.class), txCfg);
            if (log.isTraceEnabled()) {
                log.trace("Berkeley tx created", (Throwable)new TransactionBegin(btx.toString()));
            }
            return btx;
        }
        catch (EnvironmentFailureException e) {
            this.reInitialize((DatabaseException)((Object)e));
            if (retryEnvironmentFailure) {
                return this.beginTransaction(txCfg, false);
            }
            throw new TemporaryBackendException("Could not start BerkeleyJE transaction", (Throwable)e);
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException("Could not start BerkeleyJE transaction", (Throwable)e);
        }
    }

    public BerkeleyJETx beginTransaction(BaseTransactionConfig txCfg) throws BackendException {
        return this.beginTransaction(txCfg, true);
    }

    private BerkeleyJEKeyValueStore openDatabase(String name, boolean force, boolean retryEnvironmentFailure) throws BackendException {
        Preconditions.checkNotNull((Object)name);
        if (this.stores.containsKey(name) && !force) {
            return (BerkeleyJEKeyValueStore)this.stores.get(name);
        }
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(false);
            dbConfig.setAllowCreate(true);
            dbConfig.setTransactional(this.transactional);
            dbConfig.setKeyPrefixing(true);
            if (this.batchLoading) {
                dbConfig.setDeferredWrite(true);
            }
            Database db = this.environment.openDatabase(null, name, dbConfig);
            log.debug("Opened database {}", (Object)name);
            BerkeleyJEKeyValueStore store = new BerkeleyJEKeyValueStore(name, db, this);
            if (this.stores.containsKey(name)) {
                ((BerkeleyJEKeyValueStore)this.stores.get(name)).reopen(db);
            } else {
                this.stores.put(name, store);
            }
            return store;
        }
        catch (EnvironmentFailureException e) {
            this.reInitialize((DatabaseException)((Object)e));
            if (retryEnvironmentFailure) {
                return this.openDatabase(name, force, false);
            }
            throw new TemporaryBackendException("Could not open BerkeleyJE data store", (Throwable)e);
        }
        catch (DatabaseException e) {
            throw new PermanentBackendException("Could not open BerkeleyJE data store", (Throwable)e);
        }
    }

    private BerkeleyJEKeyValueStore openDatabase(String name, boolean force) throws BackendException {
        return this.openDatabase(name, force, true);
    }

    public BerkeleyJEKeyValueStore openDatabase(String name) throws BackendException {
        return this.openDatabase(name, false, true);
    }

    public void mutateMany(Map<String, KVMutation> mutations, StoreTransaction txh) throws BackendException {
        for (Map.Entry<String, KVMutation> mutation : mutations.entrySet()) {
            BerkeleyJEKeyValueStore store = this.openDatabase(mutation.getKey());
            KVMutation mutationValue = mutation.getValue();
            if (!mutationValue.hasAdditions() && !mutationValue.hasDeletions()) {
                log.debug("Empty mutation set for {}, doing nothing", (Object)mutation.getKey());
            } else {
                log.debug("Mutating {}", (Object)mutation.getKey());
            }
            if (mutationValue.hasAdditions()) {
                for (KeyValueEntry entry : mutationValue.getAdditions()) {
                    store.insert(entry.getKey(), entry.getValue(), txh, entry.getTtl());
                    log.trace("Insertion on {}: {}", (Object)mutation.getKey(), (Object)entry);
                }
            }
            if (!mutationValue.hasDeletions()) continue;
            for (StaticBuffer del : mutationValue.getDeletions()) {
                store.delete(del, txh);
                log.trace("Deletion on {}: {}", (Object)mutation.getKey(), (Object)del);
            }
        }
    }

    void removeDatabase(BerkeleyJEKeyValueStore db) {
        if (!this.stores.containsKey(db.getName())) {
            throw new IllegalArgumentException("Tried to remove an unknown database from the storage manager");
        }
        String name = db.getName();
        this.stores.remove(name);
        log.debug("Removed database {}", (Object)name);
    }

    public void close(boolean force) throws BackendException {
        if (this.environment != null) {
            if (!force && !this.stores.isEmpty()) {
                throw new IllegalStateException("Cannot shutdown manager since some databases are still open");
            }
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            try {
                this.environment.close();
            }
            catch (DatabaseException e) {
                throw new PermanentBackendException("Could not close BerkeleyJE database", (Throwable)e);
            }
        }
    }

    public void close() throws BackendException {
        this.close(false);
    }

    public void clearStorage() throws BackendException {
        if (!this.stores.isEmpty()) {
            throw new IllegalStateException("Cannot delete store, since database is open: " + this.stores.keySet());
        }
        for (String db : this.environment.getDatabaseNames()) {
            this.environment.removeDatabase(NULL_TRANSACTION, db);
            log.debug("Removed database {} (clearStorage)", (Object)db);
        }
        this.close();
        IOUtils.deleteFromDirectory((File)this.directory);
    }

    public boolean exists() throws BackendException {
        return !this.environment.getDatabaseNames().isEmpty();
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ":" + this.directory.toString();
    }

    private static class TransactionBegin
    extends Exception {
        private static final long serialVersionUID = 1L;

        private TransactionBegin(String msg) {
            super(msg);
        }
    }

    public static enum IsolationLevel {
        READ_UNCOMMITTED{

            @Override
            void configure(TransactionConfig cfg) {
                cfg.setReadUncommitted(true);
            }
        }
        ,
        READ_COMMITTED{

            @Override
            void configure(TransactionConfig cfg) {
                cfg.setReadCommitted(true);
            }
        }
        ,
        REPEATABLE_READ{

            @Override
            void configure(TransactionConfig cfg) {
            }
        }
        ,
        SERIALIZABLE{

            @Override
            void configure(TransactionConfig cfg) {
                cfg.setSerializableIsolation(true);
            }
        };


        abstract void configure(TransactionConfig var1);
    }
}

