/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.sleepycat.je.dbi.CursorImpl;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class BerkeleyTransactionTest {
    BerkeleyTransactionTest() {
    }

    @Test
    void longRunningTxShouldBeRolledBack(@TempDir File dir) throws InterruptedException {
        JanusGraph graph = JanusGraphFactory.open((String)("berkeleyje:" + dir.getAbsolutePath()));
        GraphTraversalSource traversal = graph.traversal();
        for (int i = 0; i < 10; ++i) {
            traversal.addV().property((Object)"a", (Object)"2", new Object[0]).next();
        }
        traversal.tx().commit();
        GraphTraversalSource g = graph.tx().createThreadedTx().traversal();
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> g.V(new Object[0]).has("a", (Object)"2").sideEffect(ignored -> {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).toList());
        Thread.sleep(100L);
        g.tx().rollback();
        graph.close();
        Assertions.assertThrows(ExecutionException.class, future::get);
    }

    static {
        ClassLoader.getSystemClassLoader().setClassAssertionStatus(CursorImpl.class.getName(), false);
    }
}

