/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookAdapter;
import java.time.Instant;
import org.janusgraph.StorageSetup;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJEKeyValueStore;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class BerkeleyStorageSetup
extends StorageSetup {
    public static ModifiableConfiguration getBerkeleyJEConfiguration(String dir) {
        return GraphDatabaseConfiguration.buildGraphConfiguration().set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"berkeleyje", new String[0]).set(GraphDatabaseConfiguration.STORAGE_DIRECTORY, (Object)dir, new String[0]).set(GraphDatabaseConfiguration.DROP_ON_CLEAR, (Object)false, new String[0]);
    }

    public static ModifiableConfiguration getBerkeleyJEConfiguration() {
        return BerkeleyStorageSetup.getBerkeleyJEConfiguration(BerkeleyStorageSetup.getHomeDir((String)"berkeleyje"));
    }

    public static WriteConfiguration getBerkeleyJEGraphConfiguration() {
        return BerkeleyStorageSetup.getBerkeleyJEConfiguration().getConfiguration();
    }

    public static ModifiableConfiguration getBerkeleyJEPerformanceConfiguration() {
        return BerkeleyStorageSetup.getBerkeleyJEConfiguration().set(GraphDatabaseConfiguration.STORAGE_TRANSACTIONAL, (Object)false, new String[0]).set(GraphDatabaseConfiguration.TX_CACHE_SIZE, (Object)1000, new String[0]);
    }

    static {
        BerkeleyJEKeyValueStore.ttlConverter = ttl -> ttl;
        TTL.setTimeTestHook((TestHook)new TestHookAdapter<Long>(){
            private static final long SECONDS_PER_HOUR = 3600L;
            private final long initial = Instant.now().toEpochMilli();

            public synchronized Long getHookValue() {
                long delta = Instant.now().toEpochMilli() - this.initial;
                return this.initial + delta * 3600L;
            }
        });
    }
}

