/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.blueprints;

import java.time.Duration;
import java.util.Set;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.janusgraph.BerkeleyStorageSetup;
import org.janusgraph.StorageSetup;
import org.janusgraph.blueprints.AbstractJanusGraphComputerProvider;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJETx;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.olap.computer.FulgoraGraphComputer;

@GraphProvider.Descriptor(computer=FulgoraGraphComputer.class)
public class BerkeleyGraphComputerProvider
extends AbstractJanusGraphComputerProvider {
    public ModifiableConfiguration getJanusGraphConfiguration(String graphName, Class<?> test, String testMethodName) {
        ModifiableConfiguration config = super.getJanusGraphConfiguration(graphName, test, testMethodName);
        config.setAll(BerkeleyStorageSetup.getBerkeleyJEConfiguration(StorageSetup.getHomeDir((String)graphName)).getAll());
        config.set(GraphDatabaseConfiguration.IDAUTHORITY_WAIT, (Object)Duration.ofMillis(20L), new String[0]);
        return config;
    }

    public Set<Class> getImplementations() {
        Set implementations = super.getImplementations();
        implementations.add(BerkeleyJETx.class);
        return implementations;
    }
}

