/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.berkeleyje;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.janusgraph.BerkeleyStorageSetup;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.berkeleyje.BerkeleyJEStoreManager;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.JanusGraphTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BerkeleyGraphTest
extends JanusGraphTest {
    private static final Logger log = LoggerFactory.getLogger(BerkeleyGraphTest.class);

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration modifiableConfiguration = BerkeleyStorageSetup.getBerkeleyJEConfiguration();
        String methodName = this.testInfo.getTestMethod().toString();
        if (methodName.equals("testConsistencyEnforcement")) {
            BerkeleyJEStoreManager.IsolationLevel iso = BerkeleyJEStoreManager.IsolationLevel.SERIALIZABLE;
            log.debug("Forcing isolation level {} for test method {}", (Object)iso, (Object)methodName);
            modifiableConfiguration.set(BerkeleyJEStoreManager.ISOLATION_LEVEL, (Object)iso.toString(), new String[0]);
        } else {
            BerkeleyJEStoreManager.IsolationLevel iso = null;
            if (modifiableConfiguration.has(BerkeleyJEStoreManager.ISOLATION_LEVEL, new String[0])) {
                iso = (BerkeleyJEStoreManager.IsolationLevel)ConfigOption.getEnumValue((String)((String)modifiableConfiguration.get(BerkeleyJEStoreManager.ISOLATION_LEVEL, new String[0])), BerkeleyJEStoreManager.IsolationLevel.class);
            }
            log.debug("Using isolation level {} (null means adapter default) for test method {}", iso, (Object)methodName);
        }
        return modifiableConfiguration.getConfiguration();
    }

    public void testClearStorage() throws Exception {
        this.tearDown();
        this.config.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.DROP_ON_CLEAR, (String[])new String[0]), (Object)true);
        Backend backend = BerkeleyGraphTest.getBackend((WriteConfiguration)this.config, (boolean)false);
        Assertions.assertTrue((boolean)backend.getStoreManager().exists(), (String)"graph should exist before clearing storage");
        BerkeleyGraphTest.clearGraph((WriteConfiguration)this.config);
        backend.close();
        backend = BerkeleyGraphTest.getBackend((WriteConfiguration)this.config, (boolean)false);
        Assertions.assertFalse((boolean)backend.getStoreManager().exists(), (String)"graph should not exist after clearing storage");
        backend.close();
    }

    @Test
    public void testVertexCentricQuerySmall() {
        this.testVertexCentricQuery(1450);
    }

    public void testConsistencyEnforcement() {
        BerkeleyJEStoreManager.IsolationLevel effective = (BerkeleyJEStoreManager.IsolationLevel)ConfigOption.getEnumValue((String)((String)this.config.get(ConfigElement.getPath((ConfigElement)BerkeleyJEStoreManager.ISOLATION_LEVEL, (String[])new String[0]), String.class)), BerkeleyJEStoreManager.IsolationLevel.class);
        Preconditions.checkState((boolean)BerkeleyJEStoreManager.IsolationLevel.SERIALIZABLE.equals((Object)effective));
        super.testConsistencyEnforcement();
    }

    public void testEdgeTTLTiming() throws Exception {
    }

    public void testEdgeTTLWithTransactions() throws Exception {
    }

    public void testUnsettingTTL() throws InterruptedException {
    }

    public void testVertexTTLWithCompositeIndex() throws Exception {
    }

    public void testConcurrentConsistencyEnforcement() {
    }

    @Disabled(value="Unable to run on GitHub Actions.")
    @Test
    public void testIDBlockAllocationTimeout() throws BackendException {
        this.config.set("ids.authority.wait-time", (Object)Duration.of(0L, ChronoUnit.NANOS));
        this.config.set("ids.renew-timeout", (Object)Duration.of(1L, ChronoUnit.MILLIS));
        this.close();
        JanusGraphFactory.drop((JanusGraph)this.graph);
        this.open(this.config);
        Assertions.assertThrows(JanusGraphException.class, () -> this.graph.addVertex(new Object[0]));
        Assertions.assertTrue((boolean)this.graph.isOpen());
        this.close();
        this.open(this.config);
        Assertions.assertEquals((long)0L, (long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
    }
}

