/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.janusgraph.diskstorage.util.backpressure.PassAllQueryBackPressure;
import org.janusgraph.diskstorage.util.backpressure.QueryBackPressure;
import org.janusgraph.diskstorage.util.backpressure.SemaphoreProtectedReleaseQueryBackPressure;
import org.janusgraph.diskstorage.util.backpressure.SemaphoreQueryBackPressure;
import org.janusgraph.util.system.ExecuteUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class BackPressureBenchmark {
    @Param(value={"2000", "1000", "100", "10", "4", "2", "1"})
    int threads;
    @Param(value={"50000", "10000", "1000", "100"})
    int backPressure;
    @Param(value={"semaphoreReleaseProtectedBackPressureWithReleasesAwait", "semaphoreReleaseProtectedBackPressureWithoutReleasesAwait", "semaphoreBackPressure", "passAllBackPressure"})
    String type;
    private QueryBackPressure queryBackPressure;
    private ExecutorService queriesAcquireService;
    private ExecutorService queriesReleaseService;
    private boolean closeBackPressure;
    private Semaphore acquireJobsSemaphore;

    @Setup(value=Level.Invocation)
    public void setup() {
        this.acquireJobsSemaphore = new Semaphore(0);
        this.queriesAcquireService = Executors.newFixedThreadPool(this.threads);
        this.queriesReleaseService = Executors.newFixedThreadPool(this.threads);
        switch (this.type) {
            case "semaphoreReleaseProtectedBackPressureWithReleasesAwait": {
                this.queryBackPressure = new SemaphoreProtectedReleaseQueryBackPressure(this.backPressure);
                this.closeBackPressure = true;
                break;
            }
            case "semaphoreReleaseProtectedBackPressureWithoutReleasesAwait": {
                this.queryBackPressure = new SemaphoreProtectedReleaseQueryBackPressure(this.backPressure);
                this.closeBackPressure = false;
                break;
            }
            case "semaphoreBackPressure": {
                this.queryBackPressure = new SemaphoreQueryBackPressure(this.backPressure);
                this.closeBackPressure = false;
                break;
            }
            case "passAllBackPressure": {
                this.queryBackPressure = new PassAllQueryBackPressure();
                this.closeBackPressure = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("No implementation found to type = " + this.type);
            }
        }
        for (int j = 0; j < this.backPressure; ++j) {
            this.queryBackPressure.acquireBeforeQuery();
            this.acquireJobsSemaphore.release();
        }
        for (int i = 0; i < this.threads; ++i) {
            this.queriesAcquireService.submit(() -> {
                this.queryBackPressure.acquireBeforeQuery();
                this.acquireJobsSemaphore.release();
            });
        }
    }

    @Benchmark
    public void releaseBlocked() {
        for (int i = 0; i < this.threads; ++i) {
            this.queriesReleaseService.submit(() -> {
                try {
                    this.acquireJobsSemaphore.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.queryBackPressure.releaseAfterQuery();
            });
        }
        ExecuteUtil.gracefulExecutorServiceShutdown((ExecutorService)this.queriesReleaseService, (long)Long.MAX_VALUE);
        if (this.closeBackPressure) {
            this.queryBackPressure.close();
        }
    }

    @TearDown(value=Level.Invocation)
    public void clearResources() {
        ExecuteUtil.gracefulExecutorServiceShutdown((ExecutorService)this.queriesAcquireService, (long)Long.MAX_VALUE);
        this.queryBackPressure.close();
        System.gc();
    }
}

