/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryDropStepStrategyMode;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CQLMultiQueryDropBenchmark {
    @Param(value={"5000"})
    int verticesAmount;
    @Param(value={"true", "false"})
    boolean isMultiDrop;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"cql", new String[0]);
        config.set(CQLConfigOptions.LOCAL_DATACENTER, (Object)"dc1", new String[0]);
        config.set(GraphDatabaseConfiguration.USE_MULTIQUERY, (Object)true, new String[0]);
        config.set(GraphDatabaseConfiguration.DROP_STEP_BATCH_MODE, (Object)MultiQueryDropStepStrategyMode.NONE.getConfigName(), new String[0]);
        return config.getConfiguration();
    }

    @Setup
    public void setUp() throws Exception {
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        JanusGraphManagement mgmt = this.graph.openManagement();
        mgmt.makePropertyKey("id").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey nameProp = mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        mgmt.makePropertyKey("details").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        mgmt.buildIndex("nameIndex", Vertex.class).addKey(nameProp).buildCompositeIndex();
        mgmt.commit();
        this.addVertices();
    }

    @TearDown
    public void tearDown() throws BackendException {
        JanusGraphFactory.drop((JanusGraph)this.graph);
    }

    @Benchmark
    public Integer dropVertices() {
        Integer dropCount;
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        if (this.isMultiDrop) {
            List vertices = tx.traversal().V(new Object[0]).has("name", (Object)"name_test").toList().stream().map(v -> (JanusGraphVertex)v).collect(Collectors.toList());
            dropCount = tx.multiQuery(vertices).drop().size();
        } else {
            dropCount = tx.traversal().V(new Object[0]).has("name", (Object)"name_test").drop().toList().size();
        }
        tx.rollback();
        return dropCount;
    }

    @Benchmark
    public Integer dropVerticesGremlinQuery() {
        JanusGraphTransaction tx = this.isMultiDrop ? this.graph.buildTransaction().setDropStepStrategyMode(MultiQueryDropStepStrategyMode.ALL).start() : this.graph.buildTransaction().setDropStepStrategyMode(MultiQueryDropStepStrategyMode.NONE).start();
        Integer dropCount = tx.traversal().V(new Object[0]).has("name", (Object)"name_test").drop().toList().size();
        tx.rollback();
        return dropCount;
    }

    private void addVertices() {
        for (int i = 0; i < this.verticesAmount; ++i) {
            JanusGraphVertex vertex = this.graph.addVertex(new Object[]{"id", i});
            vertex.property("name", (Object)"name_test");
            vertex.property("details", (Object)("details_" + i));
        }
        this.graph.tx().commit();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(CQLMultiQueryDropBenchmark.class.getSimpleName()).warmupIterations(3).measurementIterations(10).build();
        new Runner(options).run();
    }
}

