/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CQLCompositeIndexInlinePropBenchmark {
    @Param(value={"5000"})
    int verticesAmount;
    @Param(value={"true", "false"})
    boolean isInlined;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"cql", new String[0]);
        config.set(CQLConfigOptions.LOCAL_DATACENTER, (Object)"dc1", new String[0]);
        return config.getConfiguration();
    }

    @Setup
    public void setUp() throws Exception {
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        JanusGraphManagement mgmt = this.graph.openManagement();
        PropertyKey idProp = mgmt.makePropertyKey("id").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey cityProp = mgmt.makePropertyKey("city").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey nameProp = mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        mgmt.makePropertyKey("details").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        JanusGraphManagement.IndexBuilder indexBuilder = mgmt.buildIndex("cityIndex", Vertex.class).addKey(cityProp);
        if (this.isInlined) {
            indexBuilder.addInlinePropertyKey(nameProp).addInlinePropertyKey(idProp);
        }
        indexBuilder.buildCompositeIndex();
        mgmt.commit();
        this.addVertices();
    }

    @TearDown
    public void tearDown() throws BackendException {
        JanusGraphFactory.drop((JanusGraph)this.graph);
    }

    @Benchmark
    public Integer searchVertices() {
        JanusGraphTransaction tx = this.graph.buildTransaction().propertyPrefetching(!this.isInlined).start();
        List names = tx.traversal().V(new Object[0]).has("city", (Object)"Toulouse").toList().stream().map(v -> v.value("id").toString() + ":" + v.value("name").toString()).collect(Collectors.toList());
        tx.rollback();
        return names.size();
    }

    private void addVertices() {
        for (int i = 0; i < this.verticesAmount; ++i) {
            JanusGraphVertex vertex = this.graph.addVertex(new Object[]{"id", i});
            vertex.property("name", (Object)("name_test_" + i));
            vertex.property("city", (Object)"Toulouse");
            vertex.property("details", (Object)("details_" + i));
        }
        this.graph.tx().commit();
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(CQLCompositeIndexInlinePropBenchmark.class.getSimpleName()).warmupIterations(3).measurementIterations(10).build();
        new Runner(options).run();
    }
}

