/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryPropertiesStrategyMode;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CQLMultiQueryMultiSlicesBenchmark {
    @Param(value={"5000", "50000"})
    int verticesAmount;
    @Param(value={"true", "false"})
    boolean propertyCardinalitySingle;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"cql", new String[0]);
        config.set(CQLConfigOptions.LOCAL_DATACENTER, (Object)"dc1", new String[0]);
        config.set(GraphDatabaseConfiguration.USE_MULTIQUERY, (Object)true, new String[0]);
        config.set(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (Object)MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), new String[0]);
        config.set(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (Object)false, new String[0]);
        return config.getConfiguration();
    }

    @Setup
    public void setUp() throws Exception {
        int i;
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        int propertiesAmount = 10;
        JanusGraphManagement mgmt = this.graph.openManagement();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).make();
        for (i = 0; i < propertiesAmount; ++i) {
            mgmt.makePropertyKey("prop" + i).dataType(String.class).cardinality(this.propertyCardinalitySingle ? Cardinality.SINGLE : Cardinality.LIST).make();
        }
        mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        mgmt.commit();
        for (i = 0; i < this.verticesAmount; ++i) {
            JanusGraphVertex vertex = this.graph.addVertex(new Object[]{"name", "testVertex"});
            for (int j = 0; j < propertiesAmount; ++j) {
                vertex.property("prop" + j, (Object)("SomeTestPropertyValue " + j + " 0123456789 ABCDEFG"));
            }
        }
        this.graph.tx().commit();
    }

    @TearDown
    public void tearDown() throws BackendException {
        JanusGraphFactory.drop((JanusGraph)this.graph);
    }

    @Benchmark
    public List<? extends Object> getValuesMultiplePropertiesWithAllMultiQuerySlicesUnderMaxRequestsPerConnection() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).barrier((Integer)CQLConfigOptions.MAX_REQUESTS_PER_CONNECTION.getDefaultValue() / 10 - 2).values(new String[]{"prop0", "prop1", "prop2", "prop3", "prop4", "prop5", "prop6", "prop7", "prop8", "prop9"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValuesMultiplePropertiesWithUnlimitedBatch() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).barrier(Integer.MAX_VALUE).values(new String[]{"prop0", "prop1", "prop2", "prop3", "prop4", "prop5", "prop6", "prop7", "prop8", "prop9"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValuesMultiplePropertiesWithSmallBatch() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).barrier(10).values(new String[]{"prop0", "prop1", "prop2", "prop3", "prop4", "prop5", "prop6", "prop7", "prop8", "prop9"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValuesThreePropertiesWithAllMultiQuerySlicesUnderMaxRequestsPerConnection() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).barrier(100).values(new String[]{"prop1", "prop3", "prop8"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValuesAllPropertiesWithAllMultiQuerySlicesUnderMaxRequestsPerConnection() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).barrier((Integer)CQLConfigOptions.MAX_REQUESTS_PER_CONNECTION.getDefaultValue() / 10 - 2).values(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValuesAllPropertiesWithUnlimitedBatch() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).barrier(Integer.MAX_VALUE).values(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> vertexCentricPropertiesFetching() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List vertices = this.toVerticesTraversal(tx).toList();
        ArrayList result = new ArrayList(vertices.size() * 10);
        for (Vertex vertex : vertices) {
            vertex.properties(new String[]{"prop0", "prop1", "prop2", "prop3", "prop4", "prop5", "prop6", "prop7", "prop8", "prop9"}).forEachRemaining(property -> result.add(property.value()));
        }
        tx.rollback();
        return result;
    }

    private GraphTraversal<Vertex, Vertex> toVerticesTraversal(JanusGraphTransaction tx) {
        return tx.traversal().V(new Object[0]).has("name", (Object)"testVertex");
    }
}

