/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.util.ByteBufferUtil;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.diskstorage.util.StaticArrayEntryList;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.Throughput})
@State(value=Scope.Benchmark)
@Fork(jvmArgsAppend={"-Xmx1G"})
public class StaticArrayEntryListBenchmark {
    List<Entry> entries = new ArrayList<Entry>();
    @Param(value={"10000", "100000"})
    Integer size;
    @Param(value={"50", "1000", "5000"})
    Integer valueSize;

    @Setup
    public void setup() {
        for (int i = 0; i < this.size; ++i) {
            StaticArrayBuffer column = StaticArrayEntry.of((ByteBuffer)ByteBufferUtil.oneByteBuffer((int)20));
            StaticArrayBuffer value = StaticArrayEntry.of((ByteBuffer)ByteBufferUtil.oneByteBuffer((int)this.valueSize));
            Entry entry = StaticArrayEntry.of((StaticBuffer)column, (StaticBuffer)value);
            this.entries.add(entry);
        }
    }

    @Benchmark
    public void iterator(Blackhole bh) {
        EntryList result = StaticArrayEntryList.ofStaticBuffer(this.entries.iterator(), (StaticArrayEntry.GetColVal)StaticArrayEntry.ENTRY_GETTER);
        bh.consume((Object)result);
    }

    @Benchmark
    public void iterable(Blackhole bh) {
        EntryList result = StaticArrayEntryList.ofStaticBuffer(this.entries, (StaticArrayEntry.GetColVal)StaticArrayEntry.ENTRY_GETTER);
        bh.consume((Object)result);
    }
}

