/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CQLMultiQueryPropertiesBenchmark {
    @Param(value={"5000", "50000"})
    int verticesAmount;
    @Param(value={"true", "false"})
    boolean fastProperty;
    @Param(value={"all_properties", "required_properties_only", "none"})
    String propertiesBatchMode;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"cql", new String[0]);
        config.set(CQLConfigOptions.LOCAL_DATACENTER, (Object)"dc1", new String[0]);
        config.set(GraphDatabaseConfiguration.USE_MULTIQUERY, (Object)true, new String[0]);
        config.set(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, (Object)this.propertiesBatchMode, new String[0]);
        config.set(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (Object)this.fastProperty, new String[0]);
        return config.getConfiguration();
    }

    @Setup
    public void setUp() throws Exception {
        int i;
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        int propertiesAmount = 10;
        JanusGraphManagement mgmt = this.graph.openManagement();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).make();
        for (i = 0; i < propertiesAmount; ++i) {
            mgmt.makePropertyKey("prop" + i).dataType(String.class).make();
        }
        mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        mgmt.commit();
        for (i = 0; i < this.verticesAmount; ++i) {
            JanusGraphVertex vertex = this.graph.addVertex(new Object[]{"name", "testVertex"});
            for (int j = 0; j < propertiesAmount; ++j) {
                vertex.property("prop" + j, (Object)("SomeTestPropertyValue " + j + " 0123456789 ABCDEFG"));
            }
        }
        this.graph.tx().commit();
    }

    @TearDown
    public void tearDown() throws BackendException {
        JanusGraphFactory.drop((JanusGraph)this.graph);
    }

    @Benchmark
    public List<? extends Object> getValueMap() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).valueMap(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValueMapWithOptions() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.all).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValueMapWithOptionsLimitedOne() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.all).limit(1L).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValueMapWithOptionsLimitedBatchSizePlusOne() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.all).limit((long)((Integer)GraphDatabaseConfiguration.LIMITED_BATCH_SIZE.getDefaultValue() + 1)).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getPropertyMap() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).propertyMap(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getElementMap() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).elementMap(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValues() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).values(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getProperties() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).properties(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValueMapSingleProperty() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).valueMap(new String[]{"prop1"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getPropertyMapSingleProperty() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).propertyMap(new String[]{"prop1"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getElementMapSingleProperty() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).elementMap(new String[]{"prop1"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValuesSingleProperty() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).values(new String[]{"prop1"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getPropertiesSingleProperty() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).properties(new String[]{"prop1"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValuesMultipleProperties() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).values(new String[]{"prop1", "prop3", "prop5", "prop7", "prop9"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getValueMapMultipleProperties() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).valueMap(new String[]{"prop1", "prop3", "prop5", "prop7", "prop9"}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<? extends Object> getElementMapMultipleProperties() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = this.toVerticesTraversal(tx).elementMap(new String[]{"prop1", "prop3", "prop5", "prop7", "prop9"}).toList();
        tx.rollback();
        return result;
    }

    private GraphTraversal<Vertex, Vertex> toVerticesTraversal(JanusGraphTransaction tx) {
        return tx.traversal().V(new Object[0]).has("name", (Object)"testVertex");
    }
}

