/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Thread)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class JanusGraphSpeedBenchmark {
    @Param(value={"1000", "10000", "100000"})
    long numberOfVertices;
    public JanusGraph graph;
    private static final String START_LABEL = "startVertex";
    private static final String END_LABEL = "endVertex";
    private static final String UID_PROP = "uid";

    @Setup
    public void setup() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"inmemory", new String[0]);
        config.set(GraphDatabaseConfiguration.AUTO_TYPE, (Object)"none", new String[0]);
        config.set(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, (Object)true, new String[0]);
        this.graph = JanusGraphFactory.open((BasicConfiguration)config);
        JanusGraphManagement jgm = this.graph.openManagement();
        VertexLabel startVertex = jgm.makeVertexLabel(START_LABEL).make();
        PropertyKey uid = jgm.makePropertyKey(UID_PROP).dataType(Integer.class).make();
        jgm.buildIndex("byUid", Vertex.class).addKey(uid).indexOnly((JanusGraphSchemaType)startVertex).buildCompositeIndex();
        jgm.addProperties(startVertex, new PropertyKey[]{uid});
        VertexLabel endVertex = jgm.makeVertexLabel(END_LABEL).make();
        jgm.addProperties(endVertex, new PropertyKey[]{uid});
        EdgeLabel between = jgm.makeEdgeLabel("between").make();
        jgm.addConnection(between, startVertex, endVertex);
        jgm.commit();
        Vertex next = (Vertex)this.graph.traversal().addV(START_LABEL).property((Object)UID_PROP, (Object)1, new Object[0]).next();
        int i = 0;
        while ((long)i < this.numberOfVertices) {
            this.graph.traversal().addV(END_LABEL).property((Object)UID_PROP, (Object)i, new Object[0]).as("end", new String[0]).addE("between").to("end").from(next).iterate();
            ++i;
        }
    }

    @Benchmark
    public void basicCount() {
        if (this.numberOfVertices != (Long)this.graph.traversal().V(new Object[0]).has(START_LABEL, UID_PROP, (Object)1).out(new String[0]).count().next()) {
            throw new AssertionError();
        }
    }

    @Benchmark
    public void basicAddAndDelete() {
        GraphTraversalSource g;
        int i = 0;
        while ((long)i < this.numberOfVertices) {
            g = this.graph.traversal();
            g.addV(START_LABEL).property((Object)UID_PROP, (Object)(i + 2), new Object[0]).iterate();
            ++i;
        }
        i = 0;
        while ((long)i < this.numberOfVertices) {
            g = this.graph.traversal();
            g.V(new Object[0]).has(START_LABEL, UID_PROP, (Object)(i + 2)).iterate();
            ++i;
        }
    }

    @TearDown
    public void teardown() {
        this.graph.close();
    }
}

