/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class GraphCentricQueryBenchmark {
    @Param(value={"10000", "250000"})
    int size;
    @Param(value={"true", "false"})
    boolean useSmartLimit;
    @Param(value={"100000", "2147483647"})
    int hardMaxLimit;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"inmemory", new String[0]);
        return config.getConfiguration();
    }

    @Setup
    public void setUp() throws Exception {
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        JanusGraphManagement mgmt = this.graph.openManagement();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        mgmt.commit();
        int batchSize = Math.min(10000, this.size);
        for (int i = 0; i < this.size / batchSize; ++i) {
            for (int j = 0; j < batchSize; ++j) {
                this.graph.addVertex(new Object[]{"name", "value"});
            }
            this.graph.tx().commit();
        }
    }

    @TearDown
    public void tearDown() {
        this.graph.close();
    }

    @Benchmark
    public List<Vertex> getVertices() {
        JanusGraphTransaction tx = this.graph.buildTransaction().customOption(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ADJUST_LIMIT, (String[])new String[0]), (Object)this.useSmartLimit).customOption(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.HARD_MAX_LIMIT, (String[])new String[0]), (Object)this.hardMaxLimit).start();
        List vertices = tx.traversal().V(new Object[0]).has("name", (Object)"value").toList();
        tx.rollback();
        return vertices;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().include(GraphCentricQueryBenchmark.class.getSimpleName()).warmupIterations(10).measurementIterations(10).build();
        new Runner(options).run();
    }
}

