/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import com.datastax.oss.driver.api.testinfra.ccm.CcmBridge;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.janusgraph.BackPressureBenchmark;
import org.janusgraph.CQLMultiQueryHasStepBenchmark;
import org.janusgraph.CQLMultiQueryPropertiesBenchmark;
import org.janusgraph.StaticArrayEntryListBenchmark;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.TimeValue;

public class BenchmarkRunner {
    private static void transformResults(Collection<RunResult> results, List<Map<String, Object>> outputs) {
        HashMap<String, Double> metrics = new HashMap<String, Double>();
        for (RunResult runResult : results) {
            Result primaryResult = runResult.getPrimaryResult();
            String benchmark = runResult.getParams().getBenchmark();
            double score = primaryResult.getScore();
            String unit = primaryResult.getScoreUnit();
            if (!"ms/op".equals(unit)) {
                throw new IllegalArgumentException("Please use ms/op as measurement for benchmark " + benchmark);
            }
            metrics.put(benchmark, metrics.getOrDefault(benchmark, 0.0) + score);
        }
        for (final Map.Entry entry : metrics.entrySet()) {
            outputs.add(new HashMap(){
                {
                    this.put("name", entry.getKey());
                    this.put("value", entry.getValue());
                    this.put("unit", "ms/op");
                }
            });
        }
    }

    private static void runCqlBenchmarks(ChainedOptionsBuilder cqlBuilder, List<Map<String, Object>> outputs) throws RunnerException, InterruptedException, IOException {
        CcmBridge.Builder builder = CcmBridge.builder().withNodes(new int[]{1});
        CcmBridge bridge = builder.build();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            bridge.stop();
            bridge.remove();
        }));
        bridge.create();
        bridge.start();
        System.out.println("Cassandra version = " + bridge.getCassandraVersion());
        cqlBuilder.include("CQL.*Benchmark");
        cqlBuilder.exclude(CQLMultiQueryHasStepBenchmark.class.getSimpleName());
        cqlBuilder.exclude(CQLMultiQueryPropertiesBenchmark.class.getSimpleName());
        BenchmarkRunner.transformResults(new Runner(cqlBuilder.build()).run(), outputs);
    }

    private static ChainedOptionsBuilder getJmhBuilder() {
        return new OptionsBuilder().forks(1).measurementTime(TimeValue.seconds((long)5L)).shouldFailOnError(true).warmupIterations(2).warmupTime(TimeValue.seconds((long)1L));
    }

    public static void main(String[] args) throws RunnerException, IOException, InterruptedException {
        boolean runSpecifiedTests = args.length > 0;
        ArrayList<Map<String, Object>> outputs = new ArrayList<Map<String, Object>>();
        ChainedOptionsBuilder builder = BenchmarkRunner.getJmhBuilder();
        if (runSpecifiedTests) {
            for (String arg : args) {
                builder.include(arg);
            }
        } else {
            builder.include(".*Benchmark");
            builder.exclude(StaticArrayEntryListBenchmark.class.getSimpleName());
            builder.exclude(BackPressureBenchmark.class.getSimpleName());
            builder.exclude("CQL.*Benchmark");
        }
        Collection results = new Runner(builder.build()).run();
        BenchmarkRunner.transformResults(results, outputs);
        if (!runSpecifiedTests) {
            BenchmarkRunner.runCqlBenchmarks(BenchmarkRunner.getJmhBuilder(), outputs);
        }
        File file = new File("benchmark.json");
        ObjectMapper objectMapper = new ObjectMapper();
        String json = objectMapper.writeValueAsString(outputs);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(json);
        writer.close();
    }
}

