/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CQLMultiQueryBenchmark {
    @Param(value={"100", "500"})
    int fanoutFactor;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"cql", new String[0]);
        config.set(CQLConfigOptions.LOCAL_DATACENTER, (Object)"dc1", new String[0]);
        config.set(GraphDatabaseConfiguration.USE_MULTIQUERY, (Object)true, new String[0]);
        return config.getConfiguration();
    }

    @Setup
    public void setUp() throws Exception {
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        JanusGraphManagement mgmt = this.graph.openManagement();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).make();
        mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        mgmt.commit();
        JanusGraphVertex mostInnerSingleVertex = this.graph.addVertex(new Object[]{"name", "mostInner"});
        JanusGraphVertex mostOuter = this.graph.addVertex(new Object[]{"name", "outer"});
        for (int i = 0; i < this.fanoutFactor; ++i) {
            JanusGraphVertex otherV = this.graph.addVertex(new Object[]{"name", "middle"});
            mostOuter.addEdge("connects", (Vertex)otherV, new Object[0]);
            for (int j = 0; j < this.fanoutFactor; ++j) {
                JanusGraphVertex innerV = this.graph.addVertex(new Object[]{"name", "inner"});
                otherV.addEdge("connects", (Vertex)innerV, new Object[0]);
                innerV.addEdge("connects", (Vertex)mostInnerSingleVertex, new Object[0]);
            }
            this.graph.tx().commit();
        }
    }

    @TearDown
    public void tearDown() throws BackendException {
        JanusGraphFactory.drop((JanusGraph)this.graph);
    }

    @Benchmark
    public List<Object> getNeighborNames() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List names = tx.traversal().V(new Object[0]).has("name", (Object)"outer").out(new String[0]).out(new String[0]).values(new String[]{"name"}).toList();
        tx.rollback();
        return names;
    }

    @Benchmark
    public List<Object> getNames() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List names = tx.traversal().V(new Object[0]).has("name", (Object)"inner").values(new String[]{"name"}).toList();
        tx.rollback();
        return names;
    }

    @Benchmark
    public List<Map<String, Object>> getIdToOutVerticesProjection() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List idNameMap = tx.traversal().V(new Object[0]).has("name", (Object)"middle").project("a", new String[]{"b"}).by((Traversal)__.id()).by((Traversal)__.out((String[])new String[]{"connects"})).toList();
        tx.rollback();
        return idNameMap;
    }

    @Benchmark
    public List<Vertex> getAllElementsTraversedFromOuterVertex() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"outer").repeat((Traversal)__.out((String[])new String[]{"connects"})).emit().toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getElementsWithUsingRepeatUntilSteps() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"outer").repeat((Traversal)__.out((String[])new String[]{"connects"})).until((Traversal)__.not((Traversal)__.out((String[])new String[]{"connects"}))).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getElementsWithUsingEmitRepeatSteps() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"outer").emit((Traversal)__.in((String[])new String[]{"connects"})).repeat((Traversal)__.out((String[])new String[]{"connects"})).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getVerticesFilteredByAndStep() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"middle").and(new Traversal[]{__.out((String[])new String[]{"connects"}).count().is((Object)P.gte((Object)this.fanoutFactor)), __.hasId((P)P.neq((Object)0))}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getVerticesWithCoalesceUsage() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"middle").coalesce(new Traversal[]{__.out((String[])new String[]{"connects"}), __.identity()}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getVerticesWithDoubleUnion() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"middle").union(new Traversal[]{__.union((Traversal[])new Traversal[]{__.out((String[])new String[]{"connects"}), __.identity()}), __.identity()}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getVerticesFromMultiNestedRepeatStepStartingFromSingleVertex() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"mostInner").emit().repeat((Traversal)__.repeat((Traversal)__.in((String[])new String[]{"connects"})).until((Traversal)__.identity().loops().is(P.gt((Object)0)))).until((Traversal)__.identity().loops().is(P.gt((Object)2))).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Long> getAdjacentVerticesLocalCounts() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"inner").local((Traversal)__.in((String[])new String[]{"connects"}).count()).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<String> getLabels() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"inner").label().toList();
        tx.rollback();
        return result;
    }
}

