/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.cql.CQLConfigOptions;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@BenchmarkMode(value={Mode.AverageTime})
@Fork(value=1)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class CQLMultiQueryHasStepBenchmark {
    @Param(value={"100", "500"})
    int fanoutFactor;
    @Param(value={"true", "false"})
    boolean fastProperty;
    @Param(value={"all_properties", "required_properties_only", "required_and_next_properties", "required_and_next_properties_or_all"})
    String hasStepBatchMode;
    JanusGraph graph;

    public WriteConfiguration getConfiguration() {
        ModifiableConfiguration config = GraphDatabaseConfiguration.buildGraphConfiguration();
        config.set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"cql", new String[0]);
        config.set(CQLConfigOptions.LOCAL_DATACENTER, (Object)"dc1", new String[0]);
        config.set(GraphDatabaseConfiguration.USE_MULTIQUERY, (Object)true, new String[0]);
        config.set(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, (Object)this.hasStepBatchMode, new String[0]);
        config.set(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (Object)this.fastProperty, new String[0]);
        return config.getConfiguration();
    }

    @Setup
    public void setUp() throws Exception {
        this.graph = JanusGraphFactory.open((ReadConfiguration)this.getConfiguration());
        int additionalPropertiesAmount = 5;
        JanusGraphManagement mgmt = this.graph.openManagement();
        PropertyKey name = mgmt.makePropertyKey("name").dataType(String.class).make();
        for (int i = 0; i < additionalPropertiesAmount; ++i) {
            mgmt.makePropertyKey("prop" + i).dataType(String.class).make();
        }
        mgmt.buildIndex("nameIndex", Vertex.class).addKey(name).buildCompositeIndex();
        mgmt.commit();
        JanusGraphVertex mostInnerSingleVertex = this.graph.addVertex(new Object[]{"name", "mostInner"});
        JanusGraphVertex mostOuter = this.graph.addVertex(new Object[]{"name", "outer"});
        for (int i = 0; i < this.fanoutFactor; ++i) {
            JanusGraphVertex otherV = this.graph.addVertex(new Object[]{"name", "middle"});
            mostOuter.addEdge("connects", (Vertex)otherV, new Object[0]);
            for (int j = 0; j < this.fanoutFactor; ++j) {
                JanusGraphVertex innerV = this.graph.addVertex(new Object[]{"name", "inner"});
                for (int k = 0; k < additionalPropertiesAmount; ++k) {
                    innerV.property("prop" + k, (Object)("SomeTestPropertyValue " + k + " 0123456789 ABCDEFG"));
                }
                otherV.addEdge("connects", (Vertex)innerV, new Object[0]);
                innerV.addEdge("connects", (Vertex)mostInnerSingleVertex, new Object[0]);
            }
            this.graph.tx().commit();
        }
    }

    @TearDown
    public void tearDown() throws BackendException {
        JanusGraphFactory.drop((JanusGraph)this.graph);
    }

    @Benchmark
    public List<Vertex> getVerticesFilteredByHasStep() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"mostInner").in(new String[]{"connects"}).has("name", (Object)"inner").toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getVerticesFilteredByHasStepWithNonHasStepAfterOut() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"mostInner").in(new String[]{"connects"}).map(Traverser::get).has("name", (Object)"inner").toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Vertex> getVerticesFilteredByHasStepInParentStep() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"mostInner").in(new String[]{"connects"}).union(new Traversal[]{__.has((String)"name", (Object)"inner")}).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Object> getAllPropertiesOfVerticesFilteredByHasStep() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"mostInner").in(new String[]{"connects"}).has("name", (Object)"inner").values(new String[0]).toList();
        tx.rollback();
        return result;
    }

    @Benchmark
    public List<Object> getSpecificPropertiesOfVerticesFilteredByHasStep() {
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        List result = tx.traversal().V(new Object[0]).has("name", (Object)"mostInner").in(new String[]{"connects"}).has("name", (Object)"inner").values(new String[]{"prop1", "prop2"}).toList();
        tx.rollback();
        return result;
    }
}

