/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import java.util.ArrayList;
import java.util.List;
import org.janusgraph.testutil.RetryInfo;
import org.janusgraph.testutil.RetryingTestFailure;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExecutionExceptionHandler;
import org.opentest4j.TestAbortedException;

public class RetryingTestExecutionExtension
implements ExecutionCondition,
ParameterResolver,
TestExecutionExceptionHandler {
    private final int invocation;
    private final int maxInvocations;
    private final int minSuccess;

    public RetryingTestExecutionExtension(int invocation, int maxInvocations, int minSuccess) {
        this.invocation = invocation;
        this.maxInvocations = maxInvocations;
        this.minSuccess = minSuccess;
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        int failureCount = this.getFailures(context).size();
        int successCount = this.invocation - 1 - failureCount;
        if (this.maxInvocations - failureCount < this.minSuccess) {
            return ConditionEvaluationResult.disabled((String)("Cannot hit minimum success rate of " + this.minSuccess + "/" + this.maxInvocations + " - " + failureCount + " failures already"));
        }
        if (successCount < this.minSuccess) {
            return ConditionEvaluationResult.enabled((String)("Have not ran " + this.minSuccess + "/" + this.maxInvocations + " successful executions"));
        }
        return ConditionEvaluationResult.disabled((String)(this.minSuccess + "/" + this.maxInvocations + " successful runs have already ran. Skipping " + this.invocation));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == RetryInfo.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return new RetryInfo(this.invocation, this.maxInvocations);
    }

    public void handleTestExecutionException(ExtensionContext context, Throwable throwable) throws Throwable {
        RetryingTestFailure testFailure = new RetryingTestFailure(this.invocation, throwable);
        List<RetryingTestFailure> failures = this.getFailures(context);
        failures.add(testFailure);
        int failureCount = failures.size();
        int successCount = this.invocation - failureCount;
        if (this.maxInvocations - failureCount < this.minSuccess) {
            throw testFailure;
        }
        if (successCount < this.minSuccess) {
            throw new TestAbortedException("Aborting test #" + this.minSuccess + " of " + this.maxInvocations + "- still have retries left", (Throwable)testFailure);
        }
    }

    private List<RetryingTestFailure> getFailures(ExtensionContext context) {
        ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{RetryingTestExecutionExtension.class});
        ExtensionContext.Store store = ((ExtensionContext)context.getParent().get()).getStore(namespace);
        return (List)store.getOrComputeIfAbsent((Object)context.getRequiredTestMethod().getName(), a -> new ArrayList(), List.class);
    }
}

