/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import java.util.Collections;
import java.util.List;
import org.janusgraph.testutil.RetryingTestExecutionExtension;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;

public class RetryTemplateContext
implements TestTemplateInvocationContext {
    private final int invocation;
    private final int maxInvocations;
    private final int minSuccess;

    public RetryTemplateContext(int invocation, int maxInvocations, int minSuccess) {
        this.invocation = invocation;
        this.maxInvocations = maxInvocations;
        this.minSuccess = minSuccess;
    }

    public String getDisplayName(int invocationIndex) {
        return "Invocation number " + invocationIndex + " (requires " + this.minSuccess + " success)";
    }

    public List<Extension> getAdditionalExtensions() {
        return Collections.singletonList(new RetryingTestExecutionExtension(this.invocation, this.maxInvocations, this.minSuccess));
    }
}

