/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.commons.lang.NotImplementedException;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.TextP;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.HasStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.WithOptions;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphConfigurationException;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.SchemaViolationException;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.VertexList;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Contain;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.log.Change;
import org.janusgraph.core.log.LogProcessorFramework;
import org.janusgraph.core.log.TransactionRecovery;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJobFuture;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.locking.PermanentLockingException;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.Message;
import org.janusgraph.diskstorage.log.MessageReader;
import org.janusgraph.diskstorage.log.ReadMarker;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.util.CacheMetricsAction;
import org.janusgraph.diskstorage.util.HashingUtil;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.TestMockLog;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.EdgeSerializer;
import org.janusgraph.graphdb.database.IndexRecordEntry;
import org.janusgraph.graphdb.database.IndexSerializer;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.cache.CacheInvalidationService;
import org.janusgraph.graphdb.database.index.IndexMutationType;
import org.janusgraph.graphdb.database.index.IndexUpdate;
import org.janusgraph.graphdb.database.log.LogTxMeta;
import org.janusgraph.graphdb.database.log.LogTxStatus;
import org.janusgraph.graphdb.database.log.TransactionLogHeader;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.management.RelationIndexStatusWatcher;
import org.janusgraph.graphdb.database.serialize.Serializer;
import org.janusgraph.graphdb.database.util.IndexRecordUtil;
import org.janusgraph.graphdb.database.util.StaleIndexRecordUtil;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.ElementLifeCycle;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.log.StandardTransactionLogProcessor;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.JanusGraphPredicateUtils;
import org.janusgraph.graphdb.query.QueryUtil;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.MultiCondition;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.query.index.IndexSelectionUtil;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.relations.StandardEdge;
import org.janusgraph.graphdb.relations.StandardVertexProperty;
import org.janusgraph.graphdb.serializer.SpecialInt;
import org.janusgraph.graphdb.serializer.SpecialIntSerializer;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphElementMapStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphHasStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphPropertiesStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphPropertyMapStep;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryHasStepStrategyMode;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryLabelStepStrategyMode;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryPropertiesStrategyMode;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.MultiQueryStrategyRepeatStepMode;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.CompositeIndexType;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.graphdb.types.StandardPropertyKeyMaker;
import org.janusgraph.graphdb.types.system.BaseVertexLabel;
import org.janusgraph.graphdb.types.system.ImplicitKey;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.vertices.CacheVertex;
import org.janusgraph.testutil.FeatureFlag;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.testutil.JanusGraphFeature;
import org.janusgraph.testutil.TestGraphConfigs;
import org.janusgraph.util.IDUtils;
import org.janusgraph.util.stats.MetricManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.opentest4j.AssertionFailedError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphTest
extends JanusGraphBaseTest {
    private final Logger log = LoggerFactory.getLogger(JanusGraphTest.class);

    final boolean isLockingOptimistic() {
        return this.features.hasOptimisticLocking();
    }

    private void initializeGraphWithVerticesAndEdges() {
        if (this.mgmt.getEdgeLabel("fork-connect") == null) {
            EdgeLabel forkConnect = this.mgmt.makeEdgeLabel("fork-connect").make();
            this.mgmt.setConsistency((JanusGraphSchemaElement)forkConnect, ConsistencyModifier.FORK);
            this.finishSchema();
        }
        Vertex v = (Vertex)this.graph.traversal().addV().property((Object)"_v", (Object)1, new Object[0]).next();
        v.property("_v").property("flag", (Object)false);
        Vertex v2 = (Vertex)this.graph.traversal().addV().property((Object)"_v", (Object)2, new Object[0]).property((Object)"prop", (Object)"old", new Object[0]).next();
        Edge edge = v.addEdge("connect", v2, new Object[]{"_e", 1});
        Edge forkEdge = v.addEdge("fork-connect", v2, new Object[]{"_e", 2});
        this.graph.tx().commit();
    }

    @Test
    public void testUpdateVertexPropThenRemoveProp() {
        this.initializeGraphWithVerticesAndEdges();
        Vertex v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        Assertions.assertEquals((Object)"old", (Object)v2.property("prop").value());
        v2.property("prop", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)v2.property("prop").value());
        v2.property("prop", (Object)"new2");
        Assertions.assertEquals((Object)"new2", (Object)v2.property("prop").value());
        v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        v2.property("prop", (Object)"new3");
        Assertions.assertEquals((Object)"new3", (Object)v2.property("prop").value());
        v2.property("prop").remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[]{v2}).values(new String[]{"prop"}).hasNext());
    }

    @Test
    public void testNestedAddVertexPropThenRemoveProp() {
        this.mgmt.makePropertyKey("prop").dataType(String.class).make();
        this.mgmt.commit();
        this.graph.addVertex(new Object[0]);
        this.graph.tx().commit();
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        ((Vertex)tx1.traversal().V(new Object[0]).next()).property("prop", (Object)"tx1");
        Vertex v = (Vertex)tx2.traversal().V(new Object[0]).next();
        v.property("prop", (Object)"tx2");
        tx1.commit();
        v.property("prop").remove();
        tx2.commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).values(new String[]{"prop"}).hasNext());
    }

    @Test
    public void testUpdateVertexPropThenRemoveVertex() {
        this.initializeGraphWithVerticesAndEdges();
        Vertex v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        Assertions.assertEquals((Object)"old", (Object)v2.property("prop").value());
        v2.property("prop", (Object)"new");
        Assertions.assertEquals((Object)"new", (Object)v2.property("prop").value());
        v2 = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)2).next();
        v2.property("prop", (Object)"new2");
        Assertions.assertEquals((Object)"new2", (Object)v2.property("prop").value());
        v2.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[]{v2}).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("prop", (Object)"old").hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("prop", (Object)"new").hasNext());
    }

    @Test
    public void testUpdatePropertyPropThenRemoveProperty() {
        for (boolean reload : Arrays.asList(true, false)) {
            this.graph.traversal().V(new Object[0]).drop().iterate();
            this.initializeGraphWithVerticesAndEdges();
            Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext());
            VertexProperty p = (VertexProperty)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).next();
            Assertions.assertEquals((Object)false, (Object)p.property("flag").value());
            p.property("flag", (Object)true);
            Assertions.assertEquals((Object)true, (Object)p.property("flag").value());
            if (!reload) {
                p.remove();
            } else {
                ((Property)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).next()).remove();
            }
            this.graph.tx().commit();
            Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext());
        }
    }

    @Test
    public void testUpdatePropertyPropThenRemovePropertyProp() {
        this.initializeGraphWithVerticesAndEdges();
        VertexProperty p = (VertexProperty)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).next();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).values(new String[]{"flag"}).hasNext());
        Assertions.assertEquals((Object)false, (Object)p.property("flag").value());
        p.property("flag", (Object)true);
        Assertions.assertEquals((Object)true, (Object)p.property("flag").value());
        p.property("flag").remove();
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).properties(new String[]{"_v"}).values(new String[]{"flag"}).hasNext());
    }

    @Test
    public void testUpdatePropertyPropThenRemoveVertex() {
        this.initializeGraphWithVerticesAndEdges();
        Vertex v = (Vertex)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).next();
        VertexProperty p = (VertexProperty)v.properties(new String[]{"_v"}).next();
        Assertions.assertEquals((Object)false, (Object)p.property("flag").value());
        p.property("flag", (Object)true);
        Assertions.assertEquals((Object)true, (Object)p.property("flag").value());
        p.property("flag").remove();
        v.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).hasNext());
    }

    @Test
    public void testUpdateEdgePropertyThenRemoveEdge() {
        this.initializeGraphWithVerticesAndEdges();
        InternalElement edge = (InternalElement)this.graph.traversal().E(new Object[0]).has("_e", (Object)1).next();
        Assertions.assertTrue((boolean)ElementLifeCycle.isLoaded((byte)edge.getLifeCycle()));
        Object id = edge.id();
        for (int val : Arrays.asList(-1, -11)) {
            edge.property("_e", (Object)val);
            Assertions.assertEquals((Object)id, (Object)edge.id());
            Assertions.assertTrue((boolean)ElementLifeCycle.isRemoved((byte)edge.getLifeCycle()));
            Assertions.assertEquals((Object)id, (Object)edge.it().id());
            Assertions.assertTrue((boolean)ElementLifeCycle.isNew((byte)edge.it().getLifeCycle()));
            Assertions.assertTrue((boolean)edge.isNew());
        }
        edge.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)1).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-1).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-11).hasNext());
        Assertions.assertTrue((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)2).hasNext());
    }

    @Test
    public void testUpdateForkEdgePropertyThenRemoveEdge() {
        this.initializeGraphWithVerticesAndEdges();
        InternalElement edge = (InternalElement)this.graph.traversal().E(new Object[0]).has("_e", (Object)2).next();
        Assertions.assertTrue((boolean)ElementLifeCycle.isLoaded((byte)edge.getLifeCycle()));
        Object id = edge.id();
        edge.property("_e", (Object)-2);
        Assertions.assertEquals((Object)id, (Object)edge.id());
        Assertions.assertTrue((boolean)ElementLifeCycle.isRemoved((byte)edge.getLifeCycle()));
        Object forkedId = edge.it().id();
        Assertions.assertNotEquals((Object)id, (Object)forkedId);
        Assertions.assertTrue((boolean)ElementLifeCycle.isNew((byte)edge.it().getLifeCycle()));
        Assertions.assertTrue((boolean)edge.isNew());
        edge.property("_e", (Object)-3);
        Assertions.assertEquals((Object)id, (Object)edge.id());
        Assertions.assertTrue((boolean)ElementLifeCycle.isRemoved((byte)edge.getLifeCycle()));
        Assertions.assertEquals((Object)forkedId, (Object)edge.it().id());
        Assertions.assertTrue((boolean)ElementLifeCycle.isNew((byte)edge.it().getLifeCycle()));
        Assertions.assertTrue((boolean)edge.isNew());
        edge.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)2).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-2).hasNext());
        Assertions.assertFalse((boolean)this.graph.traversal().E(new Object[0]).has("_e", (Object)-3).hasNext());
    }

    @Test
    public void testUpdateForkEdgePropertyThenFindEdgeById() {
        this.initializeGraphWithVerticesAndEdges();
        InternalElement edge = (InternalElement)this.graph.traversal().E(new Object[0]).has("_e", (Object)2).next();
        Object id = edge.id();
        edge.property("_e", (Object)-2);
        Assertions.assertTrue((boolean)this.graph.traversal().E(new Object[]{id}).hasNext());
    }

    @Test
    public void testOpenClose() {
    }

    @Test
    public void testClearStorage() throws Exception {
        this.tearDown();
        this.config.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.DROP_ON_CLEAR, (String[])new String[0]), (Object)true);
        Backend backend = JanusGraphTest.getBackend(this.config, false);
        Assertions.assertTrue((boolean)backend.getStoreManager().exists(), (String)"graph should exist before clearing storage");
        JanusGraphTest.clearGraph(this.config);
        Assertions.assertFalse((boolean)backend.getStoreManager().exists(), (String)"graph should not exist after clearing storage");
    }

    @Test
    public void testBasic() throws BackendException {
        PropertyKey uid = this.makeVertexIndexedUniqueKey("name", String.class);
        this.finishSchema();
        JanusGraphVertex n1 = this.tx.addVertex(new Object[0]);
        uid = this.tx.getPropertyKey("name");
        n1.property(uid.name(), (Object)"abcd");
        this.clopen(new Object[0]);
        long nid = (Long)n1.id();
        uid = this.tx.getPropertyKey("name");
        Assertions.assertNotNull((Object)JanusGraphTest.getV((Transaction)this.tx, nid));
        Assertions.assertNotNull((Object)JanusGraphTest.getV((Transaction)this.tx, uid.id()));
        Assertions.assertNotNull((Object)JanusGraphTest.getV((Transaction)this.tx, uid.id().toString()));
        JanusGraphTest.assertMissing((Transaction)this.tx, nid + 64L);
        uid = this.tx.getPropertyKey(uid.name());
        n1 = JanusGraphTest.getV((Transaction)this.tx, nid);
        Assertions.assertEquals((Object)n1, (Object)JanusGraphTest.getOnlyVertex(this.tx.query().has(uid.name(), (Object)"abcd")));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)n1.query().relations()));
        Assertions.assertEquals((Object)"abcd", (Object)n1.value(uid.name()));
        JanusGraphAssert.assertCount(1, this.tx.query().vertices());
        this.close();
        JanusGraphFactory.drop((JanusGraph)this.graph);
        this.open(this.config);
        JanusGraphAssert.assertEmpty(this.tx.query().vertices());
    }

    @Test
    public void testVariables() {
        Assertions.assertTrue((boolean)this.graph.variables().asMap().isEmpty());
        this.graph.variables().set("systemAdmins", (Object)"stephen, peter, pavel");
        this.graph.variables().set("systemUsers", (Object)"matthias, marko, josh");
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("systemAdmins", "systemUsers")), (Object)this.graph.variables().keys());
        Assertions.assertEquals((Object)"matthias, marko, josh", this.graph.variables().get("systemUsers").get());
        this.graph.variables().remove("systemAdmins");
        Assertions.assertEquals(new HashSet<String>(Arrays.asList("systemUsers")), (Object)this.graph.variables().keys());
    }

    @Test
    public void testVertexRemoval() {
        String nameUniqueVertexPropertyName = "name";
        this.makeVertexIndexedUniqueKey("name", String.class);
        this.finishSchema();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "v1"});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "v2"});
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        JanusGraphAssert.assertCount(2, this.graph.query().vertices());
        JanusGraphAssert.assertCount(1, this.graph.query().has("name", (Object)"v2").vertices());
        this.clopen(new Object[0]);
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2);
        JanusGraphAssert.assertCount(1, v1.query().direction(Direction.BOTH).edges());
        JanusGraphAssert.assertCount(1, v2.query().direction(Direction.BOTH).edges());
        v2.remove();
        JanusGraphAssert.assertCount(0, v1.query().direction(Direction.BOTH).edges());
        JanusGraphVertex v2Copied = v2;
        Assertions.assertThrows(IllegalStateException.class, () -> v2Copied.query().direction(Direction.BOTH).edges());
        JanusGraphAssert.assertCount(1, this.graph.query().vertices());
        JanusGraphAssert.assertCount(1, this.graph.query().has("name", (Object)"v1").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (Object)"v2").vertices());
        this.graph.tx().commit();
        JanusGraphTest.assertMissing((Transaction)this.graph, v2);
        JanusGraphAssert.assertCount(1, this.graph.query().vertices());
        JanusGraphAssert.assertCount(1, this.graph.query().has("name", (Object)"v1").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (Object)"v2").vertices());
    }

    @Test
    public void testGlobalIteration() {
        int i;
        int numV = 50;
        int deleteV = 5;
        JanusGraphVertex previous = this.tx.addVertex(new Object[]{"count", 0});
        for (int i2 = 1; i2 < numV; ++i2) {
            JanusGraphVertex next = this.tx.addVertex(new Object[]{"count", i2});
            previous.addEdge("next", (Vertex)next, new Object[0]);
            previous = next;
        }
        int numE = numV - 1;
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        JanusGraphAssert.assertCount(numE, this.tx.query().edges());
        for (JanusGraphVertex v : this.tx.query().limit(deleteV).vertices()) {
            v.remove();
        }
        for (i = 0; i < 10; ++i) {
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().vertices());
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().has("count", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0).vertices());
        }
        this.clopen(new Object[0]);
        for (i = 0; i < 10; ++i) {
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().vertices());
            JanusGraphAssert.assertCount(numV - deleteV, this.tx.query().has("count", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0).vertices());
        }
    }

    @Test
    public void testMediumCreateRetrieve() {
        JanusGraphVertex n;
        int i;
        JanusGraphVertex n2;
        this.makeLabel("connect");
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{id}).signature(new PropertyKey[]{weight}).make();
        this.finishSchema();
        int noVertices = 500;
        String[] names = new String[noVertices];
        int[] ids = new int[noVertices];
        JanusGraphVertex[] nodes = new JanusGraphVertex[noVertices];
        Object[] nodeIds = new Object[noVertices];
        List[] nodeEdges = new List[noVertices];
        for (int i2 = 0; i2 < noVertices; ++i2) {
            names[i2] = "vertex" + i2;
            ids[i2] = i2;
            nodes[i2] = this.tx.addVertex(new Object[]{"name", names[i2], "uid", ids[i2]});
            if ((i2 + 1) % 100 != 0) continue;
            this.log.debug("Added 100 nodes");
        }
        this.log.debug("Nodes created");
        int[] connectOff = new int[]{-100, -34, -4, 10, 20};
        int[] knowsOff = new int[]{-400, -18, 8, 232, 334};
        for (int i3 = 0; i3 < noVertices; ++i3) {
            JanusGraphVertex n3 = nodes[i3];
            nodeEdges[i3] = new ArrayList(10);
            for (int c : connectOff) {
                JanusGraphEdge r = n3.addEdge("connect", (Vertex)nodes[JanusGraphTest.wrapAround(i3 + c, noVertices)], new Object[0]);
                nodeEdges[i3].add(r);
            }
            for (int k : knowsOff) {
                n2 = nodes[JanusGraphTest.wrapAround(i3 + k, noVertices)];
                JanusGraphEdge r = n3.addEdge("knows", (Vertex)n2, new Object[]{"uid", ((Number)n3.value("uid")).intValue() + ((Number)n2.value("uid")).intValue(), "weight", (double)k * 1.5, "name", i3 + "-" + k});
                nodeEdges[i3].add(r);
            }
            if (i3 % 100 != 99) continue;
            this.log.debug(".");
        }
        this.tx.commit();
        this.tx = null;
        Set[] nodeEdgeIds = new Set[noVertices];
        for (i = 0; i < noVertices; ++i) {
            nodeIds[i] = (Long)nodes[i].id();
            nodeEdgeIds[i] = new HashSet(10);
            Object object = nodeEdges[i].iterator();
            while (object.hasNext()) {
                Object r = object.next();
                nodeEdgeIds[i].add(((JanusGraphEdge)r).id());
            }
        }
        this.clopen(new Object[0]);
        nodes = new JanusGraphVertex[noVertices];
        for (i = 0; i < noVertices; ++i) {
            n = this.getVertex("uid", (Object)ids[i]);
            Assertions.assertEquals((Object)n, (Object)this.getVertex("name", (Object)names[i]));
            Assertions.assertEquals((Object)names[i], (Object)n.value("name"));
            nodes[i] = n;
            Assertions.assertEquals((Object)nodeIds[i], (Object)n.id());
        }
        for (i = 0; i < noVertices; ++i) {
            n = nodes[i];
            JanusGraphAssert.assertCount(connectOff.length + knowsOff.length, n.query().direction(Direction.OUT).edges());
            JanusGraphAssert.assertCount(connectOff.length, n.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
            JanusGraphAssert.assertCount(connectOff.length * 2, n.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
            JanusGraphAssert.assertCount(knowsOff.length * 2, n.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(connectOff.length + knowsOff.length, n.query().direction(Direction.OUT).edges());
            JanusGraphAssert.assertCount(2, n.properties(new String[0]));
            Iterator r = n.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges().iterator();
            while (r.hasNext()) {
                JanusGraphEdge o;
                JanusGraphEdge r2 = o = (JanusGraphEdge)r.next();
                n2 = r2.vertex(Direction.IN);
                int idSum = ((Number)n.value("uid")).intValue() + ((Number)n2.value("uid")).intValue();
                Assertions.assertEquals((int)idSum, (int)((Number)r2.value("uid")).intValue());
                double k = ((Number)r2.value("weight")).doubleValue() / 1.5;
                int ki = (int)k;
                Assertions.assertEquals((Object)(i + "-" + ki), (Object)r2.value("name"));
            }
            HashSet<Object> edgeIds = new HashSet<Object>(10);
            for (JanusGraphEdge r2 : n.query().direction(Direction.OUT).edges()) {
                edgeIds.add(r2.id());
            }
            Assertions.assertEquals(edgeIds, (Object)nodeEdgeIds[i], (String)(edgeIds + " vs " + nodeEdgeIds[i]));
        }
        this.newTx();
        Object[] vertexIdsOne = new Object[noVertices / 10];
        System.arraycopy(nodeIds, 0, vertexIdsOne, 0, vertexIdsOne.length);
        this.verifyVerticesRetrieval(vertexIdsOne, Lists.newArrayList((Iterable)this.tx.getVertices(vertexIdsOne)));
        this.verifyVerticesRetrieval(vertexIdsOne, Lists.newArrayList((Iterable)this.tx.getVertices(vertexIdsOne)));
        Object[] vertexIdsTwo = new Object[noVertices / 10 * 2];
        System.arraycopy(nodeIds, 0, vertexIdsTwo, 0, vertexIdsTwo.length);
        this.verifyVerticesRetrieval(vertexIdsTwo, Lists.newArrayList((Iterable)this.tx.getVertices(vertexIdsTwo)));
    }

    private void verifyVerticesRetrieval(Object[] vertexIds, List<JanusGraphVertex> vs) {
        Assertions.assertEquals((int)vertexIds.length, (int)vs.size());
        HashSet vertexIdSet = new HashSet(vs.size());
        vs.forEach(v -> vertexIdSet.add((Long)v.id()));
        for (Object vertexId : vertexIds) {
            Assertions.assertTrue((boolean)vertexIdSet.contains(vertexId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaTypes() {
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", String.class);
        PropertyKey someId = this.makeVertexIndexedKey("someid", Object.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        PropertyKey value = this.mgmt.makePropertyKey("value").dataType(Double.class).signature(new PropertyKey[]{weight}).cardinality(Cardinality.LIST).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{uid}).multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel parent = this.mgmt.makeEdgeLabel("parent").multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel tag = this.mgmt.makeVertexLabel("tag").make();
        VertexLabel tweet = this.mgmt.makeVertexLabel("tweet").setStatic().make();
        Assertions.assertTrue((boolean)this.mgmt.isOpen());
        Assertions.assertEquals((Object)"weight", (Object)weight.toString());
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assertions.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assertions.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assertions.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assertions.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assertions.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assertions.assertTrue((boolean)weight.isPropertyKey());
        Assertions.assertFalse((boolean)weight.isEdgeLabel());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)weight.cardinality());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)someId.cardinality());
        Assertions.assertEquals((Object)Cardinality.SET, (Object)name.cardinality());
        Assertions.assertEquals((Object)Cardinality.LIST, (Object)value.cardinality());
        Assertions.assertEquals(Object.class, (Object)someId.dataType());
        Assertions.assertEquals(Float.class, (Object)weight.dataType());
        long[] sig = ((InternalRelationType)value).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((Object)weight.id(), (Object)sig[0]);
        Assertions.assertTrue((boolean)this.mgmt.getGraphIndex(uid.name()).isUnique());
        Assertions.assertFalse((boolean)this.mgmt.getGraphIndex(someId.name()).isUnique());
        Assertions.assertEquals((Object)"friend", (Object)friend.name());
        Assertions.assertTrue((boolean)friend.isEdgeLabel());
        Assertions.assertFalse((boolean)friend.isPropertyKey());
        Assertions.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MULTI, (Object)friend.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.multiplicity());
        Assertions.assertTrue((boolean)link.isUnidirected());
        Assertions.assertFalse((boolean)link.isDirected());
        Assertions.assertFalse((boolean)child.isUnidirected());
        Assertions.assertTrue((boolean)spouse.isDirected());
        Assertions.assertFalse((boolean)((InternalRelationType)friend).isInvisibleType());
        Assertions.assertTrue((boolean)((InternalRelationType)friend).isInvisible());
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((Object)uid.id(), (Object)sig[0]);
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSortKey().length);
        Assertions.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assertions.assertEquals((int)5, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assertions.assertEquals((int)6, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assertions.assertEquals((int)11, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assertions.assertEquals((Object)"tweet", (Object)tweet.name());
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assertions.assertFalse((boolean)person.isPartitioned());
        Assertions.assertFalse((boolean)person.isStatic());
        Assertions.assertFalse((boolean)tag.isPartitioned());
        Assertions.assertTrue((boolean)tweet.isStatic());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makePropertyKey("fid").make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeEdgeLabel("link").unidirected().make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new PropertyKey[]{someId, weight}).signature(new PropertyKey[]{someId}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new PropertyKey[]{weight}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new PropertyKey[]{weight}).make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeVertexLabel("tweet").make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makeEdgeLabel("test").signature(new PropertyKey[]{someId}).make());
        this.finishSchema();
        this.clopen(new Object[0]);
        PropertyKey weight2 = this.mgmt.getPropertyKey("weight");
        uid = this.mgmt.getPropertyKey("uid");
        PropertyKey someId2 = this.mgmt.getPropertyKey("someid");
        name = this.mgmt.getPropertyKey("name");
        value = this.mgmt.getPropertyKey("value");
        friend = this.mgmt.getEdgeLabel("friend");
        link = this.mgmt.getEdgeLabel("link");
        connect = this.mgmt.getEdgeLabel("connect");
        parent = this.mgmt.getEdgeLabel("parent");
        child = this.mgmt.getEdgeLabel("child");
        spouse = this.mgmt.getEdgeLabel("spouse");
        person = this.mgmt.getVertexLabel("person");
        tag = this.mgmt.getVertexLabel("tag");
        tweet = this.mgmt.getVertexLabel("tweet");
        Assertions.assertTrue((boolean)this.mgmt.isOpen());
        Assertions.assertEquals((Object)"weight", (Object)weight2.toString());
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assertions.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assertions.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assertions.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assertions.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assertions.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assertions.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assertions.assertTrue((boolean)weight2.isPropertyKey());
        Assertions.assertFalse((boolean)weight2.isEdgeLabel());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)weight2.cardinality());
        Assertions.assertEquals((Object)Cardinality.SINGLE, (Object)someId2.cardinality());
        Assertions.assertEquals((Object)Cardinality.SET, (Object)name.cardinality());
        Assertions.assertEquals((Object)Cardinality.LIST, (Object)value.cardinality());
        Assertions.assertEquals(Object.class, (Object)someId2.dataType());
        Assertions.assertEquals(Float.class, (Object)weight2.dataType());
        sig = ((InternalRelationType)value).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((Object)weight2.id(), (Object)sig[0]);
        Assertions.assertTrue((boolean)this.mgmt.getGraphIndex(uid.name()).isUnique());
        Assertions.assertFalse((boolean)this.mgmt.getGraphIndex(someId2.name()).isUnique());
        Assertions.assertEquals((Object)"friend", (Object)friend.name());
        Assertions.assertTrue((boolean)friend.isEdgeLabel());
        Assertions.assertFalse((boolean)friend.isPropertyKey());
        Assertions.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.MULTI, (Object)friend.multiplicity());
        Assertions.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.multiplicity());
        Assertions.assertTrue((boolean)link.isUnidirected());
        Assertions.assertFalse((boolean)link.isDirected());
        Assertions.assertFalse((boolean)child.isUnidirected());
        Assertions.assertTrue((boolean)spouse.isDirected());
        Assertions.assertFalse((boolean)((InternalRelationType)friend).isInvisibleType());
        Assertions.assertTrue((boolean)((InternalRelationType)friend).isInvisible());
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assertions.assertEquals((int)1, (int)sig.length);
        Assertions.assertEquals((Object)uid.id(), (Object)sig[0]);
        Assertions.assertEquals((int)0, (int)((InternalRelationType)friend).getSortKey().length);
        Assertions.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assertions.assertEquals((int)5, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assertions.assertEquals((int)6, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assertions.assertEquals((int)11, (int)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assertions.assertEquals((Object)"tweet", (Object)tweet.name());
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assertions.assertFalse((boolean)person.isPartitioned());
        Assertions.assertFalse((boolean)person.isStatic());
        Assertions.assertFalse((boolean)tag.isPartitioned());
        Assertions.assertTrue((boolean)tweet.isStatic());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makePropertyKey("fid").make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeEdgeLabel("link").unidirected().make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new PropertyKey[]{someId2, weight2}).signature(new PropertyKey[]{someId2}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new PropertyKey[]{weight2}).make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new PropertyKey[]{weight2}).make());
        Assertions.assertThrows(SchemaViolationException.class, () -> this.mgmt.makeVertexLabel("tweet").make());
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.makeEdgeLabel("test").signature(new PropertyKey[]{someId2}).make());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertEmpty(this.tx.query().has("uid", (Object)"v1").vertices());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.property("uid", (Object)"v1");
        v.property("weight", (Object)1.5);
        v.property("someid", (Object)"Hello");
        v.property("name", (Object)"Bob");
        v.property("name", (Object)"John");
        JanusGraphVertexProperty p = v.property("value", (Object)11);
        p.property("weight", (Object)22);
        v.property("value", (Object)33.3, new Object[]{"weight", 66.6});
        v.property("value", (Object)11, new Object[]{"weight", 22});
        JanusGraphVertex v12 = this.tx.addVertex("person");
        JanusGraphVertex v13 = this.tx.addVertex("person");
        v12.property("uid", (Object)"v12");
        v13.property("uid", (Object)"v13");
        v12.addEdge("parent", (Vertex)v, new Object[]{"weight", 4.5});
        v13.addEdge("parent", (Vertex)v, new Object[]{"weight", 4.5});
        v.addEdge("child", (Vertex)v12, new Object[0]);
        v.addEdge("child", (Vertex)v13, new Object[0]);
        v.addEdge("spouse", (Vertex)v12, new Object[0]);
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v.addEdge("connect", (Vertex)v12, new Object[]{"uid", "e1"});
        v.addEdge("link", (Vertex)v13, new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex("tweet");
        v2.addEdge("link", (Vertex)v13, new Object[0]);
        v12.addEdge("connect", (Vertex)v2, new Object[0]);
        Assertions.assertEquals((Object)v, JanusGraphTest.getOnlyElement(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1").vertices()));
        v = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"));
        v12 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v12"));
        v13 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v13"));
        JanusGraphVertex finalV = v;
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV.property("weight", (Object)"x"));
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV.property(VertexProperty.Cardinality.list, "name", (Object)"John", new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalV.property("link", (Object)finalV));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)1.0, new Object[0]);
        JanusGraphAssert.assertCount(1, v.properties(new String[]{"weight"}));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)0.5, new Object[0]);
        Assertions.assertEquals((double)0.5, (double)((Float)v.value("weight")).doubleValue(), (double)1.0E-5);
        Assertions.assertEquals((Object)"v1", (Object)v.value("uid"));
        JanusGraphAssert.assertCount(2, v.properties(new String[]{"name"}));
        for (Object prop : v.query().labels(new String[]{"name"}).properties()) {
            String nameString = (String)((JanusGraphVertexProperty)prop).value();
            Assertions.assertTrue((nameString.equals("Bob") || nameString.equals("John") ? 1 : 0) != 0);
        }
        Assertions.assertTrue((Iterators.size((Iterator)v.properties(new String[]{"value"})) >= 3 ? 1 : 0) != 0);
        for (Object o : v.query().labels(new String[]{"value"}).properties()) {
            JanusGraphVertexProperty prop = (JanusGraphVertexProperty)o;
            double prec = (Double)prop.value();
            Assertions.assertEquals((double)(prec * 2.0), (double)((Number)prop.value("weight")).doubleValue(), (double)1.0E-5);
        }
        p = v.property("value", (Object)44.4, new Object[]{"weight", 88.8});
        Assertions.assertEquals((Object)v, JanusGraphTest.getOnlyElement(this.tx.query().has("someid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Hello").vertices()));
        try {
            v12.addEdge("parent", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("child", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge("spouse", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addEdge("spouse", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        JanusGraphAssert.assertCount(1, v12.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        JanusGraphAssert.assertCount(1, v13.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        Assertions.assertEquals((Object)v12, JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"spouse"}).vertices()));
        JanusGraphEdge edge = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((int)1, (int)edge.keys().size());
        Assertions.assertEquals((Object)"e1", (Object)edge.value("uid"));
        try {
            v.addEdge("connect", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        JanusGraphAssert.assertCount(0, v13.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v2 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v12.query().direction(Direction.OUT).labels(new String[]{"connect"}).vertices());
        Assertions.assertEquals((Object)v13, JanusGraphTest.getOnlyElement(v2.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices()));
        Assertions.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.label());
        Assertions.assertEquals((Object)"person", (Object)v12.label());
        Assertions.assertEquals((Object)"person", (Object)v13.label());
        JanusGraphAssert.assertCount(4, this.tx.query().vertices());
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v, (Object)JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1")));
        v = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"));
        v12 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v12"));
        v13 = JanusGraphTest.getOnlyVertex(this.tx.query().has("uid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v13"));
        JanusGraphVertex finalV1 = v;
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV1.property("weight", (Object)"x"));
        Assertions.assertThrows(SchemaViolationException.class, () -> finalV1.property(VertexProperty.Cardinality.list, "name", (Object)"John", new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> finalV1.property("link", (Object)finalV1));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)1.0, new Object[0]);
        JanusGraphAssert.assertCount(1, v.properties(new String[]{"weight"}));
        v.property(VertexProperty.Cardinality.single, "weight", (Object)0.5, new Object[0]);
        Assertions.assertEquals((double)0.5, (double)((Float)v.value("weight")).doubleValue(), (double)1.0E-5);
        Assertions.assertEquals((Object)"v1", (Object)v.value("uid"));
        JanusGraphAssert.assertCount(2, v.properties(new String[]{"name"}));
        for (Object o : v.query().labels(new String[]{"name"}).properties()) {
            JanusGraphVertexProperty prop = (JanusGraphVertexProperty)o;
            String nameString = (String)prop.value();
            Assertions.assertTrue((nameString.equals("Bob") || nameString.equals("John") ? 1 : 0) != 0);
        }
        Assertions.assertTrue((Iterables.size((Iterable)v.query().labels(new String[]{"value"}).properties()) >= 3 ? 1 : 0) != 0);
        for (Object o : v.query().labels(new String[]{"value"}).properties()) {
            JanusGraphVertexProperty prop = (JanusGraphVertexProperty)o;
            double prec = (Double)prop.value();
            Assertions.assertEquals((double)(prec * 2.0), (double)((Number)prop.value("weight")).doubleValue(), (double)1.0E-5);
        }
        p = v.property("value", (Object)44.4, new Object[]{"weight", 88.8});
        Assertions.assertEquals((Object)v, JanusGraphTest.getOnlyElement(this.tx.query().has("someid", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Hello").vertices()));
        try {
            v12.addEdge("parent", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        try {
            v13.addEdge("child", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        try {
            v13.addEdge("spouse", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        try {
            v.addEdge("spouse", (Vertex)v13, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.IN).labels(new String[]{"parent"}).edges());
        JanusGraphAssert.assertCount(1, v12.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        JanusGraphAssert.assertCount(1, v13.query().direction(Direction.OUT).labels(new String[]{"parent"}).has("weight").edges());
        Assertions.assertEquals((Object)v12, JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"spouse"}).vertices()));
        edge = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.BOTH).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((int)1, (int)edge.keys().size());
        Assertions.assertEquals((Object)"e1", (Object)edge.value("uid"));
        try {
            v.addEdge("connect", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException o) {
            // empty catch block
        }
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        JanusGraphAssert.assertCount(0, v13.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
        v.addEdge("friend", (Vertex)v12, new Object[0]);
        v2 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v12.query().direction(Direction.OUT).labels(new String[]{"connect"}).vertices());
        Assertions.assertEquals((Object)v13, JanusGraphTest.getOnlyElement(v2.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices()));
        Assertions.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.label());
        Assertions.assertEquals((Object)"person", (Object)v12.label());
        Assertions.assertEquals((Object)"person", (Object)v13.label());
        JanusGraphAssert.assertCount(4, this.tx.query().vertices());
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        try {
            JanusGraphVertex vx = tx2.addVertex(new Object[0]);
            try {
                vx.property(VertexProperty.Cardinality.single, "uid", (Object)"v1", new Object[0]);
                Assertions.fail();
            }
            catch (SchemaViolationException o) {
                // empty catch block
            }
            vx.property(VertexProperty.Cardinality.single, "uid", (Object)"unique", new Object[0]);
            JanusGraphVertex vx2 = tx2.addVertex(new Object[0]);
            try {
                vx2.property(VertexProperty.Cardinality.single, "uid", (Object)"unique", new Object[0]);
                Assertions.fail();
            }
            catch (SchemaViolationException schemaViolationException) {
                // empty catch block
            }
        }
        finally {
            tx2.rollback();
        }
        v2 = JanusGraphTest.getV((Transaction)this.tx, v2);
        Assertions.assertEquals((Object)"tweet", (Object)v2.label());
        try {
            v2.property(VertexProperty.Cardinality.single, "weight", (Object)11, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v2.addEdge("friend", (Vertex)v12, new Object[0]);
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        JanusGraphTest.getV((Transaction)this.tx, v13).remove();
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"link"}).edges());
    }

    @Test
    public void testDataTypes() {
        Object value;
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_CLASS, "attribute10"), SpecialInt.class.getCanonicalName(), JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, "attribute10"), SpecialIntSerializer.class.getCanonicalName());
        PropertyKey any = this.mgmt.makePropertyKey("any").cardinality(Cardinality.LIST).dataType(Object.class).make();
        try {
            this.makeKey("pint", Integer.TYPE);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.makeKey("number", Number.class);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        any = this.tx.getPropertyKey("any");
        Assertions.assertEquals(Object.class, (Object)any.dataType());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.property(JanusGraphTest.n(any), (Object)"Hello");
        v.property(JanusGraphTest.n(any), (Object)10L);
        int[] testArray = new int[]{5, 6, 7};
        v.property(JanusGraphTest.n(any), (Object)testArray);
        for (Object prop : v.query().labels(new String[]{"any"}).properties()) {
            value = ((JanusGraphVertexProperty)prop).value();
            if (value instanceof String) {
                Assertions.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assertions.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value.getClass().isArray()) {
                Assertions.assertArrayEquals((int[])testArray, (int[])((int[])value));
                continue;
            }
            Assertions.fail();
        }
        this.clopen(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (Object prop : v.query().labels(new String[]{"any"}).properties()) {
            value = ((JanusGraphVertexProperty)prop).value();
            if (value instanceof String) {
                Assertions.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assertions.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value.getClass().isArray()) {
                Assertions.assertArrayEquals((int[])testArray, (int[])((int[])value));
                continue;
            }
            Assertions.fail();
        }
    }

    private static Stream<Arguments> generateParametersTestSupportOfDataTypes() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{SpecialInt.class, new SpecialInt(10), a -> a.getValue() == 10}), Arguments.arguments((Object[])new Object[]{byte[].class, new byte[]{1, 2, 3, 4}, a -> ((byte[])a).length == 4}), Arguments.arguments((Object[])new Object[]{Boolean.class, true, a -> a}), Arguments.arguments((Object[])new Object[]{Instant.class, Instant.ofEpochSecond(1429225756L), a -> a.equals(Instant.ofEpochSecond(1429225756L))}), Arguments.arguments((Object[])new Object[]{Geoshape.class, Geoshape.point((double)10.0, (double)10.0), a -> a.equals((Object)Geoshape.point((double)10.0, (double)10.0))}), Arguments.arguments((Object[])new Object[]{Geoshape.class, Geoshape.box((double)10.0, (double)10.0, (double)20.0, (double)20.0), a -> a.equals((Object)Geoshape.box((double)10.0, (double)10.0, (double)20.0, (double)20.0))}), Arguments.arguments((Object[])new Object[]{Double.class, 10.12345, a -> a == 10.12345})});
    }

    @ParameterizedTest
    @MethodSource(value={"generateParametersTestSupportOfDataTypes"})
    public <T> void testSupportOfDataTypes(Class<T> classes, T data, Equals<T> a) {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_CLASS, "attribute10"), SpecialInt.class.getCanonicalName(), JanusGraphTest.option(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, "attribute10"), SpecialIntSerializer.class.getCanonicalName());
        PropertyKey num = this.makeKey("propertyKey", classes);
        this.finishSchema();
        this.clopen(new Object[0]);
        num = this.tx.getPropertyKey("propertyKey");
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.property(VertexProperty.Cardinality.single, JanusGraphTest.n(num), data, new Object[0]);
        Assertions.assertTrue((boolean)a.verifyValue(v.value("propertyKey")));
        this.clopen(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        Assertions.assertTrue((boolean)a.verifyValue(v.value("propertyKey")));
    }

    @Test
    public void testTransactionalScopeOfSchemaTypes() {
        this.makeVertexIndexedUniqueKey("domain", String.class);
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property(VertexProperty.Cardinality.single, "domain", (Object)"unique1", new Object[0]);
        this.tx.rollback();
        this.tx = null;
        this.newTx();
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("domain", (Object)"unique1");
        Assertions.assertThrows(SchemaViolationException.class, () -> {
            JanusGraphVertex vInternal = this.tx.addVertex(new Object[0]);
            vInternal.property("domain", (Object)"unique1");
        });
        this.tx.rollback();
        this.tx = null;
        this.newTx();
        this.clopen(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v3.property("domain", (Object)"unique1");
        JanusGraphAssert.assertCount(1, this.tx.query().has("domain", (Object)"unique1").vertices());
        Assertions.assertThrows(SchemaViolationException.class, () -> {
            JanusGraphVertex vInternal = this.tx.addVertex(new Object[0]);
            vInternal.property("domain", (Object)"unique1");
        });
        this.tx.rollback();
        this.tx = null;
    }

    @Test
    public void testDefaultSchemaMaker() {
        Assertions.assertFalse((boolean)this.tx.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.tx.containsRelationType("value"));
        Assertions.assertNull((Object)this.tx.getPropertyKey("value"));
        PropertyKey value = this.tx.getOrCreatePropertyKey("value");
        Assertions.assertNotNull((Object)value);
        Assertions.assertTrue((boolean)this.tx.containsRelationType("value"));
        JanusGraphVertex v = this.tx.addVertex("person");
        Assertions.assertTrue((boolean)this.tx.containsVertexLabel("person"));
        Assertions.assertEquals((Object)"person", (Object)v.label());
        Assertions.assertFalse((boolean)this.tx.containsRelationType("knows"));
        JanusGraphEdge e = v.addEdge("knows", (Vertex)v, new Object[0]);
        Assertions.assertTrue((boolean)this.tx.containsRelationType("knows"));
        Assertions.assertNotNull((Object)this.tx.getEdgeLabel(e.label()));
    }

    @Test
    public void testDisableDefaultSchemaMaker() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none");
        EdgeLabel has = this.mgmt.makeEdgeLabel("has").make();
        this.mgmt.makePropertyKey("prop").dataType(Integer.class).make();
        this.mgmt.commit();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        JanusGraphEdge e = v.addEdge("has", (Vertex)v, new Object[0]);
        Exception exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.tx.addVertex("org"));
        Assertions.assertEquals((Object)"Vertex Label with given name does not exist: org", (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> v.addEdge("blub", (Vertex)v, new Object[0]));
        Assertions.assertEquals((Object)"Edge Label with given name does not exist: blub", (Object)exception.getMessage());
        v.property("prop", (Object)6);
        e.property("prop", (Object)6);
        String errorMsg = "Property Key with given name does not exist: bla";
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> v.property("bla", (Object)5));
        Assertions.assertEquals((Object)errorMsg, (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> v.property("bla", (Object)5).element().property("prop", (Object)6));
        Assertions.assertEquals((Object)errorMsg, (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> v.property("prop", (Object)6).element().property("bla", (Object)5));
        Assertions.assertEquals((Object)errorMsg, (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> e.property("bla", (Object)5));
        Assertions.assertEquals((Object)errorMsg, (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> e.property("bla", (Object)5).element().property("prop", (Object)6));
        Assertions.assertEquals((Object)errorMsg, (Object)exception.getMessage());
        exception = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> e.property("prop", (Object)6).element().property("bla", (Object)5));
        Assertions.assertEquals((Object)errorMsg, (Object)exception.getMessage());
    }

    @Test
    public void testIgnorePropertySchemaMaker() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "ignore-prop");
        EdgeLabel has = this.mgmt.makeEdgeLabel("has").make();
        this.mgmt.makePropertyKey("prop").dataType(Integer.class).make();
        this.mgmt.makePropertyKey("beta").dataType(Boolean.class).make();
        this.mgmt.commit();
        GraphTraversalSource g = this.graph.traversal();
        JanusGraphVertex v = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e = v.addEdge("has", (Vertex)v, new Object[0]);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.graph.addVertex("org"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> v.addEdge("blub", (Vertex)v, new Object[0]));
        this.graph.tx().commit();
        Vertex v1 = (Vertex)g.V(new Object[0]).next();
        g.V(new Object[]{v1}).property((Object)"prop", (Object)6, new Object[0]).property((Object)"bla", (Object)1, new Object[0]).property((Object)"unknown", (Object)"value", new Object[0]).next();
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"bla", 1, "prop", 2, "unknown", "value"});
        Vertex v3 = (Vertex)g.addV().property((Object)"bla", (Object)1, new Object[0]).property((Object)"prop", (Object)1, new Object[0]).property((Object)"unknown", (Object)"value", new Object[0]).next();
        Assertions.assertEquals((int)1, (int)((Map)g.V(new Object[]{v1}).valueMap(new String[0]).next()).size());
        Assertions.assertEquals((int)1, (int)((Map)g.V(new Object[]{v2}).valueMap(new String[0]).next()).size());
        Assertions.assertEquals((int)1, (int)((Map)g.V(new Object[]{v3}).valueMap(new String[0]).next()).size());
        g.E(new Object[]{e}).property((Object)"bla", (Object)5, new Object[0]).property((Object)"prop", (Object)1, new Object[0]).property((Object)"unknown", (Object)"value", new Object[0]).next();
        Assertions.assertEquals((int)1, (int)((Map)g.E(new Object[]{e}).valueMap(new String[0]).next()).size());
        v2.property("prop").property("meta-prop", (Object)"val");
        v3.property("prop").property("beta", (Object)true);
        Assertions.assertEquals((int)0, (int)((Map)g.V(new Object[]{v2}).properties(new String[]{"prop"}).valueMap(new String[0]).next()).size());
        Assertions.assertEquals((int)1, (int)((Map)g.V(new Object[]{v3}).properties(new String[]{"prop"}).valueMap(new String[0]).next()).size());
        this.graph.tx().commit();
        this.tx = this.graph.newTransaction();
        Assertions.assertNotNull((Object)this.tx.getOrCreatePropertyKey("prop"));
        Assertions.assertTrue((boolean)this.tx.containsRelationType("prop"));
        Assertions.assertNotNull((Object)this.tx.getOrCreatePropertyKey("beta"));
        Assertions.assertTrue((boolean)this.tx.containsRelationType("beta"));
        Assertions.assertNull((Object)this.tx.getOrCreatePropertyKey("bla"));
        Assertions.assertFalse((boolean)this.tx.containsRelationType("bla"));
        Assertions.assertNull((Object)this.tx.getOrCreatePropertyKey("meta-prop"));
        Assertions.assertFalse((boolean)this.tx.containsRelationType("meta-prop"));
    }

    @Test
    public void testUpdateSchemaChangeNameForEdgeLabel() {
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex("people");
        v.addEdge("knows", (Vertex)v, new Object[0]);
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((Object)"people", (Object)v.label());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        this.newTx();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("knows"));
        knows = this.mgmt.getEdgeLabel("knows");
        this.mgmt.changeName((JanusGraphSchemaElement)knows, "know");
        Assertions.assertEquals((Object)"know", (Object)knows.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("know"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationType("knows"));
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"know"}).edges());
        JanusGraphAssert.assertCount(0, v.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
    }

    @Test
    public void testUpdateSchemaChangeNameForVertexLabel() {
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex("people");
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        Assertions.assertEquals((Object)"people", (Object)v.label());
        this.newTx();
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("people"));
        VertexLabel vl = this.mgmt.getVertexLabel("people");
        this.mgmt.changeName((JanusGraphSchemaElement)vl, "person");
        Assertions.assertEquals((Object)"person", (Object)vl.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assertions.assertFalse((boolean)this.mgmt.containsVertexLabel("people"));
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((Object)"person", (Object)v.label());
    }

    @Test
    public void testDiscardAndDropRegisteredIndex() throws ExecutionException, InterruptedException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "composite";
        String propertyName = "prop";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.discardIndex(indexName);
        this.dropIndex(indexName);
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
    }

    @Test
    public void testReenableDisabledIndex() throws ExecutionException, InterruptedException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "composite";
        String propertyName = "prop";
        String propertyValue = "value";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        this.disableIndex(indexName);
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        this.enableIndex(indexName);
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has(propertyName, (Object)propertyValue).count().next()));
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has(propertyName, (Object)propertyValue).count().next()));
    }

    @Test
    public void testCreateCompositeIndexThatPreviouslyExisted() throws ExecutionException, InterruptedException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "composite";
        String propertyName = "prop";
        String propertyValue = "value";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        this.disableIndex(indexName);
        this.discardIndex(indexName);
        this.dropIndex(indexName);
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has(propertyName, (Object)propertyValue).hasNext());
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has(propertyName, (Object)propertyValue).hasNext());
    }

    private void registerIndex(String indexName, Class<? extends Element> type, String ... propertyNames) throws InterruptedException {
        JanusGraphManagement.IndexBuilder builder = this.mgmt.buildIndex(indexName, type);
        for (String prop : propertyNames) {
            builder.addKey(this.mgmt.getPropertyKey(prop));
        }
        builder.buildCompositeIndex();
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call().getSucceeded());
        this.mgmt = this.graph.openManagement();
    }

    @Test
    public void testUpdateSchemaChangeNameForPropertyKey() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("timeIndex", Vertex.class).addKey(time).buildCompositeIndex();
        this.finishSchema();
        PropertyKey prop = this.mgmt.getPropertyKey("time");
        this.mgmt.changeName((JanusGraphSchemaElement)prop, "delTime");
        Assertions.assertEquals((Object)"delTime", (Object)prop.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsPropertyKey("delTime"));
        Assertions.assertFalse((boolean)this.mgmt.containsPropertyKey("time"));
    }

    @Test
    public void testUpdateSchemaChangeNameForCompositeIndex() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("timeIndex", Vertex.class).addKey(time).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("timeIndex"));
        JanusGraphIndex graphIndex = this.mgmt.getGraphIndex("timeIndex");
        this.mgmt.changeName((JanusGraphSchemaElement)graphIndex, "byTime");
        Assertions.assertEquals((Object)"byTime", (Object)graphIndex.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("byTime"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("timeIndex"));
    }

    @Test
    public void testUpdateSchemaChangeNameForRelationIndex() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.buildEdgeIndex(knows, "byTime", Direction.BOTH, new PropertyKey[]{time});
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
        RelationTypeIndex byTimeIndex = this.mgmt.getRelationIndex((RelationType)knows, "byTime");
        Assertions.assertEquals((Object)"byTime", (Object)byTimeIndex.name());
        this.mgmt.changeName((JanusGraphSchemaElement)byTimeIndex, "overTime");
        Assertions.assertEquals((Object)"overTime", (Object)byTimeIndex.name());
        this.finishSchema();
        knows = this.mgmt.getEdgeLabel("knows");
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "overTime"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
    }

    @Test
    public void testGotGLoadWithoutIndexBackendException() {
        try {
            GraphOfTheGodsFactory.load((JanusGraph)this.graph);
            Assertions.fail((String)"Expected an exception to be thrown indicating improper index backend configuration");
        }
        catch (IllegalStateException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("loadWithoutMixedIndex"), (String)"An exception asking the user to use loadWithoutMixedIndex was expected");
        }
    }

    @Test
    public void testGotGIndexRemoval() throws InterruptedException, ExecutionException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        String name = "name";
        GraphOfTheGodsFactory.loadWithoutMixedIndex((JanusGraph)this.graph, (boolean)true);
        this.newTx();
        this.finishSchema();
        JanusGraphIndex graphIndex = this.mgmt.getGraphIndex("name");
        Assertions.assertNotNull((Object)graphIndex);
        Assertions.assertEquals((int)1, (int)graphIndex.getFieldKeys().length);
        Assertions.assertEquals((Object)"name", (Object)graphIndex.getFieldKeys()[0].name());
        Assertions.assertEquals((Object)"internalindex", (Object)graphIndex.getBackingIndex());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)graphIndex.getIndexStatus(graphIndex.getFieldKeys()[0]));
        this.mgmt.commit();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        graphIndex = this.mgmt.getGraphIndex("name");
        this.mgmt.updateIndex((Index)graphIndex, SchemaAction.DISABLE_INDEX);
        this.mgmt.commit();
        this.mgmt = this.graph.openManagement();
        ScanJobFuture future = this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("name"), SchemaAction.DISCARD_INDEX);
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"name").status(new SchemaStatus[]{SchemaStatus.DISCARDED})).call().getSucceeded());
        ScanMetrics scanMetrics = (ScanMetrics)future.get();
        Assertions.assertNotEquals((long)0L, (long)scanMetrics.getCustom("deletes"));
    }

    @Test
    public void testVertexCentricEdgeIndexOnSimpleMultiplicityShouldWork() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.SIMPLE).make();
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime").getIndexStatus());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (int i = 200; i < 210; ++i) {
            JanusGraphVertex o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(199), (Comparable)Integer.valueOf(210)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @Test
    public void testVertexCentricPropertyIndexOnSetCardinalityShouldWork() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        this.mgmt.buildPropertyIndex(name, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("name"), "byTime").getIndexStatus());
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (int i = 200; i < 210; ++i) {
            v.property("name", (Object)String.valueOf(i), new Object[]{"time", i});
        }
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(199), (Comparable)Integer.valueOf(210)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @Test
    public void testVertexCentricIndexOrderingOnEdgePropertyWithCardinalityList() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        for (int i = 200; i < 210; ++i) {
            JanusGraphVertex o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime").getIndexStatus());
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @Test
    public void testVertexCentricIndexOrderingOnMetaPropertyWithCardinalityList() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        PropertyKey sensor = this.mgmt.makePropertyKey("sensor").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildPropertyIndex(sensor, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        for (int i = 200; i < 210; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
        }
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime").getIndexStatus());
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        this.tx.commit();
        this.finishSchema();
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testIndexUpdatesWithReindexAndRemove() throws InterruptedException, ExecutionException {
        JanusGraphVertex o;
        int i;
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        PropertyKey sensor = this.mgmt.makePropertyKey("sensor").dataType(Double.class).cardinality(Cardinality.LIST).make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        for (i = 0; i < 10; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, new String[0]);
        this.newTx();
        this.finishSchema();
        sensor = this.mgmt.getPropertyKey("sensor");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        friend = this.mgmt.getEdgeLabel("friend");
        this.mgmt.buildPropertyIndex(sensor, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildIndex("bySensorReading", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (i = 100; i < 110; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.tx.commit();
        RelationTypeIndex pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        RelationTypeIndex eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        JanusGraphIndex graphIndex = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)pindex, SchemaAction.ENABLE_INDEX));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)eindex, SchemaAction.ENABLE_INDEX));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)graphIndex, SchemaAction.ENABLE_INDEX));
        this.mgmt.commit();
        ManagementUtil.awaitVertexIndexUpdate((JanusGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        RelationTypeIndex pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        RelationTypeIndex eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        JanusGraphIndex graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)eindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.finishSchema();
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        this.mgmt.updateIndex((Index)eindex2, SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        Assertions.assertTrue((boolean)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)"byTime", (String)"friend").status(new SchemaStatus[]{SchemaStatus.ENABLED})).call().getSucceeded());
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        ScanMetrics reindexSensorByTime = (ScanMetrics)this.mgmt.updateIndex((Index)pindex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics reindexBySensorReading = (ScanMetrics)this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assertions.assertNotEquals((long)0L, (long)reindexSensorByTime.getCustom("adds"));
        Assertions.assertNotEquals((long)0L, (long)reindexBySensorReading.getCustom("adds"));
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)eindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        for (int i2 = 200; i2 < 210; ++i2) {
            v.property("sensor", (Object)i2, new Object[]{"time", i2});
            v.property("name", (Object)("v" + i2));
            JanusGraphVertex o2 = this.tx.addVertex(new Object[0]);
            v.addEdge("friend", (Vertex)o2, new Object[]{"time", i2});
        }
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 0, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        this.finishSchema();
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        ScanMetrics reindexFriendByTime = (ScanMetrics)this.mgmt.updateIndex((Index)eindex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assertions.assertNotEquals((long)0L, (long)reindexFriendByTime.getCustom("adds"));
        this.finishSchema();
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        this.mgmt.updateIndex((Index)pindex2, SchemaAction.DISABLE_INDEX);
        this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.DISABLE_INDEX);
        this.mgmt.commit();
        this.tx.commit();
        ManagementUtil.awaitVertexIndexUpdate((JanusGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.finishSchema();
        this.newTx();
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.tx.commit();
        this.finishSchema();
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics pmetrics = (ScanMetrics)this.mgmt.updateIndex((Index)pindex2, SchemaAction.DISCARD_INDEX).get();
        ScanMetrics graphIndexMetrics = (ScanMetrics)this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.DISCARD_INDEX).get();
        this.finishSchema();
        Assertions.assertEquals((long)30L, (long)pmetrics.getCustom("deletes"));
        Assertions.assertEquals((long)30L, (long)graphIndexMetrics.getCustom("deletes"));
    }

    @Tag(value="BRITTLE_TESTS")
    @Test
    public void testIndexUpdateSyncWithMultipleInstances() throws InterruptedException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        StandardJanusGraph graph2 = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)this.config);
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "v1"});
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTransaction tx2 = graph2.newTransaction();
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(this.mgmt.getPropertyKey("name")).buildCompositeIndex();
        this.mgmt.commit();
        JanusGraphTransaction tx3 = graph2.newTransaction();
        tx3.addVertex(new Object[]{"name", "v2"});
        tx3.commit();
        this.newTx();
        this.tx.addVertex(new Object[]{"name", "v3"});
        this.tx.commit();
        this.finishSchema();
        try {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        tx2.commit();
        this.mgmt.rollback();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").status(new SchemaStatus[]{SchemaStatus.REGISTERED})).timeout(TestGraphConfigs.getSchemaConvergenceTime(ChronoUnit.SECONDS), (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        tx2 = graph2.newTransaction();
        tx2.addVertex(new Object[]{"name", "v4"});
        tx2.commit();
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        tx2 = graph2.newTransaction();
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        tx2.commit();
        Set openInstances = this.mgmt.getOpenInstances();
        Assertions.assertEquals((int)2, (int)openInstances.size());
        Assertions.assertTrue((boolean)openInstances.contains(this.graph.getConfiguration().getUniqueGraphId() + "(current)"));
        Assertions.assertTrue((boolean)openInstances.contains(graph2.getConfiguration().getUniqueGraphId()));
        try {
            this.mgmt.forceCloseInstance(this.graph.getConfiguration().getUniqueGraphId());
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.forceCloseInstance(graph2.getConfiguration().getUniqueGraphId());
        graph2.close();
    }

    @Tag(value="BRITTLE_TESTS")
    @Test
    public void testIndexShouldRegisterWhenWeRemoveAnInstance() throws InterruptedException {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L));
        StandardJanusGraph graph2 = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)this.config);
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "v1"});
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTransaction tx2 = graph2.newTransaction();
        JanusGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(this.mgmt.getPropertyKey("name")).buildCompositeIndex();
        this.mgmt.commit();
        JanusGraphTransaction tx3 = graph2.newTransaction();
        tx3.addVertex(new Object[]{"name", "v2"});
        tx3.commit();
        this.newTx();
        this.tx.addVertex(new Object[]{"name", "v3"});
        this.tx.commit();
        this.finishSchema();
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX));
        this.finishSchema();
        Set openInstances = this.mgmt.getOpenInstances();
        Assertions.assertEquals((int)2, (int)openInstances.size());
        Assertions.assertTrue((boolean)openInstances.contains(this.graph.getConfiguration().getUniqueGraphId() + "(current)"));
        Assertions.assertTrue((boolean)openInstances.contains(graph2.getConfiguration().getUniqueGraphId()));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.forceCloseInstance(this.graph.getConfiguration().getUniqueGraphId()));
        this.mgmt.forceCloseInstance(graph2.getConfiguration().getUniqueGraphId());
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").status(new SchemaStatus[]{SchemaStatus.REGISTERED})).timeout(TestGraphConfigs.getSchemaConvergenceTime(ChronoUnit.SECONDS), (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
    }

    @Test
    public void testIndexShouldBeEnabledForExistingPropertyKeyAndConstrainedToNewVertexLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        VertexLabel newLabel = this.mgmt.makeVertexLabel("newLabel").make();
        this.mgmt.buildIndex("newIndex", Vertex.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)newLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldBeEnabledForExistingPropertyKeyAndConstrainedToNewEdgeLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel newLabel = this.mgmt.makeEdgeLabel("newLabel").make();
        this.mgmt.buildIndex("newIndex", Edge.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)newLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldNotBeEnabledForExistingPropertyKeyAndConstrainedToExistingVertexLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeVertexLabel("alreadyExistingLabel").make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        VertexLabel existingLabel = this.mgmt.getVertexLabel("alreadyExistingLabel");
        this.mgmt.buildIndex("newIndex", Vertex.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)existingLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldNotBeEnabledForExistingPropertyKeyAndConstrainedToExistingEdgeLabel() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildIndex("newIndex", Edge.class).addKey(existingPropertyKey).indexOnly((JanusGraphSchemaType)existingLabel).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testIndexShouldNotBeEnabledForExistingPropertyKeyWithoutLabelConstraint() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        this.mgmt.buildIndex("newIndex", Vertex.class).addKey(existingPropertyKey).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getGraphIndex("newIndex").getIndexStatus(existingPropertyKey));
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForExistingPropertyKeyAndNewRelationType() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        this.mgmt.makeEdgeLabel("newLabel").make();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel newLabel = this.mgmt.getEdgeLabel("newLabel");
        this.mgmt.buildEdgeIndex(newLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)newLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForNewPropertyKeyAndExistingRelationType() {
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.finishSchema();
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildEdgeIndex(existingLabel, "newIndex", Direction.BOTH, new PropertyKey[]{newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)existingLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForSingleNewPropertyKeyAndExistingRelationType() {
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildEdgeIndex(existingLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey, newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)existingLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForSingleNewPropertyKeyAndNewRelationType() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        this.mgmt.makeEdgeLabel("newLabel").make();
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel newLabel = this.mgmt.getEdgeLabel("newLabel");
        this.mgmt.buildEdgeIndex(newLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey, newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)newLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldBeEnabledForNewPropertyKeyAndNewRelationType() {
        this.mgmt.makePropertyKey("newProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("newLabel").make();
        PropertyKey newPropertyKey = this.mgmt.getPropertyKey("newProperty");
        EdgeLabel newLabel = this.mgmt.getEdgeLabel("newLabel");
        this.mgmt.buildEdgeIndex(newLabel, "newIndex", Direction.BOTH, new PropertyKey[]{newPropertyKey});
        this.finishSchema();
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)newLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testRelationTypeIndexShouldNotBeEnabledForExistingPropertyKeyAndExistingRelationType() {
        this.mgmt.makePropertyKey("alreadyExistingProperty").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("alreadyExistingLabel").make();
        this.finishSchema();
        PropertyKey existingPropertyKey = this.mgmt.getPropertyKey("alreadyExistingProperty");
        EdgeLabel existingLabel = this.mgmt.getEdgeLabel("alreadyExistingLabel");
        this.mgmt.buildEdgeIndex(existingLabel, "newIndex", Direction.BOTH, new PropertyKey[]{existingPropertyKey});
        this.finishSchema();
        Assertions.assertNotEquals((Object)SchemaStatus.ENABLED, (Object)this.mgmt.getRelationIndex((RelationType)existingLabel, "newIndex").getIndexStatus());
    }

    @Test
    public void testPropertyCardinality() {
        PropertyKey uid = this.mgmt.makePropertyKey("uid").dataType(Long.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("byUid", Vertex.class).addKey(uid).unique().buildCompositeIndex();
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property("name", (Object)"name1");
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("uid", (Object)512);
        this.newTx();
        v1 = this.tx.getVertex(v1.id());
        v1.property("name", (Object)"name2");
        v2 = this.tx.getVertex(v2.id());
        v2.property("uid", (Object)512);
        this.newTx();
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (Object)"name1").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (Object)"name2").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("uid", (Object)512).vertices());
    }

    @Test
    public void testImplicitKey() {
        JanusGraphVertex v = this.graph.addVertex(new Object[]{"name", "Dan"});
        JanusGraphVertex u = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e = v.addEdge("knows", (Vertex)u, new Object[0]);
        this.graph.tx().commit();
        RelationIdentifier eid = (RelationIdentifier)e.id();
        Assertions.assertEquals((Object)v.id(), (Object)v.value(ID_NAME));
        Assertions.assertEquals((Object)eid, (Object)e.value(ID_NAME));
        Assertions.assertEquals((Object)"knows", (Object)e.value(LABEL_NAME));
        Assertions.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.name(), (Object)v.value(LABEL_NAME));
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has(ID_NAME, (Object)eid).edges());
        JanusGraphAssert.assertCount(0, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has(ID_NAME, (Object)RelationIdentifier.get((Object[])new Object[]{4L, 5L, 6L, 7L})).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has("~nid", (Object)eid.getRelationId()).edges());
        JanusGraphAssert.assertCount(0, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).has("~nid", (Object)110111).edges());
        Assertions.assertNotNull((Object)JanusGraphTest.getE((Transaction)this.graph, eid));
        Assertions.assertEquals((Object)eid, (Object)JanusGraphTest.getE((Transaction)this.graph, eid).id());
        Assertions.assertEquals((long)1L, (long)v.query().direction(Direction.BOTH).has("~adjacent", u.id()).edgeCount());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.BOTH).has("~adjacent", JanusGraphTest.getId((Element)u)).edges());
        try {
            JanusGraphAssert.assertCount(0, v.query().direction(Direction.BOTH).has("~adjacent", (Object)110111).edges());
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testArrayEqualityUsingImplicitKey() {
        JanusGraphVertex v = this.graph.addVertex(new Object[0]);
        byte[] singleDimension = new byte[]{127, 0, 0, 1};
        byte[] singleDimensionCopy = new byte[]{127, 0, 0, 1};
        String singlePropName = "single";
        v.property("single", (Object)singleDimension);
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
        this.graph.tx().commit();
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
    }

    @Test
    public void testSelfLoop() {
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        v.addEdge("self", (Vertex)v, new Object[0]);
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"self"}).edges());
        this.clopen(new Object[0]);
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        Assertions.assertNotNull((Object)v);
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(1, v.query().direction(Direction.IN).labels(new String[]{"self"}).edges());
        JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"self"}).edges());
    }

    @Test
    public void testThreadBoundTx() {
        PropertyKey t = this.mgmt.makePropertyKey("type").dataType(Integer.class).make();
        this.mgmt.buildIndex("etype", Edge.class).addKey(t).buildCompositeIndex();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new PropertyKey[]{t}).make();
        this.finishSchema();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "Vertex1", "age", 35});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "Vertex2", "age", 45});
        JanusGraphVertex v3 = this.graph.addVertex(new Object[]{"name", "Vertex3", "age", 55});
        JanusGraphEdge e1 = v1.addEdge("knows", (Vertex)v2, new Object[]{"time", 5});
        JanusGraphEdge e2 = v2.addEdge("knows", (Vertex)v3, new Object[]{"time", 15});
        JanusGraphEdge e3 = v3.addEdge("knows", (Vertex)v1, new Object[]{"time", 25});
        JanusGraphEdge e4 = v2.addEdge("friend", (Vertex)v2, new Object[]{"type", 1});
        for (JanusGraphVertex v : new JanusGraphVertex[]{v1, v2, v3}) {
            JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            JanusGraphEdge tmpE = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assertions.assertEquals((int)5, (int)((Integer)tmpE.value("time") % 10));
        }
        e3.property("time", (Object)35);
        Assertions.assertEquals((int)35, (int)((Integer)e3.value("time")));
        v1.addEdge("friend", (Vertex)v2, new Object[]{"type", 0});
        this.graph.tx().commit();
        e4.property("type", (Object)2);
        JanusGraphEdge ef = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"friend"}).edges());
        Assertions.assertEquals((Object)ef, JanusGraphTest.getOnlyElement(this.graph.query().has("type", (Object)0).edges()));
        ef.property("type", (Object)1);
        this.graph.tx().commit();
        Assertions.assertEquals((int)35, (int)((Integer)e3.value("time")));
        e3 = JanusGraphTest.getE((Transaction)this.graph, e3);
        e3.property("time", (Object)45);
        Assertions.assertEquals((int)45, (int)((Integer)e3.value("time")));
        Assertions.assertEquals((int)15, (int)((Integer)e2.value("time")));
        e2.property("time", (Object)25);
        Assertions.assertEquals((int)25, (int)((Integer)e2.value("time")));
        Assertions.assertEquals((int)35, (int)((Integer)v1.value("age")));
        Assertions.assertEquals((int)55, (int)((Integer)v3.value("age")));
        v3.property("age", (Object)65);
        Assertions.assertEquals((int)65, (int)((Integer)v3.value("age")));
        e1 = JanusGraphTest.getE((Transaction)this.graph, e1);
        for (JanusGraphVertex v : new JanusGraphVertex[]{v1, v2, v3}) {
            JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assertions.assertEquals((int)5, (int)((Integer)((JanusGraphEdge)JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges())).value("time") % 10));
        }
        this.graph.tx().commit();
        VertexProperty prop = (VertexProperty)v1.properties(new String[0]).next();
        Assertions.assertTrue((((JanusGraphVertexProperty)prop).longId() > 0L ? 1 : 0) != 0);
        prop = (VertexProperty)((Iterable)this.graph.multiQuery(new JanusGraphVertex[]{v1}).properties().values().iterator().next()).iterator().next();
        Assertions.assertTrue((((JanusGraphVertexProperty)prop).longId() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)45, (int)((Integer)e3.value("time")));
        Assertions.assertEquals((int)5, (int)((Integer)e1.value("time")));
        Assertions.assertEquals((int)35, (int)((Integer)v1.value("age")));
        Assertions.assertEquals((int)65, (int)((Integer)v3.value("age")));
        for (JanusGraphVertex v : new JanusGraphVertex[]{v1, v2, v3}) {
            JanusGraphAssert.assertCount(2, v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(1, v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            Assertions.assertEquals((int)5, (int)((Integer)((JanusGraphEdge)JanusGraphTest.getOnlyElement(v.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges())).value("time") % 10));
        }
        this.graph.tx().commit();
        v1 = this.graph.addVertex(new Object[0]);
        v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        v3 = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e = v1.addEdge("knows", (Vertex)v3, new Object[0]);
        Assertions.assertFalse((boolean)e.property("age").isPresent());
    }

    @Test
    public void testPropertyIdAccessInDifferentTransaction() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        Object expectedId = v1.property("name", (Object)"foo").id();
        this.graph.tx().commit();
        VertexProperty p = (VertexProperty)JanusGraphTest.getOnlyElement(v1.properties(new String[]{"name"}));
        this.graph.tx().commit();
        Assertions.assertEquals((Object)expectedId, (Object)p.id());
    }

    @Test
    public void testCacheForceRefresh() {
        if (this.features.hasLocking()) {
            return;
        }
        this.graph.addVertex(new Object[0]).property("prop", (Object)0);
        this.graph.tx().commit();
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        Vertex v1 = (Vertex)tx1.traversal().V(new Object[0]).next();
        Assertions.assertEquals((Object)0, (Object)v1.property("prop").value());
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        Vertex v2 = (Vertex)tx2.traversal().V(new Object[0]).next();
        Assertions.assertEquals((Object)0, (Object)v2.property("prop").value());
        v2.property("prop", (Object)2);
        Assertions.assertEquals((Object)2, (Object)v2.property("prop").value());
        tx2.commit();
        Assertions.assertEquals((Object)0, (Object)v1.property("prop").value());
        Assertions.assertEquals((Object)0, (Object)((Vertex)tx1.traversal().V(new Object[]{v1}).next()).property("prop").value());
        Assertions.assertEquals((Object)0, (Object)((Property)tx1.traversal().V(new Object[]{v1}).properties(new String[]{"prop"}).next()).value());
        ((CacheVertex)v1).refresh();
        Assertions.assertEquals((Object)2, (Object)v1.property("prop").value());
        Assertions.assertEquals((Object)2, (Object)((Vertex)tx1.traversal().V(new Object[]{v1}).next()).property("prop").value());
        Assertions.assertEquals((Object)2, (Object)((Property)tx1.traversal().V(new Object[]{v1}).properties(new String[]{"prop"}).next()).value());
        v1.property("prop", (Object)1);
        ((CacheVertex)v1).refresh();
        Assertions.assertEquals((Object)1, (Object)v1.property("prop").value());
        Assertions.assertEquals((Object)1, (Object)((Vertex)tx1.traversal().V(new Object[]{v1}).next()).property("prop").value());
        Assertions.assertEquals((Object)1, (Object)((Property)tx1.traversal().V(new Object[]{v1}).properties(new String[]{"prop"}).next()).value());
        tx1.commit();
    }

    @Test
    public void testTransactionScopeTransition() {
        this.tx.rollback();
        JanusGraphVertex newV = this.graph.addVertex(new Object[0]);
        this.graph.tx().commit();
        newV.property("prop", (Object)"value");
        this.graph.tx().commit();
    }

    @Test
    public void testNestedTransactions() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        this.newTx();
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v2.property("name", (Object)"foo");
        this.tx.commit();
        v1.addEdge("related", (Vertex)this.graph.traversal().V(new Object[]{v2}).next(), new Object[0]);
        this.graph.tx().commit();
        JanusGraphAssert.assertCount(1, v1.edges(Direction.OUT, new String[0]));
    }

    @Test
    public void testStaleVertex() {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex cartman = this.graph.addVertex(new Object[]{"name", "cartman", "age", 10});
        this.graph.addVertex(new Object[]{"name", "stan", "age", 8});
        this.graph.tx().commit();
        cartman = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.graph.query().has("name", (Object)"cartman").vertices());
        this.graph.tx().commit();
        JanusGraphVertexProperty p = (JanusGraphVertexProperty)cartman.properties(new String[0]).next();
        Assertions.assertTrue((p.longId() > 0L ? 1 : 0) != 0);
        this.graph.tx().commit();
    }

    @Test
    public void testTransactionIsolation() {
        this.makeLabel("knows");
        this.finishSchema();
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        JanusGraphVertex v11 = tx1.addVertex(new Object[0]);
        JanusGraphVertex v12 = tx1.addVertex(new Object[0]);
        v11.addEdge("knows", (Vertex)v12, new Object[0]);
        JanusGraphVertex v21 = tx2.addVertex(new Object[0]);
        try {
            v21.addEdge("knows", (Vertex)v11, new Object[0]);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        JanusGraphVertex v22 = tx2.addVertex(new Object[0]);
        v21.addEdge("knows", (Vertex)v22, new Object[0]);
        tx2.commit();
        try {
            v22.addEdge("knows", (Vertex)v21, new Object[0]);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        tx1.rollback();
        try {
            v11.property(VertexProperty.Cardinality.single, "test", (Object)5, new Object[0]);
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.newTx();
        v21 = JanusGraphTest.getV((Transaction)this.tx, v21);
        this.tx.makeEdgeLabel("link").unidirected().make();
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v21.addEdge("link", (Vertex)v3, new Object[0]);
        this.newTx();
        v21 = JanusGraphTest.getV((Transaction)this.tx, v21);
        v3 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assertions.assertFalse((boolean)v3.isRemoved());
        v3.remove();
        this.newTx();
        v21 = JanusGraphTest.getV((Transaction)this.tx, v21);
        v3 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assertions.assertFalse((boolean)v3.isRemoved());
        this.newTx();
        JanusGraphTransaction tx3 = this.graph.buildTransaction().checkInternalVertexExistence(true).start();
        v21 = JanusGraphTest.getV((Transaction)tx3, v21);
        v3 = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)v21.query().direction(Direction.OUT).labels(new String[]{"link"}).vertices());
        Assertions.assertTrue((boolean)v3.isRemoved());
        tx3.commit();
    }

    @Test
    public <V> void testMultivaluedVertexProperty() {
        String foo = "foo";
        String bar = "bar";
        String weight = "weight";
        ImmutableList values = ImmutableList.of((Object)"four", (Object)"score", (Object)"and", (Object)"seven");
        Assertions.assertTrue((2 <= values.size() ? 1 : 0) != 0, (String)"Values list must have multiple elements for this test to make sense");
        PropertyKey w = this.makeKey("weight", Integer.class);
        PropertyKey f = ((StandardPropertyKeyMaker)this.mgmt.makePropertyKey("foo")).dataType(String.class).cardinality(Cardinality.LIST).sortKey(new PropertyKey[]{w}).sortOrder(Order.DESC).make();
        this.mgmt.buildIndex("foo", Vertex.class).addKey(f).buildCompositeIndex();
        PropertyKey b = this.mgmt.makePropertyKey("bar").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("bar", Vertex.class).addKey(b).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        int i = 0;
        for (String s : values) {
            v.property("foo", (Object)s, new Object[]{"weight", ++i});
            v.property("bar", (Object)s, new Object[]{"weight", i});
        }
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"foo"}));
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"bar"}));
        for (String prop : new String[]{"foo", "bar"}) {
            int sum = 0;
            int index = values.size();
            for (Object o : v.query().labels(new String[]{"foo"}).properties()) {
                JanusGraphVertexProperty p = (JanusGraphVertexProperty)o;
                Assertions.assertTrue((boolean)values.contains(p.value()));
                int weightAsInteger = (Integer)p.value("weight");
                sum += weightAsInteger;
                if (prop.equals("foo")) {
                    Assertions.assertEquals((int)index, (int)weightAsInteger);
                }
                --index;
            }
            Assertions.assertEquals((int)(values.size() * (values.size() + 1) / 2), (int)sum);
        }
        JanusGraphAssert.assertCount(1, this.tx.query().has("foo", values.get(1)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("foo", values.get(3)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(1)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(3)).vertices());
        JanusGraphTest.asStream(v.properties(new String[]{"foo"})).forEach(Property::remove);
        JanusGraphAssert.assertEmpty(v.properties(new String[]{"foo"}));
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(0, this.tx.query().has("foo", values.get(1)).vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("foo", values.get(3)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(1)).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bar", values.get(3)).vertices());
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        JanusGraphAssert.assertEmpty(v.properties(new String[]{"foo"}));
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"bar"}));
        for (String s : values) {
            v.property("foo", (Object)s);
        }
        JanusGraphAssert.assertCount(values.size(), v.properties(new String[]{"foo"}));
        JanusGraphTest.asStream(v.properties(new String[]{"foo"})).forEach(Property::remove);
        JanusGraphAssert.assertEmpty(v.properties(new String[]{"foo"}));
    }

    @Test
    public void testLocalGraphConfiguration() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.STORAGE_READONLY, ConfigOption.Type.LOCAL, true);
    }

    @Test
    public void testMaskableGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.DB_CACHE, ConfigOption.Type.MASKABLE, true, false);
    }

    @Test
    public void testGlobalGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, ConfigOption.Type.GLOBAL, true, false);
    }

    @Test
    public void testGlobalOfflineGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.IDS_STORE_NAME, ConfigOption.Type.GLOBAL_OFFLINE, "testIdsStoreName", "testIdsStoreName2");
    }

    @Test
    public void testFixedGraphConfig() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.INITIAL_JANUSGRAPH_VERSION, ConfigOption.Type.FIXED, "foo");
    }

    @Test
    public void testManagedOptionMasking() throws BackendException {
        Duration customCommitTime = Duration.ofMillis(456L);
        Preconditions.checkState((boolean)((Boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getDefaultValue()));
        Preconditions.checkState((boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getType().equals((Object)ConfigOption.Type.MASKABLE));
        Preconditions.checkState((!customCommitTime.equals(GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue()) ? 1 : 0) != 0);
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        try {
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            Assertions.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (JanusGraphConfigurationException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
        this.graph.getBackend().clearStorage();
        try {
            this.graph.close();
        }
        catch (Throwable t) {
            this.log.debug("Swallowing throwable during shutdown after clearing backend storage", t);
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        try {
            this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
            Assertions.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (JanusGraphConfigurationException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime);
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)wc);
        Assertions.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
    }

    @Test
    public void testTransactionConfiguration() {
        block2: {
            JanusGraphTransaction readOnlyTx = this.graph.buildTransaction().readOnly().start();
            try {
                readOnlyTx.addVertex(new Object[0]);
                readOnlyTx.commit();
                Assertions.fail((String)"Read-only transactions should not be able to add a vertex and commit");
            }
            catch (Throwable t) {
                if (!readOnlyTx.isOpen()) break block2;
                readOnlyTx.rollback();
            }
        }
        String logID = "spam";
        StandardJanusGraphTx customLogIDTx = (StandardJanusGraphTx)this.graph.buildTransaction().logIdentifier(logID).start();
        Assertions.assertEquals((Object)logID, (Object)customLogIDTx.getConfiguration().getLogIdentifier());
        customLogIDTx.rollback();
        Instant customTimestamp = Instant.ofEpochMilli(-42L);
        StandardJanusGraphTx customTimeTx = (StandardJanusGraphTx)this.graph.buildTransaction().commitTime(customTimestamp).start();
        Assertions.assertTrue((boolean)customTimeTx.getConfiguration().hasCommitTime());
        Assertions.assertEquals((Object)customTimestamp, (Object)customTimeTx.getConfiguration().getCommitTime());
        customTimeTx.rollback();
    }

    private <A> void setAndCheckGraphOption(ConfigOption<A> opt, ConfigOption.Type requiredType, A firstValue, A secondValue) {
        Preconditions.checkState((boolean)opt.getType().equals((Object)requiredType));
        EnumSet<ConfigOption.Type> allowedTypes = EnumSet.of(ConfigOption.Type.GLOBAL, ConfigOption.Type.GLOBAL_OFFLINE, ConfigOption.Type.MASKABLE);
        Preconditions.checkState((boolean)allowedTypes.contains(opt.getType()));
        Preconditions.checkArgument((!firstValue.equals(secondValue) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        this.mgmt.set(path, firstValue);
        Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.tx.rollback();
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.set(path, secondValue);
        Assertions.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assertions.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        JanusGraph g2 = JanusGraphFactory.open((ReadConfiguration)this.config);
        JanusGraphManagement m2 = g2.openManagement();
        Assertions.assertEquals((Object)secondValue.toString(), (Object)m2.get(path));
        if (opt.getType().equals((Object)ConfigOption.Type.GLOBAL_OFFLINE)) {
            try {
                this.mgmt.set(path, firstValue);
                this.mgmt.commit();
                Assertions.fail((String)("Option " + path + " with type " + ConfigOption.Type.GLOBAL_OFFLINE + " should not be modifiable with concurrent instances"));
            }
            catch (RuntimeException e) {
                this.log.debug("Caught expected exception", (Throwable)e);
            }
            Assertions.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        } else {
            this.mgmt.set(path, firstValue);
            Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
            this.mgmt.commit();
            this.clopen(new Object[0]);
            Assertions.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        }
        m2.rollback();
        g2.close();
    }

    private <A> void setIllegalGraphOption(ConfigOption<A> opt, ConfigOption.Type requiredType, A attemptedValue) {
        ConfigOption.Type type = opt.getType();
        Preconditions.checkState((boolean)type.equals((Object)requiredType));
        Preconditions.checkArgument((requiredType.equals((Object)ConfigOption.Type.LOCAL) || requiredType.equals((Object)ConfigOption.Type.FIXED) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        try {
            this.mgmt.get(path);
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
        try {
            this.mgmt.set(path, attemptedValue);
            this.mgmt.commit();
            Assertions.fail((String)("Option " + path + " with type " + type + " should not be modifiable in the persistent graph config"));
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
    }

    @Test
    public void testConsistencyEnforcement() {
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.setConsistency((JanusGraphSchemaElement)uid, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)name, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").multiplicity(Multiplicity.MULTI).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.setConsistency((JanusGraphSchemaElement)knows, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)spouse, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((JanusGraphSchemaElement)related, ConsistencyModifier.FORK);
        this.finishSchema();
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{"uid", 1});
        JanusGraphVertex v2 = this.tx.addVertex(new Object[]{"uid", 2});
        JanusGraphVertex v3 = this.tx.addVertex(new Object[]{"uid", 3});
        JanusGraphEdge e1 = v1.addEdge(connect.name(), (Vertex)v2, new Object[]{name.name(), "e1"});
        JanusGraphEdge e2 = v1.addEdge(related.name(), (Vertex)v2, new Object[]{name.name(), "e2"});
        this.newTx();
        v1 = JanusGraphTest.getV((Transaction)this.tx, v1);
        Object e1id = JanusGraphTest.getId((Element)e1);
        Object e2id = JanusGraphTest.getId((Element)e2);
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((Object)"e1", (Object)e1.value("name"));
        Assertions.assertEquals((Object)e1id, (Object)JanusGraphTest.getId((Element)e1));
        e2 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"related"}).edges());
        Assertions.assertEquals((Object)"e2", (Object)e2.value("name"));
        Assertions.assertEquals((Object)e2id, (Object)JanusGraphTest.getId((Element)e2));
        e1.property("name", (Object)"e1.2");
        e2.property("name", (Object)"e2.2");
        this.newTx();
        v1 = JanusGraphTest.getV((Transaction)this.tx, v1);
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"connect"}).edges());
        Assertions.assertEquals((Object)"e1.2", (Object)e1.value("name"));
        Assertions.assertEquals((Object)e1id, (Object)JanusGraphTest.getId((Element)e1));
        e2 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"related"}).edges());
        Assertions.assertEquals((Object)"e2.2", (Object)e2.value("name"));
        Assertions.assertNotEquals((Object)e2id, (Object)JanusGraphTest.getId((Element)e2));
        this.clopen(new Object[0]);
        Random random = new Random();
        final Object[] vertexIds = new Object[]{JanusGraphTest.getId((Element)v1), JanusGraphTest.getId((Element)v2), JanusGraphTest.getId((Element)v3)};
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, new TransactionJob(){
            private int pos = 0;

            @Override
            public void run(JanusGraphTransaction tx) {
                JanusGraphVertex u = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[this.pos++]);
                u.property(VertexProperty.Cardinality.single, "uid", (Object)5, new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, tx -> {
            JanusGraphVertex u = JanusGraphTest.getV((Transaction)tx, vertexIds[0]);
            u.property(VertexProperty.Cardinality.single, "name", (Object)("v" + random.nextInt(10)), new Object[0]);
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, tx -> {
            JanusGraphVertex u1 = JanusGraphTest.getV((Transaction)tx, vertexIds[0]);
            JanusGraphVertex u2 = JanusGraphTest.getV((Transaction)tx, vertexIds[1]);
            u1.addEdge("knows", (Vertex)u2, new Object[0]);
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(JanusGraphTransaction tx) {
                JanusGraphVertex u1 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[0]);
                JanusGraphVertex u2 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[this.pos++]);
                u1.addEdge("spouse", (Vertex)u2, new Object[0]);
            }
        });
        this.executeLockConflictingTransactionJobs((JanusGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(JanusGraphTransaction tx) {
                JanusGraphVertex u1 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[this.pos++]);
                JanusGraphVertex u2 = JanusGraphBaseTest.getV((Transaction)tx, vertexIds[0]);
                u1.addEdge("spouse", (Vertex)u2, new Object[0]);
            }
        });
        try {
            this.mgmt.setConsistency((JanusGraphSchemaElement)this.mgmt.getPropertyKey("name"), ConsistencyModifier.FORK);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void executeLockConflictingTransactionJobs(JanusGraph graph, TransactionJob job) {
        JanusGraphException janusGraphException;
        JanusGraphTransaction tx1 = graph.newTransaction();
        JanusGraphTransaction tx2 = graph.newTransaction();
        job.run(tx1);
        job.run(tx2);
        if (this.isLockingOptimistic()) {
            tx1.commit();
            janusGraphException = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> ((JanusGraphTransaction)tx2).commit());
        } else {
            janusGraphException = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> ((JanusGraphTransaction)tx1).commit());
            tx2.commit();
        }
        Throwable rootCause = janusGraphException.getCause().getCause();
        Assertions.assertTrue((boolean)(rootCause instanceof PermanentLockingException));
        Assertions.assertTrue((boolean)rootCause.getMessage().contains("Expected value mismatch for"));
    }

    @Test
    public void testConcurrentConsistencyEnforcement() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        JanusGraphIndex nameIndex = this.mgmt.buildIndex("name", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.mgmt.setConsistency((JanusGraphSchemaElement)nameIndex, ConsistencyModifier.LOCK);
        EdgeLabel married = this.mgmt.makeEdgeLabel("married").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.setConsistency((JanusGraphSchemaElement)married, ConsistencyModifier.LOCK);
        this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        JanusGraphVertex baseV = this.tx.addVertex(new Object[]{"name", "base"});
        this.newTx();
        Object baseVid = JanusGraphTest.getId((Element)baseV);
        String nameA = "a";
        String nameB = "b";
        int parallelThreads = 4;
        int[] results = this.executeParallelTransactions(tx -> {
            JanusGraphVertex a = tx.addVertex(new Object[0]);
            JanusGraphVertex base = JanusGraphTest.getV((Transaction)tx, baseVid);
            base.addEdge("married", (Vertex)a, new Object[0]);
        }, 4);
        int numOfSuccess = results[0];
        int numOfLockContentions = results[1];
        Assertions.assertEquals((int)1, (int)numOfSuccess);
        Assertions.assertEquals((int)3, (int)numOfLockContentions);
        results = this.executeParallelTransactions(tx -> {
            tx.addVertex(new Object[]{"name", "a"});
            JanusGraphVertex b = tx.addVertex(new Object[]{"name", "b"});
            b.addEdge("friend", (Vertex)b, new Object[0]);
        }, 4);
        numOfSuccess = results[0];
        numOfLockContentions = results[1];
        Assertions.assertTrue((numOfSuccess <= 1 ? 1 : 0) != 0);
        Assertions.assertEquals((int)(4 - numOfSuccess), (int)numOfLockContentions);
        this.newTx();
        long numA = Iterables.size((Iterable)this.tx.query().has("name", (Object)"a").vertices());
        long numB = Iterables.size((Iterable)this.tx.query().has("name", (Object)"b").vertices());
        Assertions.assertTrue((numA <= 1L ? 1 : 0) != 0);
        Assertions.assertTrue((numB <= 1L ? 1 : 0) != 0);
    }

    private void failTransactionOnCommit(TransactionJob job) {
        JanusGraphTransaction tx = this.graph.newTransaction();
        Assertions.assertThrows(Exception.class, () -> {
            job.run(tx);
            tx.commit();
        });
        if (tx.isOpen()) {
            tx.rollback();
        }
    }

    private int[] executeParallelTransactions(final TransactionJob job, int concurrency) {
        final CountDownLatch startLatch = new CountDownLatch(concurrency);
        final CountDownLatch finishLatch = new CountDownLatch(concurrency);
        final AtomicInteger txSuccess = new AtomicInteger(0);
        final AtomicInteger lockingExCount = new AtomicInteger(0);
        for (int i = 0; i < concurrency; ++i) {
            new Thread(){

                @Override
                public void run() {
                    JanusGraphTransaction tx = JanusGraphTest.this.graph.newTransaction();
                    try {
                        job.run(tx);
                        this.awaitAllThreadsReady();
                        tx.commit();
                        txSuccess.incrementAndGet();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (tx.isOpen()) {
                            tx.rollback();
                        }
                        if (ex.getCause() instanceof PermanentLockingException && ex.getCause().getMessage().contains("Local lock contention")) {
                            lockingExCount.incrementAndGet();
                        }
                    }
                    finally {
                        finishLatch.countDown();
                    }
                }

                private void awaitAllThreadsReady() {
                    startLatch.countDown();
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        try {
            finishLatch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return new int[]{txSuccess.get(), lockingExCount.get()};
    }

    @Test
    public void testVertexCentricQuery() {
        this.testVertexCentricQuery(10000);
    }

    public void testVertexCentricQuery(int noVertices) {
        int nowTime;
        int i;
        VertexList vl;
        int i2;
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey time = this.makeKey("time", Integer.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey number = this.makeKey("number", Long.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connect")).sortKey(new PropertyKey[]{time}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connectDesc")).sortKey(new PropertyKey[]{time}).sortOrder(Order.DESC).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new PropertyKey[]{weight, time}).sortOrder(Order.ASC).signature(new PropertyKey[]{number}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friendDesc")).sortKey(new PropertyKey[]{weight, time}).sortOrder(Order.DESC).signature(new PropertyKey[]{number}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{number, weight}).make();
        this.mgmt.makeEdgeLabel("follows").make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "v"});
        JanusGraphVertex u = this.tx.addVertex(new Object[]{"name", "u"});
        Assertions.assertEquals((int)0, (int)((noVertices - 1) % 3));
        JanusGraphVertex[] vs = new JanusGraphVertex[noVertices];
        for (int i3 = 0; i3 < noVertices; ++i3) {
            vs[i3] = this.tx.addVertex(new Object[]{"name", "v" + i3});
        }
        EdgeLabel[] labelsV = new EdgeLabel[]{this.tx.getEdgeLabel("connect"), this.tx.getEdgeLabel("friend"), this.tx.getEdgeLabel("knows")};
        EdgeLabel[] labelsU = new EdgeLabel[]{this.tx.getEdgeLabel("connectDesc"), this.tx.getEdgeLabel("friendDesc"), this.tx.getEdgeLabel("knows")};
        for (int i4 = 1; i4 < noVertices; ++i4) {
            for (JanusGraphVertex vertex : new JanusGraphVertex[]{v, u}) {
                for (Direction d : new Direction[]{Direction.OUT, Direction.IN}) {
                    EdgeLabel label = vertex == v ? labelsV[i4 % 3] : labelsU[i4 % 3];
                    JanusGraphEdge e = d == Direction.OUT ? vertex.addEdge(JanusGraphTest.n(label), (Vertex)vs[i4], new Object[0]) : vs[i4].addEdge(JanusGraphTest.n(label), (Vertex)vertex, new Object[0]);
                    e.property("time", (Object)i4);
                    e.property("weight", (Object)((double)(i4 % 4) + 0.5));
                    e.property("name", (Object)("e" + i4));
                    e.property("number", (Object)(i4 % 5));
                }
            }
        }
        int edgesPerLabel = noVertices / 3;
        this.clopen(new Object[0]);
        Object[] vertexIdSubset = new Object[28];
        for (i2 = 0; i2 < vertexIdSubset.length; ++i2) {
            vertexIdSubset[i2] = vs[i2 + 3].id();
        }
        Arrays.sort(vertexIdSubset);
        this.clopen(new Object[0]);
        for (i2 = 1; i2 < noVertices; ++i2) {
            vs[i2] = JanusGraphTest.getV((Transaction)this.tx, vs[i2].id());
        }
        v = JanusGraphTest.getV((Transaction)this.tx, v.id());
        u = JanusGraphTest.getV((Transaction)this.tx, u.id());
        Object[] qvs = new JanusGraphVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        JanusGraphAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assertions.assertEquals((long)1L, (long)v.query().propertyCount());
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        int lastTime = 0;
        for (Object e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime2 = (Integer)e.value("time");
            Assertions.assertTrue((lastTime <= nowTime2 ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime2));
            lastTime = nowTime2;
        }
        lastTime = Integer.MAX_VALUE;
        for (Object e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime3 = (Integer)e.value("time");
            Assertions.assertTrue((lastTime >= nowTime3 ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime3));
            lastTime = nowTime3;
        }
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Iterator outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (Object e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assertions.assertEquals((Object)e, outer.next());
        }
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assertions.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).edgeCount());
        Assertions.assertEquals((int)10, (int)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assertions.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)31).count());
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        int friendsWhoHaveOutEdgesWithWeightBetweenPointFiveAndOnePointFive = (int)Math.round(Math.ceil((double)(1667 * noVertices) / 10000.0));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, friendsWhoHaveOutEdgesWithWeightBetweenPointFiveAndOnePointFive, 2, new boolean[]{true, true});
        Assertions.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)5).edgeCount());
        Assertions.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10).edgeCount());
        Assertions.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assertions.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).has("weight", (Object)3.5).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[8]).has("time", (Object)8).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((int)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assertions.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).edgeCount());
        Assertions.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.OUT).vertices()));
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assertions.assertEquals((Object)vertexIdSubset[i], (Object)vl.getID(i));
            }
        }
        JanusGraphAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().properties()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().keys(new String[]{"name"}).properties()));
        Map results = this.tx.multiQuery((JanusGraphVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).labels(new String[]{"knows"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)result));
        }
        Map results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        this.clopen(new Object[0]);
        for (int i5 = 1; i5 < noVertices; ++i5) {
            vs[i5] = JanusGraphTest.getV((Transaction)this.tx, vs[i5].id());
        }
        v = JanusGraphTest.getV((Transaction)this.tx, v.id());
        u = JanusGraphTest.getV((Transaction)this.tx, u.id());
        qvs = new JanusGraphVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)30).limit(10).vertices()));
        lastTime = 0;
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime = (Integer)e.value("time");
            Assertions.assertTrue((lastTime <= nowTime ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime));
            lastTime = nowTime;
        }
        lastTime = Integer.MAX_VALUE;
        for (Edge e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime = (Integer)e.value("time");
            Assertions.assertTrue((lastTime >= nowTime ? 1 : 0) != 0, (String)(lastTime + " vs. " + nowTime));
            lastTime = nowTime;
        }
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)60).limit(10).vertices()));
        outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assertions.assertEquals((Object)e, outer.next());
        }
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assertions.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).edgeCount());
        Assertions.assertEquals((int)10, (int)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assertions.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)31).count());
        Assertions.assertEquals((int)10, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, friendsWhoHaveOutEdgesWithWeightBetweenPointFiveAndOnePointFive, 2, new boolean[]{true, true});
        Assertions.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).edgeCount());
        Assertions.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).edgeCount());
        Assertions.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10).edgeCount());
        Assertions.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).edgeCount());
        Assertions.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("number", (Object)0).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).edgeCount());
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assertions.assertEquals((int)20, (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assertions.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).edgeCount());
        Assertions.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent((Vertex)vs[11]).has("weight", (Object)3.5).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[6]).has("time", (Object)6).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent((Vertex)vs[8]).has("time", (Object)8).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)2L, (long)v.query().adjacent((Vertex)vs[11]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)0L, (long)v.query().labels(new String[0]).direction(Direction.BOTH).adjacent((Vertex)vs[0]).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).edgeCount());
        Assertions.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).edgeCount());
        Assertions.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).edgeCount());
        Assertions.assertEquals((int)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (int)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assertions.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).edgeCount());
        Assertions.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)10).edgeCount());
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.OUT).vertices()));
        Assertions.assertEquals((int)(noVertices - 1), (int)Iterables.size((Iterable)v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assertions.assertEquals((Object)vertexIdSubset[i], (Object)vl.getID(i));
            }
        }
        JanusGraphAssert.assertCount(2 * (noVertices - 1), v.query().direction(Direction.BOTH).edges());
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().properties()));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)v.query().keys(new String[]{"name"}).properties()));
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).labels(new String[]{"knows"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((JanusGraphVertex[])qvs).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((JanusGraphVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("name", (Object)"v").vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((int)2, (int)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).vertexIds().size());
        Assertions.assertEquals((int)10, (int)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).vertexIds().size());
        this.newTx();
        v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("name", (Object)"v").vertices());
        Assertions.assertNotNull((Object)v);
        Assertions.assertEquals((long)2L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).edgeCount());
        Assertions.assertEquals((long)10L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).edgeCount());
        this.newTx();
        JanusGraphVertex[] qvs2 = new JanusGraphVertex[qvs.length + 2];
        qvs2[0] = this.tx.addVertex(new Object[0]);
        for (int i6 = 0; i6 < qvs.length; ++i6) {
            qvs2[i6 + 1] = JanusGraphTest.getV((Transaction)this.tx, qvs[i6].id());
        }
        qvs2[qvs2.length - 1] = this.tx.addVertex(new Object[0]);
        qvs2[0].addEdge("connect", (Vertex)qvs2[qvs2.length - 1], new Object[0]);
        qvs2[qvs2.length - 1].addEdge("connect", (Vertex)qvs2[0], new Object[0]);
        results = this.tx.multiQuery(qvs2).direction(Direction.IN).labels(new String[]{"connect"}).edges();
        for (Iterable result : results.values()) {
            Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)result));
        }
    }

    @Test
    public void shouldBeAbleToIterateManagementIterablesMultipleTimes() {
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        Iterable vertexLabels = this.mgmt.getVertexLabels();
        vertexLabels.iterator();
        vertexLabels.iterator();
        Iterable graphIndexes = this.mgmt.getGraphIndexes(Vertex.class);
        graphIndexes.iterator();
        graphIndexes.iterator();
        Iterable relationTypes = this.mgmt.getRelationTypes(EdgeLabel.class);
        relationTypes.iterator();
        relationTypes.iterator();
        Iterable relationTypeIndices = this.mgmt.getRelationIndexes((RelationType)child);
        relationTypeIndices.iterator();
        relationTypeIndices.iterator();
    }

    @Test
    public void testRelationTypeIndexes() {
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{time}).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().make();
        RelationTypeIndex name1 = this.mgmt.buildPropertyIndex(name, "weightDesc", new PropertyKey[]{weight});
        RelationTypeIndex connect1 = this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.asc, new PropertyKey[]{weight});
        RelationTypeIndex connect2 = this.mgmt.buildEdgeIndex(connect, "weightDesc", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{weight});
        RelationTypeIndex connect3 = this.mgmt.buildEdgeIndex(connect, "time+weight", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time, weight});
        RelationTypeIndex child1 = this.mgmt.buildEdgeIndex(child, "time", Direction.OUT, new PropertyKey[]{time});
        RelationTypeIndex link1 = this.mgmt.buildEdgeIndex(link, "time", Direction.OUT, new PropertyKey[]{time});
        String name1n = name1.name();
        String connect1n = connect1.name();
        String connect2n = connect2.name();
        String connect3n = connect3.name();
        String child1n = child1.name();
        String link1n = link1.name();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assertions.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").name());
        Assertions.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assertions.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)child)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)connect)));
        Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        weight = this.mgmt.getPropertyKey("weight");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        connect = this.mgmt.getEdgeLabel("connect");
        child = this.mgmt.getEdgeLabel("child");
        link = this.mgmt.getEdgeLabel("link");
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assertions.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assertions.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assertions.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").name());
        Assertions.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assertions.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)child)));
        Assertions.assertEquals((int)3, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)connect)));
        Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new PropertyKey[]{time});
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.rollback();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        int numV = 100;
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        JanusGraphVertex[] ns = new JanusGraphVertex[100];
        for (int i = 0; i < 100; ++i) {
            double w = (double)i * 0.5 % 5.0;
            long t = (i + 77) % 100;
            JanusGraphVertexProperty p = v.property("name", (Object)("v" + i), new Object[]{"weight", w, "time", t});
            ns[i] = this.tx.addVertex(new Object[0]);
            String[] stringArray = new String[]{"connect", "child", "link"};
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String label = stringArray[j];
                JanusGraphEdge janusGraphEdge = v.addEdge(label, (Vertex)ns[i], new Object[]{"weight", w, "time", t});
            }
        }
        JanusGraphVertex u = ns[0];
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        u = JanusGraphTest.getV((Transaction)this.tx, u);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)0.9).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("weight", (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        VertexList vl = v.query().labels(new String[]{"child"}).direction(Direction.BOTH).vertexIds();
        Assertions.assertEquals((int)100, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assertions.assertEquals((int)20, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).vertexIds();
        Assertions.assertEquals((int)10, (int)vl.size());
        Assertions.assertFalse((boolean)vl.isSorted());
        Assertions.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        u = JanusGraphTest.getV((Transaction)this.tx, u);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)0.9).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("weight", (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        vl = v.query().labels(new String[]{"child"}).direction(Direction.BOTH).vertexIds();
        Assertions.assertEquals((int)100, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{"child"}).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assertions.assertEquals((int)20, (int)vl.size());
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{"child"}).interval("time", (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).vertexIds();
        Assertions.assertEquals((int)10, (int)vl.size());
        Assertions.assertFalse((boolean)vl.isSorted());
        Assertions.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assertions.assertTrue((boolean)vl.isSorted());
        Assertions.assertTrue((boolean)this.isSortedByID(vl));
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)22).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent((Vertex)u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        for (Object o : v.query().labels(new String[]{"name"}).properties()) {
            JanusGraphVertexProperty p = (JanusGraphVertexProperty)o;
            if ((Long)p.value("time") >= 50L) continue;
            p.remove();
        }
        for (JanusGraphEdge o : v.query().direction(Direction.BOTH).edges()) {
            if ((Long)o.value("time") >= 50L) continue;
            o.remove();
        }
        ns = new JanusGraphVertex[150];
        for (int i = 100; i < 150; ++i) {
            double w = (double)i * 0.5 % 5.0;
            v.property("name", (Object)("v" + i), new Object[]{"weight", w, "time", (long)i});
            ns[i] = this.tx.addVertex(new Object[0]);
            for (String label : new String[]{"connect", "child", "link"}) {
                JanusGraphEdge janusGraphEdge = v.addEdge(label, (Vertex)ns[i], new Object[]{"weight", w, "time", (long)i});
            }
        }
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.newTx();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        v = JanusGraphTest.getV((Transaction)this.tx, v);
        u = JanusGraphTest.getV((Transaction)this.tx, u);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).has("weight", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().keys(new String[]{"name"}).interval("time", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query().labels(new String[]{"child"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        JanusGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        JanusGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
    }

    @Test
    public void testAutoSchemaMakerAllowsToSetCardinalityList() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex next = (Vertex)g.addV().property(VertexProperty.Cardinality.list, (Object)"name", (Object)"marko a. rodriguez", new Object[0]).property(VertexProperty.Cardinality.list, (Object)"name", (Object)"sdsdsd", new Object[0]).next();
        next = (Vertex)g.V(new Object[]{next.id()}).property((Object)"name", (Object)"sdsdsd", new Object[0]).next();
        Assertions.assertEquals((int)3, (int)g.V(new Object[]{next}).values(new String[]{"name"}).toList().size());
    }

    @Test
    public void testAutoSchemaMakerAllowsToSetCardinalitySet() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex next = (Vertex)g.addV().property(VertexProperty.Cardinality.set, (Object)"name", (Object)"marko a. rodriguez", new Object[0]).property(VertexProperty.Cardinality.set, (Object)"name", (Object)"sdsdsd", new Object[0]).property(VertexProperty.Cardinality.set, (Object)"name", (Object)"sdsdsd", new Object[0]).next();
        next = (Vertex)g.V(new Object[]{next.id()}).property((Object)"name", (Object)"sdsdsd", new Object[0]).next();
        Assertions.assertEquals((int)2, (int)g.V(new Object[]{next}).values(new String[]{"name"}).toList().size());
    }

    @Test
    public void testAutoSchemaMakerAllowsToSetCardinalitySingle() {
        GraphTraversalSource g = this.graph.traversal();
        Vertex next = (Vertex)g.addV().property(VertexProperty.Cardinality.single, (Object)"name", (Object)"marko a. rodriguez", new Object[0]).property((Object)"name", (Object)"sdsdsd", new Object[0]).property((Object)"name", (Object)"sdsdsd", new Object[0]).next();
        Assertions.assertEquals((int)1, (int)g.V(new Object[]{next}).values(new String[]{"name"}).toList().size());
    }

    private void createStrictSchemaForVertexProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel label = this.mgmt.makeVertexLabel("user").make();
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(label, new PropertyKey[]{id});
        this.finishSchema();
    }

    @Test
    public void testEnforcedSchemaAllowsDefinedVertexProperties() {
        this.createStrictSchemaForVertexProperties();
        JanusGraphVertex v = this.tx.addVertex("user");
        v.property("id", (Object)10);
    }

    @Test
    public void testSchemaIsEnforcedForVertexProperties() {
        this.createStrictSchemaForVertexProperties();
        JanusGraphVertex v = this.tx.addVertex("user");
        try {
            v.property("test", (Object)10);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAllowDisablingSchemaConstraintForVertexProperty() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), false);
        this.mgmt.makeVertexLabel("user").make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex("user");
        v.property("test", (Object)10);
    }

    @Test
    public void testAllowDisablingSchemaConstraintForConnection() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), false);
        this.mgmt.makeVertexLabel("user").make();
        this.mgmt.makeEdgeLabel("knows").make();
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
    }

    @Test
    public void testAllowDisablingSchemaConstraintForEdgeProperty() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), false);
        this.mgmt.makeVertexLabel("user").make();
        this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"test", 10});
    }

    @Test
    public void testAutoSchemaMakerForVertexPropertyConstraints() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v1 = this.tx.addVertex("user");
        v1.property("test", (Object)10);
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v2.property("test", (Object)10);
        try {
            v2.property("id", (Object)10);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSupportDirectCommitOfSchemaChangesForVertexProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        GraphTraversalSource g = this.graph.traversal();
        VertexLabel label = this.mgmt.makeVertexLabel("user").make();
        PropertyKey prop = this.mgmt.makePropertyKey("id").dataType(Integer.class).make();
        this.mgmt.addProperties(label, new PropertyKey[]{prop});
        this.mgmt.commit();
        g.addV("user").property((Object)"id", (Object)10, new Object[0]).iterate();
    }

    private GraphTraversalSource prepareGraphForDirectCommitTests() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        GraphTraversalSource g = this.graph.traversal();
        VertexLabel user = this.mgmt.makeVertexLabel("user").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{id});
        this.mgmt.addConnection(edge, user, user);
        this.mgmt.commit();
        return g;
    }

    @Test
    public void testSupportDirectCommitOfSchemaChangesForConnection() {
        GraphTraversalSource g = this.prepareGraphForDirectCommitTests();
        g.addV("user").as("p1", new String[0]).addV("user").addE("knows").from("p1").iterate();
    }

    @Test
    public void testSupportDirectCommitOfSchemaChangesForEdgeProperties() {
        GraphTraversalSource g = this.prepareGraphForDirectCommitTests();
        g.addV("user").as("p1", new String[0]).addV("user").addE("knows").from("p1").property((Object)"id", (Object)10, new Object[0]).iterate();
    }

    private void createStrictSchemaForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel user = this.mgmt.makeVertexLabel("user").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("test").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{id});
        this.mgmt.addConnection(edge, user, user);
        this.finishSchema();
    }

    @Test
    public void testEnforcedSchemaAllowsDefinedEdgeProperties() {
        this.createStrictSchemaForEdgeProperties();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10});
    }

    @Test
    public void testSchemaIsEnforcedForEdgeProperties() {
        this.createStrictSchemaForEdgeProperties();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        try {
            v1.addEdge("knows", (Vertex)v2, new Object[]{"test", 10});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAllowSingleCardinalityForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        PropertyKey propertyKey1 = this.mgmt.makePropertyKey("propertyKey1").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{propertyKey1});
        PropertyKey propertyKey2 = this.mgmt.makePropertyKey("propertyKey2").dataType(Integer.class).make();
        this.mgmt.addProperties(edge, new PropertyKey[]{propertyKey2});
        this.finishSchema();
    }

    @Test
    public void testBanListCardinalityForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        try {
            PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.LIST).dataType(Integer.class).make();
            this.mgmt.addProperties(edge, new PropertyKey[]{id});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
    }

    @Test
    public void testBanSetCardinalityForEdgeProperties() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        try {
            PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SET).dataType(Integer.class).make();
            this.mgmt.addProperties(edge, new PropertyKey[]{id});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
    }

    @Test
    public void testAutoSchemaMakerForEdgePropertyConstraints() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10});
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        v1 = this.tx.addVertex("user");
        v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10});
        try {
            v1.addEdge("knows", (Vertex)v2, new Object[]{"test", 10});
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void createStrictSchemaForConnections() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel user = this.mgmt.makeVertexLabel("user").make();
        VertexLabel company = this.mgmt.makeVertexLabel("company").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("knows").make();
        this.mgmt.makeEdgeLabel("buys").make();
        this.mgmt.addConnection(edge, user, company);
        this.finishSchema();
    }

    @Test
    public void testEnforcedSchemaAllowsDefinedConnections() {
        this.createStrictSchemaForConnections();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("company");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
    }

    @Test
    public void testSchemaIsEnforcedForConnections() {
        this.createStrictSchemaForConnections();
        JanusGraphVertex v1 = this.tx.addVertex("user");
        try {
            v1.addEdge("buys", (Vertex)v1, new Object[0]);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        JanusGraphVertex v2 = this.tx.addVertex("company");
        try {
            v2.addEdge("knows", (Vertex)v1, new Object[0]);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAutoSchemaMakerForConnectionConstraints() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        v1 = this.tx.addVertex("user");
        v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        try {
            v1.addEdge("has", (Vertex)v2, new Object[0]);
            Assertions.fail((String)"This should never reached!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSupportChangeNameOfEdgeAndUpdateConnections() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel user = this.mgmt.makeVertexLabel("V1").make();
        VertexLabel company = this.mgmt.makeVertexLabel("V2").make();
        EdgeLabel edge = this.mgmt.makeEdgeLabel("E1").make();
        this.mgmt.addConnection(edge, user, company);
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("V1");
        JanusGraphVertex v2 = this.tx.addVertex("V2");
        v1.addEdge("E1", (Vertex)v2, new Object[0]);
        this.newTx();
        edge = this.mgmt.getEdgeLabel("E1");
        this.mgmt.changeName((JanusGraphSchemaElement)edge, "E2");
        this.mgmt.commit();
        JanusGraphVertex v3 = this.tx.addVertex("V1");
        JanusGraphVertex v4 = this.tx.addVertex("V2");
        v3.addEdge("E2", (Vertex)v4, new Object[0]);
    }

    private void createStrictSchemaForComplexConnections() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none", JanusGraphTest.option(GraphDatabaseConfiguration.SCHEMA_CONSTRAINTS, new String[0]), true);
        VertexLabel v1 = this.mgmt.makeVertexLabel("V1").make();
        VertexLabel v2 = this.mgmt.makeVertexLabel("V2").make();
        VertexLabel v3 = this.mgmt.makeVertexLabel("V3").make();
        VertexLabel v4 = this.mgmt.makeVertexLabel("V4").make();
        EdgeLabel e1 = this.mgmt.makeEdgeLabel("E1").make();
        EdgeLabel e2 = this.mgmt.makeEdgeLabel("E2").make();
        this.mgmt.addConnection(e1, v1, v2);
        this.mgmt.addConnection(e1, v3, v4);
        this.mgmt.addConnection(e2, v1, v4);
        this.mgmt.addConnection(e2, v3, v2);
        this.finishSchema();
    }

    @Test
    public void testAllowEnforcedComplexConnections() {
        this.createStrictSchemaForComplexConnections();
        JanusGraphVertex v1 = this.tx.addVertex("V1");
        JanusGraphVertex v2 = this.tx.addVertex("V2");
        JanusGraphVertex v3 = this.tx.addVertex("V3");
        JanusGraphVertex v4 = this.tx.addVertex("V4");
        v1.addEdge("E1", (Vertex)v2, new Object[0]);
        v3.addEdge("E1", (Vertex)v4, new Object[0]);
        v3.addEdge("E2", (Vertex)v2, new Object[0]);
        v1.addEdge("E2", (Vertex)v4, new Object[0]);
    }

    @Test
    public void testEnforceComplexConnections() {
        this.createStrictSchemaForComplexConnections();
        JanusGraphVertex v1 = this.tx.addVertex("V1");
        JanusGraphVertex v2 = this.tx.addVertex("V2");
        JanusGraphVertex v3 = this.tx.addVertex("V3");
        JanusGraphVertex v4 = this.tx.addVertex("V4");
        Assertions.assertThrows(IllegalArgumentException.class, () -> v1.addEdge("E2", (Vertex)v2, new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> v3.addEdge("E2", (Vertex)v4, new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> v3.addEdge("E1", (Vertex)v2, new Object[0]));
        Assertions.assertThrows(IllegalArgumentException.class, () -> v1.addEdge("E1", (Vertex)v4, new Object[0]));
    }

    private boolean isSortedByID(VertexList vl) {
        for (int i = 1; i < vl.size(); ++i) {
            if (IDUtils.compare((Object)vl.getID(i - 1), (Object)vl.getID(i)) <= 0) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testEdgesExceedCacheSize() {
        int numEdges = this.graph.getConfiguration().getTxVertexCacheSize();
        JanusGraphVertex parentVertex = this.graph.addVertex(new Object[0]);
        for (int i = 0; i < numEdges; ++i) {
            JanusGraphVertex childVertex = this.graph.addVertex(new Object[0]);
            parentVertex.addEdge("friend", (Vertex)childVertex, new Object[0]);
        }
        this.graph.tx().commit();
        JanusGraphAssert.assertCount(numEdges, parentVertex.query().direction(Direction.OUT).edges());
        ((JanusGraphEdge)parentVertex.query().direction(Direction.OUT).edges().iterator().next()).remove();
        JanusGraphAssert.assertCount(numEdges - 1, parentVertex.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertCount(numEdges - 1, parentVertex.query().direction(Direction.OUT).edges());
    }

    @Test
    public void testRemoveCachedVertexVisibility() {
        int cacheSize = this.graph.getConfiguration().getTxVertexCacheSize();
        ArrayList<Object> vertexIds = new ArrayList<Object>();
        for (int i = 0; i < cacheSize; ++i) {
            JanusGraphVertex vertex = this.graph.addVertex(new Object[0]);
            vertexIds.add(vertex.id());
        }
        Object vertexIdToBeDeleted = this.graph.addVertex(new Object[0]).id();
        this.graph.tx().commit();
        Vertex retrievedVertex = (Vertex)this.graph.traversal().V(new Object[]{vertexIdToBeDeleted}).next();
        retrievedVertex.remove();
        this.graph.traversal().V(new Object[]{vertexIds}).toStream().collect(Collectors.toList());
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[]{vertexIdToBeDeleted}).hasNext());
    }

    @Test
    public void testNestedContainPredicates() {
        int graphSize = 10;
        for (int i = 0; i < graphSize; ++i) {
            this.graph.addVertex(new Object[]{"id", i});
        }
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).has("id", P.within((Object[])new Integer[]{4, 5, 6})).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).has("id", P.within((Object[])new Object[0])).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)6L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)5L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.within((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).has("id", P.without((Object[])new Integer[]{4, 5, 6})).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).has("id", P.without((Object[])new Object[0])).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 1), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 6), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 5), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 2), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)graphSize, (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)(graphSize - 3), (Long)((Long)g.V(new Object[0]).or(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Object[0])), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{6, 7, 8}))}).count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{4, 5, 6}))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Integer[]{2, 3, 4})), __.has((String)"id", (P)P.without((Object[])new Object[0]))}).count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)g.V(new Object[0]).and(new Traversal[]{__.has((String)"id", (P)P.within((Object[])new Object[0])), __.has((String)"id", (P)P.without((Object[])new Integer[]{2, 3, 4}))}).count().next()));
    }

    @Test
    public void testTinkerPopCardinality() {
        PropertyKey id = this.mgmt.makePropertyKey("id").cardinality(Cardinality.SINGLE).dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").cardinality(Cardinality.SINGLE).dataType(String.class).make();
        PropertyKey names = this.mgmt.makePropertyKey("names").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.mgmt.buildIndex("byId", Vertex.class).addKey(id).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex v = this.graph.addVertex(new Object[]{"id", 1});
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t1", new Object[0]);
        this.graph.addVertex(new Object[]{"id", 2, "names", "n1", "names", "n2"});
        this.graph.tx().commit();
        GraphTraversalSource gts = this.graph.traversal();
        v = (Vertex)gts.V(new Object[0]).has("id", (Object)1).next();
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t2", new Object[0]);
        v = (Vertex)gts.V(new Object[0]).has("id", (Object)1).next();
        v.property(VertexProperty.Cardinality.single, "name", (Object)"t3", new Object[0]);
        JanusGraphAssert.assertCount(1, (Traversal)gts.V(new Object[]{v}).properties(new String[]{"name"}));
        JanusGraphAssert.assertCount(2, (Traversal)gts.V(new Object[0]).has("id", (Object)2).properties(new String[]{"names"}));
        JanusGraphAssert.assertCount(2, (Traversal)gts.V(new Object[0]).hasLabel("vertex", new String[0]));
    }

    @Test
    public void testMultiQueryMetricsWhenReadingFromBackend() {
        int numV = 100;
        JanusGraphVertex[] vs = new JanusGraphVertex[numV];
        for (int i = 0; i < numV; ++i) {
            vs[i] = this.graph.addVertex(new Object[]{"id", i, "weight", i % 5});
        }
        int superV = 10;
        int sid = -1;
        JanusGraphVertex[] sv = new JanusGraphVertex[superV];
        for (int i = 0; i < superV; ++i) {
            sv[i] = this.graph.addVertex(new Object[]{"id", sid});
            for (int j = 0; j < numV; ++j) {
                sv[i].addEdge("knows", (Vertex)vs[j], new Object[]{"weight", j % 5});
                sv[i].property(VertexProperty.Cardinality.list, "names", (Object)("n" + j), new Object[]{"weight", j % 5});
            }
        }
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true);
        GraphTraversalSource gts = this.graph.traversal();
        GraphTraversal t = gts.V(new Object[0]).has("id", (Object)sid).local((Traversal)__.outE((String[])new String[]{"knows"}).has("weight", P.gte((Object)1)).has("weight", P.lt((Object)3)).order().by("weight", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(10L)).profile("~metrics");
        JanusGraphAssert.assertCount(superV * 10, (Traversal)t);
        Assertions.assertTrue((boolean)JanusGraphAssert.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
        t = gts.V(new Object[0]).has("id", (Object)sid).values(new String[]{"names"}).profile("~metrics");
        JanusGraphAssert.assertCount(superV * numV, (Traversal)t);
        Assertions.assertTrue((boolean)JanusGraphAssert.queryProfilerAnnotationIsPresent((Traversal)t, "multi"));
    }

    @Test
    public void testLimitBatchSizeForMultiQueryRepeatStep() {
        int barrierSize = 50;
        int limit = 135;
        int levelVerticesAmount = 3;
        int depth = 6;
        JanusGraphVertex a = this.graph.addVertex(new Object[0]);
        a.property("depth", (Object)Integer.MAX_VALUE);
        a.property("localAddedVertexNumber", (Object)1);
        a.property("levelVertexNumber", (Object)1);
        a.property("parentNumber", (Object)-1);
        HashMap<Integer, Integer> levelToNumberOfVertices = new HashMap<Integer, Integer>();
        this.addTestAdjacentVertices((Vertex)a, 3, 6, levelToNumberOfVertices);
        this.graph.tx().commit();
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.barrier((int)50).out(new String[]{"knows"}).barrier(50)).until((Traversal)__.out((String[])new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 2);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).repeat((Traversal)__.barrier((int)50).out(new String[]{"knows"}).barrier(50)).until((Traversal)__.barrier((int)50).out(new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 2);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit((Traversal)__.out((String[])new String[]{"knows"})).limit(135L).count(), new Object[0]);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).repeat((Traversal)__.out((String[])new String[]{"knows"})).emit((Traversal)__.out((String[])new String[]{"knows"}).hasId(P.neq((Object)-100L))).count(), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH_SIZE, new String[0]), Integer.MAX_VALUE);
        Assertions.assertTrue((this.countBackendQueriesOfSize(s -> s > 150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, Integer.MAX_VALUE, profile);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).until((Traversal)__.out((String[])new String[]{"knows"}).has("depth", (Object)"3")).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 2);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).emit().repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit().count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit((Traversal)__.out((String[])new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 2);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).emit((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 3);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 150L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertTrue((this.countBackendQueriesOfSize(3L, (Collection<? extends Metrics>)profile.getMetrics()) > (long)((int)Math.pow(3.0, 6.0)) ? 1 : 0) != 0);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).emit((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 2);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).emit((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 150L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertTrue((this.countBackendQueriesOfSize(3L, (Collection<? extends Metrics>)profile.getMetrics()) > (long)((int)Math.pow(3.0, 6.0)) ? 1 : 0) != 0);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 3);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit().count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 3);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).emit().repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 3);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).emit().repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 150L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertTrue((this.countBackendQueriesOfSize(3L, (Collection<? extends Metrics>)profile.getMetrics()) > (long)((int)Math.pow(3.0, 6.0)) ? 1 : 0) != 0);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit().until((Traversal)__.in((String[])new String[]{"knows"}).has("depth", (Object)"3")).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 3);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.union((Traversal[])new Traversal[]{__.out((String[])new String[]{"knows"}), __.where((Traversal)__.in((String[])new String[]{"knows"})).none()}).barrier(50)).emit().count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 150L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertTrue((this.countBackendQueriesOfSize(3L, (Collection<? extends Metrics>)profile.getMetrics()) <= 2L ? 1 : 0) != 0);
        Assertions.assertTrue((this.countBackendQueriesOfSize(9L, (Collection<? extends Metrics>)profile.getMetrics()) <= 2L ? 1 : 0) != 0);
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize((long)Math.pow(3.0, 3.0), (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).out(new String[]{"knows"}).barrier(50).union(new Traversal[]{__.repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).emit(), __.identity()}).count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 2);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).repeat((Traversal)__.repeat((Traversal)__.barrier((int)50).out(new String[]{"knows"}).barrier(50))).emit().count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 2);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).repeat((Traversal)__.barrier((int)50).out(new String[]{"knows"}).barrier(50)).until((Traversal)__.out((String[])new String[]{"knows"}).has("depth", (Object)"3")).emit().count(), new Object[0]);
        Assertions.assertTrue((this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()) > 0L ? 1 : 0) != 0);
        this.assertRepeatBatchSizeByLoop(6, 3, 50, profile, 3);
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true);
        Vertex[] middleVertices = this.graph.traversal().V(new Object[]{a}).repeat((Traversal)__.out((String[])new String[]{"knows"})).times(4).toList().toArray(new Vertex[0]);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])middleVertices).barrier(50).repeat((Traversal)__.barrier((int)50).union(new Traversal[]{__.repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).until((Traversal)__.identity())}).barrier(50)).until((Traversal)__.identity()).limit(1L), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.REPEAT_STEP_BATCH_MODE, new String[0]), MultiQueryStrategyRepeatStepMode.CLOSEST_REPEAT_PARENT.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(3L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 3L, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])middleVertices).barrier(50).repeat((Traversal)__.barrier((int)50).union(new Traversal[]{__.repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).until((Traversal)__.identity())}).barrier(50)).until((Traversal)__.identity()).limit(1L), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.REPEAT_STEP_BATCH_MODE, new String[0]), MultiQueryStrategyRepeatStepMode.ALL_REPEAT_PARENTS.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s < 150L, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])middleVertices).barrier(50).repeat((Traversal)__.barrier((int)50).union(new Traversal[]{__.repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).until((Traversal)__.identity())}).barrier(50)).until((Traversal)__.identity()).limit(1L), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.REPEAT_STEP_BATCH_MODE, new String[0]), MultiQueryStrategyRepeatStepMode.STARTS_ONLY_OF_ALL_REPEAT_PARENTS.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(150L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s < 150L, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.barrier((int)1).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).until((Traversal)__.identity().loops().is(P.gt((Object)0))).barrier(50)).until((Traversal)__.identity().loops().is(P.gt((Object)1))), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.REPEAT_STEP_BATCH_MODE, new String[0]), MultiQueryStrategyRepeatStepMode.ALL_REPEAT_PARENTS.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(3L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(9L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 9L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s < 3L, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).barrier(50).repeat((Traversal)__.barrier((int)1).repeat((Traversal)__.out((String[])new String[]{"knows"}).barrier(50)).until((Traversal)__.identity().loops().is(P.gt((Object)0))).barrier(50)).until((Traversal)__.identity().loops().is(P.gt((Object)1))), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.REPEAT_STEP_BATCH_MODE, new String[0]), MultiQueryStrategyRepeatStepMode.STARTS_ONLY_OF_ALL_REPEAT_PARENTS.getConfigName());
        Assertions.assertEquals((long)4L, (long)this.countBackendQueriesOfSize(3L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 3L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s < 3L, (Collection<? extends Metrics>)profile.getMetrics()));
    }

    private void assertRepeatBatchSizeByLoop(int depth, int levelVerticesAmount, int barrierSize, TraversalMetrics profile) {
        this.assertRepeatBatchSizeByLoop(depth, levelVerticesAmount, barrierSize, profile, 1);
    }

    private void assertRepeatBatchSizeByLoop(int depth, int levelVerticesAmount, int barrierSize, TraversalMetrics profile, int uniqueBatchRequestsAmount) {
        int calculatedMaxReturnSize;
        try {
            calculatedMaxReturnSize = Math.multiplyExact(levelVerticesAmount, barrierSize);
        }
        catch (Exception e) {
            calculatedMaxReturnSize = Integer.MAX_VALUE;
        }
        int maxReturnSize = calculatedMaxReturnSize;
        int currentReturnSize = 1;
        for (int currentLoop = 0; currentReturnSize < maxReturnSize && currentLoop <= depth; currentReturnSize *= levelVerticesAmount, ++currentLoop) {
            Assertions.assertTrue((this.countBackendQueriesOfSize(currentReturnSize, (Collection<? extends Metrics>)profile.getMetrics()) <= (long)(uniqueBatchRequestsAmount * 2) ? 1 : 0) != 0);
        }
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > (long)maxReturnSize, (Collection<? extends Metrics>)profile.getMetrics()));
    }

    private void addTestAdjacentVertices(Vertex vertex, int levelVerticesAmount, int depth, Map<Integer, Integer> levelToNumberOfVertices) {
        if (depth < 0) {
            return;
        }
        int addedVertices = 0;
        Integer parentNumber = (Integer)vertex.value("levelVertexNumber");
        for (int i = 0; i < levelVerticesAmount; ++i) {
            JanusGraphVertex adjacentVertex = this.graph.addVertex(new Object[0]);
            adjacentVertex.property("foo", (Object)"bar");
            adjacentVertex.property("depth", (Object)depth);
            adjacentVertex.property("localAddedVertexNumber", (Object)(++addedVertices));
            levelToNumberOfVertices.put(depth, levelToNumberOfVertices.getOrDefault(depth, 0) + 1);
            adjacentVertex.property("levelVertexNumber", (Object)levelToNumberOfVertices.get(depth));
            adjacentVertex.property("parentNumber", (Object)parentNumber);
            vertex.addEdge("knows", (Vertex)adjacentVertex, new Object[0]);
            this.addTestAdjacentVertices((Vertex)adjacentVertex, levelVerticesAmount, depth - 1, levelToNumberOfVertices);
        }
    }

    @Test
    public void testLimitBatchSizeForMultiQueryMultiCardinalityProperties() {
        JanusGraphVertex[] cs = this.setupDataForMultiQueryMultiCardinalityProperties();
        int barrierSize = 27;
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo", "setProperty", "listProperty"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize + barrierSize * 4 + barrierSize * 4, (Collection<? extends Metrics>)profile.getMetrics()));
        int lastBatch = cs.length - 3 * barrierSize;
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(lastBatch + lastBatch * 4 + lastBatch * 4, (Collection<? extends Metrics>)profile.getMetrics()));
    }

    @Test
    public void testMultiQueryPropertiesWithLimit() {
        JanusGraphVertex[] cs = this.setupDataForMultiQueryMultiCardinalityProperties();
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false);
        this.verityMultiQueryPropertiesWithLimit(cs);
    }

    protected void verityMultiQueryPropertiesWithLimit(JanusGraphVertex[] cs) {
        cs = this.graph.traversal().V((Object[])cs).toList().toArray(new JanusGraphVertex[0]);
        for (String[] keys : Arrays.asList({"foo", "fooBar", "barFoo"}, {"foo"}, {"fooBar"}, {"barFoo"})) {
            Map properties = this.graph.multiQuery(new JanusGraphVertex[]{cs[0], cs[1], cs[3]}).limit(1).keys(keys).properties();
            HashMap deserializedProperties = new HashMap();
            Assertions.assertEquals((int)3, (int)properties.size());
            properties.forEach((janusGraphVertex, janusGraphVertexProperties) -> {
                HashMap props = new HashMap();
                janusGraphVertexProperties.forEach(janusGraphVertexProperty -> ((ArrayList)props.computeIfAbsent(janusGraphVertexProperty.key(), k -> new ArrayList())).add(janusGraphVertexProperty.value()));
                deserializedProperties.put(janusGraphVertex, props);
            });
            for (Map vertexProps : deserializedProperties.values()) {
                int numOfValues = 0;
                for (Object val : vertexProps.values()) {
                    numOfValues += ((List)val).size();
                }
                Assertions.assertEquals((int)1, (int)numOfValues);
            }
        }
    }

    protected JanusGraphVertex[] setupDataForMultiQueryMultiCardinalityProperties() {
        this.mgmt.makeVertexLabel("testVertex").make();
        this.mgmt.makePropertyKey("setProperty").cardinality(Cardinality.SET).dataType(String.class).make();
        this.mgmt.makePropertyKey("listProperty").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.finishSchema();
        int numV = 100;
        JanusGraphVertex[] cs = new JanusGraphVertex[numV];
        for (int i = 0; i < numV; ++i) {
            cs[i] = this.graph.addVertex("testVertex");
            cs[i].property("foo", (Object)"bar");
            cs[i].property("fooBar", (Object)"Bar");
            cs[i].property("barFoo", (Object)"Foo");
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue1", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue2", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue3", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.set, "setProperty", (Object)"setValue4", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue1", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue2", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue3", new Object[0]);
            cs[i].property(VertexProperty.Cardinality.list, "listProperty", (Object)"listValue4", new Object[0]);
        }
        return cs;
    }

    @Test
    public void testLimitBatchSizeForMultiQuery() {
        this.mgmt.makeVertexLabel("testVertex").make();
        this.finishSchema();
        int numV = 100;
        JanusGraphVertex a = this.graph.addVertex(new Object[0]);
        JanusGraphVertex[] bs = new JanusGraphVertex[numV];
        JanusGraphVertex[] cs = new JanusGraphVertex[numV];
        for (int i = 0; i < numV; ++i) {
            bs[i] = this.graph.addVertex(new Object[0]);
            cs[i] = this.graph.addVertex("testVertex");
            cs[i].property("foo", (Object)"bar");
            cs[i].property("fooBar", (Object)"Bar");
            cs[i].property("barFoo", (Object)"Foo");
            a.addEdge("knows", (Vertex)bs[i], new Object[0]);
            bs[i].addEdge("knows", (Vertex)cs[i], new Object[0]);
        }
        int barrierSize = 27;
        int limit = 40;
        this.testLimitBatchSizeForHasStep(numV, barrierSize, limit, bs, cs);
        this.testLimitBatchSizeForPropertySteps(numV, barrierSize, limit, cs);
        this.testLimitBatchSizeForLabelStep(numV, barrierSize, limit, bs, cs);
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).out(new String[0]), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).out(new String[0]).limit((long)limit), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize)), (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).out(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), false);
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(bs.length * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).where((Traversal)__.out((String[])new String[0])), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), false);
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(bs.length * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).where((Traversal)__.out((String[])new String[0])), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V(new Object[]{a}).repeat((Traversal)__.barrier((int)barrierSize).out(new String[0])).times(2), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).project("a", new String[]{"b"}).by((Traversal)__.id()).by((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).choose((Traversal)__.hasId((P)P.gte((Object)0L)), (Traversal)__.out((String[])new String[]{"knows"}), (Traversal)__.identity()), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).coalesce(new Traversal[]{__.out((String[])new String[]{"knows"}), __.identity()}), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).and(new Traversal[]{__.out((String[])new String[]{"knows"}), __.hasId((P)P.gte((Object)0))}), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).or(new Traversal[]{__.out((String[])new String[]{"knows"}), __.hasId((P)P.gte((Object)0))}), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).sideEffect((Traversal)__.out((String[])new String[]{"knows"}).sideEffect(Traverser::get)), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).map((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).where((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).filter((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).optional((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).not((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).union(new Traversal[]{__.identity(), __.out((String[])new String[]{"knows"})}), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).local((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).group().by((Traversal)__.out((String[])new String[]{"knows"}).count()), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).groupCount().by((Traversal)__.out((String[])new String[]{"knows"})), new Object[0]);
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        this.testLimitBatchSizeForMultiQueryOfConnectiveSteps(bs, barrierSize, limit);
    }

    private void testLimitBatchSizeForPropertySteps(int numV, int barrierSize, int limit, JanusGraphVertex[] cs) {
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize)), (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize)), (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize)), (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)6L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)6L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        int propertiesCount = (int)((Long)this.graph.traversal().V((Object[])cs).values(new String[0]).count().next() / (long)numV);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize)), (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize / 2.0)), (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize)), (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize / 2.0)), (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize)), (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)((int)Math.ceil((double)limit / (double)barrierSize / 2.0)), (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)6L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)6L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo", "fooBar"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)2L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo", "fooBar"}).limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertEquals((long)100L, (long)this.countBackendQueriesOfSize(s -> true, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertiesStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).values(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertEquals((long)100L, (long)this.countOptimizationQueries(profile.getMetrics()));
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertiesStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertEquals((long)100L, (long)this.countBackendQueriesOfSize(s -> true, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertiesStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).properties(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertEquals((long)100L, (long)this.countOptimizationQueries(profile.getMetrics()));
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertiesStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertyMapStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertyMapStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertyMapStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphPropertyMapStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphElementMapStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).elementMap(new String[]{"foo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.NONE.getConfigName());
        Assertions.assertNull((Object)JanusGraphAssert.getLastStepMetrics(profile, JanusGraphElementMapStep.class).getAnnotation("multi"));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.ids), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.labels), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[0]).with(WithOptions.tokens, (Object)(WithOptions.ids | WithOptions.labels)), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).valueMap(new String[0]).with(WithOptions.tokens, (Object)WithOptions.all), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * propertiesCount, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().withStrategies(new TraversalStrategy[]{SubgraphStrategy.create((Configuration)new MapConfiguration(Collections.singletonMap("vertexProperties", __.hasNot((String)"fooBar"))))}).V((Object[])cs).barrier(barrierSize).propertyMap(new String[]{"foo"}).select(Column.values).unfold().unfold(), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
    }

    private void testLimitBatchSizeForHasStep(int numV, int barrierSize, int limit, JanusGraphVertex[] bs, JanusGraphVertex[] cs) {
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).union(new Traversal[]{__.has((String)"foo", (Object)"bar")}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((double)Math.ceil((double)limit / (double)barrierSize), (double)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").limit(1L), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).hasLabel("testVertex", new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).hasId(P.within((Object[])new Object[]{cs[0].id(), cs[1].id(), cs[2].id(), cs[3].id()})), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s > 0L, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).hasLabel("testVertex", new String[0]).hasId(P.within((Object[])new Object[]{cs[0].id(), cs[1].id(), cs[2].id(), cs[3].id()})), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(4L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(s -> s != 4L, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").hasLabel("testVertex", new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").hasId(P.within((Object[])new Object[]{cs[0].id(), cs[1].id(), cs[2].id(), cs[3].id()})), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(12L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(4L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").hasLabel("testVertex", new String[0]).hasId(P.within((Object[])new Object[]{cs[0].id(), cs[1].id(), cs[2].id(), cs[3].id()})), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(12L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(4L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).hasLabel("testVertex", new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        ArrayList<JanusGraphVertex> allVertices = new ArrayList<JanusGraphVertex>(cs.length + bs.length);
        allVertices.addAll(Arrays.asList(cs));
        allVertices.addAll(Arrays.asList(bs));
        JanusGraphVertex[] allVerticesArr = allVertices.toArray(new JanusGraphVertex[0]);
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])allVerticesArr).barrier(barrierSize).hasLabel("testVertex", new String[0]).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)4L, (long)this.countBackendQueriesOfSize(0L, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").has("barFoo", (Object)"Foo"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 2, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").valueMap(new String[]{"barFoo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").properties(new String[]{"barFoo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").values(new String[]{"barFoo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").elementMap(new String[]{"barFoo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").valueMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").properties(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").values(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").propertyMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").valueMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").elementMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").identity().values(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").elementMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").barrier(5000).identity().barrier(100).identity().elementMap(new String[0]), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.TX_CACHE_SIZE, new String[0]), barrierSize / 4, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)15L, (long)this.countBackendQueriesOfSize(barrierSize / 4 * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(9L, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").values(new String[]{"barFoo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES_OR_ALL.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar").map(Traverser::get).values(new String[]{"barFoo"}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES_OR_ALL.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).has("foo", (Object)"bar").has("fooBar", (Object)"Bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.NONE.getConfigName());
        Assertions.assertFalse((boolean)profile.toString().contains(JanusGraphHasStep.class.getSimpleName()));
        Assertions.assertTrue((boolean)profile.toString().contains(HasStep.class.getSimpleName()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).repeat((Traversal)__.has((String)"foo", (Object)"bar").in(new String[]{"knows"})).emit(), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).out(new String[]{"knows"}).barrier(barrierSize).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).out(new String[]{"knows"}).barrier(barrierSize).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).out(new String[]{"knows"}).barrier(barrierSize).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.NONE.getConfigName());
        Assertions.assertFalse((boolean)profile.toString().contains(JanusGraphHasStep.class.getSimpleName()));
        Assertions.assertTrue((boolean)profile.toString().contains(HasStep.class.getSimpleName()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).out(new String[]{"knows"}).barrier(barrierSize).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize((numV - 3 * barrierSize) * 3, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).out(new String[]{"knows"}).barrier(barrierSize).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_AND_NEXT_PROPERTIES.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).out(new String[]{"knows"}).barrier(barrierSize).has("foo", (Object)"bar"), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.NONE.getConfigName());
        Assertions.assertFalse((boolean)profile.toString().contains(JanusGraphHasStep.class.getSimpleName()));
        Assertions.assertTrue((boolean)profile.toString().contains(HasStep.class.getSimpleName()));
    }

    private void testLimitBatchSizeForMultiQueryOfConnectiveSteps(JanusGraphVertex[] bs, int barrierSize, int limit) {
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).and(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)bs.length / (double)barrierSize) * 2), (long)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).and(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}).limit((long)limit), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)Math.min(bs.length, limit) / (double)barrierSize) * 2), (long)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).and(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)1000000)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)bs.length / (double)barrierSize)), (long)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).and(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)1000000)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}).limit((long)limit), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)bs.length / (double)barrierSize)), (long)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).or(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)1000000)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)bs.length / (double)barrierSize) * 2), (long)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).or(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)1000000)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}).limit((long)limit), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)Math.min(bs.length, limit) / (double)barrierSize) * 2), (long)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).or(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)bs.length / (double)barrierSize)), (long)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).or(new Traversal[]{__.out((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0)), __.inE((String[])new String[]{"knows"}).count().is((Object)P.gte((Object)0))}).limit((long)limit), new Object[0]);
        Assertions.assertEquals((long)((int)Math.ceil((double)Math.min(bs.length, limit) / (double)barrierSize)), (long)this.countOptimizationQueries(profile.getMetrics()));
    }

    private void testLimitBatchSizeForLabelStep(int numV, int barrierSize, int limit, JanusGraphVertex[] bs, JanusGraphVertex[] cs) {
        TraversalMetrics profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).label(), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LABEL_STEP_BATCH_MODE, new String[0]), MultiQueryLabelStepStrategyMode.ALL.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])bs).barrier(barrierSize).label(), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LABEL_STEP_BATCH_MODE, new String[0]), MultiQueryLabelStepStrategyMode.ALL.getConfigName());
        Assertions.assertEquals((double)Math.ceil((double)bs.length / (double)barrierSize), (double)this.countOptimizationQueries(profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).union(new Traversal[]{__.label()}), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LABEL_STEP_BATCH_MODE, new String[0]), MultiQueryLabelStepStrategyMode.ALL.getConfigName());
        Assertions.assertEquals((long)3L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(numV - 3 * barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).label().limit((long)limit), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LABEL_STEP_BATCH_MODE, new String[0]), MultiQueryLabelStepStrategyMode.ALL.getConfigName());
        Assertions.assertEquals((long)1L, (long)this.countBackendQueriesOfSize(limit, (Collection<? extends Metrics>)profile.getMetrics()));
        profile = this.testLimitedBatch(() -> this.graph.traversal().V((Object[])cs).barrier(barrierSize).label(), JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LABEL_STEP_BATCH_MODE, new String[0]), MultiQueryLabelStepStrategyMode.NONE.getConfigName());
        Assertions.assertEquals((long)0L, (long)this.countBackendQueriesOfSize(barrierSize, (Collection<? extends Metrics>)profile.getMetrics()));
        Assertions.assertEquals((long)0L, (long)this.countOptimizationQueries(profile.getMetrics()));
    }

    @Test
    public void testMultiSliceDBCachedRequests() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), false);
        this.mgmt.makeVertexLabel("testVertex").make();
        this.finishSchema();
        int numV = 100;
        JanusGraphVertex a = this.graph.addVertex(new Object[0]);
        JanusGraphVertex[] bs = new JanusGraphVertex[numV];
        Object[] cs = new JanusGraphVertex[numV];
        for (int i = 0; i < numV; ++i) {
            bs[i] = this.graph.addVertex(new Object[0]);
            cs[i] = this.graph.addVertex("testVertex");
            cs[i].property("foo", (Object)"bar");
            cs[i].property("fooBar", (Object)"Bar");
            cs[i].property("barFoo", (Object)"Foo");
            a.addEdge("knows", (Vertex)bs[i], new Object[0]);
            bs[i].addEdge("knows", (Vertex)cs[i], new Object[0]);
        }
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 1000000L, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((int)numV, (int)this.graph.traversal().V(cs).values(new String[]{"foo"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)numV, (int)this.graph.traversal().V(cs).values(new String[]{"foo"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)(numV * 2), (int)this.graph.traversal().V(cs).values(new String[]{"foo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)(numV * 2), (int)this.graph.traversal().V(cs).values(new String[]{"foo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)(numV * 3), (int)this.graph.traversal().V(cs).values(new String[]{"foo", "barFoo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)(numV * 3), (int)this.graph.traversal().V(cs).values(new String[]{"foo", "barFoo", "fooBar"}).toList().size());
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 1000000L, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((int)numV, (int)this.graph.traversal().V(cs).values(new String[]{"foo"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)(numV * 3), (int)this.graph.traversal().V(cs).values(new String[]{"foo", "barFoo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 1000000L, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName(), JanusGraphTest.option(GraphDatabaseConfiguration.PROPERTIES_BATCH_MODE, new String[0]), MultiQueryPropertiesStrategyMode.REQUIRED_PROPERTIES_ONLY.getConfigName());
        Assertions.assertEquals((int)3, (int)this.graph.traversal().V(new Object[]{cs[1], cs[5], cs[10]}).values(new String[]{"foo"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)3, (int)this.graph.traversal().V(new Object[]{cs[1], cs[7], cs[10]}).values(new String[]{"foo"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)6, (int)this.graph.traversal().V(new Object[]{cs[1], cs[6], cs[8]}).values(new String[]{"foo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)6, (int)this.graph.traversal().V(new Object[]{cs[1], cs[7], cs[10]}).values(new String[]{"foo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)9, (int)this.graph.traversal().V(new Object[]{cs[1], cs[5], cs[10]}).values(new String[]{"foo", "barFoo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)(numV * 3), (int)this.graph.traversal().V(cs).values(new String[]{"foo", "barFoo", "fooBar"}).toList().size());
        this.graph.tx().rollback();
        Assertions.assertEquals((int)(numV * 2), (int)this.graph.traversal().V(cs).values(new String[]{"foo", "fooBar"}).toList().size());
        Assertions.assertEquals((int)(numV * 3), (int)this.graph.traversal().V(new Object[0]).values(new String[]{"foo", "barFoo", "fooBar"}).toList().size());
    }

    protected TraversalMetrics testLimitedBatch(Supplier<GraphTraversal<?, ?>> traversal, Object ... settings) {
        this.assertEqualResultWithAndWithoutLimitBatchSize(traversal);
        if (settings.length == 0) {
            this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName());
        } else {
            this.clopen(settings);
        }
        return (TraversalMetrics)traversal.get().profile().next();
    }

    private void assertEqualResultWithAndWithoutLimitBatchSize(Supplier<GraphTraversal<?, ?>> traversal) {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), true);
        List resultLimitedBatch = traversal.get().toList();
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LIMITED_BATCH, new String[0]), false);
        List resultUnimitedBatch = traversal.get().toList();
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), false);
        List resultNoMultiQuery = traversal.get().toList();
        Assertions.assertEquals((Object)resultLimitedBatch, (Object)resultUnimitedBatch);
        Assertions.assertEquals((Object)resultLimitedBatch, (Object)resultNoMultiQuery);
    }

    protected long countBackendQueriesOfSize(long size, Collection<? extends Metrics> metrics) {
        return this.countBackendQueriesOfSize(querySize -> querySize == size, metrics);
    }

    private long countBackendQueriesOfSize(Predicate<Long> sizePredicate, Collection<? extends Metrics> metrics) {
        long count = metrics.stream().filter(m -> m.getName().equals("backend-query")).map(Metrics::getCounts).flatMap(c -> c.values().stream()).filter(sizePredicate).count();
        long nestedCount = metrics.stream().mapToLong(m -> this.countBackendQueriesOfSize(sizePredicate, (Collection<? extends Metrics>)m.getNested())).sum();
        return count + nestedCount;
    }

    private long countOptimizationQueries(Collection<? extends Metrics> metrics) {
        long count = metrics.stream().filter(m -> m.getName().equals("optimization")).count();
        long nestedCount = metrics.stream().mapToLong(m -> this.countOptimizationQueries(m.getNested())).sum();
        return count + nestedCount;
    }

    @Test
    public void testSimpleTinkerPopTraversal() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "josh"});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "lop"});
        v1.addEdge("created", (Vertex)v2, new Object[0]);
        Object id = ((Edge)this.graph.traversal().V(new Object[0]).has("name", (Object)"josh").outE(new String[]{"created"}).as("e", new String[0]).inV().has("name", (Object)"lop").select("e").next()).id();
        Assertions.assertNotNull((Object)id);
    }

    @Test
    public void testHasKeyOnEdgePropertyTraversal() {
        Vertex vertex = this.prepareDataForEdgePropertyFilterTest();
        List result = this.graph.traversal().V(new Object[]{vertex}).bothE(new String[0]).properties(new String[0]).hasKey("name", new String[0]).value().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals(result.get(0), (Object)"testValue");
    }

    @Test
    public void testHasValueOnEdgePropertyTraversal() {
        Vertex vertex = this.prepareDataForEdgePropertyFilterTest();
        List result = this.graph.traversal().V(new Object[]{vertex}).bothE(new String[0]).properties(new String[0]).hasValue((Object)"testValue", new Object[0]).value().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals(result.get(0), (Object)"testValue");
    }

    @Test
    public void testHasKeyAndHasValueOnEdgePropertyTraversal() {
        Vertex vertex = this.prepareDataForEdgePropertyFilterTest();
        List result = this.graph.traversal().V(new Object[]{vertex}).bothE(new String[0]).properties(new String[0]).hasKey("weight", new String[0]).hasValue(P.lt((Object)3)).value().toList();
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals(result.get(0), (Object)2);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 10, 15, 0x7FFFFFFF})
    public void testBatchPropertiesPrefetching(int txCacheSize) {
        boolean inmemoryBackend = ((String)this.getConfig().get(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0])).equals("inmemory");
        int numV = 10;
        int expectedVerticesPrefetch = Math.min(txCacheSize, numV);
        JanusGraphVertex mainVertex = this.graph.addVertex(new Object[]{"id", 0});
        for (int i = 1; i <= numV; ++i) {
            JanusGraphVertex adjacentVertex = this.graph.addVertex(new Object[]{"id", i});
            mainVertex.addEdge("knows", (Vertex)adjacentVertex, new Object[0]);
        }
        this.graph.tx().commit();
        if (!inmemoryBackend) {
            this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName(), JanusGraphTest.option(GraphDatabaseConfiguration.TX_CACHE_SIZE, new String[0]), txCacheSize);
        }
        GraphTraversalSource gts = this.graph.traversal();
        TraversalMetrics traversalMetrics = (TraversalMetrics)gts.V(new Object[0]).has("id", (Object)0).out(new String[]{"knows"}).has("id", P.within((Object[])new Integer[]{4, 5, 6, 7})).values(new String[]{"id"}).profile().next();
        Metrics janusGraphVertexStepMetrics = JanusGraphAssert.getStepMetrics(traversalMetrics, JanusGraphHasStep.class);
        Assertions.assertNotNull((Object)janusGraphVertexStepMetrics);
        if (expectedVerticesPrefetch > 1 && !inmemoryBackend) {
            int latestBatchVerticesSize;
            JanusGraphAssert.assertContains(janusGraphVertexStepMetrics, "multiPreFetch", "true");
            int n = latestBatchVerticesSize = txCacheSize > 1 && txCacheSize < numV ? numV % txCacheSize : expectedVerticesPrefetch;
            if (latestBatchVerticesSize == 0) {
                latestBatchVerticesSize = txCacheSize;
            }
            JanusGraphAssert.assertContains(janusGraphVertexStepMetrics, "vertices", latestBatchVerticesSize);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={0, 1, 2, 3, 10, 15, 0x7FFFFFFF})
    public void testBatchPropertiesPrefetchingFromEdges(int txCacheSize) {
        boolean inmemoryBackend = ((String)this.getConfig().get(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0])).equals("inmemory");
        int numV = 10;
        int expectedVerticesPrefetch = Math.min(txCacheSize, 4);
        JanusGraphVertex mainVertex = this.graph.addVertex(new Object[]{"id", 0});
        for (int i = 1; i <= numV; ++i) {
            JanusGraphVertex adjacentVertex = this.graph.addVertex(new Object[]{"id", i});
            mainVertex.addEdge("knows", (Vertex)adjacentVertex, new Object[]{"id", i});
        }
        this.graph.tx().commit();
        if (!inmemoryBackend) {
            this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.ALL_PROPERTIES.getConfigName(), JanusGraphTest.option(GraphDatabaseConfiguration.TX_CACHE_SIZE, new String[0]), txCacheSize);
        }
        GraphTraversalSource gts = this.graph.traversal();
        for (Direction direction : Direction.values()) {
            int latestBatchVerticesSize;
            GraphTraversal graphVertexTraversal;
            GraphTraversal graphEdgeTraversal = gts.V(new Object[0]).has("id", (Object)0).outE(new String[]{"knows"}).has("id", P.within((Object[])new Integer[]{4, 5, 6, 7}));
            switch (direction) {
                case IN: {
                    graphVertexTraversal = graphEdgeTraversal.inV();
                    break;
                }
                case OUT: {
                    graphVertexTraversal = graphEdgeTraversal.outV();
                    break;
                }
                case BOTH: {
                    graphVertexTraversal = graphEdgeTraversal.bothV();
                    break;
                }
                default: {
                    throw new NotImplementedException("No implementation found for direction: " + direction.name());
                }
            }
            TraversalMetrics traversalMetrics = (TraversalMetrics)graphVertexTraversal.has("id", P.within((Object[])new Integer[]{4, 5, 6, 7})).values(new String[]{"id"}).profile().next();
            Metrics janusGraphEdgeVertexStepMetrics = JanusGraphAssert.getLastStepMetrics(traversalMetrics, JanusGraphHasStep.class);
            Assertions.assertNotNull((Object)janusGraphEdgeVertexStepMetrics);
            if (inmemoryBackend || expectedVerticesPrefetch <= 1 || Direction.OUT.equals((Object)direction)) continue;
            JanusGraphAssert.assertContains(janusGraphEdgeVertexStepMetrics, "multiPreFetch", "true");
            boolean withAdditionalOutVertex = Direction.BOTH.equals((Object)direction);
            int n = txCacheSize > 1 && txCacheSize < numV ? (4 + (withAdditionalOutVertex ? 1 : 0)) % txCacheSize : (latestBatchVerticesSize = expectedVerticesPrefetch + (withAdditionalOutVertex ? 1 : 0));
            if (latestBatchVerticesSize == 0) {
                latestBatchVerticesSize = txCacheSize;
            }
            JanusGraphAssert.assertContains(janusGraphEdgeVertexStepMetrics, "vertices", latestBatchVerticesSize);
        }
    }

    private Vertex prepareDataForEdgePropertyFilterTest() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"name", "josh"});
        JanusGraphVertex v2 = this.graph.addVertex(new Object[]{"name", "lop"});
        JanusGraphVertex v3 = this.graph.addVertex(new Object[]{"name", "lop2"});
        this.graph.traversal().V(new Object[]{v1}).addE("created").to((Vertex)v2).property((Object)"name", (Object)"testValue", new Object[0]).next();
        this.graph.traversal().V(new Object[]{v1}).addE("created").to((Vertex)v3).property((Object)"weight", (Object)2, new Object[0]).next();
        return v1;
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void simpleLogTest(boolean useStringId) throws InterruptedException {
        if (useStringId && this.getStoreFeatures().isKeyOrdered()) {
            return;
        }
        this.simpleLogTest(false, useStringId);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void simpleLogTestWithFailure(boolean useStringId) throws InterruptedException {
        if (useStringId && this.getStoreFeatures().isKeyOrdered()) {
            return;
        }
        this.simpleLogTest(true, useStringId);
    }

    private void simpleLogTest(final boolean withLogFailure, boolean useStringId) throws InterruptedException {
        String userLogName = "test";
        final Serializer serializer = this.graph.getDataSerializer();
        EdgeSerializer edgeSerializer = this.graph.getEdgeSerializer();
        final TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        final Instant startTime = times.getTime();
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.LOG_BACKEND, "user"), withLogFailure ? TestMockLog.class.getName() : GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue(), JanusGraphTest.option(TestMockLog.LOG_MOCK_FAILADD, "user"), withLogFailure, JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "user"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "user"), Duration.ofMillis(250L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "user"), Duration.ofMillis(100L), JanusGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), Duration.ofMillis(50L), JanusGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), Duration.ofMillis(250L), JanusGraphTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), Duration.ofSeconds(1L), JanusGraphTest.option(GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, new String[0]), useStringId, JanusGraphTest.option(GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, new String[0]), useStringId);
        String instanceId = this.graph.getConfiguration().getUniqueGraphId();
        PropertyKey weight = this.tx.makePropertyKey("weight").dataType(Float.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.tx.makeEdgeLabel("knows").make();
        JanusGraphVertex n1 = useStringId ? this.tx.addVertex(new Object[]{T.id, "n1", "weight", 10.5}) : this.tx.addVertex(new Object[]{"weight", 10.5});
        this.tx.addProperties(knows, new PropertyKey[]{weight});
        this.newTx();
        Instant[] txTimes = new Instant[4];
        txTimes[0] = times.getTime();
        JanusGraphTransaction tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        JanusGraphVertex v1 = useStringId ? tx2.addVertex(new Object[]{T.id, "v1", "weight", 111.1}) : tx2.addVertex(new Object[]{"weight", 111.1});
        v1.addEdge("knows", (Vertex)v1, new Object[0]);
        tx2.commit();
        Object v1id = JanusGraphTest.getId((Element)v1);
        txTimes[1] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        JanusGraphVertex v2 = useStringId ? tx2.addVertex(new Object[]{T.id, "v2", "weight", 222.2}) : tx2.addVertex(new Object[]{"weight", 222.2});
        v2.addEdge("knows", (Vertex)JanusGraphTest.getV((Transaction)tx2, v1id), new Object[0]);
        tx2.commit();
        Object v2id = JanusGraphTest.getId((Element)v2);
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v1 = JanusGraphTest.getV((Transaction)tx2, v1id);
        Assertions.assertEquals((double)111.1, (double)((Float)v1.value("weight")).doubleValue(), (double)0.01);
        Assertions.assertEquals((double)222.2, (double)((Float)JanusGraphTest.getV((Transaction)tx2, v2).value("weight")).doubleValue(), (double)0.01);
        tx2.commit();
        txTimes[2] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v2 = JanusGraphTest.getV((Transaction)tx2, v2id);
        Assertions.assertEquals((double)222.2, (double)((Float)v2.value("weight")).doubleValue(), (double)0.01);
        v2.remove();
        tx2.commit();
        txTimes[3] = times.getTime();
        tx2 = this.graph.buildTransaction().logIdentifier("test").start();
        v1 = JanusGraphTest.getV((Transaction)tx2, v1id);
        Assertions.assertEquals((double)111.1, (double)((Float)v1.value("weight")).doubleValue(), (double)0.01);
        Edge e = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assertions.assertFalse((boolean)e.property("weight").isPresent());
        e.property("weight", (Object)44.4);
        tx2.commit();
        this.close();
        Instant endTime = times.getTime();
        ReadMarker startMarker = ReadMarker.fromTime((Instant)startTime);
        Log transactionLog = this.openTxLog();
        Log userLog = this.openUserLog("test");
        final EnumMap<LogTxStatus, AtomicInteger> txMsgCounter = new EnumMap<LogTxStatus, AtomicInteger>(LogTxStatus.class);
        for (LogTxStatus status : LogTxStatus.values()) {
            txMsgCounter.put(status, new AtomicInteger(0));
        }
        final AtomicInteger userLogMeta = new AtomicInteger(0);
        transactionLog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                Instant msgTime = message.getTimestamp();
                Assertions.assertTrue((msgTime.isAfter(startTime) || msgTime.equals(startTime) ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)message.getSenderId());
                TransactionLogHeader.Entry txEntry = TransactionLogHeader.parse((StaticBuffer)message.getContent(), (Serializer)serializer, (TimestampProvider)times);
                TransactionLogHeader header = txEntry.getHeader();
                Assertions.assertTrue((header.getTimestamp().isAfter(startTime) || header.getTimestamp().equals(startTime) ? 1 : 0) != 0);
                Assertions.assertTrue((header.getTimestamp().isBefore(msgTime) || header.getTimestamp().equals(msgTime) ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)txEntry.getMetadata());
                Assertions.assertNull(txEntry.getMetadata().get(LogTxMeta.GROUPNAME));
                LogTxStatus status = txEntry.getStatus();
                if (status == LogTxStatus.PRECOMMIT) {
                    Assertions.assertTrue((boolean)txEntry.hasContent());
                    Object logId = txEntry.getMetadata().get(LogTxMeta.LOG_ID);
                    if (logId != null) {
                        Assertions.assertTrue((boolean)(logId instanceof String));
                        Assertions.assertEquals((Object)"test", logId);
                        userLogMeta.incrementAndGet();
                    }
                } else if (withLogFailure) {
                    Assertions.assertTrue((status.isPrimarySuccess() || status == LogTxStatus.SECONDARY_FAILURE ? 1 : 0) != 0);
                    if (status == LogTxStatus.SECONDARY_FAILURE) {
                        TransactionLogHeader.SecondaryFailures secFail = txEntry.getContentAsSecondaryFailures(serializer);
                        Assertions.assertTrue((boolean)secFail.failedIndexes.isEmpty());
                        Assertions.assertTrue((boolean)secFail.userLogFailure);
                    }
                } else {
                    Assertions.assertFalse((boolean)txEntry.hasContent());
                    Assertions.assertTrue((boolean)status.isSuccess());
                }
                ((AtomicInteger)txMsgCounter.get(txEntry.getStatus())).incrementAndGet();
            }

            public void updateState() {
            }
        }});
        final EnumMap<Change, AtomicInteger> userChangeCounter = new EnumMap<Change, AtomicInteger>(Change.class);
        for (Change change : Change.values()) {
            userChangeCounter.put(change, new AtomicInteger(0));
        }
        final AtomicInteger userLogMsgCounter = new AtomicInteger(0);
        userLog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                Instant msgTime = message.getTimestamp();
                Assertions.assertTrue((msgTime.isAfter(startTime) || msgTime.equals(startTime) ? 1 : 0) != 0);
                Assertions.assertNotNull((Object)message.getSenderId());
                StaticBuffer content = message.getContent();
                Assertions.assertTrue((content != null && content.length() > 0 ? 1 : 0) != 0);
                TransactionLogHeader.Entry transactionEntry = TransactionLogHeader.parse((StaticBuffer)content, (Serializer)serializer, (TimestampProvider)times);
                Instant txTime = transactionEntry.getHeader().getTimestamp();
                Assertions.assertTrue((txTime.isBefore(msgTime) || txTime.equals(msgTime) ? 1 : 0) != 0);
                Assertions.assertTrue((txTime.isAfter(startTime) || txTime.equals(msgTime) ? 1 : 0) != 0);
                long transactionId = transactionEntry.getHeader().getId();
                Assertions.assertTrue((transactionId > 0L ? 1 : 0) != 0);
                transactionEntry.getContentAsModifications(serializer).forEach(modification -> {
                    Assertions.assertTrue((modification.state == Change.ADDED || modification.state == Change.REMOVED ? 1 : 0) != 0);
                    ((AtomicInteger)userChangeCounter.get(modification.state)).incrementAndGet();
                });
                userLogMsgCounter.incrementAndGet();
            }

            public void updateState() {
            }
        }});
        Thread.sleep(4000L);
        Assertions.assertEquals((int)5, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRECOMMIT)).get());
        Assertions.assertEquals((int)4, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRIMARY_SUCCESS)).get());
        Assertions.assertEquals((int)1, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.COMPLETE_SUCCESS)).get());
        Assertions.assertEquals((int)4, (int)userLogMeta.get());
        if (withLogFailure) {
            Assertions.assertEquals((int)4, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_FAILURE)).get());
        } else {
            Assertions.assertEquals((int)4, (int)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_SUCCESS)).get());
        }
        if (withLogFailure) {
            Assertions.assertEquals((int)0, (int)userLogMsgCounter.get());
        } else {
            Assertions.assertEquals((int)4, (int)userLogMsgCounter.get());
            Assertions.assertEquals((int)7, (int)((AtomicInteger)userChangeCounter.get(Change.ADDED)).get());
            Assertions.assertEquals((int)4, (int)((AtomicInteger)userChangeCounter.get(Change.REMOVED)).get());
        }
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.VERBOSE_TX_RECOVERY, new String[0]), true);
        TransactionRecovery recovery = JanusGraphFactory.startTransactionRecovery((JanusGraph)this.graph, (Instant)startTime);
        AtomicInteger userLogCount = new AtomicInteger(0);
        LogProcessorFramework userLogs = JanusGraphFactory.openTransactionLog((JanusGraph)this.graph);
        userLogs.addLogProcessor("test").setStartTime(startTime).setRetryAttempts(1).addProcessor((tx, txId, changes) -> {
            JanusGraphVertex v;
            int txNo;
            Assertions.assertEquals((Object)instanceId, (Object)txId.getInstanceId());
            Assertions.assertTrue((txId.getTransactionId() > 0L && txId.getTransactionId() < 100L ? 1 : 0) != 0);
            Instant txTime = txId.getTransactionTime();
            Assertions.assertTrue((!(!txTime.isAfter(startTime) && !txTime.equals(startTime) || !txTime.isBefore(endTime) && !txTime.equals(endTime)) ? 1 : 0) != 0, (String)String.format("tx timestamp %s not between start %s and end time %s", txTime, startTime, endTime));
            Assertions.assertTrue((boolean)tx.containsRelationType("knows"));
            Assertions.assertTrue((boolean)tx.containsRelationType("weight"));
            EdgeLabel knows1 = tx.getEdgeLabel("knows");
            PropertyKey weight1 = tx.getPropertyKey("weight");
            Instant txTimeMicro = txId.getTransactionTime();
            if (txTimeMicro.isBefore(txTimes[1])) {
                txNo = 1;
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                Assertions.assertEquals((Object)v1id, (Object)JanusGraphTest.getId((Element)v));
                VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.ADDED, new String[]{"weight"}));
                Assertions.assertEquals((double)111.1, (double)((Float)p.value()).doubleValue(), (double)0.01);
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
            } else if (txTimeMicro.isBefore(txTimes[2])) {
                txNo = 2;
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                Assertions.assertEquals((Object)v2id, (Object)JanusGraphTest.getId((Element)v));
                VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.ADDED, new String[]{"weight"}));
                Assertions.assertEquals((double)222.2, (double)((Float)p.value()).doubleValue(), (double)0.01);
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
            } else if (txTimeMicro.isBefore(txTimes[3])) {
                txNo = 3;
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{weight1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.REMOVED));
                Assertions.assertEquals((Object)v2id, (Object)JanusGraphTest.getId((Element)v));
                VertexProperty p = (VertexProperty)Iterables.getOnlyElement((Iterable)changes.getProperties((Vertex)v, Change.REMOVED, new String[]{"weight"}));
                Assertions.assertEquals((double)222.2, (double)((Float)p.value()).doubleValue(), (double)0.01);
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.REMOVED, Direction.OUT, new String[0])));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.BOTH, new String[0])));
            } else {
                txNo = 4;
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                Assertions.assertEquals((int)0, (int)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                Assertions.assertEquals((int)1, (int)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows1})));
                Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ANY));
                Assertions.assertEquals((Object)v1id, (Object)JanusGraphTest.getId((Element)v));
                JanusGraphEdge e1 = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)changes.getEdges((Vertex)v, Change.REMOVED, Direction.OUT, new String[]{"knows"}));
                Assertions.assertFalse((boolean)e1.property("weight").isPresent());
                Assertions.assertEquals((Object)v, (Object)e1.vertex(Direction.IN));
                e1 = (JanusGraphEdge)Iterables.getOnlyElement((Iterable)changes.getEdges((Vertex)v, Change.ADDED, Direction.OUT, new String[]{"knows"}));
                Assertions.assertEquals((double)44.4, (double)((Float)e1.value("weight")).doubleValue(), (double)0.01);
                Assertions.assertEquals((Object)v, (Object)e1.vertex(Direction.IN));
            }
            JanusGraphVertex v11 = JanusGraphTest.getV((Transaction)tx, v1id);
            Assertions.assertNotNull((Object)v11);
            Assertions.assertTrue((boolean)v11.isLoaded());
            if (txNo != 2) {
                JanusGraphTest.assertMissing((Transaction)tx, v2id);
            }
            Assertions.assertEquals((double)111.1, (double)((Float)v11.value("weight")).doubleValue(), (double)0.01);
            JanusGraphAssert.assertCount(1, v11.query().direction(Direction.OUT).edges());
            userLogCount.incrementAndGet();
        }).build();
        Thread.sleep(22000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        if (withLogFailure) {
            Assertions.assertEquals((long)1L, (long)recoveryStats[0]);
            Assertions.assertEquals((long)4L, (long)recoveryStats[1]);
        } else {
            Assertions.assertEquals((long)5L, (long)recoveryStats[0]);
            Assertions.assertEquals((long)0L, (long)recoveryStats[1]);
        }
        userLogs.removeLogProcessor("test");
        userLogs.shutdown();
        Assertions.assertEquals((int)4, (int)userLogCount.get());
    }

    @Test
    public void testGlobalGraphIndexingAndQueriesForInternalIndexes() {
        JanusGraphEdge janusGraphEdge;
        JanusGraphVertex u;
        String txt;
        double w;
        JanusGraphVertexProperty p2;
        JanusGraphVertexProperty p1;
        int i;
        PropertyKey weight = this.makeKey("weight", Float.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new PropertyKey[]{weight}).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").signature(new PropertyKey[]{time}).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel organization = this.mgmt.makeVertexLabel("organization").make();
        JanusGraphIndex edge1 = this.mgmt.buildIndex("edge1", Edge.class).addKey(time).addKey(weight).buildCompositeIndex();
        JanusGraphIndex edge2 = this.mgmt.buildIndex("edge2", Edge.class).indexOnly((JanusGraphSchemaType)connect).addKey(text).buildCompositeIndex();
        JanusGraphIndex prop1 = this.mgmt.buildIndex("prop1", JanusGraphVertexProperty.class).addKey(time).buildCompositeIndex();
        JanusGraphIndex prop2 = this.mgmt.buildIndex("prop2", JanusGraphVertexProperty.class).addKey(weight).addKey(text).buildCompositeIndex();
        JanusGraphIndex vertex1 = this.mgmt.buildIndex("vertex1", Vertex.class).addKey(time).indexOnly((JanusGraphSchemaType)person).unique().buildCompositeIndex();
        JanusGraphIndex vertex12 = this.mgmt.buildIndex("vertex12", Vertex.class).addKey(text).indexOnly((JanusGraphSchemaType)person).buildCompositeIndex();
        JanusGraphIndex vertex2 = this.mgmt.buildIndex("vertex2", Vertex.class).addKey(time).addKey(name).indexOnly((JanusGraphSchemaType)organization).buildCompositeIndex();
        JanusGraphIndex vertex3 = this.mgmt.buildIndex("vertex3", Vertex.class).addKey(name).buildCompositeIndex();
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(JanusGraphVertexProperty.class)));
        Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assertions.assertTrue((boolean)vertex1.isUnique());
        Assertions.assertFalse((boolean)edge2.isUnique());
        Assertions.assertEquals((Object)"prop1", (Object)prop1.name());
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assertions.assertTrue((boolean)JanusGraphVertexProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assertions.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assertions.assertEquals((int)2, (int)vertex2.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.asParameter()}).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        text = this.mgmt.getPropertyKey("text");
        time = this.mgmt.getPropertyKey("time");
        weight = this.mgmt.getPropertyKey("weight");
        Assertions.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(JanusGraphVertexProperty.class)));
        Assertions.assertEquals((int)4, (int)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assertions.assertTrue((boolean)vertex1.isUnique());
        Assertions.assertFalse((boolean)edge2.isUnique());
        Assertions.assertEquals((Object)"prop1", (Object)prop1.name());
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assertions.assertTrue((boolean)JanusGraphVertexProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assertions.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assertions.assertEquals((int)2, (int)vertex2.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.asParameter()}).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        int numV = 100;
        boolean sorted = true;
        JanusGraphVertex[] ns = new JanusGraphVertex[100];
        String[] strings = new String[]{"aaa", "bbb", "ccc", "ddd"};
        for (i = 0; i < 100; ++i) {
            ns[i] = this.tx.addVertex(i % 2 == 0 ? "person" : "organization");
            p1 = ns[i].property("name", (Object)("v" + i));
            p2 = ns[i].property("name", (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            txt = strings[i % strings.length];
            ns[i].property(VertexProperty.Cardinality.single, "weight", (Object)w, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "time", (Object)i, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "text", (Object)txt, new Object[0]);
            for (VertexProperty p : new VertexProperty[]{p1, p2}) {
                p.property("weight", (Object)w);
                p.property("time", (Object)i);
                p.property("text", (Object)txt);
            }
            u = ns[i > 0 ? i - 1 : i];
            String[] stringArray = new String[]{"connect", "related"};
            int n = stringArray.length;
            for (int p = 0; p < n; ++p) {
                String label = stringArray[p];
                Object[] objectArray = new Object[6];
                objectArray[0] = "weight";
                double d = w;
                w = d + 1.0;
                objectArray[1] = d % 5.0;
                objectArray[2] = "time";
                objectArray[3] = (long)i;
                objectArray[4] = "text";
                objectArray[5] = txt;
                janusGraphEdge = ns[i].addEdge(label, (Vertex)u, objectArray);
            }
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[10 % strings.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect"), ElementCategory.EDGE, 100 / strings.length, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.EDGE, 100 / strings.length * 2, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.name(), prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.name(), vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v51").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 0, new boolean[]{true, false}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Contain.NOT_IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.name());
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[10 % strings.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect"), ElementCategory.EDGE, 100 / strings.length, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.EDGE, 100 / strings.length * 2, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0.0).has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.name(), prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)50).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.name(), vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v51").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)51).has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"v1").has(LABEL_NAME, (Object)"organization"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 0, new boolean[]{true, false}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (Object)"person").has("time", (JanusGraphPredicate)Contain.NOT_IN, (Object)ImmutableList.of()), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, vertex12.name());
        for (i = 0; i < 50; ++i) {
            JanusGraphVertex v = JanusGraphTest.getV((Transaction)this.tx, ns[i]);
            v.remove();
        }
        ns = new JanusGraphVertex[150];
        for (i = 100; i < 150; ++i) {
            ns[i] = this.tx.addVertex(i % 2 == 0 ? "person" : "organization");
            p1 = ns[i].property("name", (Object)("v" + i));
            p2 = ns[i].property("name", (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            txt = strings[i % strings.length];
            ns[i].property(VertexProperty.Cardinality.single, "weight", (Object)w, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "time", (Object)i, new Object[0]);
            ns[i].property(VertexProperty.Cardinality.single, "text", (Object)txt, new Object[0]);
            for (VertexProperty p : new JanusGraphVertex[]{p1, p2}) {
                p.property("weight", (Object)w);
                p.property("time", (Object)i);
                p.property("text", (Object)txt);
            }
            u = ns[i > 100 ? i - 1 : i];
            for (String label : new String[]{"connect", "related"}) {
                Object[] objectArray = new Object[6];
                objectArray[0] = "weight";
                double d = w;
                w = d + 1.0;
                objectArray[1] = d % 5.0;
                objectArray[2] = "time";
                objectArray[3] = (long)i;
                objectArray[4] = "text";
                objectArray[5] = txt;
                janusGraphEdge = ns[i].addEdge(label, (Vertex)u, objectArray);
            }
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)110).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)30).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)130).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)10).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)110).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has(LABEL_NAME, (Object)"connect").limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)30).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (JanusGraphPredicate)Cmp.EQUAL, (Object)130).has(LABEL_NAME, (Object)"person"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.name());
    }

    @Test
    public void testTinkerPropInfinityLimit() {
        this.initializeGraphWithVerticesHavingNames("marko", "ark", "arko", "park", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)5L, (Long)((Long)g.V(new Object[0]).limit(-1L).count().next()));
        Assertions.assertEquals((long)4L, (Long)((Long)g.V(new Object[0]).skip(1L).count().next()));
    }

    @Test
    public void testTinkerPopTextContainingFindsCorrectValue() {
        this.initializeGraphWithVerticesHavingNames("marko", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((Object)"marko", (Object)g.V(new Object[0]).has("name", (P)TextP.containing((String)"ark")).values(new String[]{"name"}).next());
    }

    @Test
    public void testTinkerPopTextContainingFindsRightNumberOfValues() {
        this.initializeGraphWithVerticesHavingNames("marko", "ark", "arko", "park", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)4L, (Long)((Long)g.V(new Object[0]).has("name", (P)TextP.containing((String)"ark")).count().next()));
    }

    @Test
    public void testTinkerPopTextPredicatesConnectedViaAnd() {
        this.initializeGraphWithVerticesHavingNames("marko", "mark", "notmarko", "notmark", "stephen");
        GraphTraversalSource g = this.graph.traversal();
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[0]).has("name", TextP.startingWith((String)"mark").and((Predicate)TextP.endingWith((String)"ark"))).count().next()));
    }

    private void initializeGraphWithVerticesHavingNames(String ... names) {
        this.makeKey("name", String.class);
        this.finishSchema();
        GraphTraversalSource g = this.graph.traversal();
        for (String name : names) {
            g.addV().property((Object)"name", (Object)name, new Object[0]).iterate();
        }
        g.tx().commit();
    }

    @Test
    public void testTinkerPopTextStartingWith() {
        this.makeKey("name", String.class);
        this.mgmt.makeVertexLabel("person").make();
        this.finishSchema();
        GraphTraversalSource g = this.graph.traversal();
        g.addV("person").property((Object)"name", (Object)"marko", new Object[0]).iterate();
        g.tx().commit();
        Assertions.assertEquals((Object)"marko", (Object)g.V(new Object[0]).has("person", "name", (P)TextP.containing((String)"ark")).values(new String[]{"name"}).next());
    }

    @Test
    public void testIndexUniqueness() {
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("organization").make();
        JanusGraphIndex vertexIndex1 = this.mgmt.buildIndex("vindex1", Vertex.class).addKey(time).indexOnly((JanusGraphSchemaType)person).unique().buildCompositeIndex();
        JanusGraphIndex vertexIndex2 = this.mgmt.buildIndex("vindex2", Vertex.class).addKey(time).addKey(text).unique().buildCompositeIndex();
        this.finishSchema();
        Assertions.assertEquals((Object)"person", (Object)this.mgmt.getIndexOnlyConstraint("vindex1").name());
        Assertions.assertNull((Object)this.mgmt.getIndexOnlyConstraint("vindex2"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.getIndexOnlyConstraint(null));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.getIndexOnlyConstraint("invalidName"));
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v0 = tx.addVertex("person");
            v0.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
            JanusGraphVertex v1 = tx.addVertex("person");
            v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        });
        JanusGraphVertex v0 = this.tx.addVertex("person");
        v0.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        this.newTx();
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v1 = tx.addVertex("person");
            v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        });
        JanusGraphVertex v1 = this.tx.addVertex("organization");
        v1.property(VertexProperty.Cardinality.single, "time", (Object)1, new Object[0]);
        this.newTx();
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v01 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
            JanusGraphVertex v11 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
        });
        v0 = this.tx.addVertex(new Object[]{"time", 2, "text", "hello"});
        this.newTx();
        this.failTransactionOnCommit(tx -> {
            JanusGraphVertex v112 = tx.addVertex(new Object[]{"time", 2, "text", "hello"});
        });
    }

    @Test
    public void testForceIndexUsage() {
        PropertyKey age = this.makeKey("age", Integer.class);
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildIndex("time", Vertex.class).addKey(time).buildCompositeIndex();
        this.finishSchema();
        for (int i = 1; i <= 10; ++i) {
            JanusGraphVertex janusGraphVertex = this.tx.addVertex(new Object[]{"time", i, "age", i});
        }
        JanusGraphAssert.assertCount(1, this.tx.query().has("time", (Object)5).vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("age", (Object)6).vertices());
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        JanusGraphAssert.assertCount(1, this.tx.query().has("time", (Object)5).vertices());
        try {
            JanusGraphAssert.assertCount(1, this.tx.query().has("age", (Object)6).vertices());
            Assertions.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testLargeJointIndexRetrieval() {
        this.makeVertexIndexedKey("sid", Integer.class);
        this.makeVertexIndexedKey("color", String.class);
        this.finishSchema();
        int sids = 17;
        String[] colors = new String[]{"blue", "red", "yellow", "brown", "green", "orange", "purple"};
        int multiplier = 200;
        int numV = sids * colors.length * multiplier;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex janusGraphVertex = this.graph.addVertex(new Object[]{"color", colors[i % colors.length], "sid", i % sids});
        }
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(numV / sids, this.graph.query().has("sid", (Object)8).vertices());
        JanusGraphAssert.assertCount(numV / colors.length, this.graph.query().has("color", (Object)colors[2]).vertices());
        JanusGraphAssert.assertCount(multiplier, this.graph.query().has("sid", (Object)11).has("color", (Object)colors[3]).vertices());
    }

    @Test
    public void testIndexQueryWithLabelsAndContainsIN() {
        String labelName = "labelName";
        VertexLabel label = this.mgmt.makeVertexLabel(labelName).make();
        PropertyKey uid = this.mgmt.makePropertyKey("uid").dataType(String.class).make();
        JanusGraphIndex uidCompositeIndex = this.mgmt.buildIndex("uidIndex", Vertex.class).indexOnly((JanusGraphSchemaType)label).addKey(uid).unique().buildCompositeIndex();
        this.mgmt.setConsistency((JanusGraphSchemaElement)uidCompositeIndex, ConsistencyModifier.LOCK);
        this.finishSchema();
        JanusGraphVertex foo = this.graph.addVertex(labelName);
        JanusGraphVertex bar = this.graph.addVertex(labelName);
        foo.property("uid", (Object)"foo");
        bar.property("uid", (Object)"bar");
        this.graph.tx().commit();
        Iterable vertexes = this.graph.query().has("uid", (JanusGraphPredicate)Contain.IN, (Object)ImmutableList.of((Object)"foo", (Object)"bar")).has(LABEL_NAME, (Object)labelName).vertices();
        Assertions.assertEquals((int)2, (int)Iterables.size((Iterable)vertexes));
        for (JanusGraphVertex v : vertexes) {
            Assertions.assertEquals((Object)labelName, (Object)v.vertexLabel().name());
        }
    }

    @Test
    public void testLimitWithMixedIndexCoverage() {
        String key1 = "vt";
        String key2 = "firstname";
        String value1 = "user";
        String alice = "alice";
        String bob = "bob";
        this.makeVertexIndexedKey("vt", String.class);
        this.makeKey("firstname", String.class);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"vt", "user", "firstname", "alice"});
        this.tx.addVertex(new Object[]{"vt", "user", "firstname", "bob"});
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "bob");
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "alice");
        this.tx.commit();
        this.tx = this.graph.newTransaction();
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "bob");
        JanusGraphTest.getVertexWithLimitAndAssertProperties(this.tx, "vt", "user", "firstname", "alice");
    }

    private static void getVertexWithLimitAndAssertProperties(JanusGraphTransaction tx, String key1, String value1, String key2, String value2) {
        JanusGraphVertex v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)tx.query().has(key1, (Object)value1).has(key2, (Object)value2).limit(1).vertices());
        Assertions.assertEquals((Object)value2, (Object)v.value(key2));
        Assertions.assertEquals((Object)value1, (Object)v.value(key1));
    }

    @Test
    public void testWithoutIndex() {
        PropertyKey kid = this.mgmt.makePropertyKey("kid").dataType(Long.class).make();
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makeEdgeLabel("knows").signature(new PropertyKey[]{kid}).make();
        this.finishSchema();
        Random random = new Random();
        int numV = 1000;
        JanusGraphVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex v = this.graph.addVertex(new Object[]{"kid", random.nextInt(numV), "name", "v" + i});
            if (previous != null) {
                JanusGraphEdge janusGraphEdge = v.addEdge("knows", (Vertex)previous, new Object[]{"kid", random.nextInt(numV / 2)});
            }
            previous = v;
        }
        JanusGraphTest.assertElementOrderForWithoutIndex(this.graph);
        this.clopen(new Object[0]);
        JanusGraphTest.assertElementOrderForWithoutIndex(this.graph);
    }

    private static void assertElementOrderForWithoutIndex(StandardJanusGraph graph) {
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(500).vertices(), "kid", Order.ASC, 500);
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(300).edges(), "kid", Order.ASC, 300);
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(400).vertices(), "kid", Order.DESC, 400);
        JanusGraphTest.verifyElementOrder(graph.query().orderBy("kid", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(200).edges(), "kid", Order.DESC, 200);
    }

    @Test
    public void testNeqQuery() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p1", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p1", P.neq(null)).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p2", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p2", P.neq(null)).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p3", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p3", P.neq(null)).hasNext());
    }

    @Test
    public void testHasNullQuery() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p1", null).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p2", null).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p3", null).hasNext());
    }

    @Test
    public void testNullValueMutation() {
        this.mgmt.makePropertyKey("single").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makePropertyKey("list").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.makePropertyKey("set").dataType(String.class).cardinality(Cardinality.SET).make();
        this.finishSchema();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[]{"single", null});
        Assertions.assertFalse((boolean)v1.properties(new String[]{"single"}).hasNext());
        Assertions.assertFalse((boolean)v1.values(new String[0]).hasNext());
        v1.property("single", (Object)"oldValue");
        this.newTx();
        Assertions.assertTrue((boolean)v1.properties(new String[]{"single"}).hasNext());
        Assertions.assertEquals((Object)"oldValue", v1.values(new String[0]).next());
        v1.property("single", null);
        Assertions.assertFalse((boolean)v1.properties(new String[]{"single"}).hasNext());
        Assertions.assertFalse((boolean)v1.values(new String[0]).hasNext());
        this.newTx();
        Assertions.assertFalse((boolean)v1.properties(new String[]{"single"}).hasNext());
        Assertions.assertFalse((boolean)v1.values(new String[0]).hasNext());
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("list", (Object)"a");
        v2.property("list", null);
        v2.property("list", (Object)"b");
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"a", "b"}, Iterators.toArray((Iterator)v2.values(new String[0]), String.class)));
        this.newTx();
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"a", "b"}, Iterators.toArray((Iterator)v2.values(new String[0]), String.class)));
        v2.property(VertexProperty.Cardinality.single, "list", null, new Object[0]);
        Assertions.assertFalse((boolean)v2.values(new String[0]).hasNext());
        this.newTx();
        Assertions.assertFalse((boolean)v2.values(new String[0]).hasNext());
        Edge e = v1.addEdge("connect", (Vertex)v2, new Object[0]);
        e.property("set", (Object)"a");
        e.property("set", (Object)"a");
        e.property("set", null);
        Assertions.assertTrue((boolean)Objects.deepEquals(new String[]{"a"}, Iterators.toArray((Iterator)e.values(new String[0]), String.class)));
        e.property("single", (Object)"b");
        Assertions.assertTrue((boolean)e.values(new String[]{"single"}).hasNext());
        e.property("single", null);
        Assertions.assertFalse((boolean)e.values(new String[]{"single"}).hasNext());
        this.newTx();
        Assertions.assertFalse((boolean)e.values(new String[]{"single"}).hasNext());
    }

    @Test
    public void testHasNot() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p1").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p1").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p1", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p1", (Object)"value").vertices().iterator().hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p2").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p2").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p2", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p2", (Object)"value").vertices().iterator().hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p3").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p3").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p3", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p3", (Object)"value").vertices().iterator().hasNext());
    }

    @Test
    public void testNotHas() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p1")).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p2")).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p3")).hasNext());
    }

    @Test
    public void testGraphCentricQueryProfiling() {
        if (this.getStoreFeatures().isDistributed() && this.getStoreFeatures().isKeyOrdered()) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Integer.class);
        JanusGraphIndex compositeNameIndex = this.mgmt.buildIndex("nameIdx", Vertex.class).addKey(name).buildCompositeIndex();
        JanusGraphIndex compositeWeightIndex = this.mgmt.buildIndex("weightIdx", Vertex.class).addKey(weight).buildCompositeIndex();
        PropertyKey prop = this.makeKey("prop", Integer.class);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "bob", "prop", 100, "weight", 100});
        this.tx.addVertex(new Object[]{"name", "alex", "prop", 100, "weight", 100});
        this.tx.addVertex(new Object[]{"name", "bob", "prop", 150, "weight", 120});
        this.tx.commit();
        this.newTx();
        Metrics mCompSingle = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").profile().next()).getMetrics(0);
        Assertions.assertEquals((long)2L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").count().next()));
        Assertions.assertEquals((Object)"JanusGraphStep([],[name.eq(bob)])", (Object)mCompSingle.getName());
        Assertions.assertTrue((mCompSingle.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)mCompSingle.getNested().size());
        Metrics nested = (Metrics)mCompSingle.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompSingle.getNested().toArray()[1];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        HashMap nameIdxAnnotations = new HashMap(){
            {
                this.put("condition", "(name = bob)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "multiKSQ[1]{KeySliceQuery(0x0689A0626FE2)[0x00,0xFF)}");
                this.put("index", "nameIdx");
            }
        };
        Assertions.assertEquals((Object)nameIdxAnnotations, (Object)nested.getAnnotations());
        Assertions.assertEquals((int)1, (int)nested.getNested().size());
        Metrics backendQueryMetrics = (Metrics)nested.getNested().toArray()[0];
        Assertions.assertTrue((backendQueryMetrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        this.newTx();
        Metrics mCompMultiOr = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"weight", (Object)100)}).profile().next()).getMetrics(0);
        Assertions.assertEquals((long)3L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"weight", (Object)100)}).count().next()));
        Assertions.assertEquals((Object)"Or(JanusGraphStep([],[name.eq(bob)]),JanusGraphStep([],[weight.eq(100)]))", (Object)mCompMultiOr.getName());
        Assertions.assertTrue((mCompMultiOr.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)5, (int)mCompMultiOr.getNested().size());
        nested = (Metrics)mCompMultiOr.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompMultiOr.getNested().toArray()[1];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompMultiOr.getNested().toArray()[2];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)nameIdxAnnotations, (Object)nested.getAnnotations());
        Assertions.assertEquals((int)1, (int)nested.getNested().size());
        backendQueryMetrics = (Metrics)nested.getNested().toArray()[0];
        Assertions.assertTrue((backendQueryMetrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompMultiOr.getNested().toArray()[3];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompMultiOr.getNested().toArray()[4];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        HashMap weightIdxAnnotations = new HashMap(){
            {
                this.put("condition", "(weight = 100)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "multiKSQ[1]{KeySliceQuery(0x088901C8)[0x00,0xFF)}");
                this.put("index", "weightIdx");
            }
        };
        Assertions.assertEquals((Object)weightIdxAnnotations, (Object)nested.getAnnotations());
        Assertions.assertEquals((int)1, (int)nested.getNested().size());
        backendQueryMetrics = (Metrics)nested.getNested().toArray()[0];
        Assertions.assertTrue((backendQueryMetrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        this.newTx();
        Assertions.assertEquals((long)3L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"name", (Object)"alex")}).count().next()));
        TraversalMetrics metrics = (TraversalMetrics)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"name", (Object)"alex")}).profile().next();
        mCompMultiOr = metrics.getMetrics(0);
        Assertions.assertEquals((Object)"JanusGraphStep([],[name.or(=(bob), =(alex))])", (Object)mCompMultiOr.getName());
        Assertions.assertTrue((mCompMultiOr.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)mCompMultiOr.getNested().size());
        nested = (Metrics)mCompMultiOr.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompMultiOr.getNested().toArray()[1];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"((name = bob OR name = alex))", (Object)nested.getAnnotation("condition"));
        HashMap multiKSQAnnotations = new HashMap(){
            {
                this.put("condition", "((name = bob OR name = alex))");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "multiKSQ[2]{KeySliceQuery(0x0689A0626FE2)[0x00,0xFF),KeySliceQuery(0x0689A0616C65F8)[0x00,0xFF)}");
                this.put("index", "nameIdx");
            }
        };
        Assertions.assertEquals((Object)multiKSQAnnotations, (Object)nested.getAnnotations());
        this.newTx();
        Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"weight", (Object)100)}).count().next()));
        metrics = (TraversalMetrics)this.tx.traversal().V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"weight", (Object)100)}).profile().next();
        Metrics mCompMultiAnd = metrics.getMetrics(0);
        Assertions.assertEquals((Object)"JanusGraphStep([],[name.eq(bob), weight.eq(100)])", (Object)mCompMultiAnd.getName());
        Assertions.assertTrue((mCompMultiAnd.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)mCompMultiAnd.getNested().size());
        nested = (Metrics)mCompMultiAnd.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompMultiAnd.getNested().toArray()[1];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"(name = bob AND weight = 100)", (Object)nested.getAnnotation("condition"));
        Assertions.assertEquals((int)2, (int)nested.getNested().size());
        Metrics deeplyNested1 = (Metrics)nested.getNested().toArray()[0];
        Assertions.assertEquals((Object)"AND-query", (Object)deeplyNested1.getName());
        Metrics deeplyNested2 = (Metrics)nested.getNested().toArray()[1];
        Assertions.assertEquals((Object)"AND-query", (Object)deeplyNested2.getName());
        try {
            Assertions.assertEquals((Object)"multiKSQ[1]{KeySliceQuery(0x088901C8)[0x00,0xFF)}", (Object)deeplyNested1.getAnnotation("query"));
            Assertions.assertEquals((Object)"multiKSQ[1]{KeySliceQuery(0x0689A0626FE2)[0x00,0xFF)}", (Object)deeplyNested2.getAnnotation("query"));
        }
        catch (AssertionFailedError error) {
            Assertions.assertEquals((Object)"multiKSQ[1]{KeySliceQuery(0x088901C8)[0x00,0xFF)}", (Object)deeplyNested2.getAnnotation("query"));
            Assertions.assertEquals((Object)"multiKSQ[1]{KeySliceQuery(0x0689A0626FE2)[0x00,0xFF)}", (Object)deeplyNested1.getAnnotation("query"));
        }
        this.newTx();
        Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)100)}).count().next()));
        Metrics mUnfittedMultiAnd = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)100)}).profile().next()).getMetrics(0);
        Assertions.assertEquals((Object)"JanusGraphStep([],[name.eq(bob), prop.eq(100)])", (Object)mUnfittedMultiAnd.getName());
        Assertions.assertTrue((mUnfittedMultiAnd.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)mUnfittedMultiAnd.getNested().size());
        nested = (Metrics)mUnfittedMultiAnd.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mUnfittedMultiAnd.getNested().toArray()[1];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        HashMap annotations = new HashMap(){
            {
                this.put("condition", "(name = bob AND prop = 100)");
                this.put("orders", "[]");
                this.put("isFitted", "false");
                this.put("isOrdered", "true");
                this.put("query", "multiKSQ[1]{KeySliceQuery(0x0689A0626FE2)[0x00,0xFF)}");
                this.put("index", "nameIdx");
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
        this.newTx();
        Assertions.assertEquals((long)3L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)100)}).count().next()));
        Metrics mUnfittedMultiOr = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)100)}).profile().next()).getMetrics(0);
        Assertions.assertEquals((Object)"Or(JanusGraphStep([],[name.eq(bob)]),JanusGraphStep([],[prop.eq(100)]))", (Object)mUnfittedMultiOr.getName());
        Assertions.assertTrue((mUnfittedMultiOr.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)5, (int)mUnfittedMultiOr.getNested().size());
        nested = (Metrics)mUnfittedMultiOr.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mUnfittedMultiOr.getNested().toArray()[1];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mUnfittedMultiOr.getNested().toArray()[2];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)nameIdxAnnotations, (Object)nested.getAnnotations());
        nested = (Metrics)mUnfittedMultiOr.getNested().toArray()[3];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mUnfittedMultiOr.getNested().toArray()[4];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        annotations = new HashMap(){
            {
                this.put("condition", "(prop = 100)");
                this.put("orders", "[]");
                this.put("isFitted", "false");
                this.put("isOrdered", "true");
                this.put("query", "[]");
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
        nested = (Metrics)nested.getNested().toArray()[0];
        HashMap fullScanAnnotations = new HashMap(){
            {
                this.put("query", "[]");
                this.put("fullscan", "true");
                this.put("condition", "VERTEX");
            }
        };
        Assertions.assertEquals((Object)fullScanAnnotations, (Object)nested.getAnnotations());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testGraphCentricQueryProfilingWithLimitAdjusting() throws BackendException {
        if (this.getStoreFeatures().isDistributed() && this.getStoreFeatures().isKeyOrdered()) {
            return;
        }
        Runnable dataLoader = () -> {
            PropertyKey name = this.makeKey("name", String.class);
            JanusGraphIndex compositeNameIndex = this.mgmt.buildIndex("nameIdx", Vertex.class).addKey(name).buildCompositeIndex();
            this.finishSchema();
            this.newTx();
            for (int i = 0; i < 3000; ++i) {
                this.tx.addVertex(new Object[]{"name", "bob"});
            }
            this.tx.commit();
        };
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.ADJUST_LIMIT, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HARD_MAX_LIMIT, new String[0]), 100000);
        dataLoader.run();
        this.newTx();
        Metrics mCompSingle = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").profile().next()).getMetrics(0);
        Assertions.assertEquals((int)2, (int)mCompSingle.getNested().size());
        Metrics nested = (Metrics)mCompSingle.getNested().toArray()[1];
        HashMap nameIdxAnnotations = new HashMap(){
            {
                this.put("condition", "(name = bob)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "multiKSQ[1]@100000{KeySliceQuery(0x0489A0626FE2)[0x00,0xFF)}");
                this.put("index", "nameIdx");
            }
        };
        Assertions.assertEquals((Object)nameIdxAnnotations, (Object)nested.getAnnotations());
        List backendQueryMetrics = nested.getNested().stream().map(m -> m).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)backendQueryMetrics.size());
        HashMap backendAnnotations = new HashMap(){
            {
                this.put("query", "nameIdx:multiKSQ[1]@100000{KeySliceQuery(0x0489A0626FE2)[0x00,0xFF)}");
                this.put("limit", 100000);
            }
        };
        Assertions.assertEquals((Object)backendAnnotations, (Object)((Metrics)backendQueryMetrics.get(0)).getAnnotations());
        Assertions.assertTrue((((Metrics)backendQueryMetrics.get(0)).getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        this.close();
        JanusGraphFactory.drop((JanusGraph)this.graph);
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.ADJUST_LIMIT, new String[0]), false, JanusGraphTest.option(GraphDatabaseConfiguration.HARD_MAX_LIMIT, new String[0]), Integer.MAX_VALUE);
        dataLoader.run();
        this.newTx();
        mCompSingle = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").profile().next()).getMetrics(0);
        Assertions.assertEquals((int)2, (int)mCompSingle.getNested().size());
        nested = (Metrics)mCompSingle.getNested().toArray()[1];
        nameIdxAnnotations = new HashMap(){
            {
                this.put("condition", "(name = bob)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "multiKSQ[1]{KeySliceQuery(0x0489A0626FE2)[0x00,0xFF)}");
                this.put("index", "nameIdx");
            }
        };
        Assertions.assertEquals((Object)nameIdxAnnotations, (Object)nested.getAnnotations());
        backendQueryMetrics = nested.getNested().stream().map(m -> m).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)backendQueryMetrics.size());
        backendAnnotations = new HashMap(){
            {
                this.put("query", "nameIdx:multiKSQ[1]{KeySliceQuery(0x0489A0626FE2)[0x00,0xFF)}");
            }
        };
        Assertions.assertEquals((Object)backendAnnotations, (Object)((Metrics)backendQueryMetrics.get(0)).getAnnotations());
        Assertions.assertTrue((((Metrics)backendQueryMetrics.get(0)).getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        this.close();
        JanusGraphFactory.drop((JanusGraph)this.graph);
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.ADJUST_LIMIT, new String[0]), true);
        dataLoader.run();
        this.newTx();
        mCompSingle = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").profile().next()).getMetrics(0);
        Assertions.assertEquals((Object)"JanusGraphStep([],[name.eq(bob)])", (Object)mCompSingle.getName());
        Assertions.assertTrue((mCompSingle.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)mCompSingle.getNested().size());
        nested = (Metrics)mCompSingle.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mCompSingle.getNested().toArray()[1];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nameIdxAnnotations = new HashMap(){
            {
                this.put("condition", "(name = bob)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "multiKSQ[1]@4000{KeySliceQuery(0x0489A0626FE2)[0x00,0xFF)}");
                this.put("index", "nameIdx");
            }
        };
        Assertions.assertEquals((Object)nameIdxAnnotations, (Object)nested.getAnnotations());
        backendQueryMetrics = nested.getNested().stream().map(m -> m).collect(Collectors.toList());
        Assertions.assertEquals((int)3, (int)backendQueryMetrics.size());
        int limit = 1000;
        for (Metrics backendQueryMetric : backendQueryMetrics) {
            final int queryLimit = limit;
            backendAnnotations = new HashMap(){
                {
                    this.put("query", "nameIdx:multiKSQ[1]@" + queryLimit + "{KeySliceQuery(0x0489A0626FE2)[0x00,0xFF)}");
                    this.put("limit", queryLimit);
                }
            };
            Assertions.assertEquals((Object)backendAnnotations, (Object)backendQueryMetric.getAnnotations());
            Assertions.assertTrue((backendQueryMetric.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            limit *= 2;
        }
    }

    @Test
    public void testVertexCentricQueryProfiling() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.SIMPLE).make();
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[0]);
        JanusGraphVertex o = this.tx.addVertex(new Object[0]);
        v.addEdge("friend", (Vertex)o, new Object[]{"time", 100});
        v.addEdge("friend-no-index", (Vertex)o, new Object[]{"time", 100});
        this.tx.commit();
        this.newTx();
        Metrics mSingleLabel = ((TraversalMetrics)this.tx.traversal().V(new Object[]{v}).outE(new String[]{"friend"}).has("time", P.lt((Object)10)).profile().next()).getMetrics(3);
        Assertions.assertEquals((Object)"JanusGraphVertexStep([time.lt(10)])", (Object)mSingleLabel.getName());
        Assertions.assertTrue((mSingleLabel.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        HashMap annotations = new HashMap(){
            {
                this.put("condition", "(time < 10 AND type[friend])");
                this.put("orders", "[]");
                this.put("vertices", 1);
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "2069:byTime:SliceQuery[0xB0E0FF7FFFFFF6,0xB0E1)");
                this.put("multi", "true");
            }
        };
        mSingleLabel.getAnnotations().remove("percentDur");
        Assertions.assertEquals((Object)annotations, (Object)mSingleLabel.getAnnotations());
        this.newTx();
        Metrics mMultiLabels = ((TraversalMetrics)this.tx.traversal().V(new Object[]{v}).outE(new String[]{"friend", "friend-no-index"}).has("time", (Object)100).profile().next()).getMetrics(3);
        Assertions.assertEquals((Object)"JanusGraphVertexStep([time.eq(100)])", (Object)mMultiLabels.getName());
        Assertions.assertTrue((mMultiLabels.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        annotations = new HashMap(){
            {
                this.put("condition", "(time = 100 AND (type[friend] OR type[friend-no-index]))");
                this.put("orders", "[]");
                this.put("multi", "true");
                this.put("vertices", 1);
            }
        };
        mMultiLabels.getAnnotations().remove("percentDur");
        Assertions.assertEquals((Object)annotations, (Object)mMultiLabels.getAnnotations());
        Assertions.assertEquals((int)4, (int)mMultiLabels.getNested().size());
        Metrics friendMetrics = (Metrics)mMultiLabels.getNested().toArray()[1];
        Assertions.assertEquals((Object)"OR-query", (Object)friendMetrics.getName());
        annotations = new HashMap(){
            {
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", "2069:byTime:SliceQuery[0xB0E0FF7FFFFF9B,0xB0E0FF7FFFFF9C)");
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)friendMetrics.getAnnotations());
        Metrics friendNoIndexMetrics = (Metrics)mMultiLabels.getNested().toArray()[2];
        Assertions.assertEquals((Object)"OR-query", (Object)friendNoIndexMetrics.getName());
        annotations = new HashMap(){
            {
                this.put("isFitted", "false");
                this.put("isOrdered", "true");
                this.put("query", "friend-no-index:SliceQuery[0x7180,0x7181)");
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)friendNoIndexMetrics.getAnnotations());
        Metrics backendQueryMetrics = (Metrics)mMultiLabels.getNested().toArray()[3];
        Assertions.assertEquals((Object)"backend-query", (Object)backendQueryMetrics.getName());
        Map annotatnions = backendQueryMetrics.getAnnotations();
        Assertions.assertEquals((int)3, (int)annotatnions.size());
        Assertions.assertEquals((Object)"true", annotatnions.get("multiSlices"));
        Assertions.assertEquals((Object)2, annotatnions.get("queriesAmount"));
        Assertions.assertTrue((annotatnions.get("queries").equals("[2069:byTime:SliceQuery[0xB0E0FF7FFFFF9B,0xB0E0FF7FFFFF9C), friend-no-index:SliceQuery[0x7180,0x7181)]") || annotatnions.get("queries").equals("[friend-no-index:SliceQuery[0x7180,0x7181), 2069:byTime:SliceQuery[0xB0E0FF7FFFFF9B,0xB0E0FF7FFFFF9C)]") ? 1 : 0) != 0);
    }

    @Test
    public void testVertexCentricIndexWithNull() {
        EdgeLabel bought = this.makeLabel("bought");
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildEdgeIndex(bought, "byTimeDesc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildEdgeIndex(bought, "byTimeAsc", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.asc, new PropertyKey[]{time});
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)1);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)2);
        v1.addEdge("bought", (Vertex)v2, new Object[0]).property("time", (Object)3);
        v1.addEdge("bought", (Vertex)v2, new Object[0]);
        v1.addEdge("bought", (Vertex)v2, new Object[0]);
        JanusGraphTest.assertVertexCentricIndexWithNull(v1);
        this.newTx();
        v1 = this.tx.getVertex(v1.id());
        JanusGraphTest.assertVertexCentricIndexWithNull(v1);
    }

    private static void assertVertexCentricIndexWithNull(JanusGraphVertex v1) {
        Assertions.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
        Assertions.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Object)1).edgeCount());
        Assertions.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)3).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)1).edgeCount());
        Assertions.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)5).edgeCount());
        Assertions.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)0).edgeCount());
        Assertions.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)3).edgeCount());
        Assertions.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)2).edgeCount());
        Assertions.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).hasNot("time").edgeCount());
        Assertions.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).edgeCount());
    }

    @Test
    public void testCreateDelete() {
        this.makeKey("weight", Double.class);
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{uid}).sortOrder(Order.DESC).directed().make();
        this.mgmt.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        this.finishSchema();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.graph.addVertex(new Object[]{"uid", 445});
        JanusGraphEdge e = v3.addEdge("knows", (Vertex)v1, new Object[]{"uid", 111});
        JanusGraphEdge e2 = v1.addEdge("friend", (Vertex)v3, new Object[0]);
        Assertions.assertEquals((int)111, (int)((Integer)e.value("uid")));
        this.graph.tx().commit();
        v3 = JanusGraphTest.getV((Transaction)this.graph, v3);
        Assertions.assertEquals((int)445, (int)((Integer)v3.value("uid")));
        e = (Edge)Iterables.getOnlyElement((Iterable)v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assertions.assertEquals((int)111, (int)((Integer)e.value("uid")));
        Assertions.assertEquals((Object)e, (Object)JanusGraphTest.getE((Transaction)this.graph, e.id()));
        Assertions.assertEquals((Object)e, (Object)JanusGraphTest.getE((Transaction)this.graph, e.id().toString()));
        VertexProperty p = (VertexProperty)JanusGraphTest.getOnlyElement(v3.properties(new String[]{"uid"}));
        p.remove();
        v3.property("uid", (Object)353);
        e = (Edge)Iterables.getOnlyElement((Iterable)v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        e.property("uid", (Object)222);
        e2 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"friend"}).edges());
        e2.property("uid", (Object)1);
        e2.property("weight", (Object)2.0);
        Assertions.assertEquals((int)1, (int)((Integer)e2.value("uid")));
        Assertions.assertEquals((double)2.0, (double)((Double)e2.value("weight")), (double)1.0E-4);
        this.clopen(new Object[0]);
        v3 = JanusGraphTest.getV((Transaction)this.graph, v3.id());
        Assertions.assertEquals((int)353, (int)((Integer)v3.value("uid")));
        e = (Edge)Iterables.getOnlyElement((Iterable)v3.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        Assertions.assertEquals((int)222, (int)((Integer)e.value("uid")));
    }

    @Test
    public void testRemoveEdge() {
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e = v1.addEdge("related", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        e.remove();
        this.graph.tx().commit();
        Assertions.assertFalse((boolean)this.tx.query().edges().iterator().hasNext());
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLTiming() throws Exception {
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        int ttl1 = 1;
        int ttl2 = 4;
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(ttl1));
        EdgeLabel label2 = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)label2, Duration.ofSeconds(ttl2));
        EdgeLabel label3 = this.mgmt.makeEdgeLabel("indifferentTo").make();
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl1), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl2), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label2));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)label3));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        v2.addEdge("dislikes", (Vertex)v1, new Object[0]);
        v3.addEdge("indifferentTo", (Vertex)v1, new Object[0]);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        long commitTime = System.currentTimeMillis();
        this.graph.tx().commit();
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        Thread.sleep(commitTime + ((long)ttl1 * 1000L + 200L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
        Thread.sleep(commitTime + ((long)ttl2 * 1000L + 500L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertEmpty(v2.query().direction(Direction.OUT).vertices());
        JanusGraphAssert.assertNotEmpty(v3.query().direction(Direction.OUT).vertices());
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLWithTransactions() throws Exception {
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(1L));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        Thread.sleep(1001L);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        this.graph.tx().commit();
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        Thread.sleep(1001L);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).vertices());
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).vertices());
    }

    @Test
    @Tag(value="BRITTLE_TESTS")
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLWithIndex() throws Exception {
        int ttl = 1;
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        EdgeLabel wavedAt = this.mgmt.makeEdgeLabel("wavedAt").signature(new PropertyKey[]{time}).make();
        this.mgmt.buildEdgeIndex(wavedAt, "timeindex", Direction.BOTH, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildIndex("edge-time", Edge.class).addKey(time).buildCompositeIndex();
        this.mgmt.setTTL((JanusGraphSchemaType)wavedAt, Duration.ofSeconds(ttl));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)time));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl), (Object)this.mgmt.getTTL((JanusGraphSchemaType)wavedAt));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("wavedAt", (Vertex)v2, new Object[]{"time", 42});
        Assertions.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("time", (Object)42).edges());
        this.graph.tx().commit();
        long commitTime = System.currentTimeMillis();
        Assertions.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("time", (Object)42).edges());
        Thread.sleep(commitTime + ((long)ttl * 1000L + 100L) - System.currentTimeMillis());
        this.graph.tx().rollback();
        Assertions.assertFalse((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertEmpty(this.graph.query().has("time", (Object)42).edges());
    }

    @Test
    @Tag(value="BRITTLE_TESTS")
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testPropertyTTLTiming() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey place = this.mgmt.makePropertyKey("place").dataType(String.class).make();
        this.mgmt.setTTL((JanusGraphSchemaType)name, Duration.ofSeconds(42L));
        this.mgmt.setTTL((JanusGraphSchemaType)place, Duration.ofSeconds(1L));
        JanusGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        JanusGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(place).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(2L));
        Assertions.assertEquals((Object)Duration.ofSeconds(42L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)place));
        Assertions.assertEquals((Object)Duration.ofSeconds(2L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{T.label, "event", "name", "some event", "place", "somewhere"});
        this.tx.commit();
        Object id = v1.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNotNull((Object)v1);
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNotNull((Object)v1);
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices());
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNull((Object)v1);
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testVertexTTLWithCompositeIndex() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Long.class).make();
        JanusGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        JanusGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(time).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(1L));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)time));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{T.label, "event", "name", "some event", "time", System.currentTimeMillis()});
        this.tx.commit();
        Object id = v1.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNotNull((Object)v1);
        JanusGraphAssert.assertNotEmpty(this.graph.query().has("name", (Object)"some event").vertices());
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, id);
        Assertions.assertNull((Object)v1);
        JanusGraphAssert.assertEmpty(this.graph.query().has("name", (Object)"some event").vertices());
    }

    @Test
    @Tag(value="BRITTLE_TESTS")
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLLimitedByVertexTTL() throws Exception {
        Boolean dbCache = (Boolean)this.config.get("cache.db-cache", Boolean.class);
        if (null == dbCache) {
            dbCache = false;
        }
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)likes, Duration.ofSeconds(42L));
        EdgeLabel dislikes = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)dislikes, Duration.ofSeconds(1L));
        EdgeLabel indifferentTo = this.mgmt.makeEdgeLabel("indifferentTo").make();
        VertexLabel label1 = this.mgmt.makeVertexLabel("person").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(2L));
        Assertions.assertEquals((Object)Duration.ofSeconds(42L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)likes));
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)dislikes));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)indifferentTo));
        Assertions.assertEquals((Object)Duration.ofSeconds(2L), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex("person");
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphEdge v1LikesV2 = v1.addEdge("likes", (Vertex)v2, new Object[0]);
        JanusGraphEdge v1DislikesV2 = v1.addEdge("dislikes", (Vertex)v2, new Object[0]);
        JanusGraphEdge v1IndifferentToV2 = v1.addEdge("indifferentTo", (Vertex)v2, new Object[0]);
        this.tx.commit();
        long commitTime = System.currentTimeMillis();
        Object v1Id = v1.id();
        Object v2id = v2.id();
        Object v1LikesV2Id = v1LikesV2.id();
        Object v1DislikesV2Id = v1DislikesV2.id();
        Object v1IndifferentToV2Id = v1IndifferentToV2.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1Id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        v1LikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = JanusGraphTest.getE((Transaction)this.graph, v1IndifferentToV2Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v1LikesV2);
        Assertions.assertNotNull((Object)v1DislikesV2);
        Assertions.assertNotNull((Object)v1IndifferentToV2);
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        Thread.sleep(commitTime + 1001L - System.currentTimeMillis());
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1Id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        v1LikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = JanusGraphTest.getE((Transaction)this.graph, v1IndifferentToV2Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v1LikesV2);
        Assertions.assertNull((Object)v1DislikesV2);
        Assertions.assertNotNull((Object)v1IndifferentToV2);
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
        JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        Thread.sleep(commitTime + 2001L - System.currentTimeMillis());
        this.graph.tx().rollback();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1Id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        v1LikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1LikesV2Id);
        v1DislikesV2 = JanusGraphTest.getE((Transaction)this.graph, v1DislikesV2Id);
        v1IndifferentToV2 = JanusGraphTest.getE((Transaction)this.graph, v1IndifferentToV2Id);
        Assertions.assertNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNull((Object)v1LikesV2);
        Assertions.assertNull((Object)v1DislikesV2);
        Assertions.assertNull((Object)v1IndifferentToV2);
        if (!dbCache.booleanValue()) {
            JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"likes"}).edges());
            JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"dislikes"}).edges());
            JanusGraphAssert.assertEmpty(v2.query().direction(Direction.IN).labels(new String[]{"indifferentTo"}).edges());
        }
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testSettingTTLOnUnsupportedType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ImplicitKey type = ImplicitKey.ID;
            this.mgmt.setTTL((JanusGraphSchemaType)type, Duration.ZERO);
        });
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testUnsettingTTL() throws InterruptedException {
        int initialTTLMillis = 2000;
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((JanusGraphSchemaType)likes, Duration.ofMillis(initialTTLMillis));
        this.mgmt.commit();
        this.graph.tx().rollback();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Thread.sleep((long)Math.ceil((double)initialTTLMillis * 1.25));
        Assertions.assertEquals((int)2, (int)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assertions.assertEquals((int)0, (int)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        this.mgmt.setTTL((JanusGraphSchemaType)this.mgmt.getEdgeLabel("likes"), Duration.ZERO);
        this.mgmt.commit();
        Thread.sleep(1L);
        Assertions.assertEquals((int)2, (int)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assertions.assertEquals((int)0, (int)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        v1 = this.graph.addVertex(new Object[0]);
        v2 = this.graph.addVertex(new Object[0]);
        v1.addEdge("likes", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Thread.sleep((long)Math.ceil((double)initialTTLMillis * 1.25));
        Assertions.assertEquals((int)4, (int)Iterators.size((Iterator)this.graph.vertices(new Object[0])));
        Assertions.assertEquals((int)1, (int)Iterators.size((Iterator)this.graph.edges(new Object[0])));
        this.graph.tx().rollback();
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testGettingUndefinedEdgeLabelTTL() {
        this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)this.mgmt.getEdgeLabel("likes")));
        this.mgmt.rollback();
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testGettingUndefinedVertexLabelTTL() {
        this.mgmt.makeVertexLabel("foo").make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.mgmt = this.graph.openManagement();
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)this.mgmt.getVertexLabel("foo")));
        this.mgmt.rollback();
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testGetTTLFromUnsupportedType() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            ImplicitKey type = ImplicitKey.ID;
            this.mgmt.getTTL((JanusGraphSchemaType)type);
        });
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testSettingTTLOnNonStaticVertexLabel() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            VertexLabel label1 = this.mgmt.makeVertexLabel("event").make();
            this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(42L));
        });
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testEdgeTTLImplicitKey() throws Exception {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        Assertions.assertEquals((Object)"~ttl", (Object)ImplicitKey.TTL.name());
        int ttl = 86400;
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        EdgeLabel hasLiked = this.mgmt.makeEdgeLabel("hasLiked").make();
        this.mgmt.setTTL((JanusGraphSchemaType)likes, Duration.ofSeconds(ttl));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl), (Object)this.mgmt.getTTL((JanusGraphSchemaType)likes));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)hasLiked));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        JanusGraphEdge e1 = v1.addEdge("likes", (Vertex)v2, new Object[0]);
        JanusGraphEdge e2 = v1.addEdge("hasLiked", (Vertex)v2, new Object[0]);
        this.graph.tx().commit();
        Duration d = (Duration)e1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"likes"}).edges());
        d = (Duration)e1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        Thread.sleep(1001L);
        this.graph.tx().rollback();
        e1 = (Edge)Iterables.getOnlyElement((Iterable)v1.query().direction(Direction.OUT).labels(new String[]{"likes"}).edges());
        d = (Duration)e1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofDays(1L), (Object)d);
        d = (Duration)e2.value("~ttl");
        Assertions.assertEquals((Object)Duration.ZERO, (Object)d);
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testVertexTTLImplicitKey() throws Exception {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        int ttl1 = 1;
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((JanusGraphSchemaType)label1, Duration.ofSeconds(ttl1));
        Assertions.assertEquals((Object)Duration.ofSeconds(ttl1), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label1));
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex("event");
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        this.tx.commit();
        Object v1id = v1.id();
        Object v2id = v2.id();
        v1 = JanusGraphTest.getV((Transaction)this.graph, v1id);
        v2 = JanusGraphTest.getV((Transaction)this.graph, v2id);
        Duration d = (Duration)v1.value("~ttl");
        Assertions.assertEquals((Object)Duration.ofSeconds(1L), (Object)d);
        d = (Duration)v2.value("~ttl");
        Assertions.assertEquals((Object)Duration.ZERO, (Object)d);
    }

    @Test
    public void testAutoSchemaMakerForVertexPropertyDataType() {
        JanusGraphVertex v1 = this.tx.addVertex("user");
        v1.property("id", (Object)10);
        v1.property("created", (Object)new Date());
        PropertyKey idPropertyKey = this.tx.getPropertyKey("id");
        Assertions.assertEquals(Integer.class, (Object)idPropertyKey.dataType(), (String)"Data type not identified correctly by auto schema maker");
        PropertyKey createdPropertyKey = this.tx.getPropertyKey("created");
        Assertions.assertEquals(Date.class, (Object)createdPropertyKey.dataType(), (String)"Data type not identified properly by auto schema maker");
    }

    @Test
    public void testAutoSchemaMakerForEdgePropertyDataType() {
        JanusGraphVertex v1 = this.tx.addVertex("user");
        JanusGraphVertex v2 = this.tx.addVertex("user");
        v1.addEdge("knows", (Vertex)v2, new Object[]{"id", 10, "created", new Date()});
        PropertyKey idPropertyKey = this.tx.getPropertyKey("id");
        Assertions.assertEquals(Integer.class, (Object)idPropertyKey.dataType(), (String)"Data type not identified correctly by auto schema maker");
        PropertyKey createdPropertyKey = this.tx.getPropertyKey("created");
        Assertions.assertEquals(Date.class, (Object)createdPropertyKey.dataType(), (String)"Data type not identified correctly by auto schema maker");
    }

    @Test
    public void testWriteAndReadWithJanusGraphIoRegistryWithGryo(@TempDir Path tempDir) {
        Path file = tempDir.resolve("testgraph_" + this.getClass().getCanonicalName() + ".kryo");
        this.testWritingAndReading(file.toFile());
    }

    @Test
    public void testWriteAndReadWithJanusGraphIoRegistryWithGraphson(@TempDir Path tempDir) {
        Path file = tempDir.resolve("testgraph_" + this.getClass().getCanonicalName() + ".json");
        this.testWritingAndReading(file.toFile());
    }

    private void testWritingAndReading(File f) {
        GraphTraversalSource g = this.graph.traversal();
        g.addV().property((Object)"name", (Object)f.getName(), new Object[0]).iterate();
        g.tx().commit();
        Assertions.assertEquals((long)0L, (long)f.length());
        g.io(f.getAbsolutePath()).write().iterate();
        Assertions.assertTrue((f.length() > 0L ? 1 : 0) != 0, (String)("File " + f.getAbsolutePath() + " was expected to be not empty, but is"));
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        g.V(new Object[0]).has("name", (Object)f.getName()).drop().iterate();
        g.tx().commit();
        g.io(f.getAbsolutePath()).read().iterate();
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[0]).has("name", (Object)f.getName()).count().next()));
    }

    @Test
    public void testGetMatchingIndexes() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey age = this.makeKey("age", Integer.class);
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).buildCompositeIndex();
        this.mgmt.buildIndex("byAge", Vertex.class).addKey(age).buildCompositeIndex();
        this.finishSchema();
        String searchName = "someName";
        Integer searchAge = 42;
        Assertions.assertEquals(Collections.emptySet(), (Object)IndexSelectionUtil.getMatchingIndexes(null));
        Assertions.assertEquals(Collections.emptySet(), (Object)IndexSelectionUtil.getMatchingIndexes(null, null));
        Assertions.assertEquals(Collections.emptySet(), (Object)IndexSelectionUtil.getMatchingIndexes(null, i -> true));
        List<PredicateCondition> constraints = Arrays.asList(new PredicateCondition((Object)"name", JanusGraphPredicateUtils.convert((BiPredicate)P.eq((Object)searchName).getBiPredicate()), (Object)searchName), new PredicateCondition((Object)"age", JanusGraphPredicateUtils.convert((BiPredicate)P.eq((Object)searchAge).getBiPredicate()), (Object)searchAge));
        And conditions = QueryUtil.constraints2QNF((StandardJanusGraphTx)((StandardJanusGraphTx)this.tx), constraints);
        Assertions.assertEquals((int)2, (int)IndexSelectionUtil.getMatchingIndexes((MultiCondition)conditions).size());
        Assertions.assertEquals((int)1, (int)IndexSelectionUtil.getMatchingIndexes((MultiCondition)conditions, i -> i.getName().equals("byAge")).size());
        Assertions.assertEquals((int)0, (int)IndexSelectionUtil.getMatchingIndexes((MultiCondition)conditions, null).size());
    }

    @Test
    public void testExistsMatchingIndex() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey age = this.makeKey("age", Integer.class);
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).buildCompositeIndex();
        this.mgmt.buildIndex("byAge", Vertex.class).addKey(age).buildCompositeIndex();
        this.finishSchema();
        String searchName = "someName";
        Integer searchAge = 42;
        Assertions.assertEquals((Object)false, (Object)IndexSelectionUtil.existsMatchingIndex(null));
        Assertions.assertEquals((Object)false, (Object)IndexSelectionUtil.existsMatchingIndex(null, null));
        Assertions.assertEquals((Object)false, (Object)IndexSelectionUtil.existsMatchingIndex(null, i -> true));
        List<PredicateCondition> constraints = Arrays.asList(new PredicateCondition((Object)"name", JanusGraphPredicateUtils.convert((BiPredicate)P.eq((Object)searchName).getBiPredicate()), (Object)searchName), new PredicateCondition((Object)"age", JanusGraphPredicateUtils.convert((BiPredicate)P.eq((Object)searchAge).getBiPredicate()), (Object)searchAge));
        And conditions = QueryUtil.constraints2QNF((StandardJanusGraphTx)((StandardJanusGraphTx)this.tx), constraints);
        Assertions.assertEquals((Object)true, (Object)IndexSelectionUtil.existsMatchingIndex((MultiCondition)conditions));
        Assertions.assertEquals((Object)true, (Object)IndexSelectionUtil.existsMatchingIndex((MultiCondition)conditions, i -> i.getName().equals("byAge")));
        Assertions.assertEquals((Object)false, (Object)IndexSelectionUtil.existsMatchingIndex((MultiCondition)conditions, i -> i.getName().equals("byNonExistentKey")));
        Assertions.assertEquals((Object)false, (Object)IndexSelectionUtil.existsMatchingIndex((MultiCondition)conditions, null));
    }

    @Test
    public void testHasQueryWithNullKey() {
        this.makeKey("time", Long.class);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"time", 0});
        JanusGraphAssert.assertCount(0, this.tx.query().has(null, (Object)0).vertices());
    }

    @Test
    public void testQueryWithNullPropertyKey() {
        this.makeKey("time", Long.class);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"time", 0});
        JanusGraphAssert.assertCount(0, QueryUtil.getVertices((StandardJanusGraphTx)((StandardJanusGraphTx)this.tx), (PropertyKey)null, (Object)0));
    }

    @Test
    public void testMultipleHasQueriesWhereOneUsesNullKey() {
        this.makeKey("time", Long.class);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"time", 0});
        JanusGraphAssert.assertCount(0, this.tx.query().has("time", (Object)0).has(null, (Object)0).vertices());
    }

    @Test
    public void testReindexingForEdgeIndex() throws InterruptedException, ExecutionException {
        String edgeLabelName = "egLabel";
        String propertyKeyForIn = "assocKindForIn";
        String propertyKeyForOut = "assocKindForOut";
        String propertyKeyForBoth = "assocKindForBoth";
        EdgeLabel edgeLabel = this.mgmt.makeEdgeLabel(edgeLabelName).multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makePropertyKey("vtName").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey propAssocKindIn = this.mgmt.makePropertyKey(propertyKeyForIn).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey propAssocKindOut = this.mgmt.makePropertyKey(propertyKeyForOut).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey propAssocKindBoth = this.mgmt.makePropertyKey(propertyKeyForBoth).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        JanusGraphVertex a = this.tx.addVertex(new Object[0]);
        a.property("vtName", (Object)"A");
        JanusGraphVertex b = this.tx.addVertex(new Object[0]);
        b.property("vtName", (Object)"B");
        a.addEdge(edgeLabelName, (Vertex)b, new Object[]{propertyKeyForIn, 1, propertyKeyForOut, 1, propertyKeyForBoth, 1});
        b.addEdge(edgeLabelName, (Vertex)a, new Object[]{propertyKeyForIn, 2, propertyKeyForOut, 2, propertyKeyForBoth, 2});
        this.tx.commit();
        String indexWithDirectionIn = "edgesByAssocKindIn";
        String indexWithDirectionOut = "edgesByAssocKindOut";
        String indexWithDirectionBoth = "edgesByAssocKindBoth";
        this.mgmt.buildEdgeIndex(this.mgmt.getEdgeLabel(edgeLabelName), indexWithDirectionIn, Direction.IN, new PropertyKey[]{this.mgmt.getPropertyKey(propertyKeyForIn)});
        this.mgmt.buildEdgeIndex(this.mgmt.getEdgeLabel(edgeLabelName), indexWithDirectionOut, Direction.OUT, new PropertyKey[]{this.mgmt.getPropertyKey(propertyKeyForOut)});
        this.mgmt.buildEdgeIndex(this.mgmt.getEdgeLabel(edgeLabelName), indexWithDirectionBoth, Direction.BOTH, new PropertyKey[]{this.mgmt.getPropertyKey(propertyKeyForBoth)});
        this.mgmt.commit();
        ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)indexWithDirectionIn, (String)edgeLabelName).call();
        ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)indexWithDirectionOut, (String)edgeLabelName).call();
        ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)indexWithDirectionBoth, (String)edgeLabelName).call();
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getRelationIndex(this.mgmt.getRelationType(edgeLabelName), indexWithDirectionIn), SchemaAction.ENABLE_INDEX).get();
        this.mgmt.updateIndex((Index)this.mgmt.getRelationIndex(this.mgmt.getRelationType(edgeLabelName), indexWithDirectionOut), SchemaAction.ENABLE_INDEX).get();
        this.mgmt.updateIndex((Index)this.mgmt.getRelationIndex(this.mgmt.getRelationType(edgeLabelName), indexWithDirectionBoth), SchemaAction.ENABLE_INDEX).get();
        this.finishSchema();
        Vertex v1 = (Vertex)this.tx.traversal().V(new Object[0]).has("vtName", (Object)"A").next();
        Vertex v2 = (Vertex)this.tx.traversal().V(new Object[0]).has("vtName", (Object)"B").next();
        Vertex[] vertices = new Vertex[]{v1, v1, v1, v1, v1, v1, v2, v2, v2, v2, v2, v2};
        int[] propValues = new int[]{1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2};
        Direction[] dirs = new Direction[]{Direction.IN, Direction.IN, Direction.OUT, Direction.OUT, Direction.BOTH, Direction.BOTH, Direction.IN, Direction.IN, Direction.OUT, Direction.OUT, Direction.BOTH, Direction.BOTH};
        this.performReindexAndVerifyEdgeCount(indexWithDirectionOut, edgeLabelName, propertyKeyForOut, vertices, propValues, dirs, new int[]{0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0});
        this.performReindexAndVerifyEdgeCount(indexWithDirectionIn, edgeLabelName, propertyKeyForIn, vertices, propValues, dirs, new int[]{0, 0, 1, 0, 1, 0, 0, 0, 0, 1, 0, 1});
        this.performReindexAndVerifyEdgeCount(indexWithDirectionBoth, edgeLabelName, propertyKeyForBoth, vertices, propValues, dirs, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    }

    public void performReindexAndVerifyEdgeCount(String indexName, String edgeLabel, String propKey, Vertex[] vertices, int[] propValues, Direction[] dirs, int[] resultsBeforeReindex) throws InterruptedException, ExecutionException {
        assert (propValues.length == dirs.length);
        assert (propValues.length == resultsBeforeReindex.length);
        RelationType t = this.mgmt.getRelationType(edgeLabel);
        RelationTypeIndex relationIndex = this.mgmt.getRelationIndex(t, indexName);
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)relationIndex.getIndexStatus());
        GraphTraversalSource g = this.graph.traversal();
        for (int i = 0; i < propValues.length; ++i) {
            int expectedCount = resultsBeforeReindex[i];
            Vertex v = vertices[i];
            long count = 0L;
            count = Direction.OUT.equals((Object)dirs[i]) ? (Long)g.V(new Object[]{v}).outE(new String[]{edgeLabel}).has(propKey, (Object)propValues[i]).count().next() : (Direction.IN.equals((Object)dirs[i]) ? ((Long)g.V(new Object[]{v}).inE(new String[]{edgeLabel}).has(propKey, (Object)propValues[i]).count().next()).longValue() : ((Long)g.V(new Object[]{v}).bothE(new String[]{edgeLabel}).has(propKey, (Object)propValues[i]).count().next()).longValue());
            Assertions.assertEquals((long)expectedCount, (long)count, (String)String.format("v = %s, index = %s, direction = %s, prop value = %d", ((Property)g.V(new Object[]{v}).properties(new String[]{"vtName"}).next()).value(), indexName, dirs[i], propValues[i]));
        }
        this.mgmt.updateIndex((Index)relationIndex, SchemaAction.REINDEX, 1).get();
        this.finishSchema();
        relationIndex = this.mgmt.getRelationIndex(t, indexName);
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)relationIndex.getIndexStatus());
        int[] expectedResultsAfterReindex = new int[]{0, 1, 1, 0, 1, 1, 1, 0, 0, 1, 1, 1};
        for (int i = 0; i < propValues.length; ++i) {
            int expectedCount = expectedResultsAfterReindex[i];
            Vertex v = vertices[i];
            long count = 0L;
            count = Direction.OUT.equals((Object)dirs[i]) ? (Long)g.V(new Object[]{v}).outE(new String[]{edgeLabel}).has(propKey, (Object)propValues[i]).count().next() : (Direction.IN.equals((Object)dirs[i]) ? ((Long)g.V(new Object[]{v}).inE(new String[]{edgeLabel}).has(propKey, (Object)propValues[i]).count().next()).longValue() : ((Long)g.V(new Object[]{v}).bothE(new String[]{edgeLabel}).has(propKey, (Object)propValues[i]).count().next()).longValue());
            Assertions.assertEquals((long)expectedCount, (long)count, (String)String.format("v = %s, index = %s, direction = %s, prop value = %d", ((Property)g.V(new Object[]{v}).properties(new String[]{"vtName"}).next()).value(), indexName, dirs[i], propValues[i]));
        }
    }

    @Test
    public void testMultipleOrClauses() {
        this.clopen(new Object[0]);
        Vertex v1 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)true, new Object[0]).property((Object)"b", (Object)true, new Object[0]).property((Object)"c", (Object)true, new Object[0]).property((Object)"d", (Object)true, new Object[0]).next();
        Vertex v2 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)true, new Object[0]).property((Object)"b", (Object)false, new Object[0]).property((Object)"c", (Object)true, new Object[0]).property((Object)"d", (Object)false, new Object[0]).next();
        Vertex v3 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)false, new Object[0]).property((Object)"b", (Object)true, new Object[0]).property((Object)"c", (Object)false, new Object[0]).property((Object)"d", (Object)true, new Object[0]).next();
        Vertex v4 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)false, new Object[0]).property((Object)"b", (Object)false, new Object[0]).property((Object)"c", (Object)true, new Object[0]).property((Object)"d", (Object)false, new Object[0]).next();
        this.newTx();
        List vertices = this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"a", (Object)true), __.has((String)"b", (Object)true)}).or(new Traversal[]{__.has((String)"c", (Object)false), __.has((String)"d", (Object)true)}).toList();
        Assertions.assertTrue((boolean)vertices.contains(v1));
        Assertions.assertFalse((boolean)vertices.contains(v2));
        Assertions.assertTrue((boolean)vertices.contains(v3));
        Assertions.assertFalse((boolean)vertices.contains(v4));
        Assertions.assertEquals((int)2, (int)vertices.size());
    }

    @Test
    public void testMultipleNestedOrClauses() {
        this.clopen(new Object[0]);
        boolean[] values = new boolean[]{false, true};
        ArrayList<Object> vertices = new ArrayList<Object>(16);
        for (boolean a : values) {
            for (boolean b : values) {
                for (boolean c : values) {
                    for (boolean d : values) {
                        vertices.add(this.tx.traversal().addV("test").property((Object)"a", (Object)a, new Object[0]).property((Object)"b", (Object)b, new Object[0]).property((Object)"c", (Object)c, new Object[0]).property((Object)"d", (Object)d, new Object[0]).next());
                    }
                }
            }
        }
        this.newTx();
        List result = this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"a", (Object)true), __.has((String)"b", (Object)true), __.has((String)"c", (Object)false)}).or(new Traversal[]{__.has((String)"c", (Object)false), __.has((String)"d", (Object)true)}).toList();
        Assertions.assertTrue((boolean)result.contains(vertices.get(0)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(1)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(4)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(5)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(7)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(8)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(9)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(11)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(12)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(13)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(15)));
        Assertions.assertEquals((int)11, (int)result.size());
        this.newTx();
        result = this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.or((Traversal[])new Traversal[]{__.has((String)"a", (Object)true), __.has((String)"c", (Object)true)}), __.has((String)"b", (Object)true)}).or(new Traversal[]{__.has((String)"c", (Object)false), __.has((String)"d", (Object)true)}).toList();
        Assertions.assertTrue((boolean)result.contains(vertices.get(3)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(4)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(5)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(7)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(8)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(9)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(11)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(12)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(13)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(15)));
        Assertions.assertEquals((int)10, (int)result.size());
        this.newTx();
        result = this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.or((Traversal[])new Traversal[]{__.has((String)"a", (Object)true), __.has((String)"c", (Object)true)}).or(new Traversal[]{__.has((String)"c", (Object)true), __.has((String)"d", (Object)false)}), __.has((String)"b", (Object)true)}).or(new Traversal[]{__.has((String)"c", (Object)false), __.has((String)"d", (Object)true)}).toList();
        Assertions.assertTrue((boolean)result.contains(vertices.get(3)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(4)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(5)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(7)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(8)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(11)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(12)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(13)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(15)));
        Assertions.assertEquals((int)9, (int)result.size());
        result = this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.or((Traversal[])new Traversal[]{__.has((String)"a", (Object)true), __.has((String)"c", (Object)true)}).or(new Traversal[]{__.or((Traversal[])new Traversal[]{__.has((String)"a", (Object)false), __.has((String)"b", (Object)true)}), __.has((String)"d", (Object)false)}), __.has((String)"b", (Object)true)}).or(new Traversal[]{__.has((String)"c", (Object)false), __.has((String)"d", (Object)false)}).toList();
        Assertions.assertTrue((boolean)result.contains(vertices.get(2)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(4)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(5)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(6)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(8)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(10)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(12)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(13)));
        Assertions.assertTrue((boolean)result.contains(vertices.get(14)));
        Assertions.assertEquals((int)9, (int)result.size());
    }

    @Test
    public void testVerticesDropAfterWhereWithBatchQueryEnabled() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.NONE.getConfigName(), JanusGraphTest.option(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]), false);
        long timestamp = System.currentTimeMillis();
        Vertex v1 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)timestamp, new Object[0]).property((Object)"b", (Object)true, new Object[0]).property((Object)"c", (Object)true, new Object[0]).property((Object)"d", (Object)true, new Object[0]).next();
        Vertex v2 = (Vertex)this.tx.traversal().addV("test").next();
        Vertex v3 = (Vertex)this.tx.traversal().addV("test").next();
        Vertex v4 = (Vertex)this.tx.traversal().addV("test").next();
        v1.addEdge("edgeLabel", v2, new Object[0]);
        v1.addEdge("edgeLabel", v3, new Object[0]);
        v1.addEdge("edgeLabel", v4, new Object[0]);
        this.newTx();
        this.tx.traversal().V(new Object[0]).has("a", (Object)timestamp).has("b", (Object)true).has("c", (Object)true).where((Traversal)__.outE((String[])new String[0]).hasLabel("edgeLabel", new String[0])).both(new String[0]).drop().iterate();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("a", (Object)timestamp).has("b", (Object)true).has("c", (Object)true).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("a", (Object)timestamp).has("b", (Object)true).has("c", (Object)true).bothE(new String[0]).hasNext());
    }

    @Test
    public void testMgmtRemoveGhostVertices() throws ExecutionException, InterruptedException {
        if (this.features.hasLocking()) {
            return;
        }
        int numOfVertices = 100;
        int numOfGhostVertices = 80;
        int numOfRestVertices = 20;
        ArrayList<Object> vertices = new ArrayList<Object>(100);
        for (int i = 0; i < 100; ++i) {
            vertices.add(this.tx.traversal().addV("test").next());
        }
        this.tx.commit();
        JanusGraphTransaction tx1 = this.graph.newTransaction();
        for (int i = 0; i < 100; ++i) {
            tx1.traversal().V(new Object[]{vertices.get(i)}).property((Object)"prop", (Object)"val", new Object[0]).next();
        }
        JanusGraphTransaction tx2 = this.graph.newTransaction();
        for (int i = 0; i < 80; ++i) {
            ((Vertex)tx2.traversal().V(new Object[]{vertices.get(i)}).next()).remove();
        }
        tx2.commit();
        tx1.commit();
        JanusGraphManagement mgmt = this.graph.openManagement();
        ScanJobFuture future = mgmt.removeGhostVertices();
        Assertions.assertEquals((long)80L, (long)((ScanMetrics)future.get()).getCustom("removed-vertices"));
        Assertions.assertEquals((long)20L, (Long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        Assertions.assertEquals((long)20L, (Long)((Long)this.graph.traversal().V(new Object[0]).hasLabel("test", new String[0]).count().next()));
        Assertions.assertEquals((long)20L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("prop", (Object)"val").count().next()));
        Assertions.assertEquals((long)20L, (Long)((Long)this.graph.traversal().V(new Object[0]).hasLabel("test", new String[0]).has("prop", (Object)"val").count().next()));
        Assertions.assertEquals((long)0L, (long)((ScanMetrics)mgmt.removeGhostVertices().get()).getCustom("removed-vertices"));
    }

    @Test
    public void testDirectCompositeIndexEntryModification() throws BackendException {
        this.clopenForStaleIndex();
        String namePropKeyStr = "name";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("nameIndex", Vertex.class).addKey(nameProp).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]).property("name", (Object)"vertex1");
        this.tx.addVertex(new Object[0]).property("name", (Object)"vertex2");
        this.tx.commit();
        this.newTx();
        Vertex vertex1 = (Vertex)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex1").next();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex("nameIndex");
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        CompositeIndexType index = (CompositeIndexType)indexChangeVertex.asIndexType();
        JanusGraphVertexProperty indexedProperty = (JanusGraphVertexProperty)vertex1.property("name");
        IndexRecordEntry[] record = new IndexRecordEntry[]{new IndexRecordEntry(indexedProperty)};
        JanusGraphElement element = (JanusGraphElement)vertex1;
        Serializer serializer = this.graph.getDataSerializer();
        boolean hashKeys = this.graph.getIndexSerializer().isHashKeys();
        HashingUtil.HashLength hashLength = this.graph.getIndexSerializer().getHashLength();
        IndexUpdate update = IndexRecordUtil.getCompositeIndexUpdate((CompositeIndexType)index, (IndexMutationType)IndexMutationType.DELETE, (IndexRecordEntry[])record, (JanusGraphElement)element, (Serializer)serializer, (boolean)hashKeys, (HashingUtil.HashLength)hashLength);
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        transaction.mutateIndex((StaticBuffer)update.getKey(), Collections.emptyList(), Collections.singletonList(update.getEntry()));
        transaction.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[]{vertex1.id()}).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex1").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").hasNext());
        this.newTx();
        update = IndexRecordUtil.getCompositeIndexUpdate((CompositeIndexType)index, (IndexMutationType)IndexMutationType.ADD, (IndexRecordEntry[])record, (JanusGraphElement)element, (Serializer)serializer, (boolean)hashKeys, (HashingUtil.HashLength)hashLength);
        transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        transaction.mutateIndex((StaticBuffer)update.getKey(), Collections.singletonList(update.getEntry()), Collections.emptyList());
        transaction.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[]{vertex1.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex1").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").hasNext());
        Vertex vertex2 = (Vertex)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").next();
        indexedProperty = (JanusGraphVertexProperty)vertex2.property("name");
        long propertyId = indexedProperty.longId();
        PropertyKey propertyKey = indexedProperty.propertyKey();
        record = new IndexRecordEntry[]{new IndexRecordEntry(propertyId, (Object)"vertex2", propertyKey)};
        this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").drop().iterate();
        this.tx.commit();
        this.newTx();
        element = new CacheVertex((StandardJanusGraphTx)this.tx, vertex2.id(), 1);
        update = IndexRecordUtil.getCompositeIndexUpdate((CompositeIndexType)index, (IndexMutationType)IndexMutationType.ADD, (IndexRecordEntry[])record, (JanusGraphElement)element, (Serializer)serializer, (boolean)hashKeys, (HashingUtil.HashLength)hashLength);
        transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        transaction.mutateIndex((StaticBuffer)update.getKey(), Collections.singletonList(update.getEntry()), Collections.emptyList());
        transaction.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[]{vertex1.id()}).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex1").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").hasNext());
        record = new IndexRecordEntry[]{new IndexRecordEntry(propertyKey.longId(), (Object)"vertex2", propertyKey)};
        update = IndexRecordUtil.getCompositeIndexUpdate((CompositeIndexType)index, (IndexMutationType)IndexMutationType.DELETE, (IndexRecordEntry[])record, (JanusGraphElement)element, (Serializer)serializer, (boolean)hashKeys, (HashingUtil.HashLength)hashLength);
        transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        transaction.mutateIndex((StaticBuffer)update.getKey(), Collections.emptyList(), Collections.singletonList(update.getEntry()));
        transaction.commit();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[]{vertex1.id()}).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex1").hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").hasNext());
        managementSystem.rollback();
    }

    @Test
    public void testStaleIndexForceRemoveVertexFromGraphIndex() throws BackendException {
        this.clopenForStaleIndex();
        String namePropKeyStr = "name";
        String indexName = "nameIndex";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[0]).property("name", (Object)"vertex2");
        this.tx.commit();
        this.newTx();
        Vertex vertex2 = (Vertex)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").next();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        CompositeIndexType index = (CompositeIndexType)indexChangeVertex.asIndexType();
        Serializer serializer = this.graph.getDataSerializer();
        boolean hashKeys = this.graph.getIndexSerializer().isHashKeys();
        HashingUtil.HashLength hashLength = this.graph.getIndexSerializer().getHashLength();
        JanusGraphVertexProperty indexedProperty = (JanusGraphVertexProperty)vertex2.property("name");
        long propertyId = indexedProperty.longId();
        PropertyKey propertyKey = indexedProperty.propertyKey();
        IndexRecordEntry[] record = new IndexRecordEntry[]{new IndexRecordEntry(propertyId, (Object)"vertex2", propertyKey)};
        this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").drop().iterate();
        this.tx.commit();
        this.newTx();
        CacheVertex element = new CacheVertex((StandardJanusGraphTx)this.tx, vertex2.id(), 1);
        IndexUpdate update = IndexRecordUtil.getCompositeIndexUpdate((CompositeIndexType)index, (IndexMutationType)IndexMutationType.ADD, (IndexRecordEntry[])record, (JanusGraphElement)element, (Serializer)serializer, (boolean)hashKeys, (HashingUtil.HashLength)hashLength);
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        transaction.mutateIndex((StaticBuffer)update.getKey(), Collections.singletonList(update.getEntry()), Collections.emptyList());
        transaction.commit();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").hasNext());
        Assertions.assertThrows(Exception.class, () -> {
            Vertex cfr_ignored_0 = (Vertex)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").drop().next();
        });
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").hasNext());
        StaleIndexRecordUtil.forceRemoveElementFromGraphIndex((JanusGraphElement)element, (IndexRecordEntry[])record, (StandardJanusGraph)this.graph, (String)indexName);
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("name", (Object)"vertex2").hasNext());
    }

    @Test
    public void testEdgeEntryIndexForceRemoveFromGraphIndex() throws BackendException {
        this.clopenForStaleIndex();
        String namePropKeyStr = "name";
        String indexName = "nameIndex";
        String edgeName = "follow";
        this.mgmt.makeEdgeLabel(edgeName).make();
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Edge.class).addKey(nameProp).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex vertex1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex vertex2 = this.tx.addVertex(new Object[0]);
        Edge edge = (Edge)this.tx.traversal().addE(edgeName).from((Vertex)vertex1).to((Vertex)vertex2).property((Object)namePropKeyStr, (Object)"edge1", new Object[0]).next();
        this.tx.commit();
        this.newTx();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        CompositeIndexType index = (CompositeIndexType)indexChangeVertex.asIndexType();
        Serializer serializer = this.graph.getDataSerializer();
        boolean hashKeys = this.graph.getIndexSerializer().isHashKeys();
        HashingUtil.HashLength hashLength = this.graph.getIndexSerializer().getHashLength();
        PropertyKey propertyKey = managementSystem.getPropertyKey(namePropKeyStr);
        RelationIdentifier relationIdentifier = (RelationIdentifier)edge.id();
        long relationId = relationIdentifier.getRelationId();
        EdgeLabel edgeLabel = managementSystem.getEdgeLabel(edgeName);
        IndexRecordEntry[] record = new IndexRecordEntry[]{new IndexRecordEntry(relationId, (Object)"edge1", propertyKey)};
        InternalVertex internalVertex1 = (InternalVertex)edge.outVertex();
        InternalVertex internalVertex2 = (InternalVertex)edge.inVertex();
        StandardEdge element = new StandardEdge(relationId, edgeLabel, internalVertex1, internalVertex2, 1);
        StaleIndexRecordUtil.forceRemoveElementFromGraphIndex((JanusGraphElement)element, (IndexRecordEntry[])record, (StandardJanusGraph)this.graph, (String)indexName);
        this.tx.commit();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().E(new Object[0]).has(namePropKeyStr, (Object)"edge1").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().E(new Object[]{edge.id()}).hasNext());
        IndexUpdate update = IndexRecordUtil.getCompositeIndexUpdate((CompositeIndexType)index, (IndexMutationType)IndexMutationType.ADD, (IndexRecordEntry[])record, (JanusGraphElement)element, (Serializer)serializer, (boolean)hashKeys, (HashingUtil.HashLength)hashLength);
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        transaction.mutateIndex((StaticBuffer)update.getKey(), Collections.singletonList(update.getEntry()), Collections.emptyList());
        transaction.commit();
        this.tx.commit();
        managementSystem.rollback();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().E(new Object[0]).has(namePropKeyStr, (Object)"edge1").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().E(new Object[]{edge.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[]{vertex1}).out(new String[]{edgeName}).is((Object)vertex2).hasNext());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStaleIndexForceRemoveVertexFromGraphIndexByHelperMethod(boolean withLabelConstraint) throws BackendException {
        String vertexLabelName;
        this.clopenForStaleIndex();
        String namePropKeyStr = "name";
        String agePropKeyStr = "age";
        String indexName = "nameAgeIndex";
        String nameValue = "testNameValue";
        Integer ageValue = 123;
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey ageProp = this.mgmt.makePropertyKey(agePropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        JanusGraphManagement.IndexBuilder indexBuilder = this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp).addKey(ageProp);
        if (withLabelConstraint) {
            vertexLabelName = "testVertexLabel";
            VertexLabel vertexLabel = this.mgmt.makeVertexLabel(vertexLabelName).make();
            indexBuilder = indexBuilder.indexOnly((JanusGraphSchemaType)vertexLabel);
        } else {
            vertexLabelName = null;
        }
        indexBuilder.buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex addedVertex = vertexLabelName == null ? this.tx.addVertex(new Object[0]) : this.tx.addVertex(vertexLabelName);
        addedVertex.property(namePropKeyStr, (Object)nameValue);
        addedVertex.property(agePropKeyStr, (Object)ageValue);
        this.tx.commit();
        this.newTx();
        Vertex testVertex = (Vertex)this.getV(namePropKeyStr, nameValue, agePropKeyStr, ageValue, vertexLabelName).next();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        CompositeIndexType index = (CompositeIndexType)indexChangeVertex.asIndexType();
        Serializer serializer = this.graph.getDataSerializer();
        boolean hashKeys = this.graph.getIndexSerializer().isHashKeys();
        HashingUtil.HashLength hashLength = this.graph.getIndexSerializer().getHashLength();
        JanusGraphVertexProperty indexedNameProperty = (JanusGraphVertexProperty)testVertex.property(namePropKeyStr);
        long namePropertyId = indexedNameProperty.longId();
        PropertyKey namePropertyKey = indexedNameProperty.propertyKey();
        JanusGraphVertexProperty indexedAgeProperty = (JanusGraphVertexProperty)testVertex.property(agePropKeyStr);
        long agePropertyId = indexedAgeProperty.longId();
        PropertyKey agePropertyKey = indexedAgeProperty.propertyKey();
        IndexRecordEntry[] record = new IndexRecordEntry[]{new IndexRecordEntry(namePropertyId, (Object)nameValue, namePropertyKey), new IndexRecordEntry(agePropertyId, (Object)ageValue, agePropertyKey)};
        this.getV(namePropKeyStr, nameValue, agePropKeyStr, ageValue, vertexLabelName).drop().iterate();
        this.tx.commit();
        this.newTx();
        Object vertexId = testVertex.id();
        CacheVertex element = new CacheVertex((StandardJanusGraphTx)this.tx, testVertex.id(), 1);
        IndexUpdate update = IndexRecordUtil.getCompositeIndexUpdate((CompositeIndexType)index, (IndexMutationType)IndexMutationType.ADD, (IndexRecordEntry[])record, (JanusGraphElement)element, (Serializer)serializer, (boolean)hashKeys, (HashingUtil.HashLength)hashLength);
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        transaction.mutateIndex((StaticBuffer)update.getKey(), Collections.singletonList(update.getEntry()), Collections.emptyList());
        transaction.commit();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{testVertex.id()}).hasNext());
        Assertions.assertTrue((boolean)this.getV(namePropKeyStr, nameValue, agePropKeyStr, ageValue, vertexLabelName).hasNext());
        Assertions.assertThrows(Exception.class, () -> {
            Vertex cfr_ignored_0 = (Vertex)this.getV(namePropKeyStr, nameValue, agePropKeyStr, ageValue, vertexLabelName).drop().next();
        });
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{testVertex.id()}).hasNext());
        Assertions.assertTrue((boolean)this.getV(namePropKeyStr, nameValue, agePropKeyStr, ageValue, vertexLabelName).hasNext());
        HashMap<String, Object> indexRecordPropertyValues = new HashMap<String, Object>();
        indexRecordPropertyValues.put(namePropKeyStr, nameValue);
        indexRecordPropertyValues.put(agePropKeyStr, ageValue);
        StaleIndexRecordUtil.forceRemoveVertexFromGraphIndex((Object)vertexId, indexRecordPropertyValues, (JanusGraph)this.graph, (String)indexName);
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{testVertex.id()}).hasNext());
        Assertions.assertFalse((boolean)this.getV(namePropKeyStr, nameValue, agePropKeyStr, ageValue, vertexLabelName).hasNext());
    }

    @Test
    public void shouldThrowExceptionWhenIncorrectAmountOfPropertiesIsUsedDuringForceIndexRecordRemoval() {
        this.clopenForStaleIndex();
        String namePropKeyStr = "name";
        String agePropKeyStr = "age";
        String indexName = "nameAgeIndex";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey ageProp = this.mgmt.makePropertyKey(agePropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp).addKey(ageProp).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex addedVertex = this.tx.addVertex(new Object[0]);
        addedVertex.property(namePropKeyStr, (Object)"vertex2");
        addedVertex.property(agePropKeyStr, (Object)123);
        this.tx.commit();
        this.newTx();
        Vertex vertex2 = (Vertex)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).next();
        Assertions.assertThrows(IllegalArgumentException.class, () -> StaleIndexRecordUtil.forceRemoveVertexFromGraphIndex((Object)((Long)vertex2.id()), Collections.singletonMap(namePropKeyStr, "vertex2"), (JanusGraph)this.graph, (String)indexName));
    }

    @Test
    public void shouldThrowExceptionWhenIncorrectPropertiesAreUsedDuringForceIndexRecordRemoval() {
        this.clopenForStaleIndex();
        String namePropKeyStr = "name";
        String agePropKeyStr = "age";
        String indexName = "nameAgeIndex";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey ageProp = this.mgmt.makePropertyKey(agePropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp).addKey(ageProp).buildCompositeIndex();
        this.finishSchema();
        JanusGraphVertex addedVertex = this.tx.addVertex(new Object[0]);
        addedVertex.property(namePropKeyStr, (Object)"vertex2");
        addedVertex.property(agePropKeyStr, (Object)123);
        this.tx.commit();
        this.newTx();
        Vertex vertex2 = (Vertex)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).next();
        HashMap<String, Object> indexRecordPropertyValues = new HashMap<String, Object>();
        indexRecordPropertyValues.put(namePropKeyStr, "vertex2");
        indexRecordPropertyValues.put("unknownProperty", 123);
        Assertions.assertThrows(IllegalArgumentException.class, () -> StaleIndexRecordUtil.forceRemoveVertexFromGraphIndex((Object)((Long)vertex2.id()), (Map)indexRecordPropertyValues, (JanusGraph)this.graph, (String)indexName));
    }

    protected void clopenForStaleIndex() {
        this.clopen(new Object[0]);
    }

    @Test
    public void testPropertiesAfterProjectWithByThenChooseWithBatchQueryEnabled() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.USE_MULTIQUERY, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.HAS_STEP_BATCH_MODE, new String[0]), MultiQueryHasStepStrategyMode.NONE.getConfigName(), JanusGraphTest.option(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]), false);
        long timestamp = System.currentTimeMillis();
        this.tx.traversal().addV("test").property((Object)"a", (Object)timestamp, new Object[0]).next();
        this.newTx();
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("a", (Object)timestamp).project("a", new String[0]).by((Traversal)__.choose((Traversal)__.has((String)"a"), (Traversal)__.values((String[])new String[]{"a"}))).hasNext());
    }

    @Test
    public void testGremlinScriptEvaluationWithGremlinLangScriptEngine() {
        Exception npe = (Exception)Assertions.assertThrows(NullPointerException.class, () -> this.graph.eval("g.V()", false));
        Assertions.assertEquals((Object)"graph.script-eval.enabled is not enabled", (Object)npe.getMessage());
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCRIPT_EVAL_ENABLED, new String[0]), true);
        this.initializeGraphWithVerticesAndEdges();
        long vertexCount = (Long)this.graph.traversal().V(new Object[0]).count().next();
        Assertions.assertEquals((Object)vertexCount, (Object)this.graph.eval("g.V().count().next()", false));
        Assertions.assertEquals((Object)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext(), (Object)this.graph.eval("g.V().has('_v', 1).values('_v').hasNext()", false));
        Assertions.assertEquals((Object)this.graph.traversal().E(new Object[0]).has("_e", (Object)1).next(), (Object)this.graph.eval("g.E().has(\"_e\", 1).next()", false));
        Assertions.assertEquals((Object)(++vertexCount), (Object)this.graph.eval("g.addV().next();g.V().count().next()", true));
        JanusGraphException ex = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> this.graph.eval("g.V().map{t -> t.get()}.hasNext()", false));
        Assertions.assertEquals((Object)"Could not evaluate given gremlin script: g.V().map{t -> t.get()}.hasNext()", (Object)ex.getMessage());
        Assertions.assertThrows(JanusGraphException.class, () -> this.graph.eval("1 + 1", false));
        Assertions.assertThrows(JanusGraphException.class, () -> this.graph.eval("while(true) {}", false));
        Assertions.assertThrows(JanusGraphException.class, () -> this.graph.eval("g2 = g.getGraph().traversal(); g2.V().drop().iterate(); g2.tx().commit();", false));
        ex = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> this.graph.eval("g.addV().next()", false));
        Assertions.assertEquals((Object)"Could not evaluate given gremlin script: g.addV().next()", (Object)ex.getMessage());
        Assertions.assertEquals((Object)"org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.VerificationException: The provided traversal has a mutating step and thus is not read only: AddVertexStartStep({label=[vertex]})", (Object)ex.getCause().getMessage());
        this.graph.eval("g.addV().next()", true);
        Assertions.assertEquals((long)(vertexCount + 1L), (Long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        this.graph.tx().rollback();
        Assertions.assertEquals((long)(vertexCount + 1L), (Long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        this.graph.traversal().addV("dummyLabel").next();
        this.graph.eval("g.tx().commit()", true);
        this.graph.tx().rollback();
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).hasLabel("dummyLabel", new String[0]).hasNext());
        this.graph.traversal().addV("dummyLabel").next();
        this.graph.eval("g.tx().rollback()", true);
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).hasLabel("dummyLabel", new String[0]).hasNext());
    }

    @Test
    public void testGremlinScriptEvaluationWithGremlinGroovyScriptEngine() {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.SCRIPT_EVAL_ENABLED, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.SCRIPT_EVAL_ENGINE, new String[0]), "GremlinGroovyScriptEngine");
        this.initializeGraphWithVerticesAndEdges();
        long vertexCount = (Long)this.graph.traversal().V(new Object[0]).count().next();
        Assertions.assertEquals((Object)vertexCount, (Object)this.graph.eval("g.V().count().next()", false));
        Assertions.assertEquals((Object)this.graph.traversal().V(new Object[0]).has("_v", (Object)1).values(new String[]{"_v"}).hasNext(), (Object)this.graph.eval("g.V().has('_v', 1).values('_v').hasNext()", false));
        Assertions.assertEquals((Object)this.graph.traversal().E(new Object[0]).has("_e", (Object)1).next(), (Object)this.graph.eval("g.E().has(\"_e\", 1).next()", false));
        Assertions.assertEquals((Object)2, (Object)this.graph.eval("1 + 1", false));
        Assertions.assertEquals((Object)true, (Object)this.graph.eval("g.V().map{t -> t.get()}.hasNext()", false));
        Assertions.assertEquals((Object)(vertexCount + 1L), (Object)this.graph.eval("g.addV().next();g.V().count().next()", true));
        if (!this.features.hasLocking()) {
            this.graph.eval("g2 = g.getGraph().traversal(); g2.V().drop().iterate(); g2.tx().commit();", false);
            Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).hasNext());
        }
    }

    @Test
    public void shouldSkipDBCacheAccess() {
        if (!this.features.isDistributed()) {
            return;
        }
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]), 0, JanusGraphTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0L, JanusGraphTest.option(GraphDatabaseConfiguration.BASIC_METRICS, new String[0]), true, JanusGraphTest.option(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]), false);
        String groupName = "shouldSkipDBCacheAccess";
        String edgeStoreMetricsName = "edgestore.cache";
        JanusGraphTransaction tx = this.graph.buildTransaction().start();
        Object vertexId = ((Vertex)tx.traversal().addV().property((Object)"name", (Object)"testProp", new Object[0]).next()).id();
        tx.commit();
        long cacheRetrievalCountAfterCreation = MetricManager.INSTANCE.getCounter(groupName, new String[]{edgeStoreMetricsName, CacheMetricsAction.RETRIEVAL.getName()}).getCount();
        tx = this.graph.buildTransaction().groupName(groupName).start();
        tx.traversal().V(new Object[]{vertexId}).valueMap(new String[0]).next();
        long cacheRetrievalCountAfterReadWithCacheEnabled = MetricManager.INSTANCE.getCounter(groupName, new String[]{edgeStoreMetricsName, CacheMetricsAction.RETRIEVAL.getName()}).getCount();
        tx.rollback();
        Assertions.assertTrue((cacheRetrievalCountAfterCreation < cacheRetrievalCountAfterReadWithCacheEnabled ? 1 : 0) != 0);
        tx = this.graph.buildTransaction().skipDBCacheRead().groupName(groupName).start();
        tx.traversal().V(new Object[]{vertexId}).valueMap(new String[0]).next();
        long cacheRetrievalCountAfterReadWithCacheDisabled = MetricManager.INSTANCE.getCounter(groupName, new String[]{edgeStoreMetricsName, CacheMetricsAction.RETRIEVAL.getName()}).getCount();
        tx.rollback();
        Assertions.assertEquals((long)cacheRetrievalCountAfterReadWithCacheEnabled, (long)cacheRetrievalCountAfterReadWithCacheDisabled);
    }

    @Test
    public void testVertexPropertiesForceInvalidationFromDBCache() {
        if (this.features.hasLocking() || !this.features.isDistributed()) {
            return;
        }
        StandardJanusGraph graph1 = this.openInstanceWithDBCacheEnabled("testVertexPropertiesForceInvalidationFromDBCache1");
        StandardJanusGraph graph2 = this.openInstanceWithDBCacheEnabled("testVertexPropertiesForceInvalidationFromDBCache2");
        JanusGraphVertex v1 = graph1.addVertex(new Object[0]);
        v1.property("name", (Object)"vertex1");
        JanusGraphVertex v2 = graph1.addVertex(new Object[0]);
        v2.property("name", (Object)"vertex2");
        JanusGraphVertex v3 = graph1.addVertex(new Object[0]);
        v3.property("name", (Object)"vertex3");
        graph1.tx().commit();
        JanusGraphTransaction tx1 = graph1.newTransaction();
        tx1.traversal().V(new Object[0]).valueMap(new String[0]).toList();
        tx1.commit();
        JanusGraphTransaction tx2 = graph2.newTransaction();
        tx2.traversal().V(new Object[0]).valueMap(new String[0]).toList();
        tx2.commit();
        tx1 = graph1.newTransaction();
        tx1.traversal().V(new Object[]{v1.id()}).property((Object)"name", (Object)"vertex1_updated", new Object[0]).iterate();
        tx1.traversal().V(new Object[]{v2.id()}).property((Object)"name", (Object)"vertex2_updated", new Object[0]).iterate();
        tx1.traversal().V(new Object[]{v3.id()}).property((Object)"name", (Object)"vertex3_updated", new Object[0]).iterate();
        tx1.commit();
        tx2 = graph2.newTransaction();
        Assertions.assertEquals(Arrays.asList("vertex1"), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get("name"));
        Assertions.assertEquals(Arrays.asList("vertex2"), ((Map)tx2.traversal().V(new Object[]{v2.id()}).valueMap(new String[0]).next()).get("name"));
        Assertions.assertEquals(Arrays.asList("vertex3"), ((Map)tx2.traversal().V(new Object[]{v3.id()}).valueMap(new String[0]).next()).get("name"));
        tx2.rollback();
        graph2.getDBCacheInvalidationService().forceInvalidateVertexInEdgeStoreCache(v1.id());
        tx2 = graph2.newTransaction();
        Assertions.assertEquals(Arrays.asList("vertex1_updated"), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get("name"));
        Assertions.assertEquals(Arrays.asList("vertex2"), ((Map)tx2.traversal().V(new Object[]{v2.id()}).valueMap(new String[0]).next()).get("name"));
        Assertions.assertEquals(Arrays.asList("vertex3"), ((Map)tx2.traversal().V(new Object[]{v3.id()}).valueMap(new String[0]).next()).get("name"));
        tx2.rollback();
        graph2.getDBCacheInvalidationService().forceInvalidateVerticesInEdgeStoreCache(Arrays.asList(v2.id(), v3.id()));
        tx2 = graph2.newTransaction();
        Assertions.assertEquals(Arrays.asList("vertex1_updated"), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get("name"));
        Assertions.assertEquals(Arrays.asList("vertex2_updated"), ((Map)tx2.traversal().V(new Object[]{v2.id()}).valueMap(new String[0]).next()).get("name"));
        Assertions.assertEquals(Arrays.asList("vertex3_updated"), ((Map)tx2.traversal().V(new Object[]{v3.id()}).valueMap(new String[0]).next()).get("name"));
        tx2.rollback();
        graph1.close();
        graph2.close();
    }

    @Test
    public void testIndexStoreForceInvalidationFromDBCache() throws InterruptedException, ExecutionException {
        if (this.features.hasLocking() || !this.features.isDistributed()) {
            return;
        }
        String indexProp1Name = "indexedProp1";
        String indexProp2Name = "indexedProp2";
        String index1Name = "index1";
        String index2Name = "index2";
        PropertyKey indexedProp1 = this.mgmt.makePropertyKey(indexProp1Name).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey indexedProp2 = this.mgmt.makePropertyKey(indexProp2Name).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(index1Name, Vertex.class).addKey(indexedProp1).buildCompositeIndex();
        this.mgmt.buildIndex(index2Name, Vertex.class).addKey(indexedProp1).addKey(indexedProp2).buildCompositeIndex();
        this.finishSchema();
        ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)index1Name).call();
        ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)index2Name).call();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(index1Name), SchemaAction.REINDEX).get();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(index2Name), SchemaAction.REINDEX).get();
        this.finishSchema();
        StandardJanusGraph graph1 = this.openInstanceWithDBCacheEnabled("testIndexStoreForceInvalidationFromDBCache1");
        StandardJanusGraph graph2 = this.openInstanceWithDBCacheEnabled("testIndexStoreForceInvalidationFromDBCache2");
        JanusGraphVertex v1 = graph1.addVertex(new Object[0]);
        v1.property(indexProp1Name, (Object)1);
        v1.property(indexProp2Name, (Object)1);
        JanusGraphVertex v2 = graph1.addVertex(new Object[0]);
        v2.property(indexProp1Name, (Object)2);
        v2.property(indexProp2Name, (Object)2);
        JanusGraphVertex v3 = graph1.addVertex(new Object[0]);
        v3.property(indexProp1Name, (Object)3);
        v3.property(indexProp2Name, (Object)3);
        graph1.tx().commit();
        JanusGraphTransaction tx2 = graph2.newTransaction();
        this.queryVertices(tx2, indexProp1Name, 1, 2, 3, -1, -2, -3);
        this.queryVertices(tx2, indexProp1Name, Arrays.asList(1, 2, 3, -1, -2, -3), indexProp2Name, Arrays.asList(1, 2, 3));
        tx2.commit();
        JanusGraphTransaction tx1 = graph1.newTransaction();
        tx1.traversal().V(new Object[]{v1.id()}).property((Object)indexProp1Name, (Object)-1, new Object[0]).iterate();
        tx1.traversal().V(new Object[]{v2.id()}).property((Object)indexProp1Name, (Object)-2, new Object[0]).iterate();
        tx1.traversal().V(new Object[]{v3.id()}).property((Object)indexProp1Name, (Object)-3, new Object[0]).iterate();
        tx1.commit();
        tx2 = graph2.newTransaction();
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)3).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).has(indexProp2Name, (Object)1).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).has(indexProp2Name, (Object)2).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)3).has(indexProp2Name, (Object)3).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-2).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-3).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).has(indexProp2Name, (Object)1).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-2).has(indexProp2Name, (Object)2).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-3).has(indexProp2Name, (Object)3).hasNext());
        tx2.rollback();
        this.invalidateUpdatedVertexProperty(graph2, v1.id(), indexProp1Name, 1, -1);
        tx2 = graph2.newTransaction();
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)3).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-2).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-3).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).has(indexProp2Name, (Object)1).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).has(indexProp2Name, (Object)1).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).has(indexProp2Name, (Object)2).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-2).has(indexProp2Name, (Object)2).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)3).has(indexProp2Name, (Object)3).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-3).has(indexProp2Name, (Object)3).hasNext());
        tx2.rollback();
        this.invalidateUpdatedVertexProperty(graph2, v2.id(), indexProp1Name, 2, -2);
        this.invalidateUpdatedVertexProperty(graph2, v3.id(), indexProp1Name, 3, -3);
        tx2 = graph2.newTransaction();
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)3).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-2).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-3).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).has(indexProp2Name, (Object)1).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).has(indexProp2Name, (Object)1).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).has(indexProp2Name, (Object)2).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-2).has(indexProp2Name, (Object)2).hasNext());
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)3).has(indexProp2Name, (Object)3).hasNext());
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-3).has(indexProp2Name, (Object)3).hasNext());
        graph1.close();
        graph2.close();
    }

    @Test
    public void testIndexWithIndexOnlyConstraintForceInvalidationFromDBCache() throws InterruptedException, ExecutionException {
        if (this.features.hasLocking() || !this.features.isDistributed()) {
            return;
        }
        String indexPropName = "indexedProp";
        String vertexLabelName = "vertexLabelForIndexOnlyConstraint";
        String indexName = "indexWithIndexOnlyConstraint";
        PropertyKey indexedProp = this.mgmt.makePropertyKey(indexPropName).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        VertexLabel vertexLabel = this.mgmt.makeVertexLabel(vertexLabelName).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(indexedProp).indexOnly((JanusGraphSchemaType)vertexLabel).buildCompositeIndex();
        this.finishSchema();
        ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).call();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.REINDEX).get();
        this.finishSchema();
        StandardJanusGraph graph1 = this.openInstanceWithDBCacheEnabled("testIndexWithIndexOnlyConstraintForceInvalidationFromDBCache1");
        StandardJanusGraph graph2 = this.openInstanceWithDBCacheEnabled("testIndexWithIndexOnlyConstraintForceInvalidationFromDBCache2");
        JanusGraphVertex v1 = graph1.addVertex(vertexLabelName);
        v1.property(indexPropName, (Object)1);
        graph1.tx().commit();
        JanusGraphTransaction tx2 = graph2.newTransaction();
        Assertions.assertEquals((long)1L, (Long)((Long)tx2.traversal().V(new Object[0]).hasLabel(vertexLabelName, new String[0]).has(indexPropName, (Object)1).count().next()));
        tx2.commit();
        JanusGraphTransaction tx1 = graph1.newTransaction();
        tx1.traversal().V(new Object[]{v1.id()}).drop().iterate();
        tx1.commit();
        tx2 = graph2.newTransaction();
        Assertions.assertEquals((long)1L, (Long)((Long)tx2.traversal().V(new Object[0]).hasLabel(vertexLabelName, new String[0]).has(indexPropName, (Object)1).count().next()));
        this.invalidateUpdatedVertexProperty(graph2, v1.id(), indexPropName, 1, -1, true);
        tx2.rollback();
        tx2 = graph2.newTransaction();
        Assertions.assertEquals((long)1L, (Long)((Long)tx2.traversal().V(new Object[0]).hasLabel(vertexLabelName, new String[0]).has(indexPropName, (Object)1).count().next()));
        tx2.rollback();
        tx2 = graph2.newTransaction();
        this.invalidateUpdatedVertexProperty(graph2, v1.id(), indexPropName, 1, -1, false);
        tx2.commit();
        tx2 = graph2.newTransaction();
        Assertions.assertEquals((long)0L, (Long)((Long)tx2.traversal().V(new Object[0]).hasLabel(vertexLabelName, new String[0]).has(indexPropName, (Object)1).count().next()));
        tx2.rollback();
        graph1.close();
        graph2.close();
    }

    @Test
    public void testFullDBCacheInvalidation() throws InterruptedException, ExecutionException {
        if (this.features.hasLocking() || !this.features.isDistributed()) {
            return;
        }
        String indexProp1Name = "someProp1";
        String index1Name = "someIndex1";
        PropertyKey indexedProp1 = this.mgmt.makePropertyKey(indexProp1Name).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(index1Name, Vertex.class).addKey(indexedProp1).buildCompositeIndex();
        this.finishSchema();
        ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)index1Name).call();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(index1Name), SchemaAction.REINDEX).get();
        this.finishSchema();
        StandardJanusGraph graph1 = this.openInstanceWithDBCacheEnabled("testIndexStoreForceInvalidationFromDBCache1");
        StandardJanusGraph graph2 = this.openInstanceWithDBCacheEnabled("testIndexStoreForceInvalidationFromDBCache2");
        JanusGraphVertex v1 = graph1.addVertex(new Object[0]);
        v1.property(indexProp1Name, (Object)1);
        graph1.tx().commit();
        JanusGraphTransaction tx2 = graph2.newTransaction();
        tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next();
        tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).toList();
        tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).toList();
        tx2.commit();
        JanusGraphTransaction tx1 = graph1.newTransaction();
        tx1.traversal().V(new Object[]{v1.id()}).property((Object)indexProp1Name, (Object)-1, new Object[0]).iterate();
        tx1.commit();
        tx2 = graph2.newTransaction();
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).hasNext());
        Assertions.assertEquals(Arrays.asList(1), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get(indexProp1Name));
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        tx2.rollback();
        graph2.getDBCacheInvalidationService().clearEdgeStoreCache();
        tx2 = graph2.newTransaction();
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).hasNext());
        Assertions.assertEquals(Arrays.asList(-1), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get(indexProp1Name));
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        tx2.rollback();
        graph2.getDBCacheInvalidationService().clearIndexStoreCache();
        tx2 = graph2.newTransaction();
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)1).hasNext());
        Assertions.assertEquals(Arrays.asList(-1), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get(indexProp1Name));
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        tx2.rollback();
        tx2 = graph2.newTransaction();
        tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next();
        tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).toList();
        tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).toList();
        tx2.commit();
        tx1 = graph1.newTransaction();
        tx1.traversal().V(new Object[]{v1.id()}).property((Object)indexProp1Name, (Object)2, new Object[0]).iterate();
        tx1.commit();
        tx2 = graph2.newTransaction();
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).hasNext());
        Assertions.assertEquals(Arrays.asList(-1), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get(indexProp1Name));
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        tx2.rollback();
        graph2.getDBCacheInvalidationService().clearDBCache();
        tx2 = graph2.newTransaction();
        Assertions.assertTrue((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)2).hasNext());
        Assertions.assertEquals(Arrays.asList(2), ((Map)tx2.traversal().V(new Object[]{v1.id()}).valueMap(new String[0]).next()).get(indexProp1Name));
        Assertions.assertFalse((boolean)tx2.traversal().V(new Object[0]).has(indexProp1Name, (Object)-1).hasNext());
        tx2.rollback();
        graph1.close();
        graph2.close();
    }

    @Test
    public void testMultiQueryDropsVertices() {
        this.mgmt.makePropertyKey("id").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey nameProp = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makePropertyKey("details").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("nameIndex", Vertex.class).addKey(nameProp).buildCompositeIndex();
        this.finishSchema();
        int verticesAmount = 42;
        for (int i = 0; i < verticesAmount; ++i) {
            JanusGraphVertex vertex = this.tx.addVertex(new Object[]{"id", i});
            vertex.property("name", (Object)"name_test");
            vertex.property("details", (Object)("details_" + i));
        }
        this.clopen(new Object[0]);
        List vertices = this.tx.traversal().V(new Object[0]).has("name", (Object)"name_test").toList().stream().map(v -> (JanusGraphVertex)v).collect(Collectors.toList());
        int actualCount = this.tx.multiQuery(vertices).drop();
        this.clopen(new Object[0]);
        Assertions.assertEquals((int)verticesAmount, (int)actualCount);
        int afterDropCount = this.tx.traversal().V(new Object[0]).has("name", (Object)"name_test").toList().size();
        Assertions.assertEquals((int)0, (int)afterDropCount);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testParallelBackendOps(boolean parallelBackendOpsEnabled) {
        this.clopen(JanusGraphTest.option(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS, new String[0]), parallelBackendOpsEnabled);
        int verticesPerLevel = 10;
        ArrayList<JanusGraphVertex> firstLevelVertices = new ArrayList<JanusGraphVertex>(verticesPerLevel);
        for (int i = 0; i < verticesPerLevel; ++i) {
            firstLevelVertices.add(this.tx.addVertex(new Object[0]));
        }
        for (Vertex vertex : firstLevelVertices) {
            JanusGraphVertex secondLevelVertex = this.tx.addVertex(new Object[0]);
            vertex.addEdge("knows", (Vertex)secondLevelVertex, new Object[0]);
        }
        this.tx.commit();
        Assertions.assertEquals((long)verticesPerLevel, (Long)((Long)this.graph.traversal().V(new Object[]{firstLevelVertices}).out(new String[]{"knows"}).count().next()));
    }

    private void invalidateUpdatedVertexProperty(StandardJanusGraph graph, Object vertexIdUpdated, String propertyNameUpdated, Object previousPropertyValue, Object newPropertyValue) {
        this.invalidateUpdatedVertexProperty(graph, vertexIdUpdated, propertyNameUpdated, previousPropertyValue, newPropertyValue, true);
    }

    private void invalidateUpdatedVertexProperty(StandardJanusGraph graph, Object vertexIdUpdated, String propertyNameUpdated, Object previousPropertyValue, Object newPropertyValue, boolean withIndexConstraintsFilter) {
        JanusGraphTransaction tx = graph.newTransaction();
        JanusGraphManagement graphMgmt = graph.openManagement();
        PropertyKey propertyKey = graphMgmt.getPropertyKey(propertyNameUpdated);
        CacheVertex cacheVertex = new CacheVertex((StandardJanusGraphTx)tx, vertexIdUpdated, 2);
        StandardVertexProperty propertyPreviousVal = new StandardVertexProperty(propertyKey.longId(), propertyKey, (InternalVertex)cacheVertex, previousPropertyValue, 6);
        StandardVertexProperty propertyNewVal = new StandardVertexProperty(propertyKey.longId(), propertyKey, (InternalVertex)cacheVertex, newPropertyValue, 1);
        IndexSerializer indexSerializer = graph.getIndexSerializer();
        Collection indexUpdates = withIndexConstraintsFilter ? indexSerializer.getIndexUpdates((InternalVertex)cacheVertex, Arrays.asList(propertyPreviousVal, propertyNewVal)) : indexSerializer.getIndexUpdatesNoConstraints((InternalVertex)cacheVertex, Arrays.asList(propertyPreviousVal, propertyNewVal));
        CacheInvalidationService invalidationService = graph.getDBCacheInvalidationService();
        for (IndexUpdate indexUpdate : indexUpdates) {
            StaticBuffer keyToInvalidate = (StaticBuffer)indexUpdate.getKey();
            invalidationService.markKeyAsExpiredInIndexStore(keyToInvalidate);
        }
        invalidationService.forceClearExpiredKeysInIndexStoreCache();
        invalidationService.forceInvalidateVertexInEdgeStoreCache(vertexIdUpdated);
        graphMgmt.rollback();
        tx.rollback();
    }

    private void queryVertices(JanusGraphTransaction tx, String propName, Object ... values) {
        for (Object value : values) {
            tx.traversal().V(new Object[0]).has(propName, value).toList();
        }
    }

    private void queryVertices(JanusGraphTransaction tx, String prop1Name, Iterable<Object> prop1Values, String prop2Name, Iterable<Object> prop2Values) {
        for (Object prop1Value : prop1Values) {
            for (Object prop2Value : prop2Values) {
                tx.traversal().V(new Object[0]).has(prop1Name, prop1Value).has(prop2Name, prop2Value).toList();
                tx.traversal().V(new Object[0]).has(prop2Name, prop2Value).has(prop1Name, prop1Value).toList();
            }
        }
    }

    private StandardJanusGraph openInstanceWithDBCacheEnabled(String uniqueInstanceId) {
        WriteConfiguration configCopy = this.config.copy();
        configCopy.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (String[])new String[0]), (Object)uniqueInstanceId);
        configCopy.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.REPLACE_INSTANCE_IF_EXISTS, (String[])new String[0]), (Object)true);
        configCopy.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.DB_CACHE, (String[])new String[0]), (Object)true);
        configCopy.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.DB_CACHE_TIME, (String[])new String[0]), (Object)0);
        configCopy.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.STORAGE_BATCH, (String[])new String[0]), (Object)false);
        return (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)configCopy);
    }

    private GraphTraversal<Vertex, Vertex> getV(String propertyName1, Object value1, String propertyName2, Object value2, String vertexLabel) {
        GraphTraversal traversal = this.tx.traversal().V(new Object[0]);
        if (vertexLabel != null) {
            traversal = traversal.hasLabel(vertexLabel, new String[0]);
        }
        return traversal.has(propertyName1, value1).has(propertyName2, value2);
    }

    private static interface TransactionJob {
        public void run(JanusGraphTransaction var1);
    }

    public static interface Equals<T> {
        public boolean verifyValue(T var1);
    }
}

