/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphConfigurationException;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.RelationTypeIndex;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.management.RelationIndexStatusWatcher;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.olap.job.GhostVertexRemover;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.io.TempDir;

public abstract class JanusGraphCustomIdTest
extends JanusGraphBaseTest {
    @Override
    public WriteConfiguration getConfiguration() {
        return this.getModifiableConfiguration().getConfiguration();
    }

    protected abstract ModifiableConfiguration getModifiableConfiguration();

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
        this.config = this.getConfiguration();
        TestGraphConfigs.applyOverrides(this.config);
        Preconditions.checkNotNull((Object)this.config);
        this.logManagers = new HashMap();
        JanusGraphCustomIdTest.clearGraph(this.config);
        this.readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config, BasicConfiguration.Restriction.NONE);
    }

    private void open(Boolean allowSettingVertexId, Boolean allowCustomVertexIdType) {
        ModifiableConfiguration config = this.getModifiableConfiguration();
        if (allowSettingVertexId != null) {
            config.set(GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, (Object)allowSettingVertexId, new String[0]);
        }
        if (allowCustomVertexIdType != null) {
            config.set(GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (Object)allowCustomVertexIdType, new String[0]);
        }
        this.open(config.getConfiguration());
    }

    @Test
    public void testConfig() {
        Exception ex = (Exception)Assertions.assertThrows(JanusGraphConfigurationException.class, () -> this.open(false, true));
        Assertions.assertEquals((Object)"allow-custom-vid-types is enabled but set-vertex-id is disabled", (Object)ex.getMessage());
    }

    @Test
    public void testBasic() {
        this.open(true, true);
        Exception ex = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.graph.addVertex(new Object[0]));
        Assertions.assertEquals((Object)"Must provide vertex id", (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.graph.addVertex(new Object[]{T.id, "id\u2122"}));
        Assertions.assertEquals((Object)"Custom string id contains non-ascii or non-printable character: id\u2122", (Object)ex.getMessage());
        ex = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.graph.addVertex(new Object[]{T.id, "custom-vertex"}));
        Assertions.assertEquals((Object)"Custom string id contains reserved string (-): custom-vertex", (Object)ex.getMessage());
        ArrayList<String> vids = new ArrayList<String>();
        for (int i = 1; i < 100; ++i) {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                builder.append((char)(97 + j % 26));
            }
            String vid = builder.toString();
            vids.add(vid);
            this.graph.addVertex(new Object[]{T.id, vid, T.label, "person", "age", i});
        }
        this.graph.tx().commit();
        List resultIds = this.graph.traversal().V(new Object[0]).id().toList();
        Assertions.assertEquals(new HashSet(vids), new HashSet(resultIds));
    }

    @Test
    public void testUpgrade() {
        this.open(false, false);
        this.graph.traversal().addV().property((Object)"prop", (Object)"val", new Object[0]).next();
        this.graph.tx().commit();
        this.graph.close();
        this.open(null, null);
        JanusGraphManagement mgmt = this.graph.openManagement();
        mgmt.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, (String[])new String[0]), (Object)true);
        mgmt.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (String[])new String[0]), (Object)true);
        mgmt.commit();
        this.open(null, null);
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
        this.graph.traversal().addV().property((Object)T.id, (Object)"custom_id_1", new Object[0]).property((Object)"prop", (Object)"val", new Object[0]).next();
        Assertions.assertThrows(Exception.class, () -> {
            Vertex cfr_ignored_0 = (Vertex)this.graph.traversal().addV().next();
        });
        this.graph.traversal().addV().property((Object)T.id, (Object)this.graph.getIDManager().toVertexId(123L), new Object[0]).property((Object)"prop", (Object)"val", new Object[0]).next();
        this.graph.tx().commit();
        Assertions.assertEquals((int)3, (int)this.graph.traversal().V(new Object[0]).toList().size());
        Assertions.assertEquals((long)3L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("prop", (Object)"val").count().next()));
    }

    @Test
    public void testEnableAndDisableStringId() {
        this.open(true, true);
        this.graph.addVertex(new Object[]{T.id, "s_vid_a"});
        this.graph.tx().commit();
        this.graph.close();
        this.open(null, null);
        JanusGraphManagement mgmt = this.graph.openManagement();
        mgmt.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (String[])new String[0]), (Object)false);
        mgmt.commit();
        this.open(null, null);
        Exception ex = (Exception)Assertions.assertThrows(UnsupportedOperationException.class, () -> this.graph.addVertex(new Object[]{T.id, "s_vid_b"}));
        Assertions.assertEquals((Object)"Vertex does not support user supplied identifiers of this type", (Object)ex.getMessage());
        this.graph.addVertex(new Object[]{T.id, this.graph.getIDManager().toVertexId(1L)});
        this.graph.tx().commit();
        this.graph.close();
        this.open(null, null);
        mgmt = this.graph.openManagement();
        mgmt.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, (String[])new String[0]), (Object)false);
        mgmt.commit();
        this.open(null, null);
        this.graph.addVertex(new Object[0]);
        this.graph.tx().commit();
        Assertions.assertEquals((long)3L, (Long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
    }

    @Test
    public void testInvalidCustomLongVertexId() {
        this.open(true, true);
        Exception ex = (Exception)Assertions.assertThrows(IllegalArgumentException.class, () -> this.graph.addVertex(new Object[]{T.id, 1}));
        Assertions.assertEquals((Object)"Not a valid vertex id: 1", (Object)ex.getMessage());
        this.graph.addVertex(new Object[]{T.id, this.graph.getIDManager().toVertexId(1L)});
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).hasId((Object)1, new Object[0]).hasNext());
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).hasId((Object)this.graph.getIDManager().toVertexId(1L), new Object[0]).hasNext());
        Assertions.assertEquals((long)1L, (long)this.graph.getIDManager().fromVertexId(((Long)this.graph.traversal().V(new Object[0]).id().next()).longValue()));
        this.graph.addVertex(new Object[]{T.id, "1"});
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).hasId((Object)"1", new Object[0]).hasNext());
    }

    @Test
    public void testSpecialLengthHandling() {
        this.open(true, true);
        this.graph.traversal().addV().property((Object)T.id, (Object)"abcdefg", new Object[0]).next();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[]{"abcdefg"}).hasNext());
        this.graph.traversal().addV().property((Object)T.id, (Object)"abcdefgh", new Object[0]).next();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[]{"abcdefgh"}).hasNext());
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[]{"abcdefg"}).hasNext());
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[]{"abcdefgh"}).hasNext());
    }

    @Test
    public void testMixedStringAndLongVertexId() {
        this.open(true, true);
        ArrayList<Object> vids = new ArrayList<Object>();
        for (int i = 1; i < 100; ++i) {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                builder.append((char)(97 + j % 26));
            }
            Object vid = builder.toString();
            Assertions.assertEquals((int)i, (int)vid.toString().length());
            vids.add(vid);
            this.graph.addVertex(new Object[]{T.id, vid});
            vid = this.graph.getIDManager().toVertexId((long)i);
            vids.add(vid);
            this.graph.addVertex(new Object[]{T.id, vid});
        }
        this.graph.tx().commit();
        List resultIds = this.graph.traversal().V(new Object[0]).id().toList();
        Assertions.assertEquals(new HashSet(vids), new HashSet(resultIds));
    }

    @Test
    public void testBasicIndexLookUp() {
        this.open(true, true);
        PropertyKey key = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("nameKey", Vertex.class).addKey(key).buildCompositeIndex();
        this.finishSchema();
        this.tx.addVertex(new Object[]{T.id, "vid_alice", "name", "alice"});
        this.tx.addVertex(new Object[]{T.id, "vid_bob", "name", "bob"});
        this.newTx();
        Assertions.assertEquals((Object)"vid_alice", (Object)((Vertex)this.graph.traversal().V(new Object[0]).has("name", (Object)"alice").next()).id());
        Assertions.assertEquals((Object)"vid_alice", (Object)this.graph.traversal().V(new Object[0]).has("name", (Object)"alice").id().next());
        Assertions.assertEquals((Object)"alice", (Object)this.graph.traversal().V(new Object[0]).has("name", (Object)"alice").values(new String[]{"name"}).next());
        Assertions.assertEquals((Object)"alice", (Object)((Vertex)this.graph.traversal().V(new Object[0]).has("name", (Object)"alice").next()).value("name"));
    }

    @RepeatedIfExceptionsTest(repeats=3)
    public void testIndexUpdatesWithReindexAndRemove() throws ExecutionException, InterruptedException {
        JanusGraphVertex o;
        int i;
        ModifiableConfiguration config = this.getModifiableConfiguration();
        config.set(GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, (Object)true, new String[0]);
        config.set(GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (Object)true, new String[0]);
        config.set(GraphDatabaseConfiguration.LOG_SEND_DELAY, (Object)Duration.ofMillis(0L), new String[]{"janusgraph"});
        config.set(KCVSLog.LOG_READ_LAG_TIME, (Object)Duration.ofMillis(50L), new String[]{"janusgraph"});
        config.set(GraphDatabaseConfiguration.LOG_READ_INTERVAL, (Object)Duration.ofMillis(250L), new String[]{"janusgraph"});
        this.open(config.getConfiguration());
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        PropertyKey sensor = this.mgmt.makePropertyKey("sensor").dataType(Double.class).cardinality(Cardinality.LIST).make();
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{T.id, "first_vertex"});
        for (i = 0; i < 10; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[]{T.id, "vertex_" + i});
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.newTx();
        v = JanusGraphCustomIdTest.getV((Transaction)this.tx, v);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, new String[0]);
        this.newTx();
        this.finishSchema();
        sensor = this.mgmt.getPropertyKey("sensor");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        friend = this.mgmt.getEdgeLabel("friend");
        this.mgmt.buildPropertyIndex(sensor, "byTime", org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, org.apache.tinkerpop.gremlin.process.traversal.Order.desc, new PropertyKey[]{time});
        this.mgmt.buildIndex("bySensorReading", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        this.newTx();
        v = JanusGraphCustomIdTest.getV((Transaction)this.tx, v);
        for (i = 100; i < 110; ++i) {
            v.property("sensor", (Object)i, new Object[]{"time", i});
            v.property("name", (Object)("v" + i));
            o = this.tx.addVertex(new Object[]{T.id, "vertex_" + i});
            v.addEdge("friend", (Vertex)o, new Object[]{"time", i});
        }
        this.tx.commit();
        RelationTypeIndex pindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        RelationTypeIndex eindex = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        JanusGraphIndex graphIndex = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)pindex, SchemaAction.ENABLE_INDEX));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)eindex, SchemaAction.ENABLE_INDEX));
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.mgmt.updateIndex((Index)graphIndex, SchemaAction.ENABLE_INDEX));
        this.mgmt.commit();
        ManagementUtil.awaitVertexIndexUpdate((JanusGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        RelationTypeIndex pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        RelationTypeIndex eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        JanusGraphIndex graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)eindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.REGISTERED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.finishSchema();
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        this.mgmt.updateIndex((Index)eindex2, SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        Assertions.assertTrue((boolean)((RelationIndexStatusWatcher)((RelationIndexStatusWatcher)ManagementSystem.awaitRelationIndexStatus((JanusGraph)this.graph, (String)"byTime", (String)"friend").status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        ScanMetrics reindexSensorByTime = (ScanMetrics)this.mgmt.updateIndex((Index)pindex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics reindexBySensorReading = (ScanMetrics)this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assertions.assertNotEquals((long)0L, (long)reindexSensorByTime.getCustom("adds"));
        Assertions.assertNotEquals((long)0L, (long)reindexBySensorReading.getCustom("adds"));
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)eindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.newTx();
        v = JanusGraphCustomIdTest.getV((Transaction)this.tx, v);
        for (int i2 = 200; i2 < 210; ++i2) {
            v.property("sensor", (Object)i2, new Object[]{"time", i2});
            v.property("name", (Object)("v" + i2));
            JanusGraphVertex o2 = this.tx.addVertex(new Object[]{T.id, "vertex_" + i2});
            v.addEdge("friend", (Vertex)o2, new Object[]{"time", i2});
        }
        this.newTx();
        v = JanusGraphCustomIdTest.getV((Transaction)this.tx, v);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 0, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        this.finishSchema();
        eindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime");
        ScanMetrics reindexFriendByTime = (ScanMetrics)this.mgmt.updateIndex((Index)eindex2, SchemaAction.REINDEX).get();
        this.finishSchema();
        Assertions.assertNotEquals((long)0L, (long)reindexFriendByTime.getCustom("adds"));
        this.finishSchema();
        this.newTx();
        v = JanusGraphCustomIdTest.getV((Transaction)this.tx, v);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        this.mgmt.updateIndex((Index)pindex2, SchemaAction.DISABLE_INDEX);
        this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.DISABLE_INDEX);
        this.mgmt.commit();
        this.tx.commit();
        ManagementUtil.awaitVertexIndexUpdate((JanusGraph)this.graph, (String)"byTime", (String)"sensor", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"bySensorReading", (long)5L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)pindex2.getIndexStatus());
        Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)graphIndex2.getIndexStatus(graphIndex2.getFieldKeys()[0]));
        this.finishSchema();
        this.newTx();
        v = JanusGraphCustomIdTest.getV((Transaction)this.tx, v);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphCustomIdTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.tx.commit();
        this.finishSchema();
        pindex2 = this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime");
        graphIndex2 = this.mgmt.getGraphIndex("bySensorReading");
        ScanMetrics pmetrics = (ScanMetrics)this.mgmt.updateIndex((Index)pindex2, SchemaAction.DISCARD_INDEX).get();
        ScanMetrics graphIndexMetrics = (ScanMetrics)this.mgmt.updateIndex((Index)graphIndex2, SchemaAction.DISCARD_INDEX).get();
        this.finishSchema();
        Assertions.assertEquals((long)30L, (long)pmetrics.getCustom("deletes"));
        Assertions.assertEquals((long)30L, (long)graphIndexMetrics.getCustom("deletes"));
    }

    @Test
    public void removeGhostVertices() throws Exception {
        this.open(true, true);
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{T.label, "person", T.id, "person1"});
        v1.property("name", (Object)"stephen");
        JanusGraphVertex v2 = this.tx.addVertex(new Object[]{T.label, "person", T.id, "person2"});
        v1.property("name", (Object)"marko");
        JanusGraphVertex v3 = this.tx.addVertex(new Object[]{T.label, "person", T.id, this.graph.getIDManager().toVertexId(3L)});
        v1.property("name", (Object)"dan");
        v2.addEdge("knows", (Vertex)v3, new Object[0]);
        v1.addEdge("knows", (Vertex)v2, new Object[0]);
        this.newTx();
        Object v3id = JanusGraphCustomIdTest.getId((Element)v3);
        Object v1id = JanusGraphCustomIdTest.getId((Element)v1);
        Assertions.assertTrue((boolean)(v1id instanceof String));
        Assertions.assertTrue(((Long)v3id > 0L ? 1 : 0) != 0);
        v3 = JanusGraphCustomIdTest.getV((Transaction)this.tx, v3id);
        Assertions.assertNotNull((Object)v3);
        v3.remove();
        this.tx.commit();
        JanusGraphTransaction xx = this.graph.buildTransaction().checkExternalVertexExistence(false).start();
        v3 = JanusGraphCustomIdTest.getV((Transaction)xx, v3id);
        Assertions.assertNotNull((Object)v3);
        v1 = JanusGraphCustomIdTest.getV((Transaction)xx, v1id);
        Assertions.assertNotNull((Object)v1);
        v3.property("name", (Object)"deleted");
        v3.addEdge("knows", (Vertex)v1, new Object[0]);
        xx.commit();
        this.newTx();
        Assertions.assertNull((Object)JanusGraphCustomIdTest.getV((Transaction)this.tx, v3id));
        v1 = JanusGraphCustomIdTest.getV((Transaction)this.tx, v1id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertEquals((Object)v3id, (Object)((JanusGraphVertex)v1.query().direction(Direction.IN).labels(new String[]{"knows"}).vertices().iterator().next()).id());
        this.tx.commit();
        this.mgmt.commit();
        ScanMetrics result = this.executeScanJob((ScanJob)new GhostVertexRemover((JanusGraph)this.graph));
        Assertions.assertEquals((long)1L, (long)result.getCustom("removed-vertices"));
        Assertions.assertEquals((long)2L, (long)result.getCustom("removed-relations"));
        Assertions.assertEquals((long)0L, (long)result.getCustom("skipped-ghosts"));
        result = this.executeScanJob((ScanJob)new GhostVertexRemover((JanusGraph)this.graph));
        Assertions.assertEquals((long)0L, (long)result.getCustom("removed-vertices"));
        Assertions.assertEquals((long)0L, (long)result.getCustom("removed-relations"));
        Assertions.assertEquals((long)0L, (long)result.getCustom("skipped-ghosts"));
    }

    @Test
    public void testWriteAndReadWithJanusGraphIoRegistryWithGryo(@TempDir Path tempDir) {
        this.open(true, true);
        Path file = tempDir.resolve("testgraph_" + this.getClass().getCanonicalName() + ".kryo");
        this.testWritingAndReading(file.toFile());
    }

    @Test
    public void testWriteAndReadWithJanusGraphIoRegistryWithGraphson(@TempDir Path tempDir) {
        this.open(true, true);
        Path file = tempDir.resolve("testgraph_" + this.getClass().getCanonicalName() + ".json");
        this.testWritingAndReading(file.toFile());
    }

    private void testWritingAndReading(File f) {
        GraphTraversalSource g = this.graph.traversal();
        Vertex fromV = (Vertex)g.addV().property((Object)"name", (Object)f.getName(), new Object[0]).property((Object)T.id, (Object)"custom_id", new Object[0]).next();
        Vertex toV = (Vertex)g.addV().property((Object)T.id, (Object)"another_vertex", new Object[0]).next();
        g.addE("connect").from(fromV).to(toV).next();
        g.tx().commit();
        Assertions.assertEquals((long)0L, (long)f.length());
        g.io(f.getAbsolutePath()).write().iterate();
        Assertions.assertTrue((f.length() > 0L ? 1 : 0) != 0, (String)("File " + f.getAbsolutePath() + " was expected to be not empty, but is"));
        this.open(true, true);
        g = this.graph.traversal();
        g.V(new Object[0]).drop().iterate();
        g.tx().commit();
        g.io(f.getAbsolutePath()).read().iterate();
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[0]).has("name", (Object)f.getName()).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)g.V(new Object[]{"custom_id"}).count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)g.V(new Object[0]).count().next()));
        Assertions.assertEquals((Object)"connect", (Object)g.E(new Object[0]).label().next());
    }
}

