/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.schema.EdgeLabelMaker;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.testutil.RandomGenerator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Tag(value="PERFORMANCE_TESTS")
public abstract class JanusGraphConcurrentTest
extends JanusGraphBaseTest {
    private static final int THREAD_COUNT = JanusGraphConcurrentTest.getThreadCount();
    private static final int TASK_COUNT = THREAD_COUNT * 256;
    private static final int VERTEX_COUNT = 1000;
    private static final int EDGE_COUNT = 5;
    private static final int REL_COUNT = 5;
    private static final Logger log = LoggerFactory.getLogger(JanusGraphConcurrentTest.class);
    private ExecutorService executor;

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
        this.executor = Executors.newFixedThreadPool(THREAD_COUNT);
    }

    private void initializeGraph() {
        int i;
        for (int i2 = 0; i2 < 5; ++i2) {
            this.makeLabel("rel" + i2);
        }
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.finishSchema();
        Vertex[] vertices = new Vertex[1000];
        for (i = 0; i < 1000; ++i) {
            vertices[i] = this.tx.addVertex(new Object[]{"uid", i});
        }
        for (i = 0; i < 1000; ++i) {
            for (int r = 0; r < 5; ++r) {
                for (int j = 1; j <= 5; ++j) {
                    vertices[i].addEdge("rel" + r, vertices[JanusGraphConcurrentTest.wrapAround(i + j, 1000)], new Object[0]);
                }
            }
        }
        this.clopen(new Object[0]);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
            log.error("Abnormal executor shutdown");
            Thread.dumpStack();
        } else {
            log.debug("Test executor completed normal shutdown");
        }
        super.tearDown();
    }

    @RepeatedTest(value=10)
    public void concurrentTxRead() throws Exception {
        int t;
        int i;
        int numTypes = 20;
        int numThreads = 100;
        for (i = 0; i < 10; ++i) {
            if (i % 4 == 0) {
                this.makeVertexIndexedUniqueKey("test" + i, String.class);
                continue;
            }
            this.makeKey("test" + i, String.class);
        }
        for (i = 10; i < 20; ++i) {
            EdgeLabelMaker tm = this.mgmt.makeEdgeLabel("test" + i);
            if (i % 4 == 1) {
                tm.unidirected();
            }
            tm.make();
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        ExecutorService pool = Executors.newFixedThreadPool(100);
        Future[] futures = new Future[100];
        for (t = 0; t < 100; ++t) {
            futures[t] = pool.submit(() -> {
                JanusGraphTransaction tx = this.graph.newTransaction();
                for (int i = 0; i < 20; ++i) {
                    RelationType type = tx.getRelationType("test" + i);
                    if (i < 10) {
                        Assertions.assertTrue((boolean)type.isPropertyKey());
                        continue;
                    }
                    Assertions.assertTrue((boolean)type.isEdgeLabel());
                }
                tx.commit();
            });
        }
        for (t = 0; t < 100; ++t) {
            futures[t].get();
        }
        pool.shutdown();
    }

    @RepeatedTest(value=10)
    public void concurrentReadsOnSingleTransaction() throws Exception {
        this.initializeGraph();
        PropertyKey id = this.tx.getPropertyKey("uid");
        CountDownLatch startLatch = new CountDownLatch(TASK_COUNT);
        CountDownLatch stopLatch = new CountDownLatch(TASK_COUNT);
        for (int i = 0; i < TASK_COUNT; ++i) {
            int vertexId = RandomGenerator.randomInt(0, 1000);
            EdgeLabel edgeLabel = this.tx.getEdgeLabel("rel" + RandomGenerator.randomInt(0, 5));
            this.executor.execute(new SimpleReader(this.tx, startLatch, stopLatch, vertexId, edgeLabel.name(), 10, id.name()));
            startLatch.countDown();
        }
        stopLatch.await();
    }

    @Test
    public void concurrentReadCommittedOnlyWithScriptEngine() throws Exception {
        int t;
        this.clopen(JanusGraphConcurrentTest.option(GraphDatabaseConfiguration.SCRIPT_EVAL_ENABLED, new String[0]), true);
        this.makeVertexIndexedKey("uid", Integer.class);
        this.finishSchema();
        int verticesPerThread = 10;
        int numThreads = 100;
        Future[] futures = new Future[numThreads];
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads);
        for (t = 0; t < numThreads; ++t) {
            futures[t] = executorService.submit(() -> {
                for (int i = 0; i < verticesPerThread; ++i) {
                    Assertions.assertEquals((Object)0L, (Object)this.graph.eval(String.format("g.V().has('uid', %d).count().next()", i), false));
                    Assertions.assertEquals((long)0L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("uid", (Object)i).count().next()));
                    this.graph.traversal().addV().property((Object)"uid", (Object)i, new Object[0]).next();
                    Assertions.assertEquals((Object)0L, (Object)this.graph.eval(String.format("g.V().has('uid', %d).count().next()", i), false));
                    Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("uid", (Object)i).count().next()));
                }
                Assertions.assertEquals((Object)0L, (Object)this.graph.eval("g.V().count().next()", false));
                Assertions.assertEquals((long)10L, (Long)((Long)this.graph.traversal().V(new Object[0]).count().next()));
            });
        }
        for (t = 0; t < numThreads; ++t) {
            futures[t].get();
        }
    }

    @RepeatedTest(value=10)
    public void concurrentReadWriteOnSingleTransaction() throws Exception {
        this.initializeGraph();
        this.mgmt.getPropertyKey("uid");
        this.makeVertexIndexedUniqueKey("dummyProperty", String.class);
        this.makeLabel("dummyRelationship");
        this.finishSchema();
        PropertyKey id = this.tx.getPropertyKey("uid");
        RandomPropertyMaker propMaker = new RandomPropertyMaker(this.tx, 1000, id.name(), "dummyProperty");
        FixedRelationshipMaker relMaker = new FixedRelationshipMaker(this.tx, id.name(), "dummyRelationship");
        Future<?> propFuture = this.executor.submit(propMaker);
        Future<?> relFuture = this.executor.submit(relMaker);
        CountDownLatch startLatch = new CountDownLatch(TASK_COUNT);
        CountDownLatch stopLatch = new CountDownLatch(TASK_COUNT);
        for (int i = 0; i < TASK_COUNT; ++i) {
            int vertexId = RandomGenerator.randomInt(0, 1000);
            EdgeLabel edgeLabel = this.tx.getEdgeLabel("rel" + RandomGenerator.randomInt(0, 5));
            this.executor.execute(new SimpleReader(this.tx, startLatch, stopLatch, vertexId, edgeLabel.name(), 10, id.name()));
            startLatch.countDown();
        }
        stopLatch.await();
        propFuture.cancel(true);
        relFuture.cancel(true);
    }

    @RepeatedTest(value=10)
    public void concurrentIndexReadWriteTest() throws Exception {
        this.clopen(JanusGraphConcurrentTest.option(GraphDatabaseConfiguration.ADJUST_LIMIT, new String[0]), false);
        PropertyKey k = this.mgmt.makePropertyKey("k").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makePropertyKey("q").dataType(Long.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("byK", Vertex.class).addKey(k).buildCompositeIndex();
        this.finishSchema();
        AtomicBoolean run = new AtomicBoolean(true);
        int batchV = 10;
        int batchR = 10;
        int maxK = 5;
        int maxQ = 2;
        Random random = new Random();
        AtomicInteger duplicates = new AtomicInteger(0);
        Thread writer = new Thread(() -> {
            while (run.get()) {
                JanusGraphTransaction tx = this.graph.newTransaction();
                try {
                    for (int i = 0; i < 10; ++i) {
                        JanusGraphVertex v = tx.addVertex(new Object[0]);
                        v.property("k", (Object)random.nextInt(5));
                        v.property("q", (Object)random.nextInt(2));
                    }
                    tx.commit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    if (!tx.isOpen()) continue;
                    tx.rollback();
                }
            }
        });
        Thread reader = new Thread(() -> {
            while (run.get()) {
                JanusGraphTransaction tx = this.graph.newTransaction();
                try {
                    for (int i = 0; i < 10; ++i) {
                        HashSet<JanusGraphVertex> vs = new HashSet<JanusGraphVertex>();
                        Iterable vertices = tx.query().has("k", (Object)random.nextInt(5)).has("q", (Object)random.nextInt(2)).vertices();
                        for (JanusGraphVertex v : vertices) {
                            if (vs.add(v)) continue;
                            duplicates.incrementAndGet();
                            System.err.println("Duplicate vertex: " + v);
                        }
                    }
                    tx.commit();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                finally {
                    if (!tx.isOpen()) continue;
                    tx.rollback();
                }
            }
        });
        writer.start();
        reader.start();
        Thread.sleep(10000L);
        run.set(false);
        writer.join();
        reader.join();
        Assertions.assertEquals((int)0, (int)duplicates.get());
    }

    @RepeatedTest(value=10)
    public void testStandardIndexVertexPropertyReads() throws InterruptedException, ExecutionException {
        this.testStandardIndexVertexPropertyReadsLogic();
    }

    protected void testStandardIndexVertexPropertyReadsLogic() throws InterruptedException, ExecutionException {
        int i;
        int propCount = THREAD_COUNT * 5;
        int vertexCount = 1000;
        log.info("Creating types");
        for (i = 0; i < propCount; ++i) {
            this.makeVertexIndexedUniqueKey("p" + i, String.class);
        }
        this.finishSchema();
        log.info("Creating vertices");
        for (i = 0; i < 1000; ++i) {
            JanusGraphVertex v = this.tx.addVertex(new Object[0]);
            for (int j = 0; j < propCount; ++j) {
                v.property("p" + j, (Object)i);
            }
        }
        this.newTx();
        log.info("Querying vertex property indices");
        ArrayList futures = new ArrayList(TASK_COUNT);
        for (int i2 = 0; i2 < TASK_COUNT; ++i2) {
            futures.add(this.executor.submit(new VertexPropertyQuerier(propCount, 1000)));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private class VertexPropertyQuerier
    implements Runnable {
        private final int propCount;
        private final int vertexCount;

        public VertexPropertyQuerier(int propCount, int vertexCount) {
            this.propCount = propCount;
            this.vertexCount = vertexCount;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.vertexCount; ++i) {
                for (int p = 0; p < this.propCount; ++p) {
                    Iterables.size((Iterable)JanusGraphConcurrentTest.this.tx.query().has("p" + p, (Object)i).vertices());
                }
            }
        }
    }

    private static abstract class BarrierRunnable
    implements Runnable {
        protected final JanusGraphTransaction tx;
        protected final CountDownLatch startLatch;
        protected final CountDownLatch stopLatch;

        public BarrierRunnable(JanusGraphTransaction tx, CountDownLatch startLatch, CountDownLatch stopLatch) {
            this.tx = tx;
            this.startLatch = startLatch;
            this.stopLatch = stopLatch;
        }

        protected abstract void doRun();

        @Override
        public void run() {
            try {
                this.startLatch.await();
            }
            catch (Exception e) {
                throw new RuntimeException("Interrupted while waiting for peers to start");
            }
            try {
                this.doRun();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.stopLatch.countDown();
        }
    }

    private static class SimpleReader
    extends BarrierRunnable {
        private final int vertexId;
        private final String label2Traverse;
        private final long nodeTraversalCount = 256L;
        private final int expectedEdges;
        private final String idKey;

        public SimpleReader(JanusGraphTransaction tx, CountDownLatch startLatch, CountDownLatch stopLatch, int startNodeId, String label2Traverse, int expectedEdges, String idKey) {
            super(tx, startLatch, stopLatch);
            this.vertexId = startNodeId;
            this.label2Traverse = label2Traverse;
            this.expectedEdges = expectedEdges;
            this.idKey = idKey;
        }

        @Override
        protected void doRun() {
            JanusGraphVertex v = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(this.idKey, (Object)this.vertexId).vertices());
            int i = 0;
            while ((long)i < 256L) {
                JanusGraphAssert.assertCount(this.expectedEdges, v.query().labels(new String[]{this.label2Traverse}).direction(Direction.BOTH).edges());
                for (JanusGraphEdge r : v.query().direction(Direction.OUT).labels(new String[]{this.label2Traverse}).edges()) {
                    v = r.vertex(Direction.IN);
                }
                ++i;
            }
        }
    }

    private static class FixedRelationshipMaker
    implements Runnable {
        private final JanusGraphTransaction tx;
        private final String idKey;
        private final String edgeLabel;

        public FixedRelationshipMaker(JanusGraphTransaction tx, String id, String edgeLabel) {
            this.tx = tx;
            this.idKey = id;
            this.edgeLabel = edgeLabel;
        }

        @Override
        public void run() {
            do {
                JanusGraphVertex source = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(this.idKey, (Object)0).vertices());
                JanusGraphVertex sink = (JanusGraphVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(this.idKey, (Object)1).vertices());
                for (Edge o : source.query().direction(Direction.OUT).labels(new String[]{this.edgeLabel}).edges()) {
                    if (JanusGraphBaseTest.getId((Element)o.inVertex()) != JanusGraphBaseTest.getId((Element)sink)) continue;
                    o.remove();
                }
                source.addEdge(this.edgeLabel, (Vertex)sink, new Object[0]);
            } while (!Thread.interrupted());
        }
    }

    private static class RandomPropertyMaker
    implements Runnable {
        private final JanusGraphTransaction tx;
        private final int nodeCount;
        private final String idKey;
        private final String randomKey;

        public RandomPropertyMaker(JanusGraphTransaction tx, int nodeCount, String idKey, String randomKey) {
            this.tx = tx;
            this.nodeCount = nodeCount;
            this.idKey = idKey;
            this.randomKey = randomKey;
        }

        @Override
        public void run() {
            do {
                JanusGraphVertex n = JanusGraphBaseTest.getOnlyVertex(this.tx.query().has(this.idKey, (Object)RandomGenerator.randomInt(0, this.nodeCount)));
                String propVal = RandomGenerator.randomString();
                n.property(this.randomKey, (Object)propVal);
            } while (!Thread.interrupted());
        }
    }
}

