/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.util.MetricInstrumentedIndexProvider;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.util.stats.MetricManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class IndexMetricTest
extends JanusGraphBaseTest {
    public MetricManager metric;
    public String METRICS_INDEX_PREFIX = "org.janusgraph.indexProvider";

    @Override
    public abstract WriteConfiguration getConfiguration();

    @Override
    public void open(WriteConfiguration config) {
        this.metric = MetricManager.INSTANCE;
        super.open(config);
    }

    @Test
    public void testIndexMetrics() {
        PropertyKey p1 = this.mgmt.makePropertyKey("p1").dataType(String.class).make();
        this.mgmt.makePropertyKey("p2").dataType(String.class).make();
        PropertyKey p3 = this.mgmt.makePropertyKey("p3").dataType(Long.class).make();
        this.mgmt.makePropertyKey("p4").dataType(Integer.class).make();
        this.mgmt.buildIndex("idx", Vertex.class).addKey(p1, new Parameter[]{Mapping.STRING.asParameter()}).addKey(p3).buildMixedIndex("search");
        this.finishSchema();
        this.graph.traversal().addV().property((Object)"p1", (Object)"value", new Object[0]).property((Object)"p3", (Object)42, new Object[0]).property((Object)"p4", (Object)12, new Object[0]).iterate();
        this.graph.tx().commit();
        this.graph.traversal().V(new Object[0]).has("p1", (Object)"value").iterate();
        this.graph.traversal().V(new Object[0]).has("p2", (Object)"value").iterate();
        this.graph.traversal().V(new Object[0]).has("p1", (Object)"value").count().next();
        this.graph.traversal().V(new Object[0]).has("p1", (Object)"value").values(new String[]{"p3"}).max().next();
        this.graph.traversal().V(new Object[0]).has("p1", (Object)"value").values(new String[]{"p3"}).min().next();
        this.graph.traversal().V(new Object[0]).has("p1", (Object)"value").values(new String[]{"p3"}).sum().next();
        this.graph.traversal().V(new Object[0]).has("p1", (Object)"value").values(new String[]{"p3"}).mean().next();
        this.graph.traversal().V(new Object[0]).has("p1", (Object)"value").values(new String[]{"p4"}).max().next();
        this.graph.indexQuery("idx", "p1:*").vertexTotals();
        this.graph.indexQuery("idx", "p1:*").vertexStream();
        Assertions.assertThrows(JanusGraphException.class, () -> this.graph.indexQuery("idx", "!@#$%^").vertexTotals());
        this.verifyIndexMetrics("search", this.METRICS_INDEX_PREFIX, (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L, (Object)"query", (Object)1L, (Object)"mixedIndexAggregationQuery", (Object)5L, (Object)"totals", (Object)2L, (Object)"rawQuery", (Object)1L));
        Assertions.assertEquals((long)1L, (long)this.metric.getCounter(this.METRICS_INDEX_PREFIX, new String[]{"search", "totals", "exceptions"}).getCount());
    }

    public void verifyIndexMetrics(String indexName, String prefix, Map<String, Long> operationCounts) {
        for (String operation : MetricInstrumentedIndexProvider.OPERATION_NAMES) {
            Long count = operationCounts.get(operation);
            if (count == null) {
                count = 0L;
            }
            Assertions.assertEquals((long)count, (long)this.metric.getCounter(prefix, new String[]{indexName, operation, "calls"}).getCount(), (String)Joiner.on((String)".").join((Object)prefix, (Object)indexName, new Object[]{operation, "calls"}));
        }
    }
}

