/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect.StartStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.DefaultTraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.junit.jupiter.api.Assertions;

public class JanusGraphAssert {
    public static void assertCount(int expected, Traversal traversal) {
        Assertions.assertEquals((int)expected, (int)traversal.toList().size());
    }

    public static void assertCount(int expected, Collection collection) {
        Assertions.assertEquals((int)expected, (int)collection.size());
    }

    public static void assertCount(int expected, Iterable iterable) {
        Assertions.assertEquals((int)expected, (int)Iterables.size((Iterable)iterable));
    }

    public static void assertCount(int expected, Iterator iterator) {
        Assertions.assertEquals((int)expected, (int)Iterators.size((Iterator)iterator));
    }

    public static void assertCount(long expected, Stream stream) {
        Assertions.assertEquals((long)expected, (long)stream.count());
    }

    public static <V extends Element> void assertEmpty(Object object) {
        Assertions.assertTrue((boolean)JanusGraphAssert.isEmpty(object));
    }

    public static <V extends Element> void assertNotEmpty(Object object) {
        Assertions.assertFalse((boolean)JanusGraphAssert.isEmpty(object));
    }

    public static <E extends Element> void assertTraversal(GraphTraversal<?, E> req, E ... expectedElements) {
        for (E expectedElement : expectedElements) {
            Assertions.assertEquals(expectedElement, (Object)req.next());
        }
        Assertions.assertFalse((boolean)req.hasNext());
    }

    public static void assertIntRange(GraphTraversal<?, Integer> traversal, int start, int end) {
        int[] intArray = start <= end ? IntStream.range(start, end).toArray() : IntStream.range(end, start).map(i -> start + end - i).toArray();
        Assertions.assertArrayEquals((int[])intArray, (int[])traversal.toList().stream().mapToInt(i -> i).toArray());
    }

    private static boolean hasBackendHit(Metrics metrics) {
        if ("backend-query".equals(metrics.getName())) {
            return true;
        }
        for (Metrics subMetrics : metrics.getNested()) {
            if (!JanusGraphAssert.hasBackendHit(subMetrics)) continue;
            return true;
        }
        return false;
    }

    public static void assertBackendHit(TraversalMetrics profile) {
        Assertions.assertTrue((boolean)profile.getMetrics().stream().anyMatch(JanusGraphAssert::hasBackendHit));
    }

    public static void assertNoBackendHit(TraversalMetrics profile) {
        Assertions.assertFalse((boolean)profile.getMetrics().stream().anyMatch(JanusGraphAssert::hasBackendHit));
    }

    private static boolean isEmpty(Object obj) {
        Preconditions.checkArgument((obj != null ? 1 : 0) != 0);
        if (obj instanceof Traversal) {
            return !((Traversal)obj).hasNext();
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).isEmpty();
        }
        if (obj instanceof Iterable) {
            return Iterables.isEmpty((Iterable)((Iterable)obj));
        }
        if (obj instanceof Iterator) {
            return !((Iterator)obj).hasNext();
        }
        if (obj instanceof Stream) {
            return ((Stream)obj).count() == 0L;
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        throw new IllegalArgumentException("Cannot determine size of: " + obj);
    }

    public static void assertNumStep(int expectedResults, int expectedSteps, GraphTraversal traversal, Class<? extends Step> ... expectedStepTypes) {
        Assertions.assertEquals((int)expectedResults, (int)traversal.toList().size());
        List steps = traversal.asAdmin().getSteps();
        HashSet expSteps = Sets.newHashSet((Object[])expectedStepTypes);
        int numSteps = 0;
        for (Step s : steps) {
            if (s.getClass().equals(GraphStep.class) || s.getClass().equals(StartStep.class) || !expSteps.contains(s.getClass())) continue;
            ++numSteps;
        }
        Assertions.assertEquals((int)expectedSteps, (int)numSteps);
    }

    public static void assertOptimization(Traversal<?, ?> expectedTraversal, Traversal<?, ?> originalTraversal, TraversalStrategy ... optimizationStrategies) {
        DefaultTraversalStrategies optimizations = new DefaultTraversalStrategies();
        for (TraversalStrategy strategy : optimizationStrategies) {
            optimizations.addStrategies(new TraversalStrategy[]{strategy});
        }
        originalTraversal.asAdmin().setStrategies((TraversalStrategies)optimizations);
        originalTraversal.asAdmin().applyStrategies();
        Assertions.assertEquals((Object)expectedTraversal.asAdmin().getSteps().toString(), (Object)originalTraversal.asAdmin().getSteps().toString());
    }

    public static void assertSameResultWithOptimizations(Traversal<?, ?> originalTraversal, TraversalStrategy<?> ... strategies) {
        Traversal.Admin optimizedTraversal = originalTraversal.asAdmin().clone();
        optimizedTraversal.getStrategies().addStrategies(strategies);
        List optimizedResult = optimizedTraversal.toList();
        Traversal.Admin unOptimizedTraversal = originalTraversal.asAdmin().clone();
        Stream.of(strategies).forEach(s -> unOptimizedTraversal.getStrategies().removeStrategies(new Class[]{s.getClass()}));
        List unOptimizedResult = unOptimizedTraversal.toList();
        Assertions.assertEquals((Object)unOptimizedResult, (Object)optimizedResult);
    }

    public static boolean queryProfilerAnnotationIsPresent(Traversal t, String queryProfilerAnnotation) {
        TraversalMetrics metrics = (TraversalMetrics)t.asAdmin().getSideEffects().get("~metrics");
        return metrics.toString().contains(queryProfilerAnnotation + "=true");
    }

    public static void assertContains(Metrics metrics, String annotationKey, Object annotationValue) {
        Map annotations = metrics.getAnnotations();
        Assertions.assertTrue((boolean)annotations.containsKey(annotationKey));
        Assertions.assertEquals((Object)annotationValue, annotations.get(annotationKey));
    }

    public static void assertNotContains(Metrics metrics, String annotationKey, Object annotationValue) {
        Map annotations = metrics.getAnnotations();
        if (annotations.containsKey(annotationKey)) {
            Assertions.assertNotEquals((Object)annotationValue, annotations.get(annotationKey));
        }
    }

    public static Metrics getStepMetrics(TraversalMetrics traversalMetrics, Class<? extends Step> stepClass) {
        String stepMetricsName = stepClass.getSimpleName();
        for (Metrics metrics : traversalMetrics.getMetrics()) {
            if (!metrics.getName().startsWith(stepMetricsName)) continue;
            return metrics;
        }
        return null;
    }

    public static void assertStepExists(Traversal traversal, Class<? extends Step> expectedStepType, int stepsCount) {
        String traversalString = traversal.toString();
        int lastStepIndex = traversalString.indexOf(expectedStepType.getSimpleName());
        if (stepsCount <= 0) {
            Assertions.assertEquals((int)-1, (int)lastStepIndex);
        }
        int stepsFound = 0;
        while (lastStepIndex != -1) {
            ++stepsFound;
            lastStepIndex = traversalString.indexOf(expectedStepType.getSimpleName(), lastStepIndex + 1);
        }
        Assertions.assertEquals((int)stepsCount, (int)stepsFound);
    }

    public static Metrics getLastStepMetrics(TraversalMetrics traversalMetrics, Class<? extends Step> stepClass) {
        String stepMetricsName = stepClass.getSimpleName();
        Metrics metricsToReturn = null;
        for (Metrics metrics : traversalMetrics.getMetrics()) {
            if (!metrics.getName().startsWith(stepMetricsName)) continue;
            metricsToReturn = metrics;
        }
        return metricsToReturn;
    }
}

