/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.LogManager;
import org.janusgraph.diskstorage.log.Message;
import org.janusgraph.diskstorage.log.MessageReader;
import org.janusgraph.diskstorage.log.ReadMarker;
import org.janusgraph.diskstorage.log.util.FutureMessage;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class TestMockLog
implements LogManager {
    public static final ConfigOption<Boolean> LOG_MOCK_FAILADD = new ConfigOption(GraphDatabaseConfiguration.LOG_NS, "fail-adds", "Sets the log to reject adding messages. FOR TESTING ONLY", ConfigOption.Type.LOCAL, (Object)false).hide();
    private final Map<String, TestLog> openLogs = Maps.newHashMap();
    private final boolean failAdds;
    private final String senderId;
    private final TimestampProvider times;

    public TestMockLog(Configuration config) {
        this.failAdds = (Boolean)config.get(LOG_MOCK_FAILADD, new String[0]);
        this.senderId = (String)config.get(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, new String[0]);
        this.times = (TimestampProvider)config.get(GraphDatabaseConfiguration.TIMESTAMP_PROVIDER, new String[0]);
    }

    public synchronized Log openLog(String name) {
        return this.openLogs.computeIfAbsent(name, x$0 -> new TestLog((String)x$0));
    }

    public synchronized void close() {
        this.openLogs.clear();
    }

    private class TestMessage
    implements Message {
        private final Instant time;
        private final StaticBuffer content;

        private TestMessage(StaticBuffer content) {
            this.time = TestMockLog.this.times.getTime();
            this.content = content;
        }

        public String getSenderId() {
            return TestMockLog.this.senderId;
        }

        public Instant getTimestamp() {
            return this.time;
        }

        public StaticBuffer getContent() {
            return this.content;
        }
    }

    private class TestLog
    implements Log {
        private final String name;
        private final Set<MessageReader> readers = Sets.newHashSet();
        private List<FutureMessage<TestMessage>> messageBacklog = Lists.newArrayList();

        private TestLog(String name) {
            this.name = name;
        }

        public synchronized Future<Message> add(StaticBuffer content) {
            TestMessage msg = new TestMessage(content);
            FutureMessage fmsg = new FutureMessage((Message)msg);
            if (TestMockLog.this.failAdds) {
                System.out.println("Failed message add");
                throw new JanusGraphException("Log unavailable");
            }
            if (this.readers.isEmpty()) {
                this.messageBacklog.add((FutureMessage<TestMessage>)fmsg);
            } else {
                this.process((FutureMessage<TestMessage>)fmsg);
            }
            return fmsg;
        }

        private void process(FutureMessage<TestMessage> fmsg) {
            for (MessageReader reader : this.readers) {
                reader.read(fmsg.getMessage());
            }
            fmsg.delivered();
        }

        public synchronized Future<Message> add(StaticBuffer content, StaticBuffer key) {
            return this.add(content);
        }

        public synchronized void registerReader(ReadMarker readMarker, MessageReader ... reader) {
            this.registerReaders(readMarker, Arrays.asList(reader));
        }

        public synchronized void registerReaders(ReadMarker readMarker, Iterable<MessageReader> readers) {
            for (FutureMessage<TestMessage> fmsg : this.messageBacklog) {
                this.process(fmsg);
            }
            this.messageBacklog = null;
            Iterables.addAll(this.readers, readers);
        }

        public synchronized boolean unregisterReader(MessageReader reader) {
            return this.readers.remove(reader);
        }

        public String getName() {
            return this.name;
        }

        public void close() {
            this.readers.clear();
        }
    }
}

