/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.carrotsearch.hppc.IntHashSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphComputer;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.VertexList;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.idassigner.VertexIDAssigner;
import org.janusgraph.graphdb.database.idassigner.placement.PropertyPlacementStrategy;
import org.janusgraph.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.olap.computer.FulgoraGraphComputer;
import org.janusgraph.olap.OLAPTest;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.util.datastructures.AbstractIdListUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public abstract class JanusGraphPartitionGraphTest
extends JanusGraphBaseTest {
    static final Random random = new Random();
    static final int numPartitions = 8;
    private IDManager idManager;

    public abstract WriteConfiguration getBaseConfiguration();

    @Override
    public WriteConfiguration getConfiguration() {
        WriteConfiguration config = this.getBaseConfiguration();
        ModifiableConfiguration modifiableConfiguration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
        modifiableConfiguration.set(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, (Object)8, new String[0]);
        modifiableConfiguration.set(SimpleBulkPlacementStrategy.CONCURRENT_PARTITIONS, (Object)24, new String[0]);
        return config;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        super.setUp(testInfo);
        this.idManager = this.graph.getIDManager();
    }

    @Test
    public void testPartitionHashes() {
        Assertions.assertEquals((long)8L, (long)this.idManager.getPartitionBound());
        HashSet hashes = Sets.newHashSet();
        for (long i = 1L; i < this.idManager.getPartitionBound() * 2L; ++i) {
            hashes.add(this.idManager.getPartitionHashForId(i));
        }
        Assertions.assertTrue(((long)hashes.size() > this.idManager.getPartitionBound() / 2L ? 1 : 0) != 0);
        Assertions.assertNotEquals((long)this.idManager.getPartitionHashForId(101L), (long)this.idManager.getPartitionHashForId(102L));
    }

    @Test
    public void testVertexPartitioning() {
        JanusGraphVertex g;
        int i;
        Object[] options = new Object[]{JanusGraphPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), false};
        this.clopen(options);
        this.makeVertexIndexedUniqueKey("gid", Integer.class);
        this.makeKey("sig", Integer.class);
        this.mgmt.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
        this.makeLabel("knows");
        this.makeLabel("base");
        this.mgmt.makeEdgeLabel("one").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.makeVertexLabel("person").make();
        this.mgmt.makeVertexLabel("group").partition().make();
        this.finishSchema();
        ImmutableSet names = ImmutableSet.of((Object)"Marko", (Object)"Dan", (Object)"Stephen", (Object)"Daniel", (Object)"Josh", (Object)"Thad", (Object[])new String[]{"Pavel", "Matthias"});
        int numG = 10;
        Object[] gids = new Object[10];
        for (i = 0; i < 10; ++i) {
            g = this.tx.addVertex("group");
            g.property(VertexProperty.Cardinality.single, "gid", (Object)i, new Object[0]);
            g.property(VertexProperty.Cardinality.single, "sig", (Object)0, new Object[0]);
            for (String n : names) {
                g.property("name", (Object)n);
            }
            Assertions.assertEquals((int)i, (int)((Integer)g.value("gid")));
            Assertions.assertEquals((int)0, (int)((Integer)g.value("sig")));
            Assertions.assertEquals((Object)"group", (Object)g.label());
            JanusGraphAssert.assertCount(names.size(), g.properties(new String[]{"name"}));
            Assertions.assertTrue(((Long)JanusGraphPartitionGraphTest.getId((Element)g) > 0L ? 1 : 0) != 0);
            gids[i] = JanusGraphPartitionGraphTest.getId((Element)g);
            if (i > 0) {
                g.addEdge("base", (Vertex)JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[0]), new Object[0]);
            }
            if (i % 2 != 1) continue;
            g.addEdge("one", (Vertex)JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[i - 1]), new Object[0]);
        }
        for (i = 0; i < 10; ++i) {
            g = JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[i]);
            JanusGraphAssert.assertCount(1, g.query().direction(Direction.BOTH).labels(new String[]{"one"}).edges());
            JanusGraphAssert.assertCount(1, g.query().direction(i % 2 == 0 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            JanusGraphAssert.assertCount(0, g.query().direction(i % 2 == 1 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            if (i > 0) {
                JanusGraphAssert.assertCount(1, g.query().direction(Direction.OUT).labels(new String[]{"base"}).edges());
                continue;
            }
            JanusGraphAssert.assertCount(9, g.query().direction(Direction.IN).labels(new String[]{"base"}).edges());
        }
        this.newTx();
        for (i = 0; i < 10; ++i) {
            Object gId = gids[i];
            Assertions.assertTrue((boolean)this.idManager.isPartitionedVertex(gId));
            Assertions.assertEquals((Object)this.idManager.getCanonicalVertexId(((Long)gId).longValue()), (Object)gId);
            JanusGraphVertex g2 = JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gId);
            int canonicalPartition = this.getPartitionID(g2);
            Assertions.assertEquals((Object)g2, JanusGraphPartitionGraphTest.getOnlyElement(this.tx.query().has("gid", (Object)i).vertices()));
            Assertions.assertEquals((int)i, (int)((Integer)g2.value("gid")));
            JanusGraphAssert.assertCount(names.size(), g2.properties(new String[]{"name"}));
            JanusGraphVertexProperty p = (JanusGraphVertexProperty)JanusGraphPartitionGraphTest.getOnlyElement(g2.properties(new String[]{"gid"}));
            Assertions.assertEquals((int)canonicalPartition, (int)this.getPartitionID((JanusGraphRelation)p));
            Iterator niter = g2.properties(new String[]{"name"});
            while (niter.hasNext()) {
                Assertions.assertEquals((int)canonicalPartition, (int)this.getPartitionID((JanusGraphVertex)((VertexProperty)niter.next()).element()));
            }
            JanusGraphAssert.assertCount(1, g2.query().direction(Direction.BOTH).labels(new String[]{"one"}).edges());
            JanusGraphAssert.assertCount(1, g2.query().direction(i % 2 == 0 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            JanusGraphAssert.assertCount(0, g2.query().direction(i % 2 == 1 ? Direction.IN : Direction.OUT).labels(new String[]{"one"}).edges());
            if (i > 0) {
                JanusGraphAssert.assertCount(1, g2.query().direction(Direction.OUT).labels(new String[]{"base"}).edges());
                continue;
            }
            JanusGraphAssert.assertCount(9, g2.query().direction(Direction.IN).labels(new String[]{"base"}).edges());
        }
        this.clopen(options);
        int numTx = 100;
        int vPerTx = 10;
        HashMultiset partitions = HashMultiset.create();
        for (int t = 1; t <= 100; ++t) {
            JanusGraphVertex g1 = JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[0]);
            JanusGraphVertex g2 = JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[1]);
            Assertions.assertNotNull((Object)g1);
            JanusGraphVertex[] vs = new JanusGraphVertex[10];
            for (int vi = 0; vi < 10; ++vi) {
                vs[vi] = this.tx.addVertex("person");
                vs[vi].property(VertexProperty.Cardinality.single, "sig", (Object)t, new Object[0]);
                JanusGraphEdge e = vs[vi].addEdge("knows", (Vertex)g1, new Object[0]);
                e.property("sig", (Object)t);
                e = g1.addEdge("knows", (Vertex)vs[vi], new Object[0]);
                e.property("sig", (Object)t);
                if (vi % 2 != 0) continue;
                e = vs[vi].addEdge("knows", (Vertex)g2, new Object[0]);
                e.property("sig", (Object)t);
            }
            this.newTx();
            JanusGraphTransaction txx = this.graph.buildTransaction().readOnly().start();
            g1 = JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[0]);
            g2 = JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[1]);
            int partition = -1;
            for (int vi = 0; vi < 10; ++vi) {
                Assertions.assertTrue((boolean)vs[vi].hasId());
                int pid = this.getPartitionID(vs[vi]);
                if (partition < 0) {
                    partition = pid;
                } else {
                    Assertions.assertEquals((int)partition, (int)pid);
                }
                int numRelations = 0;
                JanusGraphVertex v = JanusGraphPartitionGraphTest.getV((Transaction)txx, vs[vi].id());
                for (JanusGraphRelation r : v.query().relations()) {
                    ++numRelations;
                    Assertions.assertEquals((int)partition, (int)this.getPartitionID(r));
                    if (!(r instanceof JanusGraphEdge)) continue;
                    JanusGraphVertex o = ((JanusGraphEdge)r).otherVertex((Vertex)v);
                    Assertions.assertTrue((o.equals(g1) || o.equals(g2) ? 1 : 0) != 0);
                }
                Assertions.assertEquals((int)(3 + (vi % 2 == 0 ? 1 : 0)), (int)numRelations);
            }
            partitions.add((Object)partition);
            txx.commit();
        }
        Assertions.assertTrue((partitions.elementSet().size() >= 3 ? 1 : 0) != 0);
        this.newTx();
        JanusGraphVertex g1 = JanusGraphPartitionGraphTest.getV((Transaction)this.tx, gids[0]);
        Assertions.assertEquals((int)0, (int)((Integer)g1.value("gid")));
        Assertions.assertEquals((Object)"group", (Object)g1.label());
        JanusGraphAssert.assertCount(names.size(), g1.properties(new String[]{"name"}));
        JanusGraphAssert.assertCount(1000, g1.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
        JanusGraphAssert.assertCount(1000, g1.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
        JanusGraphAssert.assertCount(2000, g1.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
        JanusGraphAssert.assertCount(1010, this.tx.query().vertices());
        this.newTx();
        for (int t = 0; t < 10; ++t) {
            int numP = random.nextInt(3) + 1;
            HashSet parts = Sets.newHashSet();
            int numV = 0;
            while (parts.size() < numP) {
                int part = (Integer)Iterables.get((Iterable)partitions.elementSet(), (int)random.nextInt(partitions.elementSet().size()));
                if (!parts.add(part)) continue;
                numV += partitions.count((Object)part);
            }
            numV *= 10;
            int[] partitionArray = new int[numP];
            int i2 = 0;
            for (Integer part : parts) {
                partitionArray[i2++] = part;
            }
            JanusGraphTransaction tx2 = this.graph.buildTransaction().restrictedPartitions(partitionArray).readOnly().start();
            g1 = JanusGraphPartitionGraphTest.getV((Transaction)tx2, gids[0]);
            Assertions.assertEquals((int)0, (int)((Integer)g1.value("gid")));
            Assertions.assertEquals((Object)"group", (Object)g1.label());
            Assertions.assertTrue((names.size() >= Iterators.size((Iterator)g1.properties(new String[]{"name"})) ? 1 : 0) != 0);
            JanusGraphAssert.assertCount(numV, g1.query().direction(Direction.OUT).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(numV, g1.query().direction(Direction.IN).labels(new String[]{"knows"}).edges());
            JanusGraphAssert.assertCount(numV * 2, g1.query().direction(Direction.BOTH).labels(new String[]{"knows"}).edges());
            JanusGraphVertex g2 = JanusGraphPartitionGraphTest.getV((Transaction)tx2, gids[1]);
            VertexList v1 = g1.query().direction(Direction.IN).labels(new String[]{"knows"}).vertexIds();
            VertexList v2 = g2.query().direction(Direction.IN).labels(new String[]{"knows"}).vertexIds();
            Assertions.assertEquals((int)numV, (int)v1.size());
            Assertions.assertEquals((int)(numV / 2), (int)v2.size());
            v1.sort();
            v2.sort();
            List al1 = v1.getIDs();
            List al2 = v2.getIDs();
            Assertions.assertTrue((boolean)AbstractIdListUtil.isSorted((List)al1));
            Assertions.assertTrue((boolean)AbstractIdListUtil.isSorted((List)al2));
            List alr = AbstractIdListUtil.mergeJoin((List)al1, (List)al2, (boolean)false);
            Assertions.assertEquals((int)(numV / 2), (int)alr.size());
            tx2.commit();
        }
    }

    private int setupGroupClusters(int[] groupDegrees, CommitMode commitMode) {
        this.mgmt.makeVertexLabel("person").make();
        this.mgmt.makeVertexLabel("group").partition().make();
        this.makeVertexIndexedKey("groupid", String.class);
        this.makeKey("name", String.class);
        this.makeKey("clusterId", String.class);
        this.makeLabel("member");
        this.makeLabel("contain");
        this.finishSchema();
        int numVertices = 0;
        JanusGraphVertex[] groups = new JanusGraphVertex[groupDegrees.length];
        for (int i = 0; i < groupDegrees.length; ++i) {
            groups[i] = this.tx.addVertex("group");
            groups[i].property("groupid", (Object)("group" + i));
            ++numVertices;
            if (commitMode == CommitMode.PER_VERTEX) {
                this.newTx();
            }
            for (int noEdges = 0; noEdges < groupDegrees[i]; ++noEdges) {
                JanusGraphVertex g = JanusGraphPartitionGraphTest.vInTx(groups[i], this.tx);
                JanusGraphVertex p = this.tx.addVertex(new Object[]{"name", "person" + i + ":" + noEdges, "clusterId", "group" + i});
                ++numVertices;
                p.addEdge("member", (Vertex)g, new Object[0]);
                g.addEdge("contain", (Vertex)p, new Object[0]);
                if (commitMode != CommitMode.PER_VERTEX) continue;
                this.newTx();
            }
            if (commitMode != CommitMode.PER_CLUSTER) continue;
            this.newTx();
        }
        this.newTx();
        return numVertices;
    }

    private static JanusGraphVertex vInTx(JanusGraphVertex v, JanusGraphTransaction tx) {
        if (!v.hasId()) {
            return v;
        }
        return tx.getVertex(v.id());
    }

    @Test
    public void testPartitionSpreadFlushBatch() {
        this.testPartitionSpread(true, true);
    }

    @Test
    public void testPartitionSpreadFlushNoBatch() {
        this.testPartitionSpread(true, false);
    }

    @Test
    public void testPartitionSpreadNoFlushBatch() {
        this.testPartitionSpread(false, true);
    }

    @Test
    public void testPartitionSpreadNoFlushNoBatch() {
        this.testPartitionSpread(false, false);
    }

    private void testPartitionSpread(boolean flush, boolean batchCommit) {
        Object[] options = new Object[]{JanusGraphPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), flush};
        this.clopen(options);
        int[] groupDegrees = new int[]{10, 15, 10, 17, 10, 4, 7, 20, 11};
        int numVertices = this.setupGroupClusters(groupDegrees, batchCommit ? CommitMode.BATCH : CommitMode.PER_VERTEX);
        IntHashSet partitionIds = new IntHashSet(numVertices);
        for (int i = 0; i < groupDegrees.length; ++i) {
            JanusGraphVertex g = JanusGraphPartitionGraphTest.getOnlyVertex(this.tx.query().has("groupid", (Object)("group" + i)));
            JanusGraphAssert.assertCount(groupDegrees[i], g.edges(Direction.OUT, new String[]{"contain"}));
            JanusGraphAssert.assertCount(groupDegrees[i], g.edges(Direction.IN, new String[]{"member"}));
            JanusGraphAssert.assertCount(groupDegrees[i], g.query().direction(Direction.OUT).edges());
            JanusGraphAssert.assertCount(groupDegrees[i], g.query().direction(Direction.IN).edges());
            JanusGraphAssert.assertCount(groupDegrees[i] * 2, g.query().edges());
            for (JanusGraphVertex o : g.query().direction(Direction.IN).labels(new String[]{"member"}).vertices()) {
                int pid = this.getPartitionID(o);
                partitionIds.add(pid);
                Assertions.assertEquals((Object)g, JanusGraphPartitionGraphTest.getOnlyElement(o.query().direction(Direction.OUT).labels(new String[]{"member"}).vertices()));
                VertexList vertexList = o.query().direction(Direction.IN).labels(new String[]{"contain"}).vertexIds();
                Assertions.assertEquals((int)1, (int)vertexList.size());
                Assertions.assertEquals((long)pid, (long)this.idManager.getPartitionId(((Long)vertexList.getID(0)).longValue()));
                Assertions.assertEquals((Object)g, (Object)vertexList.get(0));
            }
        }
        if (flush || !batchCommit) {
            Assertions.assertTrue((partitionIds.size() > 4 ? 1 : 0) != 0);
        } else {
            Assertions.assertEquals((int)1, (int)partitionIds.size());
        }
    }

    @Test
    public void testVertexPartitionOlapBatch() throws Exception {
        this.testVertexPartitionOlap(CommitMode.BATCH);
    }

    @Test
    public void testVertexPartitionOlapCluster() throws Exception {
        this.testVertexPartitionOlap(CommitMode.PER_CLUSTER);
    }

    @Test
    public void testVertexPartitionOlapIndividual() throws Exception {
        this.testVertexPartitionOlap(CommitMode.PER_VERTEX);
    }

    private void testVertexPartitionOlap(CommitMode commitMode) throws Exception {
        Object[] options = new Object[]{JanusGraphPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), false};
        this.clopen(options);
        int[] groupDegrees = new int[]{2};
        int numVertices = this.setupGroupClusters(groupDegrees, commitMode);
        HashMap<Object, Integer> degreeMap = new HashMap<Object, Integer>(groupDegrees.length);
        for (int i = 0; i < groupDegrees.length; ++i) {
            degreeMap.put(JanusGraphPartitionGraphTest.getOnlyVertex(this.tx.query().has("groupid", (Object)("group" + i))).id(), groupDegrees[i]);
        }
        this.clopen(options);
        JanusGraphComputer computer = (JanusGraphComputer)this.graph.compute(FulgoraGraphComputer.class);
        computer.resultMode(JanusGraphComputer.ResultMode.NONE);
        computer.workers(1);
        computer.program((VertexProgram)new OLAPTest.DegreeCounter());
        computer.mapReduce((MapReduce)new OLAPTest.DegreeMapper());
        ComputerResult result = (ComputerResult)computer.submit().get();
        Assertions.assertTrue((boolean)result.memory().exists("degrees"));
        Map degrees = (Map)result.memory().get("degrees");
        Assertions.assertNotNull((Object)degrees);
        Assertions.assertEquals((int)numVertices, (int)degrees.size());
        IDManager idManager = this.graph.getIDManager();
        for (Map.Entry entry : degrees.entrySet()) {
            long vid = (Long)entry.getKey();
            Integer degree = (Integer)entry.getValue();
            if (idManager.isPartitionedVertex((Object)vid)) {
                Assertions.assertEquals((Integer)((Integer)degreeMap.get(vid)), (Integer)degree);
                continue;
            }
            Assertions.assertEquals((long)1L, (long)degree.intValue());
        }
    }

    @Test
    public void testVLabelOnOrderedStorage() {
        String label = "pl";
        this.mgmt.makeVertexLabel("pl").partition().make();
        this.mgmt.commit();
        this.graph.tx().rollback();
        this.graph.addVertex("pl");
        this.graph.tx().commit();
        this.mgmt = this.graph.openManagement();
        VertexLabel vl = this.mgmt.getVertexLabel("pl");
        Assertions.assertTrue((boolean)vl.isPartitioned());
        this.mgmt.rollback();
    }

    @Test
    public void testKeyBasedGraphPartitioning() {
        Object[] options = new Object[]{JanusGraphPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), false, JanusGraphPartitionGraphTest.option(VertexIDAssigner.PLACEMENT_STRATEGY, new String[0]), PropertyPlacementStrategy.class.getName(), JanusGraphPartitionGraphTest.option(PropertyPlacementStrategy.PARTITION_KEY, new String[0]), "clusterId"};
        this.clopen(options);
        int[] groupDegrees = new int[]{5, 5, 5, 5, 5, 5, 5, 5};
        int numVertices = this.setupGroupClusters(groupDegrees, CommitMode.PER_VERTEX);
        IntHashSet partitionIds = new IntHashSet(numVertices);
        for (int i = 0; i < groupDegrees.length; ++i) {
            JanusGraphVertex g = JanusGraphPartitionGraphTest.getOnlyVertex(this.tx.query().has("groupid", (Object)("group" + i)));
            int partitionId = -1;
            for (JanusGraphVertex o : g.query().direction(Direction.IN).labels(new String[]{"member"}).vertices()) {
                if (partitionId < 0) {
                    partitionId = this.getPartitionID(o);
                }
                Assertions.assertEquals((int)partitionId, (int)this.getPartitionID(o));
                partitionIds.add(partitionId);
            }
        }
        Assertions.assertTrue((partitionIds.size() > 4 ? 1 : 0) != 0);
    }

    public int getPartitionID(JanusGraphVertex vertex) {
        long p = this.idManager.getPartitionId(((Long)vertex.id()).longValue());
        Assertions.assertTrue((p >= 0L && p < this.idManager.getPartitionBound() && p < Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)p;
    }

    public int getPartitionID(JanusGraphRelation relation) {
        long p = relation.longId() & this.idManager.getPartitionBound() - 1L;
        Assertions.assertTrue((p >= 0L && p < this.idManager.getPartitionBound() && p < Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)p;
    }

    private static enum CommitMode {
        BATCH,
        PER_VERTEX,
        PER_CLUSTER;

    }
}

