/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.janusgraph.diskstorage.configuration.ExecutorServiceConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.util.system.ConfigurationUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class GraphDatabaseConfigurationInstanceExecutorServiceTest {
    public abstract Map<String, Object> getStorageConfiguration();

    @Test
    public void shouldCreateCustomBackendFixedThreadPoolSize() {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CORE_POOL_SIZE.toStringWithoutRoot(), 15);
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        Assertions.assertDoesNotThrow(() -> {
            StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph.traversal().V(new Object[0]).hasNext();
            graph.close();
        });
    }

    @Test
    public void shouldCreateCustomBackendCachedThreadPoolSize() {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), "cached");
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CORE_POOL_SIZE.toStringWithoutRoot(), 15);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_KEEP_ALIVE_TIME.toStringWithoutRoot(), 30000);
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        Assertions.assertDoesNotThrow(() -> {
            StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph.traversal().V(new Object[0]).hasNext();
            graph.close();
        });
    }

    @Test
    public void shouldCreateCustomBackendExecutorServiceWithExecutorServiceConfigurationConstructor() {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CORE_POOL_SIZE.toStringWithoutRoot(), 15);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), CustomExecutorServiceImplementation.class.getName());
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        Assertions.assertDoesNotThrow(() -> {
            StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph.traversal().V(new Object[0]).hasNext();
            graph.close();
        });
    }

    @Test
    public void shouldCreateCustomBackendExecutorServiceWithoutExecutorServiceConfigurationConstructor() {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), CustomParameterlessExecutorServiceImplementation.class.getName());
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        Assertions.assertDoesNotThrow(() -> {
            StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph.traversal().V(new Object[0]).hasNext();
            graph.close();
        });
    }

    @Test
    public void shouldCreateCustomBackendExecutorServiceWithoutBothExecutorServiceConfigurationConstructors() {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CORE_POOL_SIZE.toStringWithoutRoot(), 15);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), CustomExecutorServiceWithBothConstructorsImplementation.class.getName());
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        Assertions.assertDoesNotThrow(() -> {
            StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph.traversal().V(new Object[0]).hasNext();
            graph.close();
        });
    }

    @Test
    public void shouldNotCreateBackendExecutorServiceIfClassNotExists() {
        String configurationClass = "not-existing-class";
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), configurationClass);
        this.checkExceptionIsThrownDuringInit(IllegalArgumentException.class, map, "No ExecutorService class found with class name: " + configurationClass);
    }

    @Test
    public void shouldNotCreateBackendExecutorServiceIfClassHasNoNecessaryConstructor() {
        String configurationClass = CustomExecutorServiceImplementationWithoutNecessaryConstructor.class.getName();
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), configurationClass);
        this.checkExceptionIsThrownDuringInit(IllegalArgumentException.class, map, configurationClass + " has neither public constructor which accepts " + ExecutorServiceConfiguration.class.getName() + " nor parameterless public constructor.");
    }

    @Test
    public void shouldNotCreateBackendExecutorServiceIfClassNotImplementsExecutorService() {
        String configurationClass = HashSet.class.getName();
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), configurationClass);
        this.checkExceptionIsThrownDuringInit(IllegalArgumentException.class, map, configurationClass + "isn't a subclass of " + ExecutorService.class.getName());
    }

    @Test
    public void shouldNotCreateBackendExecutorServiceIfClassHasNoPublicConstructor() {
        String configurationClass = CustomExecutorServiceImplementationWithoutPublicConstructor.class.getName();
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_OPS.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.PARALLEL_BACKEND_EXECUTOR_SERVICE_CLASS.toStringWithoutRoot(), configurationClass);
        this.checkExceptionIsThrownDuringInit(IllegalStateException.class, map, "Couldn't create a new instance of " + configurationClass + ". Please, check that the constructor which accepts " + ExecutorServiceConfiguration.class.getName() + " is public or there is a public parameterless constructor. If the necessary public constructor exists, please, check that invocation of this constructor doesn't throw an exception.");
    }

    private <T extends Exception> void checkExceptionIsThrownDuringInit(Class<T> exceptionType, Map<String, Object> configMap, String message) {
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(configMap);
        Exception exception = (Exception)Assertions.assertThrows(exceptionType, () -> {
            StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph.traversal().V(new Object[0]).hasNext();
            graph.close();
        });
        Assertions.assertEquals((Object)message, (Object)exception.getMessage());
    }

    public static class CustomExecutorServiceImplementationWithoutPublicConstructor
    extends ThreadPoolExecutor {
        private CustomExecutorServiceImplementationWithoutPublicConstructor() {
            super(1, 2, 3L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        }
    }

    public static class CustomExecutorServiceImplementationWithoutNecessaryConstructor
    extends ThreadPoolExecutor {
        public CustomExecutorServiceImplementationWithoutNecessaryConstructor(int corePoolSize) {
            super(corePoolSize, 2, 3L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        }
    }

    public static class CustomExecutorServiceWithBothConstructorsImplementation
    extends ThreadPoolExecutor {
        public CustomExecutorServiceWithBothConstructorsImplementation() {
            super(1, 2, 3L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        }

        public CustomExecutorServiceWithBothConstructorsImplementation(ExecutorServiceConfiguration executorServiceConfiguration) {
            super(executorServiceConfiguration.getCorePoolSize(), executorServiceConfiguration.getMaxPoolSize(), executorServiceConfiguration.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        }
    }

    public static class CustomParameterlessExecutorServiceImplementation
    extends ThreadPoolExecutor {
        public CustomParameterlessExecutorServiceImplementation() {
            super(1, 2, 3L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        }
    }

    public static class CustomExecutorServiceImplementation
    extends ThreadPoolExecutor {
        public CustomExecutorServiceImplementation(ExecutorServiceConfiguration executorServiceConfiguration) {
            super(executorServiceConfiguration.getCorePoolSize(), executorServiceConfiguration.getMaxPoolSize(), executorServiceConfiguration.getKeepAliveTime(), TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>());
        }
    }
}

