/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import java.util.List;
import org.janusgraph.JanusGraphBaseStoreFeaturesTest;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.common.DistributedStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRange;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.testutil.FeatureFlag;
import org.janusgraph.testutil.JanusGraphFeature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class DistributedStoreManagerTest<T extends DistributedStoreManager>
implements JanusGraphBaseStoreFeaturesTest {
    protected T manager;
    protected KeyColumnValueStore store;

    @Override
    public StoreFeatures getStoreFeatures() {
        return this.manager.getFeatures();
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.OrderedScan)
    public void testGetLocalKeyPartition() throws BackendException {
        Assumptions.assumeTrue((boolean)this.manager.getFeatures().hasLocalKeyPartition());
        List local = this.manager.getLocalKeyPartition();
        Assertions.assertNotNull((Object)local);
        Assertions.assertEquals((int)1, (int)local.size());
        Assertions.assertNotNull((Object)((KeyRange)local.get(0)).getStart());
        Assertions.assertNotNull((Object)((KeyRange)local.get(0)).getEnd());
    }
}

