/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngineManager;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.janusgraph.core.ConfiguredGraphFactory;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.management.ConfigurationManagementGraph;
import org.janusgraph.graphdb.management.JanusGraphManager;
import org.janusgraph.graphdb.management.utils.ConfigurationManagementGraphNotEnabledException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AbstractConfiguredGraphFactoryTest {
    private static JanusGraphManager gm;

    protected abstract MapConfiguration getManagementConfig();

    protected abstract MapConfiguration getTemplateConfig();

    protected abstract MapConfiguration getGraphConfig();

    @BeforeEach
    public void setup() {
        if (gm != null) {
            return;
        }
        gm = new JanusGraphManager(new Settings());
        MapConfiguration config = this.getManagementConfig();
        StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        new ConfigurationManagementGraph(graph);
    }

    @AfterEach
    public void cleanUp() {
        ConfiguredGraphFactory.removeTemplateConfiguration();
    }

    @Test
    public void shouldGetConfigurationManagementGraphInstance() throws ConfigurationManagementGraphNotEnabledException {
        ConfigurationManagementGraph thisInstance = ConfigurationManagementGraph.getInstance();
        Assertions.assertNotNull((Object)thisInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldOpenGraphUsingConfiguration() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void graphConfigurationShouldBeWhatWeExpect() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)this.getGraphConfig());
            String backend = graphConfig.getString(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot());
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            Assertions.assertEquals((Object)graphName, (Object)graph.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]));
            Assertions.assertEquals((Object)backend, (Object)graph.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0]));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    @Test
    public void shouldCreateAndGetGraphUsingTemplateConfiguration() throws Exception {
        try {
            ConfiguredGraphFactory.createTemplateConfiguration((Configuration)this.getTemplateConfig());
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph1");
            StandardJanusGraph graph1 = (StandardJanusGraph)ConfiguredGraphFactory.open((String)"graph1");
            Assertions.assertNotNull((Object)graph);
            Assertions.assertEquals((Object)graph, (Object)graph1);
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)"graph1");
            ConfiguredGraphFactory.close((String)"graph1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void graphConfigurationShouldBeWhatWeExpectWhenUsingTemplateConfiguration() throws Exception {
        try {
            MapConfiguration templateConfig = this.getTemplateConfig();
            ConfiguredGraphFactory.createTemplateConfiguration((Configuration)templateConfig);
            String backend = templateConfig.getString(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot());
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph1");
            StandardJanusGraph graph1 = (StandardJanusGraph)ConfiguredGraphFactory.open((String)"graph1");
            Assertions.assertNotNull((Object)graph);
            Assertions.assertEquals((Object)graph, (Object)graph1);
            Assertions.assertEquals((Object)"graph1", (Object)graph.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]));
            Assertions.assertEquals((Object)backend, (Object)graph.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.STORAGE_BACKEND, new String[0]));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)"graph1");
            ConfiguredGraphFactory.close((String)"graph1");
        }
    }

    @Test
    public void shouldThrowConfigurationDoesNotExistError() {
        RuntimeException graph1 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConfiguredGraphFactory.open((String)"graph1"));
        Assertions.assertEquals((Object)"Please create configuration for this graph using the ConfigurationManagementGraph#createConfiguration API.", (Object)graph1.getMessage());
    }

    @Test
    public void shouldThrowTemplateConfigurationDoesNotExistError() {
        RuntimeException graph1 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConfiguredGraphFactory.create((String)"graph1"));
        Assertions.assertEquals((Object)"Please create a template Configuration using the ConfigurationManagementGraph#createTemplateConfiguration API.", (Object)graph1.getMessage());
    }

    @Test
    public void shouldFailToOpenNewGraphAfterRemoveConfiguration() {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
        ConfiguredGraphFactory.removeConfiguration((String)graphName);
        RuntimeException graph1 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConfiguredGraphFactory.open((String)graphName));
        Assertions.assertEquals((Object)"Please create configuration for this graph using the ConfigurationManagementGraph#createConfiguration API.", (Object)graph1.getMessage());
    }

    @Test
    public void shouldFailToCreateGraphAfterRemoveTemplateConfiguration() {
        ConfiguredGraphFactory.createTemplateConfiguration((Configuration)this.getTemplateConfig());
        ConfiguredGraphFactory.removeTemplateConfiguration();
        RuntimeException graph1 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConfiguredGraphFactory.create((String)"graph1"));
        Assertions.assertEquals((Object)"Please create a template Configuration using the ConfigurationManagementGraph#createTemplateConfiguration API.", (Object)graph1.getMessage());
    }

    @Test
    public void shouldFailToOpenGraphAfterRemoveConfiguration() {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
        ConfiguredGraphFactory.removeConfiguration((String)graphName);
        RuntimeException graph1 = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConfiguredGraphFactory.create((String)graphName));
        Assertions.assertEquals((Object)"Please create a template Configuration using the ConfigurationManagementGraph#createTemplateConfiguration API.", (Object)graph1.getMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateConfigurationShouldNotUpdateUserProvidedMap() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            HashMap map = new HashMap();
            ConfiguredGraphFactory.updateConfiguration((String)graphName, (Configuration)new MapConfiguration(map));
            Assertions.assertTrue((boolean)map.isEmpty());
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void updateConfigurationShouldRemoveGraphFromCache() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            Map map = graphConfig.getMap();
            map.put(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot(), "localhost,localhost");
            ConfiguredGraphFactory.updateConfiguration((String)graphName, (Configuration)new MapConfiguration(map));
            Assertions.assertNull((Object)gm.getGraph(graphName));
            Assertions.assertNotNull((Object)ConfiguredGraphFactory.open((String)graphName));
            Map map2 = graphConfig.getMap();
            map2.put(GraphDatabaseConfiguration.STORAGE_BACKEND.toStringWithoutRoot(), "bogusBackend");
            ConfiguredGraphFactory.updateConfiguration((String)graphName, (Configuration)new MapConfiguration(map2));
            Assertions.assertNull((Object)gm.getGraph(graphName));
            IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> ConfiguredGraphFactory.open((String)graphName));
            Assertions.assertEquals((Object)"Could not find implementation class: bogusBackend", (Object)exception.getMessage());
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeConfigurationShouldRemoveGraphFromCache() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            Assertions.assertNull((Object)gm.getGraph(graphName));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeConfigurationFailsToRemovingGraphNameKey() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            Assertions.assertThrows(IllegalArgumentException.class, () -> ConfiguredGraphFactory.removeConfiguration((String)graphName, Collections.singleton(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot())));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeConfigurationShouldRemoveOneKey() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            Map map = graphConfig.getMap();
            map.put(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot(), "localhost");
            ConfiguredGraphFactory.updateConfiguration((String)graphName, (Configuration)new MapConfiguration(map));
            Assertions.assertNotNull((Object)ConfiguredGraphFactory.open((String)graphName));
            Assertions.assertEquals((Object)"localhost", ConfiguredGraphFactory.getConfiguration((String)graphName).get(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot()));
            ConfiguredGraphFactory.removeConfiguration((String)graphName, Collections.singleton(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot()));
            Assertions.assertNotNull((Object)ConfiguredGraphFactory.open((String)graphName));
            Assertions.assertFalse((boolean)ConfiguredGraphFactory.getConfiguration((String)graphName).containsKey(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot()));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void removeConfigurationShouldRemoveMultipleKeys() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            Map map = graphConfig.getMap();
            map.put(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot(), "localhost");
            map.put(GraphDatabaseConfiguration.CONNECTION_TIMEOUT.toStringWithoutRoot(), 20000L);
            ConfiguredGraphFactory.updateConfiguration((String)graphName, (Configuration)new MapConfiguration(map));
            Assertions.assertNotNull((Object)ConfiguredGraphFactory.open((String)graphName));
            Assertions.assertEquals((Object)"localhost", ConfiguredGraphFactory.getConfiguration((String)graphName).get(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot()));
            Assertions.assertEquals((Object)20000L, ConfiguredGraphFactory.getConfiguration((String)graphName).get(GraphDatabaseConfiguration.CONNECTION_TIMEOUT.toStringWithoutRoot()));
            HashSet<String> configurationKeys = new HashSet<String>();
            configurationKeys.add(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot());
            configurationKeys.add(GraphDatabaseConfiguration.CONNECTION_TIMEOUT.toStringWithoutRoot());
            ConfiguredGraphFactory.removeConfiguration((String)graphName, configurationKeys);
            Assertions.assertNotNull((Object)ConfiguredGraphFactory.open((String)graphName));
            Assertions.assertFalse((boolean)ConfiguredGraphFactory.getConfiguration((String)graphName).containsKey(GraphDatabaseConfiguration.STORAGE_HOSTS.toStringWithoutRoot()));
            Assertions.assertFalse((boolean)ConfiguredGraphFactory.getConfiguration((String)graphName).containsKey(GraphDatabaseConfiguration.CONNECTION_TIMEOUT.toStringWithoutRoot()));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dropGraphShouldRemoveGraphFromCache() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            ConfiguredGraphFactory.drop((String)graphName);
            Assertions.assertNull((Object)gm.getGraph(graphName));
            Assertions.assertTrue((boolean)graph.isClosed());
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    @Test
    public void shouldBeAbleToRemoveBogusConfiguration() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToDropBogusGraph() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            Assertions.assertNotNull((Object)graph);
            ConfiguredGraphFactory.drop((String)graphName);
            RuntimeException exception = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> ConfiguredGraphFactory.open((String)graphName));
            Assertions.assertEquals((Object)"Please create configuration for this graph using the ConfigurationManagementGraph#createConfiguration API.", (Object)exception.getMessage());
        }
        finally {
            ConfiguredGraphFactory.drop((String)graphName);
        }
    }

    @Test
    public void shouldCreateTwoGraphsUsingSameTemplateConfiguration() throws Exception {
        try {
            ConfiguredGraphFactory.createTemplateConfiguration((Configuration)this.getTemplateConfig());
            StandardJanusGraph graph1 = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph1");
            StandardJanusGraph graph2 = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph2");
            Assertions.assertNotNull((Object)graph1);
            Assertions.assertNotNull((Object)graph2);
            Assertions.assertEquals((Object)"graph1", (Object)graph1.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]));
            Assertions.assertEquals((Object)"graph2", (Object)graph2.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)"graph1");
            ConfiguredGraphFactory.removeConfiguration((String)"graph2");
            ConfiguredGraphFactory.close((String)"graph1");
            ConfiguredGraphFactory.close((String)"graph2");
        }
    }

    @Test
    public void ensureCallingGraphCloseResultsInNewGraphReferenceOnNextCallToOpen() throws Exception {
        try {
            ConfiguredGraphFactory.createTemplateConfiguration((Configuration)this.getTemplateConfig());
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph1");
            Assertions.assertNotNull((Object)graph);
            Assertions.assertEquals((Object)"graph1", (Object)graph.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]));
            graph.close();
            Assertions.assertTrue((boolean)graph.isClosed());
            StandardJanusGraph newGraph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)"graph1");
            Assertions.assertFalse((boolean)newGraph.isClosed());
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)"graph1");
            ConfiguredGraphFactory.close((String)"graph1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void dropShouldCleanUpTraversalSourceAndBindings() throws Exception {
        MapConfiguration graphConfig = this.getGraphConfig();
        String graphName = graphConfig.getString(GraphDatabaseConfiguration.GRAPH_NAME.toStringWithoutRoot());
        String graphNameTraversal = graphName + "_traversal";
        try {
            ConfiguredGraphFactory.createConfiguration((Configuration)graphConfig);
            JanusGraphManager jgm = JanusGraphManager.getInstance();
            SimpleBindings bindings = new SimpleBindings();
            jgm.configureGremlinExecutor(AbstractConfiguredGraphFactoryTest.mockGremlinExecutor(bindings));
            StandardJanusGraph graph = (StandardJanusGraph)ConfiguredGraphFactory.open((String)graphName);
            jgm.putTraversalSource(ConfiguredGraphFactory.toTraversalSourceName((String)graphName), (TraversalSource)graph.traversal());
            Assertions.assertNotNull((Object)jgm.getGraph(graphName));
            Assertions.assertEquals((Object)ConfiguredGraphFactory.toTraversalSourceName((String)graphName), jgm.getTraversalSourceNames().iterator().next());
            Assertions.assertTrue((boolean)bindings.containsKey(graphName));
            Assertions.assertTrue((boolean)bindings.containsKey(graphNameTraversal));
            ConfiguredGraphFactory.drop((String)graphName);
            Assertions.assertNull((Object)jgm.getGraph(graphName));
            Assertions.assertTrue((boolean)jgm.getTraversalSourceNames().isEmpty());
            Assertions.assertFalse((boolean)bindings.containsKey(graphName));
            Assertions.assertFalse((boolean)bindings.containsKey(graphNameTraversal));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)graphName);
            ConfiguredGraphFactory.close((String)graphName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldGetGraphNames() throws Exception {
        try {
            ConfiguredGraphFactory.createTemplateConfiguration((Configuration)this.getTemplateConfig());
            StandardJanusGraph graph1 = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph1");
            StandardJanusGraph graph2 = (StandardJanusGraph)ConfiguredGraphFactory.create((String)"graph2");
            Assertions.assertNotNull((Object)graph1);
            Assertions.assertNotNull((Object)graph2);
            Set graphNames = ConfiguredGraphFactory.getGraphNames();
            Assertions.assertEquals((int)2, (int)graphNames.size());
            Assertions.assertTrue((boolean)graphNames.contains("graph1"));
            Assertions.assertTrue((boolean)graphNames.contains("graph2"));
            Assertions.assertEquals((Object)"graph1", (Object)graph1.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]));
            Assertions.assertEquals((Object)"graph2", (Object)graph2.getConfiguration().getConfiguration().get(GraphDatabaseConfiguration.GRAPH_NAME, new String[0]));
        }
        finally {
            ConfiguredGraphFactory.removeConfiguration((String)"graph1");
            ConfiguredGraphFactory.removeConfiguration((String)"graph2");
            ConfiguredGraphFactory.close((String)"graph1");
            ConfiguredGraphFactory.close((String)"graph2");
        }
    }

    private static GremlinExecutor mockGremlinExecutor(Bindings bindings) {
        GremlinExecutor gremlinExecutor = (GremlinExecutor)Mockito.mock(GremlinExecutor.class);
        GremlinScriptEngineManager scriptEngineManager = (GremlinScriptEngineManager)Mockito.mock(GremlinScriptEngineManager.class);
        Mockito.when((Object)gremlinExecutor.getScriptEngineManager()).thenReturn((Object)scriptEngineManager);
        Mockito.when((Object)gremlinExecutor.getScriptEngineManager().getBindings()).thenReturn((Object)bindings);
        ((GremlinScriptEngineManager)Mockito.doAnswer(invocation -> {
            bindings.put((String)invocation.getArgument(0), invocation.getArgument(1));
            return null;
        }).when((Object)scriptEngineManager)).put((String)ArgumentMatchers.any(String.class), ArgumentMatchers.any(Object.class));
        ((GremlinScriptEngineManager)Mockito.doAnswer(invocation -> bindings.get(invocation.getArgument(0))).when((Object)scriptEngineManager)).get((String)ArgumentMatchers.any(String.class));
        return gremlinExecutor;
    }
}

