/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.JanusGraphBaseStoreFeaturesTest;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.RelationType;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ConfigOption;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.log.Log;
import org.janusgraph.diskstorage.log.LogManager;
import org.janusgraph.diskstorage.log.kcvs.KCVSLogManager;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.internal.OrderList;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.olap.VertexJobConverter;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.query.graph.GraphCentricQueryBuilder;
import org.janusgraph.graphdb.query.profile.QueryProfiler;
import org.janusgraph.graphdb.query.profile.SimpleQueryProfiler;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.testutil.TestGraphConfigs;
import org.janusgraph.util.datastructures.IterablesUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class JanusGraphBaseTest
implements JanusGraphBaseStoreFeaturesTest {
    public static final String LABEL_NAME = T.label.getAccessor();
    public static final String ID_NAME = T.id.getAccessor();
    public WriteConfiguration config;
    public BasicConfiguration readConfig;
    public StandardJanusGraph graph;
    public StoreFeatures features;
    public JanusGraphTransaction tx;
    public JanusGraphManagement mgmt;
    public TestInfo testInfo;
    public Map<String, LogManager> logManagers;
    private KeyColumnValueStoreManager logStoreManager = null;
    public static final int DEFAULT_THREAD_COUNT = 4;

    public abstract WriteConfiguration getConfiguration();

    public Configuration getConfig() {
        return new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config.copy(), BasicConfiguration.Restriction.NONE);
    }

    public static void clearGraph(WriteConfiguration config) throws BackendException {
        JanusGraphBaseTest.getBackend(config, true).clearStorage();
    }

    public static Backend getBackend(WriteConfiguration config, boolean initialize) throws BackendException {
        ModifiableConfiguration adjustedConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config.copy(), BasicConfiguration.Restriction.NONE);
        adjustedConfig.set(GraphDatabaseConfiguration.LOCK_LOCAL_MEDIATOR_GROUP, (Object)"tmp", new String[0]);
        adjustedConfig.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"inst", new String[0]);
        Backend backend = new Backend((Configuration)adjustedConfig);
        if (initialize) {
            backend.initialize((Configuration)adjustedConfig);
        }
        return backend;
    }

    @Override
    public StoreFeatures getStoreFeatures() {
        return this.features;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
        this.config = this.getConfiguration();
        TestGraphConfigs.applyOverrides(this.config);
        Preconditions.checkNotNull((Object)this.config);
        this.logManagers = new HashMap<String, LogManager>();
        JanusGraphBaseTest.clearGraph(this.config);
        this.readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config, BasicConfiguration.Restriction.NONE);
        this.open(this.config);
    }

    public void open(WriteConfiguration config) {
        this.graph = (StandardJanusGraph)JanusGraphFactory.open((ReadConfiguration)config);
        this.features = this.graph.getConfiguration().getStoreFeatures();
        this.tx = this.graph.newTransaction();
        this.mgmt = this.graph.openManagement();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.close();
        this.closeLogs();
    }

    public void finishSchema() {
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.commit();
        }
        this.mgmt = this.graph.openManagement();
        this.newTx();
        this.graph.tx().commit();
    }

    public void close() {
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.rollback();
        }
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        if (null != this.graph && this.graph.isOpen()) {
            this.graph.close();
        }
    }

    public void newTx() {
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        this.tx = this.graph.newTransaction();
    }

    public static Map<TestConfigOption, Object> validateConfigOptions(Object ... settings) {
        Preconditions.checkArgument((settings.length % 2 == 0 ? 1 : 0) != 0, (String)"Expected even number of settings: %s", (Object[])settings);
        HashMap options = Maps.newHashMap();
        for (int i = 0; i < settings.length; i += 2) {
            Preconditions.checkArgument((boolean)(settings[i] instanceof TestConfigOption), (String)"Expected configuration option but got: %s", (Object)settings[i]);
            Preconditions.checkNotNull((Object)settings[i + 1], (String)"Null setting at position [%s]", (int)(i + 1));
            options.put((TestConfigOption)settings[i], settings[i + 1]);
        }
        return options;
    }

    public void clopen(Object ... settings) {
        this.config = this.getConfiguration();
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.rollback();
        }
        if (null != this.tx && this.tx.isOpen()) {
            this.tx.commit();
        }
        if (settings != null && settings.length > 0) {
            Map<TestConfigOption, Object> options = JanusGraphBaseTest.validateConfigOptions(settings);
            JanusGraphManagement janusGraphManagement = null;
            ModifiableConfiguration modifiableConfiguration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.config, BasicConfiguration.Restriction.LOCAL);
            for (Map.Entry<TestConfigOption, Object> option : options.entrySet()) {
                if (option.getKey().option.isLocal()) {
                    modifiableConfiguration.set(option.getKey().option, option.getValue(), option.getKey().umbrella);
                    continue;
                }
                if (janusGraphManagement == null) {
                    janusGraphManagement = this.graph.openManagement();
                }
                janusGraphManagement.set(ConfigElement.getPath((ConfigElement)option.getKey().option, (String[])option.getKey().umbrella), option.getValue());
            }
            if (janusGraphManagement != null) {
                janusGraphManagement.commit();
            }
            modifiableConfiguration.close();
        }
        if (null != this.graph && null != this.graph.tx() && this.graph.tx().isOpen()) {
            this.graph.tx().commit();
        }
        if (null != this.graph && this.graph.isOpen()) {
            this.graph.close();
        }
        Preconditions.checkNotNull((Object)this.config);
        this.open(this.config);
    }

    public static TestConfigOption option(ConfigOption option, String ... umbrella) {
        return new TestConfigOption(option, umbrella);
    }

    private void closeLogs() {
        try {
            for (LogManager lm : this.logManagers.values()) {
                lm.close();
            }
            this.logManagers.clear();
            if (this.logStoreManager != null) {
                this.logStoreManager.close();
                this.logStoreManager = null;
            }
        }
        catch (BackendException e) {
            throw new JanusGraphException((Throwable)e);
        }
    }

    public void closeLogManager(String logManagerName) {
        if (this.logManagers.containsKey(logManagerName)) {
            try {
                this.logManagers.remove(logManagerName).close();
            }
            catch (BackendException e) {
                throw new JanusGraphException("Could not close log manager " + logManagerName, (Throwable)e);
            }
        }
    }

    public Log openUserLog(String identifier) {
        return this.openLog("user", "ulog_" + identifier);
    }

    public Log openTxLog() {
        return this.openLog("tx", "txlog");
    }

    private Log openLog(String logManagerName, String logName) {
        try {
            StoreFeatures f;
            boolean part;
            ModifiableConfiguration configuration = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, this.config.copy(), BasicConfiguration.Restriction.NONE);
            configuration.set(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID, (Object)"reader", new String[0]);
            configuration.set(GraphDatabaseConfiguration.LOG_READ_INTERVAL, (Object)Duration.ofMillis(500L), new String[]{logManagerName});
            if (this.logStoreManager == null) {
                this.logStoreManager = Backend.getStorageManager((Configuration)configuration);
            }
            boolean bl = part = (f = this.logStoreManager.getFeatures()).isDistributed() && f.isKeyOrdered();
            if (part) {
                for (String partitionedLogName : new String[]{"user", "tx", "janusgraph"}) {
                    configuration.set(KCVSLogManager.LOG_MAX_PARTITIONS, (Object)8, new String[]{partitionedLogName});
                }
            }
            Preconditions.checkNotNull((Object)this.logStoreManager);
            if (!this.logManagers.containsKey(logManagerName)) {
                Configuration logConfig = configuration.restrictTo(new String[]{logManagerName});
                Preconditions.checkState((boolean)((String)logConfig.get(GraphDatabaseConfiguration.LOG_BACKEND, new String[0])).equals(GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue()));
                this.logManagers.put(logManagerName, (LogManager)new KCVSLogManager(this.logStoreManager, logConfig));
            }
            Preconditions.checkState((boolean)this.logManagers.containsKey(logManagerName));
            return this.logManagers.get(logManagerName).openLog(logName);
        }
        catch (BackendException e) {
            throw new JanusGraphException("Could not open log: " + logName, (Throwable)e);
        }
    }

    public PropertyKey makeVertexIndexedKey(String name, Class dataType) {
        PropertyKey key = this.mgmt.makePropertyKey(name).dataType(dataType).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(name, Vertex.class).addKey(key).buildCompositeIndex();
        return key;
    }

    public PropertyKey makeVertexIndexedUniqueKey(String name, Class dataType) {
        PropertyKey key = this.mgmt.makePropertyKey(name).dataType(dataType).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(name, Vertex.class).addKey(key).unique().buildCompositeIndex();
        return key;
    }

    public void createExternalVertexIndex(PropertyKey key, String backingIndex) {
        this.createExternalIndex(key, Vertex.class, backingIndex);
    }

    public void createExternalEdgeIndex(PropertyKey key, String backingIndex) {
        this.createExternalIndex(key, Edge.class, backingIndex);
    }

    public JanusGraphIndex getExternalIndex(Class<? extends Element> clazz, String backingIndex) {
        String prefix;
        if (Vertex.class.isAssignableFrom(clazz)) {
            prefix = "v";
        } else if (Edge.class.isAssignableFrom(clazz)) {
            prefix = "e";
        } else if (JanusGraphVertexProperty.class.isAssignableFrom(clazz)) {
            prefix = "p";
        } else {
            throw new AssertionError((Object)clazz.toString());
        }
        String indexName = prefix + backingIndex;
        JanusGraphIndex index = this.mgmt.getGraphIndex(indexName);
        if (index == null) {
            index = this.mgmt.buildIndex(indexName, clazz).buildMixedIndex(backingIndex);
        }
        return index;
    }

    private void createExternalIndex(PropertyKey key, Class<? extends Element> clazz, String backingIndex) {
        this.mgmt.addIndexKey(this.getExternalIndex(clazz, backingIndex), key, new Parameter[0]);
    }

    public PropertyKey makeKey(String name, Class dataType) {
        return this.mgmt.makePropertyKey(name).dataType(dataType).cardinality(Cardinality.SINGLE).make();
    }

    public EdgeLabel makeLabel(String name) {
        return this.mgmt.makeEdgeLabel(name).make();
    }

    public EdgeLabel makeKeyedEdgeLabel(String name, PropertyKey sort, PropertyKey signature) {
        return ((StandardEdgeLabelMaker)this.tx.makeEdgeLabel(name)).sortKey(new PropertyKey[]{sort}).signature(new PropertyKey[]{signature}).directed().make();
    }

    public static int getThreadCount() {
        String s = System.getProperty("janusgraph.test.threads");
        if (null != s) {
            return Integer.parseInt(s);
        }
        return 4;
    }

    public static int wrapAround(int value, int maxValue) {
        if ((value %= maxValue) < 0) {
            value += maxValue;
        }
        return value;
    }

    public JanusGraphVertex getVertex(String key, Object value) {
        return JanusGraphBaseTest.getVertex(this.tx, key, value);
    }

    public JanusGraphVertex getVertex(PropertyKey key, Object value) {
        return JanusGraphBaseTest.getVertex(this.tx, key, value);
    }

    public static JanusGraphVertex getVertex(JanusGraphTransaction tx, String key, Object value) {
        return JanusGraphBaseTest.getOnlyElement(tx.query().has(key, value).vertices(), null);
    }

    public static JanusGraphVertex getVertex(JanusGraphTransaction tx, PropertyKey key, Object value) {
        return JanusGraphBaseTest.getVertex(tx, key.name(), value);
    }

    public static double round(double d) {
        return (double)Math.round(d * 1000.0) / 1000.0;
    }

    public static JanusGraphVertex getOnlyVertex(JanusGraphQuery<?> query) {
        return (JanusGraphVertex)JanusGraphBaseTest.getOnlyElement(query.vertices());
    }

    public static JanusGraphEdge getOnlyEdge(JanusGraphVertexQuery<?> query) {
        return (JanusGraphEdge)JanusGraphBaseTest.getOnlyElement(query.edges());
    }

    public static <E> E getOnlyElement(Iterable<E> traversal) {
        return JanusGraphBaseTest.getOnlyElement(traversal.iterator());
    }

    public static <E> E getOnlyElement(Iterator<E> traversal) {
        if (!traversal.hasNext()) {
            throw new NoSuchElementException();
        }
        return JanusGraphBaseTest.getOnlyElement(traversal, null);
    }

    public static <E> E getOnlyElement(Iterable<E> traversal, E defaultElement) {
        return JanusGraphBaseTest.getOnlyElement(traversal.iterator(), defaultElement);
    }

    public static <E> E getOnlyElement(Iterator<E> traversal, E defaultElement) {
        if (!traversal.hasNext()) {
            return defaultElement;
        }
        E result = traversal.next();
        if (traversal.hasNext()) {
            throw new IllegalArgumentException("Traversal contains more than 1 element: " + result + ", " + traversal.next());
        }
        return result;
    }

    public static void assertMissing(Transaction g, Object vid) {
        Assertions.assertFalse((boolean)g.vertices(new Object[]{vid}).hasNext());
    }

    public static JanusGraphVertex getV(Transaction g, Object vid) {
        if (!g.vertices(new Object[]{vid}).hasNext()) {
            return null;
        }
        return (JanusGraphVertex)g.vertices(new Object[]{vid}).next();
    }

    public static JanusGraphEdge getE(Transaction g, Object eid) {
        if (!g.edges(new Object[]{eid}).hasNext()) {
            return null;
        }
        return (JanusGraphEdge)g.edges(new Object[]{eid}).next();
    }

    public static String n(Object obj) {
        if (obj instanceof RelationType) {
            return ((RelationType)obj).name();
        }
        return obj.toString();
    }

    public static Object getId(Element e) {
        return e.id();
    }

    public static void verifyElementOrder(Iterable<? extends Element> elements, String key, Order order, int expectedCount) {
        JanusGraphBaseTest.verifyElementOrder(elements.iterator(), key, order, expectedCount);
    }

    public static void verifyElementOrder(Iterator<? extends Element> elements, String key, Order order, int expectedCount) {
        Comparable previous = null;
        int count = 0;
        while (elements.hasNext()) {
            Element element = elements.next();
            Comparable current = (Comparable)element.value(key);
            if (previous != null) {
                int cmp = previous.compareTo(current);
                Assertions.assertTrue((boolean)(order == Order.ASC ? cmp <= 0 : cmp >= 0), (String)(previous + " <> " + current + " @ " + count));
            }
            previous = current;
            ++count;
        }
        Assertions.assertEquals((int)expectedCount, (int)count);
    }

    public static <T> Stream<T> asStream(Iterator<T> source) {
        Iterable iterable = () -> source;
        return IterablesUtil.stream(iterable);
    }

    public JanusGraph getForceIndexGraph() {
        return this.getForceIndexGraph(this.getConfiguration());
    }

    public JanusGraph getForceIndexGraph(WriteConfiguration writeConfiguration) {
        ModifiableConfiguration adjustedConfig = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, writeConfiguration, BasicConfiguration.Restriction.NONE);
        adjustedConfig.set(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, (Object)true, new String[0]);
        WriteConfiguration adjustedWriteConfig = adjustedConfig.getConfiguration();
        TestGraphConfigs.applyOverrides(adjustedWriteConfig);
        Preconditions.checkNotNull((Object)adjustedWriteConfig);
        return JanusGraphFactory.open((ReadConfiguration)adjustedWriteConfig);
    }

    protected void discardIndex(String indexName) throws InterruptedException, ExecutionException {
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.DISCARD_INDEX).get();
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.DISCARDED})).call().getSucceeded());
        this.mgmt = this.graph.openManagement();
    }

    protected void markIndexDiscarded(String indexName) throws InterruptedException, ExecutionException {
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.MARK_DISCARDED).get();
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.DISCARDED})).call().getSucceeded());
        this.mgmt = this.graph.openManagement();
    }

    protected void enableIndex(String indexName) throws InterruptedException, ExecutionException {
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.ENABLE_INDEX).get();
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.ENABLED})).call().getSucceeded());
        this.mgmt = this.graph.openManagement();
    }

    protected void dropIndex(String indexName) throws InterruptedException, ExecutionException {
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.DROP_INDEX).get();
        this.mgmt.commit();
        this.mgmt = this.graph.openManagement();
        Assertions.assertNull((Object)this.mgmt.getGraphIndex(indexName));
    }

    protected void disableIndex(String indexName) throws InterruptedException, ExecutionException {
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.DISABLE_INDEX).get();
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.DISABLED})).call().getSucceeded());
        this.mgmt = this.graph.openManagement();
    }

    public static void evaluateQuery(JanusGraphVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs) {
        JanusGraphBaseTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of());
    }

    public static void evaluateQuery(JanusGraphVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, PropertyKey orderKey, Order order) {
        JanusGraphBaseTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey, (Object)order));
    }

    public static void evaluateQuery(JanusGraphVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap) {
        Iterable result;
        SimpleQueryProfiler profiler = new SimpleQueryProfiler();
        ((BasicVertexCentricQueryBuilder)query).profiler((QueryProfiler)profiler);
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case RELATION: {
                result = query.relations();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OrderList orders = (OrderList)profiler.getAnnotation("orders");
        int no = 0;
        JanusGraphElement previous = null;
        for (JanusGraphElement e : result) {
            Assertions.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assertions.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assertions.assertEquals((int)expectedResults, (int)no);
        Assertions.assertNotNull((Object)orders);
        Assertions.assertEquals((int)orderMap.size(), (int)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assertions.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assertions.assertTrue((boolean)orders.containsKey(key));
        }
        Assertions.assertEquals((Integer)1, (Integer)((Integer)profiler.getAnnotation("vertices")));
        int subQueryCounter = 0;
        for (SimpleQueryProfiler subProfiler : profiler) {
            Assertions.assertNotNull((Object)subProfiler);
            if (subProfiler.getGroupName().equals("optimization") || Boolean.TRUE.equals(subProfiler.getAnnotation("multiSlices"))) continue;
            if (subQuerySpecs.length == 2) {
                Assertions.assertEquals((Object)subQuerySpecs[0], (Object)subProfiler.getAnnotation("isFitted"));
                Assertions.assertEquals((Object)subQuerySpecs[1], (Object)subProfiler.getAnnotation("isOrdered"));
            }
            ++subQueryCounter;
        }
        Assertions.assertEquals((int)numSubQueries, (int)subQueryCounter);
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, String ... intersectingIndexes) {
        JanusGraphBaseTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1), intersectingIndexes);
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, PropertyKey orderKey2, Order order2, String ... intersectingIndexes) {
        JanusGraphBaseTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1, (Object)orderKey2, (Object)order2), intersectingIndexes);
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, String ... intersectingIndexes) {
        JanusGraphBaseTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of(), intersectingIndexes);
    }

    public static void evaluateQuery(JanusGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap, String ... intersectingIndexes) {
        Iterable result;
        if (intersectingIndexes == null) {
            intersectingIndexes = new String[]{};
        }
        SimpleQueryProfiler profiler = new SimpleQueryProfiler();
        ((GraphCentricQueryBuilder)query).profiler((QueryProfiler)profiler);
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case VERTEX: {
                result = query.vertices();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        OrderList orders = (OrderList)profiler.getAnnotation("orders");
        int no = 0;
        JanusGraphElement previous = null;
        for (JanusGraphElement e : result) {
            Assertions.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assertions.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assertions.assertEquals((int)expectedResults, (int)no);
        Assertions.assertNotNull((Object)orders);
        Assertions.assertEquals((int)orderMap.size(), (int)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assertions.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assertions.assertTrue((boolean)orders.containsKey(key));
        }
        SimpleQueryProfiler simpleQueryProfiler = (SimpleQueryProfiler)Iterables.getOnlyElement((Iterable)IterablesUtil.stream((Iterable)profiler).filter(p -> !p.getGroupName().equals("optimization")).collect(Collectors.toList()));
        if (subQuerySpecs.length == 2) {
            Assertions.assertEquals((Object)subQuerySpecs[0], (Object)simpleQueryProfiler.getAnnotation("isFitted"));
            Assertions.assertEquals((Object)subQuerySpecs[1], (Object)simpleQueryProfiler.getAnnotation("isOrdered"));
        }
        HashSet<Object> indexNames = new HashSet<Object>();
        int indexQueries = 0;
        boolean fullScan = false;
        for (SimpleQueryProfiler indexProfiler : simpleQueryProfiler) {
            if (indexProfiler.getAnnotation("fullscan") != null) {
                fullScan = true;
                continue;
            }
            indexNames.add(indexProfiler.getAnnotation("index"));
            ++indexQueries;
        }
        if (indexQueries > 0) {
            Assertions.assertFalse((boolean)fullScan);
        }
        if (fullScan) {
            Assertions.assertEquals((int)0, (int)intersectingIndexes.length);
        }
        Assertions.assertEquals((int)intersectingIndexes.length, (int)indexQueries);
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])intersectingIndexes), indexNames);
    }

    protected ScanMetrics executeScanJob(VertexScanJob job) throws Exception {
        return this.executeScanJob(VertexJobConverter.convert((JanusGraph)this.graph, (VertexScanJob)job));
    }

    protected ScanMetrics executeScanJob(ScanJob job) throws Exception {
        return (ScanMetrics)this.graph.getBackend().buildEdgeScanJob().setNumProcessingThreads(2).setWorkBlockSize(100).setJob(job).execute().get();
    }

    public static final class TestConfigOption {
        public final ConfigOption option;
        public final String[] umbrella;

        public TestConfigOption(ConfigOption option, String ... umbrella) {
            Preconditions.checkNotNull((Object)option);
            this.option = option;
            if (umbrella == null) {
                umbrella = new String[]{};
            }
            this.umbrella = umbrella;
        }
    }
}

