/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.MapConfiguration;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.configuration.builder.GraphDatabaseConfigurationBuilder;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.util.system.ConfigurationUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public abstract class GraphDatabaseConfigurationInstanceIdTest {
    private static final String NON_UNIQUE_INSTANCE_ID = "not-unique";
    private static final String NON_UNIQUE_CURRENT_INSTANCE_ID = GraphDatabaseConfigurationInstanceIdTest.toCurrentInstance("not-unique");

    public abstract Map<String, Object> getStorageConfiguration();

    @Test
    public void graphShouldOpenWithSameInstanceId() {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID.toStringWithoutRoot(), NON_UNIQUE_INSTANCE_ID);
        map.put(GraphDatabaseConfiguration.REPLACE_INSTANCE_IF_EXISTS.toStringWithoutRoot(), true);
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        StandardJanusGraph graph1 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)graph1.openManagement().getOpenInstances().size(), (int)1);
        Assertions.assertEquals((Object)NON_UNIQUE_CURRENT_INSTANCE_ID, graph1.openManagement().getOpenInstances().iterator().next());
        StandardJanusGraph graph2 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)1, (int)graph1.openManagement().getOpenInstances().size());
        Assertions.assertEquals((Object)NON_UNIQUE_CURRENT_INSTANCE_ID, graph1.openManagement().getOpenInstances().iterator().next());
        Assertions.assertEquals((int)1, (int)graph2.openManagement().getOpenInstances().size());
        Assertions.assertEquals((Object)NON_UNIQUE_CURRENT_INSTANCE_ID, graph2.openManagement().getOpenInstances().iterator().next());
        graph1.close();
        graph2.close();
    }

    @Disabled(value="Not working anymore. The bug is tracked here: https://github.com/JanusGraph/janusgraph/issues/2696")
    @Test
    public void graphShouldNotOpenWithSameInstanceId() {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID.toStringWithoutRoot(), NON_UNIQUE_INSTANCE_ID);
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        StandardJanusGraph graph1 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)1, (int)graph1.openManagement().getOpenInstances().size());
        Assertions.assertEquals((Object)NON_UNIQUE_CURRENT_INSTANCE_ID, graph1.openManagement().getOpenInstances().iterator().next());
        JanusGraphException janusGraphException = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> {
            StandardJanusGraph graph2 = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
            graph1.close();
        });
        Assertions.assertEquals((Object)"A JanusGraph graph with the same instance id [not-unique] is already open. Might required forced shutdown.", (Object)janusGraphException.getMessage());
    }

    @Test
    public void instanceIdShouldEqualHostname() throws UnknownHostException {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)1, (int)graph.openManagement().getOpenInstances().size());
        Assertions.assertEquals((Object)GraphDatabaseConfigurationInstanceIdTest.toCurrentInstance(Inet4Address.getLocalHost().getHostName()), graph.openManagement().getOpenInstances().iterator().next());
        graph.close();
    }

    @Test
    public void instanceIdShouldEqualHostnamePlusSuffix() throws UnknownHostException {
        Map<String, Object> map = this.getStorageConfiguration();
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_HOSTNAME.toStringWithoutRoot(), true);
        map.put(GraphDatabaseConfiguration.UNIQUE_INSTANCE_ID_SUFFIX.toStringWithoutRoot(), 1);
        MapConfiguration config = ConfigurationUtil.loadMapConfiguration(map);
        StandardJanusGraph graph = new StandardJanusGraph(new GraphDatabaseConfigurationBuilder().build((ReadConfiguration)new CommonsConfiguration((Configuration)config)));
        Assertions.assertEquals((int)1, (int)graph.openManagement().getOpenInstances().size());
        Assertions.assertEquals((Object)GraphDatabaseConfigurationInstanceIdTest.toCurrentInstance(Inet4Address.getLocalHost().getHostName() + "1"), graph.openManagement().getOpenInstances().iterator().next());
        graph.close();
    }

    private static String toCurrentInstance(String instanceId) {
        return ConfigElement.replaceIllegalChars((String)instanceId) + "(current)";
    }
}

