/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.janusgraph.JanusGraphBaseStoreFeaturesTest;
import org.janusgraph.diskstorage.AbstractKCVSTest;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.KeyColumn;
import org.janusgraph.diskstorage.KeyColumnValueStoreUtil;
import org.janusgraph.diskstorage.KeyValueStoreUtil;
import org.janusgraph.diskstorage.SimpleScanJob;
import org.janusgraph.diskstorage.SimpleScanJobRunner;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.StoreMetaData;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.KCVSUtil;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreFeatures;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanJob;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.diskstorage.keycolumnvalue.scan.StandardScanner;
import org.janusgraph.diskstorage.keycolumnvalue.ttl.TTLKCVSManager;
import org.janusgraph.diskstorage.util.BufferUtil;
import org.janusgraph.diskstorage.util.ReadArrayBuffer;
import org.janusgraph.diskstorage.util.RecordIterator;
import org.janusgraph.diskstorage.util.StaticArrayBuffer;
import org.janusgraph.diskstorage.util.StaticArrayEntry;
import org.janusgraph.testutil.FeatureFlag;
import org.janusgraph.testutil.JanusGraphFeature;
import org.janusgraph.testutil.RandomGenerator;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KeyColumnValueStoreTest
extends AbstractKCVSTest
implements JanusGraphBaseStoreFeaturesTest {
    public static final int TRIALS = 5000;
    private final Logger log = LoggerFactory.getLogger(KeyColumnValueStoreTest.class);
    final int numKeys = 500;
    final int numColumns = 50;
    protected final String storeName = "testStore1";
    public KeyColumnValueStoreManager manager;
    public StoreTransaction tx;
    public KeyColumnValueStore store;

    @BeforeEach
    public void setUp() throws Exception {
        KeyColumnValueStoreManager m = this.openStorageManager();
        m.clearStorage();
        m.close();
        this.open();
    }

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    public void open() throws BackendException {
        this.manager = this.openStorageManager();
        this.store = this.manager.openDatabase("testStore1");
        this.tx = this.startTx();
    }

    @Override
    public StoreFeatures getStoreFeatures() {
        return this.manager.getFeatures();
    }

    public StoreTransaction startTx() throws BackendException {
        return this.manager.beginTransaction((BaseTransactionConfig)this.getTxConfig());
    }

    public StoreFeatures storeFeatures() {
        return this.manager.getFeatures();
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        if (null != this.store) {
            this.store.close();
        }
        if (null != this.manager) {
            this.manager.close();
        }
    }

    public void newTx() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.tx = this.startTx();
    }

    @Test
    public void createDatabase() {
    }

    public String[][] generateValues() {
        return KeyValueStoreUtil.generateData(500, 50);
    }

    public void loadValues(String[][] values) throws BackendException {
        KeyColumnValueStoreUtil.loadValues(this.store, this.tx, values);
    }

    public void loadValues(String[][] values, int shiftEveryNthRow, int shiftSliceLength) throws BackendException {
        KeyColumnValueStoreUtil.loadValues(this.store, this.tx, values, shiftEveryNthRow, shiftSliceLength);
    }

    public void loadLowerTriangularValues(int dimension, int offset) throws BackendException {
        Preconditions.checkArgument((0 < dimension ? 1 : 0) != 0);
        ByteBuffer val = ByteBuffer.allocate(1);
        val.put((byte)-1);
        StaticArrayBuffer staticVal = StaticArrayBuffer.of((ByteBuffer)val);
        ArrayList<Entry> rowAdditions = new ArrayList<Entry>(dimension);
        for (int k = 0; k < dimension; ++k) {
            rowAdditions.clear();
            ByteBuffer key = ByteBuffer.allocate(8);
            key.putInt(0);
            key.putInt(k + offset);
            key.flip();
            StaticArrayBuffer staticKey = StaticArrayBuffer.of((ByteBuffer)key);
            for (int c = 0; c <= k; ++c) {
                ByteBuffer col = ByteBuffer.allocate(4);
                col.putInt(c + offset);
                col.flip();
                StaticArrayBuffer staticCol = StaticArrayBuffer.of((ByteBuffer)col);
                rowAdditions.add(StaticArrayEntry.of((StaticBuffer)staticCol, (StaticBuffer)staticVal));
            }
            this.store.mutate((StaticBuffer)staticKey, rowAdditions, Collections.emptyList(), this.tx);
        }
    }

    public Set<KeyColumn> deleteValues(int every) throws BackendException {
        HashSet<KeyColumn> removed = new HashSet<KeyColumn>();
        int counter = 0;
        for (int i = 0; i < 500; ++i) {
            ArrayList<StaticBuffer> deletions = new ArrayList<StaticBuffer>();
            for (int j = 0; j < 50; ++j) {
                if (++counter % every != 0) continue;
                removed.add(new KeyColumn(i, j));
                deletions.add(KeyValueStoreUtil.getBuffer(j));
            }
            this.store.mutate(KeyValueStoreUtil.getBuffer(i), KeyColumnValueStore.NO_ADDITIONS, deletions, this.tx);
        }
        return removed;
    }

    public Set<Integer> deleteKeys(int every) throws BackendException {
        HashSet<Integer> removed = new HashSet<Integer>();
        for (int i = 0; i < 500; ++i) {
            if (i % every != 0) continue;
            removed.add(i);
            ArrayList<StaticBuffer> deletions = new ArrayList<StaticBuffer>();
            for (int j = 0; j < 50; ++j) {
                deletions.add(KeyValueStoreUtil.getBuffer(j));
            }
            this.store.mutate(KeyValueStoreUtil.getBuffer(i), KeyColumnValueStore.NO_ADDITIONS, deletions, this.tx);
        }
        return removed;
    }

    public void checkKeys(Set<Integer> removed) throws BackendException {
        for (int i = 0; i < 500; ++i) {
            if (removed.contains(i)) {
                Assertions.assertFalse((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StoreTransaction)this.tx));
                continue;
            }
            Assertions.assertTrue((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StoreTransaction)this.tx));
        }
    }

    public void checkValueExistence(String[][] values) throws BackendException {
        this.checkValueExistence(values, new HashSet<KeyColumn>());
    }

    public void checkValueExistence(String[][] values, Set<KeyColumn> removed) throws BackendException {
        for (int i = 0; i < 500; ++i) {
            for (int j = 0; j < 50; ++j) {
                boolean result = KCVSUtil.containsKeyColumn((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StaticBuffer)KeyValueStoreUtil.getBuffer(j), (StoreTransaction)this.tx);
                if (removed.contains(new KeyColumn(i, j))) {
                    Assertions.assertFalse((boolean)result);
                    continue;
                }
                Assertions.assertTrue((boolean)result);
            }
        }
    }

    public void checkValues(String[][] values) throws BackendException {
        this.checkValues(values, new HashSet<KeyColumn>());
    }

    public void checkValues(String[][] values, Set<KeyColumn> removed) throws BackendException {
        for (int i = 0; i < 500; ++i) {
            for (int j = 0; j < 50; ++j) {
                StaticBuffer result = KCVSUtil.get((KeyColumnValueStore)this.store, (StaticBuffer)KeyValueStoreUtil.getBuffer(i), (StaticBuffer)KeyValueStoreUtil.getBuffer(j), (StoreTransaction)this.tx);
                if (removed.contains(new KeyColumn(i, j))) {
                    Assertions.assertNull((Object)result);
                    continue;
                }
                Assertions.assertEquals((Object)values[i][j], (Object)KeyValueStoreUtil.getString(result));
            }
        }
    }

    @Test
    public void storeAndRetrieve() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    public void compareStores() throws BackendException {
        int keys = 1000;
        int columns = 2000;
        boolean normalMode = true;
        String[][] values = new String[2000][];
        for (int i = 0; i < 2000; ++i) {
            values[i] = i % 2 == 0 ? new String[2004] : new String[0];
            for (int j = 0; j < values[i].length; ++j) {
                values[i][j] = RandomGenerator.randomString(30, 35);
            }
        }
        this.log.debug("Loading values: 1000x2000");
        long time = System.currentTimeMillis();
        this.loadValues(values);
        this.clopen();
        System.out.println("Loading time (ms): " + (System.currentTimeMillis() - time));
        Random r = new Random();
        int trials = 500;
        this.log.debug("Reading values: " + trials + " trials");
        for (int i = 0; i < 10; ++i) {
            time = System.currentTimeMillis();
            for (int t = 0; t < trials; ++t) {
                int key = r.nextInt(1000) * 2;
                Assertions.assertEquals((int)2, (int)this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(2002), KeyValueStoreUtil.getBuffer(2004)), this.tx).size());
            }
            System.out.println("Reading time (ms): " + (System.currentTimeMillis() - time));
        }
    }

    @Test
    public void storeAndRetrievePerformance() throws BackendException {
        int multiplier = 4;
        int keys = 50 * multiplier;
        int columns = 200;
        String[][] values = KeyValueStoreUtil.generateData(keys, columns);
        this.log.debug("Loading values: " + keys + "x" + columns);
        long time = System.currentTimeMillis();
        this.loadValues(values);
        this.clopen();
        System.out.println("Loading time (ms): " + (System.currentTimeMillis() - time));
        Random r = new Random();
        int trials = 500 * multiplier;
        int delta = 10;
        this.log.debug("Reading values: " + trials + " trials");
        for (int i = 0; i < 1; ++i) {
            time = System.currentTimeMillis();
            for (int t = 0; t < trials; ++t) {
                int key = r.nextInt(keys);
                int start = r.nextInt(columns - delta);
                this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(start), KeyValueStoreUtil.getBuffer(start + delta)), this.tx);
            }
            System.out.println("Reading time (ms): " + (System.currentTimeMillis() - time));
        }
    }

    @Test
    public void storeAndRetrieveWithClosing() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values);
        this.checkValues(values);
    }

    @Test
    public void deleteColumnsTest1() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.clopen();
        Set<KeyColumn> deleted = this.deleteValues(7);
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    public void deleteColumnsTest2() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.newTx();
        Set<KeyColumn> deleted = this.deleteValues(7);
        this.clopen();
        this.log.debug("Checking values...");
        this.checkValueExistence(values, deleted);
        this.checkValues(values, deleted);
    }

    @Test
    public void deleteKeys() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.newTx();
        Set<Integer> deleted = this.deleteKeys(11);
        this.clopen();
        this.checkKeys(deleted);
    }

    @Test
    public void deleteNonExistingKeys() {
        Assertions.assertDoesNotThrow(() -> {
            List<StaticBuffer> deletions = Collections.singletonList(KeyValueStoreUtil.getBuffer(1));
            this.store.mutate(KeyValueStoreUtil.getBuffer(-559038737), KeyColumnValueStore.NO_ADDITIONS, deletions, this.tx);
        });
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.Scan)
    public void scanTest() throws BackendException {
        String[][] values = this.generateValues();
        this.loadValues(values);
        KeyIterator iterator0 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
        this.verifyIterator(iterator0, 500);
        this.clopen();
        KeyIterator iterator1 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
        KeyIterator iterator2 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
        KeyIterator iterator3 = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
        this.verifyIterator(iterator1, 500);
        this.verifyIterator(iterator2, 500);
    }

    private void verifyIterator(KeyIterator iterator, int expectedKeys) {
        int keys = 0;
        while (iterator.hasNext()) {
            StaticBuffer b = (StaticBuffer)iterator.next();
            Assertions.assertTrue((b != null && b.length() > 0 ? 1 : 0) != 0);
            ++keys;
            RecordIterator entryRecordIterator = iterator.getEntries();
            int cols = 0;
            while (entryRecordIterator.hasNext()) {
                Entry e = (Entry)entryRecordIterator.next();
                Assertions.assertTrue((e != null && e.length() > 0 ? 1 : 0) != 0);
                ++cols;
            }
            Assertions.assertEquals((int)1, (int)cols);
        }
        Assertions.assertEquals((int)expectedKeys, (int)keys);
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.OrderedScan)
    public void testOrderedGetKeysRespectsKeyLimit(TestInfo testInfo) throws BackendException {
        Preconditions.checkState((boolean)true);
        long minKey = 1001L;
        long maxKey = 1498L;
        long expectedKeyCount = 497L;
        String[][] values = this.generateValues();
        this.loadValues(values);
        SliceQuery columnSlice = new SliceQuery(BufferUtil.zeroBuffer((int)8), BufferUtil.oneBuffer((int)8)).setLimit(1);
        KeyIterator keys = this.store.getKeys(new KeyRangeQuery(BufferUtil.getLongBuffer((long)1001L), BufferUtil.getLongBuffer((long)1498L), columnSlice), this.tx);
        Assertions.assertEquals((long)497L, (long)KeyValueStoreUtil.count(keys));
        this.clopen();
        keys = this.store.getKeys(new KeyRangeQuery(BufferUtil.getLongBuffer((long)1001L), BufferUtil.getLongBuffer((long)1498L), columnSlice), this.tx);
        Assertions.assertEquals((long)497L, (long)KeyValueStoreUtil.count(keys));
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.Scan)
    public void testGetKeysColumnSlicesSimple() throws BackendException {
        int shiftEveryNthRows = 10;
        int expectedKeyCount = 450;
        Preconditions.checkArgument((boolean)true);
        Preconditions.checkArgument((boolean)true);
        String[][] values = this.generateValues();
        this.loadValues(values, 10, 4);
        KeyIterator i = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
        Assertions.assertEquals((int)450, (int)KeyValueStoreUtil.count(i));
        this.clopen();
        i = KCVSUtil.getKeys((KeyColumnValueStore)this.store, (StoreFeatures)this.storeFeatures(), (int)8, (int)4, (StoreTransaction)this.tx);
        Assertions.assertEquals((int)450, (int)KeyValueStoreUtil.count(i));
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.Scan)
    public void testGetKeysColumnSlicesOnLowerTriangular() throws BackendException, IOException {
        int offset = 10;
        int size = 10;
        int midpoint = 15;
        int upper = 20;
        boolean step = true;
        this.loadLowerTriangularValues(10, 10);
        boolean executed = false;
        if (this.manager.getFeatures().hasUnorderedScan()) {
            HashSet<StaticBuffer> expected = new HashSet<StaticBuffer>(10);
            for (int start = 15; start >= 9; --start) {
                for (int end = 16; end <= 21; ++end) {
                    Preconditions.checkArgument((start < end ? 1 : 0) != 0);
                    StaticBuffer startCol = BufferUtil.getIntBuffer((int)start);
                    StaticBuffer endCol = BufferUtil.getIntBuffer((int)end);
                    SliceQuery sq = new SliceQuery(startCol, endCol);
                    expected.clear();
                    for (long l = (long)Math.max(start, 10); l < 20L; ++l) {
                        expected.add(BufferUtil.getLongBuffer((long)l));
                    }
                    KeyIterator i = this.store.getKeys(sq, this.tx);
                    HashSet actual = Sets.newHashSet((Iterator)i);
                    this.log.debug("Checking bounds [{}, {}) (expect {} keys)", new Object[]{startCol, endCol, expected.size()});
                    Assertions.assertEquals(expected, (Object)actual);
                    i.close();
                    executed = true;
                }
            }
        } else if (this.manager.getFeatures().hasOrderedScan()) {
            ArrayList<StaticBuffer> expected = new ArrayList<StaticBuffer>(10);
            for (int start = 15; start >= 9; --start) {
                for (int end = 16; end <= 21; ++end) {
                    Preconditions.checkArgument((start < end ? 1 : 0) != 0);
                    StaticBuffer startCol = BufferUtil.getIntBuffer((int)start);
                    StaticBuffer endCol = BufferUtil.getIntBuffer((int)end);
                    SliceQuery sq = new SliceQuery(startCol, endCol);
                    StaticBuffer keyStart = BufferUtil.getLongBuffer((long)start);
                    StaticBuffer keyEnd = BufferUtil.getLongBuffer((long)end);
                    KeyRangeQuery krq = new KeyRangeQuery(keyStart, keyEnd, sq);
                    expected.clear();
                    for (long l = (long)Math.max(start, 10); l < (long)Math.min(20, end); ++l) {
                        expected.add(BufferUtil.getLongBuffer((long)l));
                    }
                    KeyIterator i = this.store.getKeys(krq, this.tx);
                    ArrayList actual = Lists.newArrayList((Iterator)i);
                    this.log.debug("Checking bounds key:[{}, {}) & col:[{}, {}) (expect {} keys)", new Object[]{keyStart, keyEnd, startCol, endCol, expected.size()});
                    Assertions.assertEquals(expected, (Object)actual);
                    i.close();
                    executed = true;
                }
            }
        } else {
            throw new UnsupportedOperationException("Illegal store configuration: supportsScan()=true but supportsOrderedScan()=supportsUnorderedScan()=false");
        }
        Preconditions.checkArgument((boolean)executed);
    }

    public void checkSlice(String[][] values, Set<KeyColumn> removed, int key, int start, int end, int limit) throws BackendException {
        this.tx.rollback();
        this.tx = this.startTx();
        EntryList entries = limit <= 0 ? this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(start), KeyValueStoreUtil.getBuffer(end)), this.tx) : this.store.getSlice(new KeySliceQuery(KeyValueStoreUtil.getBuffer(key), KeyValueStoreUtil.getBuffer(start), KeyValueStoreUtil.getBuffer(end)).setLimit(limit), this.tx);
        int pos = 0;
        for (int i = start; i < end; ++i) {
            if (removed.contains(new KeyColumn(key, i))) {
                this.log.debug("Skipping deleted ({},{})", (Object)key, (Object)i);
                continue;
            }
            if (limit <= 0 || pos < limit) {
                this.log.debug("Checking k={}[c_start={},c_end={}](limit={}): column index={}/pos={}", new Object[]{key, start, end, limit, i, pos});
                Assertions.assertTrue((entries.size() > pos ? 1 : 0) != 0);
                Entry entry = (Entry)entries.get(pos);
                int col = KeyValueStoreUtil.getID(entry.getColumn());
                String str = KeyValueStoreUtil.getString((StaticBuffer)entry.getValueAs(StaticBuffer.STATIC_FACTORY));
                Assertions.assertEquals((int)i, (int)col);
                Assertions.assertEquals((Object)values[key][i], (Object)str);
            }
            ++pos;
        }
        Assertions.assertNotNull((Object)entries);
        if (limit > 0 && pos > limit) {
            Assertions.assertEquals((int)limit, (int)entries.size());
        } else {
            Assertions.assertEquals((int)pos, (int)entries.size());
        }
    }

    @Test
    public void intervalTest1() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        HashSet deleted = Sets.newHashSet();
        this.clopen();
        this.checkRandomSlices(values, deleted);
    }

    @Test
    public void intervalTest2() throws BackendException {
        String[][] values = this.generateValues();
        this.log.debug("Loading values...");
        this.loadValues(values);
        this.newTx();
        Set<KeyColumn> deleted = this.deleteValues(7);
        this.clopen();
        this.checkRandomSlices(values, deleted);
    }

    protected void checkRandomSlices(String[][] values, Set<KeyColumn> deleted) throws BackendException {
        for (int t = 0; t < 5000; ++t) {
            int key = RandomGenerator.randomInt(0, 500);
            int start = RandomGenerator.randomInt(0, 50);
            int end = RandomGenerator.randomInt(start, 50);
            int limit = RandomGenerator.randomInt(1, 30);
            this.checkSlice(values, deleted, key, start, end, limit);
            this.checkSlice(values, deleted, key, start, end, -1);
        }
    }

    @Test
    public void testConcurrentGetSlice() throws ExecutionException, InterruptedException, BackendException {
        this.testConcurrentStoreOps(false);
    }

    @Test
    public void testConcurrentGetSliceAndMutate() throws BackendException, ExecutionException, InterruptedException {
        this.testConcurrentStoreOps(true);
    }

    protected void testConcurrentStoreOps(boolean deletionEnabled) throws BackendException, ExecutionException, InterruptedException {
        String[][] values = this.generateValues();
        this.loadValues(values);
        this.tx.commit();
        this.tx = this.startTx();
        int NUM_THREADS = 64;
        ExecutorService es = Executors.newFixedThreadPool(64);
        ArrayList<ConcurrentRandomSliceReader> tasks = new ArrayList<ConcurrentRandomSliceReader>(64);
        for (int i = 0; i < 64; ++i) {
            HashSet deleted = Sets.newHashSet();
            if (!deletionEnabled) {
                tasks.add(new ConcurrentRandomSliceReader(values, deleted, 5000));
                continue;
            }
            tasks.add(new ConcurrentRandomSliceReader(values, deleted, i, 5000));
        }
        ArrayList futures = new ArrayList(64);
        for (Runnable runnable : tasks) {
            futures.add(es.submit(runnable));
        }
        int collected = 0;
        for (Future future : futures) {
            future.get();
            ++collected;
        }
        Assertions.assertEquals((int)64, (int)collected);
    }

    @Test
    public void getNonExistentKeyReturnsNull() throws Exception {
        Assertions.assertNull((Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col0"));
        Assertions.assertNull((Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col1"));
    }

    @Test
    public void insertingGettingAndDeletingSimpleDataWorks() throws Exception {
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 0L, "col0", "val0");
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 0L, "col1", "val1");
        this.tx.commit();
        this.tx = this.startTx();
        Assertions.assertEquals((Object)"val0", (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col0"));
        Assertions.assertEquals((Object)"val1", (Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col1"));
        KeyColumnValueStoreUtil.delete(this.store, this.tx, 0L, "col0");
        KeyColumnValueStoreUtil.delete(this.store, this.tx, 0L, "col1");
        this.tx.commit();
        this.tx = this.startTx();
        Assertions.assertNull((Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col0"));
        Assertions.assertNull((Object)KeyColumnValueStoreUtil.get(this.store, this.tx, 0L, "col1"));
    }

    @Test
    public void getSliceRespectsColumnLimit() throws Exception {
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        int cols = 1024;
        LinkedList<Entry> entries = new LinkedList<Entry>();
        for (int i = 0; i < 1024; ++i) {
            StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer(i);
            entries.add(StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col));
        }
        this.store.mutate(key, entries, KeyColumnValueStore.NO_DELETIONS, this.tx);
        this.tx.commit();
        this.tx = this.startTx();
        StaticBuffer columnStart = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        StaticBuffer columnEnd = KeyColumnValueStoreUtil.longToByteBuffer(1024L);
        EntryList result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1024), this.tx);
        Assertions.assertEquals((int)1024, (int)result.size());
        for (int i = 0; i < result.size(); ++i) {
            Entry dst;
            Entry src = (Entry)entries.get(i);
            if (src.equals(dst = (Entry)result.get(i))) continue;
            boolean bl = true;
        }
        Assertions.assertEquals(entries, (Object)result);
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1034), this.tx);
        Assertions.assertEquals((int)1024, (int)result.size());
        Assertions.assertEquals(entries, (Object)result);
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1023), this.tx);
        Assertions.assertEquals((int)1023, (int)result.size());
        entries.remove(entries.size() - 1);
        Assertions.assertEquals(entries, (Object)result);
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(1), this.tx);
        Assertions.assertEquals((int)1, (int)result.size());
        List firstEntrySingleton = Collections.singletonList(entries.get(0));
        Assertions.assertEquals(firstEntrySingleton, (Object)result);
    }

    @Test
    public void getSliceRespectsAllBoundsInclusionArguments() throws Exception {
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        StaticBuffer columnBeforeStart = KeyColumnValueStoreUtil.longToByteBuffer(776L);
        StaticBuffer columnStart = KeyColumnValueStoreUtil.longToByteBuffer(777L);
        StaticBuffer columnEnd = KeyColumnValueStoreUtil.longToByteBuffer(778L);
        StaticBuffer columnAfterEnd = KeyColumnValueStoreUtil.longToByteBuffer(779L);
        List<Entry> entries = Arrays.asList(StaticArrayEntry.of((StaticBuffer)columnBeforeStart, (StaticBuffer)columnBeforeStart), StaticArrayEntry.of((StaticBuffer)columnStart, (StaticBuffer)columnStart), StaticArrayEntry.of((StaticBuffer)columnEnd, (StaticBuffer)columnEnd), StaticArrayEntry.of((StaticBuffer)columnAfterEnd, (StaticBuffer)columnAfterEnd));
        this.store.mutate(key, entries, KeyColumnValueStore.NO_DELETIONS, this.tx);
        this.tx.commit();
        this.tx = this.startTx();
        EntryList result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd), this.tx);
        Assertions.assertEquals((int)1, (int)result.size());
        Assertions.assertEquals((long)777L, (long)KeyColumnValueStoreUtil.bufferToLong(((Entry)result.get(0)).getColumn()));
    }

    @Test
    public void containsKeyReturnsTrueOnExtantKey() throws Exception {
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        Assertions.assertFalse((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StoreTransaction)this.tx));
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 1L, "c", "v");
        this.tx.commit();
        this.tx = this.startTx();
        Assertions.assertTrue((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StoreTransaction)this.tx));
    }

    @Test
    public void containsKeyReturnsFalseOnNonexistentKey() throws Exception {
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        Assertions.assertFalse((boolean)KCVSUtil.containsKey((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StoreTransaction)this.tx));
    }

    @Test
    public void containsKeyColumnReturnsFalseOnNonexistentInput() throws Exception {
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer("c");
        Assertions.assertFalse((boolean)KCVSUtil.containsKeyColumn((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StaticBuffer)c, (StoreTransaction)this.tx));
    }

    @Test
    public void containsKeyColumnReturnsTrueOnExtantInput() throws Exception {
        KeyColumnValueStoreUtil.insert(this.store, this.tx, 1L, "c", "v");
        this.tx.commit();
        this.tx = this.startTx();
        StaticBuffer key1 = KeyColumnValueStoreUtil.longToByteBuffer(1L);
        StaticBuffer c = KeyColumnValueStoreUtil.stringToByteBuffer("c");
        Assertions.assertTrue((boolean)KCVSUtil.containsKeyColumn((KeyColumnValueStore)this.store, (StaticBuffer)key1, (StaticBuffer)c, (StoreTransaction)this.tx));
    }

    @Test
    public void testGetSlices() throws Exception {
        if (!this.manager.getFeatures().hasMultiQuery()) {
            return;
        }
        this.populateDBWith100Keys();
        this.tx.commit();
        this.tx = this.startTx();
        ArrayList<StaticBuffer> keys = new ArrayList<StaticBuffer>(100);
        for (int i = 1; i <= 100; ++i) {
            keys.add(KeyColumnValueStoreUtil.longToByteBuffer(i));
        }
        StaticBuffer start = KeyColumnValueStoreUtil.stringToByteBuffer("a");
        StaticBuffer end = KeyColumnValueStoreUtil.stringToByteBuffer("d");
        Map results = this.store.getSlice(keys, new SliceQuery(start, end), this.tx);
        Assertions.assertEquals((int)100, (int)results.size());
        for (List entries : results.values()) {
            Assertions.assertEquals((int)3, (int)entries.size());
        }
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.UnorderedScan)
    public void testGetKeysWithSliceQuery(TestInfo testInfo) throws Exception {
        this.populateDBWith100Keys();
        this.tx.commit();
        this.tx = this.startTx();
        KeyIterator keyIterator = this.store.getKeys(new SliceQuery((StaticBuffer)new ReadArrayBuffer("b".getBytes()), (StaticBuffer)new ReadArrayBuffer("c".getBytes())), this.tx);
        this.examineGetKeysResults(keyIterator, 0L, 100L);
    }

    @Test
    @FeatureFlag(feature=JanusGraphFeature.OrderedScan)
    public void testGetKeysWithKeyRange(TestInfo testInfo) throws Exception {
        this.populateDBWith100Keys();
        this.tx.commit();
        this.tx = this.startTx();
        KeyIterator keyIterator = this.store.getKeys(new KeyRangeQuery(KeyColumnValueStoreUtil.longToByteBuffer(10L), KeyColumnValueStoreUtil.longToByteBuffer(40L), (StaticBuffer)new ReadArrayBuffer("b".getBytes()), (StaticBuffer)new ReadArrayBuffer("c".getBytes())), this.tx);
        this.examineGetKeysResults(keyIterator, 10L, 40L);
    }

    @Tag(value="BRITTLE_TESTS")
    @Test
    @FeatureFlag(feature=JanusGraphFeature.CellTtl)
    public void testTtl() throws Exception {
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        int[] ttls = new int[]{0, 1, 2};
        LinkedList<StaticArrayEntry> additions = new LinkedList<StaticArrayEntry>();
        for (int i = 0; i < ttls.length; ++i) {
            StaticBuffer col = KeyColumnValueStoreUtil.longToByteBuffer(i);
            StaticArrayEntry entry = (StaticArrayEntry)StaticArrayEntry.of((StaticBuffer)col, (StaticBuffer)col);
            entry.setMetaData(EntryMetaData.TTL, (Object)ttls[i]);
            additions.add(entry);
        }
        this.store.mutate(key, additions, KeyColumnValueStore.NO_DELETIONS, this.tx);
        this.tx.commit();
        long commitTime = System.currentTimeMillis();
        this.tx = this.startTx();
        StaticBuffer columnStart = KeyColumnValueStoreUtil.longToByteBuffer(0L);
        StaticBuffer columnEnd = KeyColumnValueStoreUtil.longToByteBuffer(ttls.length);
        EntryList result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assertions.assertEquals((int)ttls.length, (int)result.size());
        Thread.sleep(commitTime + 1001L - System.currentTimeMillis());
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assertions.assertEquals((int)(ttls.length - 1), (int)result.size());
        this.tx.rollback();
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assertions.assertEquals((int)(ttls.length - 1), (int)result.size());
        Thread.sleep(commitTime + 2001L - System.currentTimeMillis());
        this.tx.rollback();
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assertions.assertEquals((int)(ttls.length - 2), (int)result.size());
        Thread.sleep(commitTime + 4001L - System.currentTimeMillis());
        this.tx.rollback();
        result = this.store.getSlice(new KeySliceQuery(key, columnStart, columnEnd).setLimit(ttls.length), this.tx);
        Assertions.assertEquals((int)(ttls.length - 2), (int)result.size());
    }

    @Test
    public void testStoreTTL() throws Exception {
        KeyColumnValueStoreManager storeManager = this.manager;
        if (storeManager.getFeatures().hasCellTTL() && !storeManager.getFeatures().hasStoreTTL()) {
            storeManager = new TTLKCVSManager(storeManager);
        } else if (!storeManager.getFeatures().hasStoreTTL()) {
            return;
        }
        Assertions.assertTrue((boolean)storeManager.getFeatures().hasStoreTTL());
        TimeUnit sec = TimeUnit.SECONDS;
        int storeTTLSeconds = (int)TestGraphConfigs.getTTL(sec);
        StoreMetaData.Container opts = new StoreMetaData.Container();
        opts.put(StoreMetaData.TTL, (Object)storeTTLSeconds);
        KeyColumnValueStore storeWithTTL = storeManager.openDatabase("testStore_with_TTL", opts);
        this.populateDBWith100Keys(storeWithTTL);
        this.tx.commit();
        this.tx = this.startTx();
        StaticBuffer key = KeyColumnValueStoreUtil.longToByteBuffer(2L);
        StaticBuffer start = KeyColumnValueStoreUtil.stringToByteBuffer("a");
        StaticBuffer end = KeyColumnValueStoreUtil.stringToByteBuffer("d");
        EntryList results = storeWithTTL.getSlice(new KeySliceQuery(key, new SliceQuery(start, end)), this.tx);
        Assertions.assertEquals((int)3, (int)results.size());
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)storeTTLSeconds * 1.25), sec));
        this.tx.commit();
        this.tx = this.startTx();
        results = storeWithTTL.getSlice(new KeySliceQuery(key, new SliceQuery(start, end)), this.tx);
        Assertions.assertEquals((int)0, (int)results.size());
        storeWithTTL.close();
    }

    protected void populateDBWith100Keys() throws Exception {
        this.populateDBWith100Keys(this.store);
    }

    protected void populateDBWith100Keys(KeyColumnValueStore store) throws Exception {
        Random random = new Random();
        for (int i = 1; i <= 100; ++i) {
            KeyColumnValueStoreUtil.insert(store, this.tx, i, "a", "v" + random.nextLong());
            KeyColumnValueStoreUtil.insert(store, this.tx, i, "b", "v" + random.nextLong());
            KeyColumnValueStoreUtil.insert(store, this.tx, i, "c", "v" + random.nextLong());
        }
    }

    protected void examineGetKeysResults(KeyIterator keyIterator, long startKey, long endKey) {
        Assertions.assertNotNull((Object)keyIterator);
        int count = 0;
        int expectedNumKeys = (int)(endKey - startKey);
        ArrayList<StaticBuffer> existingKeys = new ArrayList<StaticBuffer>(expectedNumKeys);
        int i = (int)(startKey == 0L ? 1L : startKey);
        while ((long)i <= endKey) {
            existingKeys.add(KeyColumnValueStoreUtil.longToByteBuffer(i));
            ++i;
        }
        while (keyIterator.hasNext()) {
            StaticBuffer key = (StaticBuffer)keyIterator.next();
            Assertions.assertNotNull((Object)key);
            Assertions.assertTrue((boolean)existingKeys.contains(key));
            RecordIterator entries = keyIterator.getEntries();
            Assertions.assertNotNull((Object)entries);
            int entryCount = 0;
            while (entries.hasNext()) {
                Assertions.assertNotNull((Object)entries.next());
                ++entryCount;
            }
            Assertions.assertEquals((int)1, (int)entryCount);
            ++count;
        }
        Assertions.assertEquals((int)expectedNumKeys, (int)count);
    }

    @Test
    public void scanTestWithSimpleJob() throws Exception {
        int keys = 1000;
        int columns = 40;
        String[][] values = KeyValueStoreUtil.generateData(keys, columns);
        for (int i = 0; i < values.length; ++i) {
            if (i % 2 != 0) continue;
            values[i] = Arrays.copyOf(values[i], columns / 2);
        }
        this.log.debug("Loading values: " + keys + "x" + columns);
        this.loadValues(values);
        this.clopen();
        StandardScanner scanner = new StandardScanner(this.manager);
        SimpleScanJobRunner runner = (job, jobConf, rootNSName) -> this.runSimpleJob(scanner, job, jobConf);
        SimpleScanJob.runBasicTests(keys, columns, runner);
    }

    private ScanMetrics runSimpleJob(StandardScanner scanner, ScanJob job, Configuration jobConf) throws BackendException, ExecutionException, InterruptedException {
        StandardScanner.Builder jobBuilder = scanner.build();
        jobBuilder.setStoreName(this.store.getName());
        jobBuilder.setJobConfiguration(jobConf);
        jobBuilder.setNumProcessingThreads(2);
        jobBuilder.setWorkBlockSize(100);
        jobBuilder.setTimestampProvider(times);
        jobBuilder.setJob(job);
        return (ScanMetrics)jobBuilder.execute().get();
    }

    @Test
    public void testClearStorage() throws Exception {
        String[][] values = this.generateValues();
        this.loadValues(values);
        this.close();
        this.manager = this.openStorageManagerForClearStorageTest();
        Assertions.assertTrue((boolean)this.manager.exists(), (String)"storage should exist before clearing");
        this.manager.clearStorage();
        try {
            Assertions.assertFalse((boolean)this.manager.exists(), (String)"storage should not exist after clearing");
        }
        catch (Exception e) {
            this.manager.close();
            this.manager = this.openStorageManager();
            Assertions.assertFalse((boolean)this.manager.exists(), (String)"storage should not exist after clearing");
        }
    }

    protected KeyColumnValueStoreManager openStorageManagerForClearStorageTest() throws Exception {
        return this.openStorageManager();
    }

    protected class ConcurrentRandomSliceReader
    implements Runnable {
        private final String[][] values;
        private final Set<KeyColumn> d;
        private final int startKey;
        private final int endKey;
        private final boolean deletionEnabled;
        private final int trials;

        public ConcurrentRandomSliceReader(String[][] values, Set<KeyColumn> deleted, int trials) {
            this.values = values;
            this.d = deleted;
            this.startKey = 0;
            this.endKey = values.length;
            this.deletionEnabled = false;
            this.trials = trials;
        }

        public ConcurrentRandomSliceReader(String[][] values, Set<KeyColumn> deleted, int key, int trials) {
            this.values = values;
            this.d = deleted;
            this.startKey = key % values.length;
            this.endKey = this.startKey + 1;
            this.deletionEnabled = true;
            this.trials = trials;
        }

        @Override
        public void run() {
            for (int t = 0; t < this.trials; ++t) {
                int key = RandomGenerator.randomInt(this.startKey, this.endKey);
                KeyColumnValueStoreTest.this.log.debug("Random key chosen: {} (start={}, end={})", new Object[]{key, this.startKey, this.endKey});
                int start = RandomGenerator.randomInt(0, 50);
                if (start == 49) {
                    start = 48;
                }
                int end = RandomGenerator.randomInt(start + 1, 50);
                int limit = RandomGenerator.randomInt(1, 30);
                try {
                    if (this.deletionEnabled) {
                        int delCol = RandomGenerator.randomInt(start, end);
                        ImmutableList deletions = ImmutableList.of((Object)KeyValueStoreUtil.getBuffer(delCol));
                        KeyColumnValueStoreTest.this.store.mutate(KeyValueStoreUtil.getBuffer(key), KeyColumnValueStore.NO_ADDITIONS, (List)deletions, KeyColumnValueStoreTest.this.tx);
                        KeyColumnValueStoreTest.this.log.debug("Deleting ({},{})", (Object)key, (Object)delCol);
                        this.d.add(new KeyColumn(key, delCol));
                        KeyColumnValueStoreTest.this.tx.commit();
                        KeyColumnValueStoreTest.this.tx = KeyColumnValueStoreTest.this.startTx();
                    }
                    KeyColumnValueStoreTest.this.checkSlice(this.values, this.d, key, start, end, limit);
                    KeyColumnValueStoreTest.this.checkSlice(this.values, this.d, key, start, end, -1);
                    continue;
                }
                catch (BackendException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

