/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.core.attribute;

import java.util.Arrays;
import java.util.stream.Stream;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.junit.jupiter.params.provider.Arguments;

public class TextArgument {
    public static final String text = "This world is full of 1funny surprises! A Full Yes";
    public static final String name = "fully funny";
    public static final String shortValue = "ah";
    public static final String mediumValue = "hop";
    public static final String longValue = "surprises";

    private static Stream<Arguments> addPredicate(JanusGraphPredicate predicate, Stream<Arguments> argStream) {
        return argStream.map(argList -> {
            Object[] rawArgs = argList.get();
            return Arguments.arguments((Object[])new Object[]{predicate, rawArgs[0], rawArgs[1], rawArgs[2]});
        });
    }

    private static Stream<Arguments> negate(Stream<Arguments> argStream) {
        return argStream.map(argList -> {
            Object[] rawArgs = argList.get();
            if (rawArgs[1] == null) {
                return argList;
            }
            return Arguments.arguments((Object[])new Object[]{(Boolean)rawArgs[0] == false, rawArgs[1], rawArgs[2]});
        });
    }

    private static Stream<Arguments> textContainsCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, text, "world"}), Arguments.arguments((Object[])new Object[]{true, text, "wOrLD"}), Arguments.arguments((Object[])new Object[]{false, text, "worl"}), Arguments.arguments((Object[])new Object[]{true, text, "this"}), Arguments.arguments((Object[])new Object[]{true, text, "yes"}), Arguments.arguments((Object[])new Object[]{false, text, "funny"}), Arguments.arguments((Object[])new Object[]{true, text, longValue}), Arguments.arguments((Object[])new Object[]{true, text, "FULL"}), Arguments.arguments((Object[])new Object[]{true, text, "full surprises"}), Arguments.arguments((Object[])new Object[]{true, text, "full,surprises,world"}), Arguments.arguments((Object[])new Object[]{true, text, "a world"}), Arguments.arguments((Object[])new Object[]{false, text, "full bunny"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    private static Stream<Arguments> textPrefixCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, name, "fully"}), Arguments.arguments((Object[])new Object[]{true, name, "ful"}), Arguments.arguments((Object[])new Object[]{true, name, "fully fu"}), Arguments.arguments((Object[])new Object[]{false, name, "fun"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    private static Stream<Arguments> textContainsPrefixCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, name, "fully"}), Arguments.arguments((Object[])new Object[]{true, name, "ful"}), Arguments.arguments((Object[])new Object[]{true, text, "worl"}), Arguments.arguments((Object[])new Object[]{true, text, "wORl"}), Arguments.arguments((Object[])new Object[]{true, text, "ye"}), Arguments.arguments((Object[])new Object[]{true, text, "Y"}), Arguments.arguments((Object[])new Object[]{false, text, "fo"}), Arguments.arguments((Object[])new Object[]{false, text, "of 1f"}), Arguments.arguments((Object[])new Object[]{false, text, "ses"}), Arguments.arguments((Object[])new Object[]{true, name, "fun"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    private static Stream<Arguments> textRegexCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, "over", "o.*"}), Arguments.arguments((Object[])new Object[]{true, "over", "ove.?"}), Arguments.arguments((Object[])new Object[]{true, "over", "ove[rst]?"}), Arguments.arguments((Object[])new Object[]{true, "over", ".*r"}), Arguments.arguments((Object[])new Object[]{true, "over", ".*ver"}), Arguments.arguments((Object[])new Object[]{true, "over", ".?ver"}), Arguments.arguments((Object[])new Object[]{true, "over", "[opr]?ver"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.*r"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.*er"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.?er"}), Arguments.arguments((Object[])new Object[]{true, "over", "o[ve]*r"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.+r"}), Arguments.arguments((Object[])new Object[]{true, name, "(fu[ln]*y) (fu[ln]*y)"}), Arguments.arguments((Object[])new Object[]{false, name, "(fu[l]*y) (fu[l]*y)"}), Arguments.arguments((Object[])new Object[]{true, name, "(fu[l]*y) .*"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    private static Stream<Arguments> textContainsRegexCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, "over", "o.*"}), Arguments.arguments((Object[])new Object[]{true, "over", "ove.?"}), Arguments.arguments((Object[])new Object[]{true, "over", "ove[rst]?"}), Arguments.arguments((Object[])new Object[]{true, "over", ".*r"}), Arguments.arguments((Object[])new Object[]{true, "over", ".*ver"}), Arguments.arguments((Object[])new Object[]{true, "over", ".?ver"}), Arguments.arguments((Object[])new Object[]{true, "over", "[opr]?ver"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.*r"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.*er"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.?er"}), Arguments.arguments((Object[])new Object[]{true, "over", "o[ve]*r"}), Arguments.arguments((Object[])new Object[]{true, "over", "o.+r"}), Arguments.arguments((Object[])new Object[]{true, text, "fu[l]+"}), Arguments.arguments((Object[])new Object[]{true, text, "wor[ld]{1,2}"}), Arguments.arguments((Object[])new Object[]{false, text, "fo"}), Arguments.arguments((Object[])new Object[]{false, text, "wor[l]+"}), Arguments.arguments((Object[])new Object[]{false, text, "wor[ld]{3,5}"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    private static Stream<Arguments> textContainsPhraseCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, text, "world"}), Arguments.arguments((Object[])new Object[]{true, text, "wOrLD"}), Arguments.arguments((Object[])new Object[]{false, text, "worl"}), Arguments.arguments((Object[])new Object[]{true, text, "this"}), Arguments.arguments((Object[])new Object[]{true, text, "yes"}), Arguments.arguments((Object[])new Object[]{false, text, "funny"}), Arguments.arguments((Object[])new Object[]{true, text, longValue}), Arguments.arguments((Object[])new Object[]{true, text, "FULL"}), Arguments.arguments((Object[])new Object[]{false, text, "full surprises"}), Arguments.arguments((Object[])new Object[]{false, text, "full,surprises,world"}), Arguments.arguments((Object[])new Object[]{true, text, "is full of 1funny"}), Arguments.arguments((Object[])new Object[]{true, text, "This world is"}), Arguments.arguments((Object[])new Object[]{false, text, "A Full Yes Or No"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    private static Stream<Arguments> textFuzzyCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, shortValue, shortValue}), Arguments.arguments((Object[])new Object[]{false, shortValue, "ai"}), Arguments.arguments((Object[])new Object[]{true, mediumValue, mediumValue}), Arguments.arguments((Object[])new Object[]{true, mediumValue, "hopp"}), Arguments.arguments((Object[])new Object[]{true, mediumValue, "hap"}), Arguments.arguments((Object[])new Object[]{false, mediumValue, "ha"}), Arguments.arguments((Object[])new Object[]{false, mediumValue, "hoopp"}), Arguments.arguments((Object[])new Object[]{true, longValue, longValue}), Arguments.arguments((Object[])new Object[]{true, longValue, "surpprises"}), Arguments.arguments((Object[])new Object[]{true, longValue, "sutprises"}), Arguments.arguments((Object[])new Object[]{true, longValue, "surprise"}), Arguments.arguments((Object[])new Object[]{false, longValue, "surppirsses"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    private static Stream<Arguments> textContainsFuzzyCommon() {
        return Arrays.stream(new Arguments[]{Arguments.arguments((Object[])new Object[]{true, shortValue, shortValue}), Arguments.arguments((Object[])new Object[]{false, shortValue, "ai"}), Arguments.arguments((Object[])new Object[]{true, mediumValue, mediumValue}), Arguments.arguments((Object[])new Object[]{true, mediumValue, "hopp"}), Arguments.arguments((Object[])new Object[]{true, mediumValue, "hap"}), Arguments.arguments((Object[])new Object[]{false, mediumValue, "ha"}), Arguments.arguments((Object[])new Object[]{false, mediumValue, "hoopp"}), Arguments.arguments((Object[])new Object[]{true, longValue, longValue}), Arguments.arguments((Object[])new Object[]{true, longValue, "surpprises"}), Arguments.arguments((Object[])new Object[]{true, longValue, "sutprises"}), Arguments.arguments((Object[])new Object[]{true, longValue, "surprise"}), Arguments.arguments((Object[])new Object[]{false, longValue, "surppirsses"}), Arguments.arguments((Object[])new Object[]{true, text, "is"}), Arguments.arguments((Object[])new Object[]{false, text, "si"}), Arguments.arguments((Object[])new Object[]{true, text, "full"}), Arguments.arguments((Object[])new Object[]{true, text, "fully"}), Arguments.arguments((Object[])new Object[]{true, text, "ful"}), Arguments.arguments((Object[])new Object[]{true, text, "fill"}), Arguments.arguments((Object[])new Object[]{false, text, "fu"}), Arguments.arguments((Object[])new Object[]{false, text, "fullest"}), Arguments.arguments((Object[])new Object[]{true, text, longValue}), Arguments.arguments((Object[])new Object[]{true, text, "Surpprises"}), Arguments.arguments((Object[])new Object[]{true, text, "Sutrises"}), Arguments.arguments((Object[])new Object[]{true, text, "surprise"}), Arguments.arguments((Object[])new Object[]{false, text, "surppirsses"}), Arguments.arguments((Object[])new Object[]{false, null, "anything"})});
    }

    public static Stream<Arguments> textContains() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.CONTAINS, TextArgument.textContainsCommon());
    }

    public static Stream<Arguments> textNotContains() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_CONTAINS, TextArgument.negate(TextArgument.textContainsCommon()));
    }

    public static Stream<Arguments> textPrefix() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.PREFIX, TextArgument.textPrefixCommon());
    }

    public static Stream<Arguments> textNotPrefix() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_PREFIX, TextArgument.negate(TextArgument.textPrefixCommon()));
    }

    public static Stream<Arguments> textContainsPrefix() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.CONTAINS_PREFIX, TextArgument.textContainsPrefixCommon());
    }

    public static Stream<Arguments> textNotContainsPrefix() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_CONTAINS_PREFIX, TextArgument.negate(TextArgument.textContainsPrefixCommon()));
    }

    public static Stream<Arguments> textRegex() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.REGEX, TextArgument.textRegexCommon());
    }

    public static Stream<Arguments> textNotRegex() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_REGEX, TextArgument.negate(TextArgument.textRegexCommon()));
    }

    public static Stream<Arguments> textContainsRegex() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.CONTAINS_REGEX, TextArgument.textContainsRegexCommon());
    }

    public static Stream<Arguments> textNotContainsRegex() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_CONTAINS_REGEX, TextArgument.negate(TextArgument.textContainsRegexCommon()));
    }

    public static Stream<Arguments> textContainsPhrase() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.CONTAINS_PHRASE, TextArgument.textContainsPhraseCommon());
    }

    public static Stream<Arguments> textNotContainsPhrase() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_CONTAINS_PHRASE, TextArgument.negate(TextArgument.textContainsPhraseCommon()));
    }

    public static Stream<Arguments> textFuzzy() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.FUZZY, TextArgument.textFuzzyCommon());
    }

    public static Stream<Arguments> textNotFuzzy() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_FUZZY, TextArgument.negate(TextArgument.textFuzzyCommon()));
    }

    public static Stream<Arguments> textContainsFuzzy() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.CONTAINS_FUZZY, TextArgument.textContainsFuzzyCommon());
    }

    public static Stream<Arguments> textNotContainsFuzzy() {
        return TextArgument.addPredicate((JanusGraphPredicate)Text.NOT_CONTAINS_FUZZY, TextArgument.negate(TextArgument.textContainsFuzzyCommon()));
    }

    public static Stream<Arguments> string() {
        return Stream.of(TextArgument.textFuzzy(), TextArgument.textNotFuzzy(), TextArgument.textPrefix(), TextArgument.textNotPrefix(), TextArgument.textRegex(), TextArgument.textNotRegex()).flatMap(ii -> ii);
    }

    public static Stream<Arguments> text() {
        return Stream.of(TextArgument.textContains(), TextArgument.textNotContains(), TextArgument.textContainsFuzzy(), TextArgument.textNotContainsFuzzy(), TextArgument.textContainsPhrase(), TextArgument.textNotContainsPhrase(), TextArgument.textContainsPrefix(), TextArgument.textNotContainsPrefix(), TextArgument.textContainsRegex(), TextArgument.textNotContainsRegex()).flatMap(ii -> ii);
    }

    public static Stream<Arguments> all() {
        return Stream.concat(TextArgument.string(), TextArgument.text());
    }
}

