/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.blueprints;

import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ProfileTest;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphMultiQueryStrategy;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;

public class JanusGraphTestListener
implements GraphProvider.TestListener {
    private static final JanusGraphTestListener INSTANCE = new JanusGraphTestListener();
    private static final Map<Class<?>, TraversalStrategy[]> testSpecificDisabledStrategies = new HashMap();

    private JanusGraphTestListener() {
    }

    public static JanusGraphTestListener instance() {
        return INSTANCE;
    }

    public void onTestStart(Class<?> test, String testName) {
        if (testSpecificDisabledStrategies.containsKey(test)) {
            TraversalStrategy[] disabledStrategies = testSpecificDisabledStrategies.get(test);
            Class[] strategyClasses = new Class[disabledStrategies.length];
            for (int i = 0; i < disabledStrategies.length; ++i) {
                strategyClasses[i] = disabledStrategies[i].getClass();
            }
            TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(StandardJanusGraph.class).clone().removeStrategies(strategyClasses));
            TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraphTx.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(StandardJanusGraphTx.class).clone().removeStrategies(strategyClasses));
        }
    }

    public void onTestEnd(Class<?> test, String testName) {
        if (testSpecificDisabledStrategies.containsKey(test)) {
            TraversalStrategy[] disabledStrategies = testSpecificDisabledStrategies.get(test);
            TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraph.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(StandardJanusGraph.class).clone().addStrategies(disabledStrategies));
            TraversalStrategies.GlobalCache.registerStrategies(StandardJanusGraphTx.class, (TraversalStrategies)TraversalStrategies.GlobalCache.getStrategies(StandardJanusGraphTx.class).clone().addStrategies(disabledStrategies));
        }
    }

    static {
        testSpecificDisabledStrategies.put(ProfileTest.Traversals.class, new TraversalStrategy[]{JanusGraphMultiQueryStrategy.instance()});
    }
}

