/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import java.io.File;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;

public class StorageSetup {
    public static String getHomeDir(String subDirectory) {
        File homeFile;
        String homeDirectory = System.getProperty("janusgraph.testdir");
        if (null == homeDirectory) {
            homeDirectory = "target" + File.separator + "db";
        }
        if (subDirectory != null && !StringUtils.isEmpty((CharSequence)subDirectory)) {
            homeDirectory = homeDirectory + File.separator + subDirectory;
        }
        if (!(homeFile = new File(homeDirectory)).exists()) {
            homeFile.mkdirs();
        }
        return homeDirectory;
    }

    public static ModifiableConfiguration getInMemoryConfiguration() {
        return GraphDatabaseConfiguration.buildGraphConfiguration().set(GraphDatabaseConfiguration.STORAGE_BACKEND, (Object)"inmemory", new String[0]).set(GraphDatabaseConfiguration.IDAUTHORITY_WAIT, (Object)Duration.ZERO, new String[0]).set(GraphDatabaseConfiguration.DROP_ON_CLEAR, (Object)false, new String[0]);
    }

    public static JanusGraph getInMemoryGraph() {
        return JanusGraphFactory.open((BasicConfiguration)StorageSetup.getInMemoryConfiguration());
    }

    public static JanusGraph getInMemoryGraphWithMultiQuery() {
        return JanusGraphFactory.open((BasicConfiguration)StorageSetup.getInMemoryConfiguration().set(GraphDatabaseConfiguration.USE_MULTIQUERY, (Object)true, new String[0]));
    }

    public static WriteConfiguration addPermanentCache(ModifiableConfiguration conf) {
        conf.set(GraphDatabaseConfiguration.DB_CACHE, (Object)true, new String[0]);
        conf.set(GraphDatabaseConfiguration.DB_CACHE_TIME, (Object)0L, new String[0]);
        return conf.getConfiguration();
    }

    public static ModifiableConfiguration getConfig(WriteConfiguration config) {
        return new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
    }

    public static BasicConfiguration getConfig(ReadConfiguration config) {
        return new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
    }
}

