/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import com.google.common.base.Preconditions;
import java.io.File;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.configuration.backend.CommonsConfiguration;
import org.janusgraph.diskstorage.util.time.Temporals;
import org.janusgraph.util.system.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGraphConfigs {
    public static final String ENV_OVERRIDE_FILE = "JANUSGRAPH_CONFIG";
    private static final CommonsConfiguration overrides;
    private static final Logger log;

    public static void applyOverrides(WriteConfiguration base) {
        if (null == overrides) {
            return;
        }
        for (String k : overrides.getKeys(null)) {
            base.set(k, overrides.get(k, Object.class));
        }
    }

    public static long getTTL(TimeUnit u) {
        long sec = 10L;
        long l = u.convert(10L, TimeUnit.SECONDS);
        Preconditions.checkState((Integer.MIN_VALUE <= l && Integer.MAX_VALUE >= l ? 1 : 0) != 0, (String)"Test TTL %d is too large to express as an integer in %s", (long)10L, (Object)((Object)u));
        return l;
    }

    public static long getSchemaConvergenceTime(ChronoUnit u) {
        long sec = 60L;
        long l = Temporals.timeUnit((ChronoUnit)u).convert(60L, TimeUnit.SECONDS);
        Preconditions.checkState((Integer.MIN_VALUE <= l && Integer.MAX_VALUE >= l ? 1 : 0) != 0, (String)"Schema convergence time %d is too large to express as an integer in %s", (long)60L, (Object)u);
        return l;
    }

    static {
        log = LoggerFactory.getLogger(TestGraphConfigs.class);
        String overridesFile = System.getenv(ENV_OVERRIDE_FILE);
        CommonsConfiguration o = null;
        if (null != overridesFile) {
            if (!new File(overridesFile).isFile()) {
                log.warn("Graph configuration overrides file {} does not exist or is not an ordinary file", (Object)overridesFile);
            } else {
                try {
                    PropertiesConfiguration cc = ConfigurationUtil.loadPropertiesConfig((String)overridesFile);
                    o = new CommonsConfiguration((Configuration)cc);
                    log.info("Loaded configuration from file {}", (Object)overridesFile);
                }
                catch (ConfigurationException e) {
                    log.error("Unable to load graph configuration from file {}", (Object)overridesFile, (Object)e);
                }
            }
        }
        overrides = o;
    }
}

