/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.testutil.MemoryAssess;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;

@Tag(value="MEMORY_TESTS")
public abstract class JanusGraphPerformanceMemoryTest
extends JanusGraphBaseTest {
    @RepeatedTest(value=10)
    public void edgeById() {
        Vertex v1 = (Vertex)this.graph.traversal().addV("V1").property((Object)"p1", (Object)"1", new Object[0]).next();
        Vertex v2 = (Vertex)this.graph.traversal().addV("V1").property((Object)"p1", (Object)"1", new Object[0]).next();
        for (int i = 0; i < 10000; ++i) {
            this.graph.traversal().V(new Object[]{v1}).addE("E").to(v2).property((Object)"time", (Object)i, new Object[0]).iterate();
        }
        this.graph.traversal().tx().commit();
        List edges = this.graph.traversal().E(new Object[0]).toList();
        for (Edge edge : edges) {
            this.graph.traversal().E(new Object[]{edge}).count().next();
        }
        Assertions.assertEquals((long)10000L, (Long)((Long)this.graph.traversal().E(new Object[]{edges}).count().next()));
    }

    @RepeatedTest(value=10)
    public void testMemoryLeakage() {
        long memoryBaseline = 0L;
        SummaryStatistics stats = new SummaryStatistics();
        int numRuns = 25;
        for (int r = 0; r < numRuns; ++r) {
            if (r == 1 || r == numRuns - 1) {
                memoryBaseline = MemoryAssess.getMemoryUse();
                stats.addValue((double)memoryBaseline);
            }
            for (int t = 0; t < 1000; ++t) {
                this.graph.addVertex(new Object[0]);
                this.graph.tx().rollback();
                JanusGraphTransaction tx = this.graph.newTransaction();
                tx.addVertex(new Object[0]);
                tx.rollback();
            }
            if (r == 1 || r == numRuns - 1) {
                memoryBaseline = MemoryAssess.getMemoryUse();
                stats.addValue((double)memoryBaseline);
            }
            this.clopen(new Object[0]);
        }
        System.out.println("Average: " + stats.getMean() + " Std. Dev: " + stats.getStandardDeviation());
        Assertions.assertTrue((stats.getStandardDeviation() < stats.getMin() ? 1 : 0) != 0);
    }

    @RepeatedTest(value=10)
    public void testTransactionalMemory() throws Exception {
        this.makeVertexIndexedUniqueKey("uid", Long.class);
        this.makeKey("name", String.class);
        PropertyKey time = this.makeKey("time", Integer.class);
        this.mgmt.makeEdgeLabel("friend").signature(new PropertyKey[]{time}).directed().make();
        this.finishSchema();
        Random random = new Random();
        int rounds = 100;
        int commitSize = 1500;
        AtomicInteger uidCounter = new AtomicInteger(0);
        Thread[] writeThreads = new Thread[4];
        long start = System.currentTimeMillis();
        for (int t = 0; t < writeThreads.length; ++t) {
            writeThreads[t] = new Thread(() -> {
                for (int r = 0; r < 100; ++r) {
                    JanusGraphTransaction tx = this.graph.newTransaction();
                    JanusGraphVertex previous = null;
                    for (int c = 0; c < 1500; ++c) {
                        JanusGraphVertex v = tx.addVertex(new Object[0]);
                        long uid = uidCounter.incrementAndGet();
                        v.property(VertexProperty.Cardinality.single, "uid", (Object)uid, new Object[0]);
                        v.property(VertexProperty.Cardinality.single, "name", (Object)("user" + uid), new Object[0]);
                        if (previous != null) {
                            v.addEdge("friend", (Vertex)previous, new Object[]{"time", Math.abs(random.nextInt())});
                        }
                        previous = v;
                    }
                    tx.commit();
                }
            });
            writeThreads[t].start();
        }
        for (Thread writeThread : writeThreads) {
            writeThread.join();
        }
        System.out.println("Write time for " + 150000 * writeThreads.length + " vertices & edges: " + (System.currentTimeMillis() - start));
        int maxUID = uidCounter.get();
        int trials = 1000;
        String fixedName = "john";
        Thread[] readThreads = new Thread[Runtime.getRuntime().availableProcessors() * 2];
        start = System.currentTimeMillis();
        for (int t = 0; t < readThreads.length; ++t) {
            readThreads[t] = new Thread(() -> {
                JanusGraphTransaction tx = this.graph.newTransaction();
                long randomUniqueId = random.nextInt(maxUID) + 1;
                JanusGraphPerformanceMemoryTest.getVertex(tx, "uid", (Object)randomUniqueId).property(VertexProperty.Cardinality.single, "name", (Object)"john", new Object[0]);
                for (int t1 = 1; t1 <= 1000; ++t1) {
                    JanusGraphVertex v = JanusGraphPerformanceMemoryTest.getVertex(tx, "uid", (Object)(random.nextInt(maxUID) + 1));
                    JanusGraphAssert.assertCount(2, v.properties(new String[0]));
                    int count = 0;
                    for (JanusGraphEdge e : v.query().direction(Direction.BOTH).edges()) {
                        ++count;
                        Assertions.assertTrue(((Integer)e.value("time") >= 0 ? 1 : 0) != 0);
                    }
                    Assertions.assertTrue((count <= 2 ? 1 : 0) != 0);
                }
                Assertions.assertEquals((Object)JanusGraphPerformanceMemoryTest.getVertex(tx, "uid", (Object)randomUniqueId).value("name"), (Object)"john");
                tx.commit();
            });
            readThreads[t].start();
        }
        for (Thread readThread : readThreads) {
            readThread.join();
        }
        System.out.println("Read time for " + 1000 * readThreads.length + " vertex lookups: " + (System.currentTimeMillis() - start));
    }
}

