/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.testutil;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.janusgraph.JanusGraphBaseStoreFeaturesTest;
import org.janusgraph.testutil.FeatureFlag;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContextException;
import org.junit.platform.commons.support.AnnotationSupport;
import org.opentest4j.TestAbortedException;

class FeatureRequirementCondition
implements BeforeTestExecutionCallback {
    FeatureRequirementCondition() {
    }

    public void beforeTestExecution(ExtensionContext context) throws Exception {
        FeatureFlag annotation = (FeatureFlag)context.getTestMethod().flatMap(testMethods -> AnnotationSupport.findAnnotation((AnnotatedElement)testMethods, FeatureFlag.class)).orElseThrow(() -> new ExtensionContextException("The extension should not be executed unless the test method is annotated with @FeatureRequirement."));
        Optional testInstance = context.getTestInstance();
        JanusGraphBaseStoreFeaturesTest test = (JanusGraphBaseStoreFeaturesTest)testInstance.get();
        switch (annotation.feature()) {
            case CellTtl: {
                if (test.getStoreFeatures().hasCellTTL()) break;
                throw new TestAbortedException("Database doesn't support CellTtl.");
            }
            case Scan: {
                if (test.getStoreFeatures().hasScan()) break;
                throw new TestAbortedException("Database doesn't support ordered/unordered scan.");
            }
            case OrderedScan: {
                if (test.getStoreFeatures().hasOrderedScan()) break;
                throw new TestAbortedException("Database doesn't support ordered scan.");
            }
            case UnorderedScan: {
                if (test.getStoreFeatures().hasUnorderedScan()) break;
                throw new TestAbortedException("Database doesn't support unordered scan.");
            }
            default: {
                throw new UnsupportedOperationException("Feature Flag " + (Object)((Object)annotation.feature()) + " is not supported.");
            }
        }
    }
}

