/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.diskstorage.configuration.BasicConfiguration;
import org.janusgraph.diskstorage.configuration.ModifiableConfiguration;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphCustomIdIndexTest
extends JanusGraphBaseTest {
    private static final Logger log = LoggerFactory.getLogger(JanusGraphCustomIdIndexTest.class);
    private static final String INDEX = "search";
    private static final String INDEX2 = "search2";
    private IndexFeatures indexFeatures;

    @Override
    public WriteConfiguration getConfiguration() {
        return this.getModifiableConfiguration().getConfiguration();
    }

    protected abstract ModifiableConfiguration getModifiableConfiguration();

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        this.testInfo = testInfo;
        this.config = this.getConfiguration();
        TestGraphConfigs.applyOverrides(this.config);
        Preconditions.checkNotNull((Object)this.config);
        this.logManagers = new HashMap();
        JanusGraphCustomIdIndexTest.clearGraph(this.config);
        this.readConfig = new BasicConfiguration(GraphDatabaseConfiguration.ROOT_NS, (ReadConfiguration)this.config, BasicConfiguration.Restriction.NONE);
    }

    private void open(boolean allowSettingVertexId, boolean allowCustomVertexIdType) {
        ModifiableConfiguration config = this.getModifiableConfiguration();
        config.set(GraphDatabaseConfiguration.ALLOW_SETTING_VERTEX_ID, (Object)allowSettingVertexId, new String[0]);
        config.set(GraphDatabaseConfiguration.ALLOW_CUSTOM_VERTEX_ID_TYPES, (Object)allowCustomVertexIdType, new String[0]);
        this.open(config.getConfiguration());
        this.indexFeatures = (IndexFeatures)this.graph.getBackend().getIndexFeatures().get(INDEX);
    }

    protected String[] getIndexBackends() {
        return new String[]{INDEX, INDEX2};
    }

    private String getRandomId() {
        return UUID.randomUUID().toString().replace('-', '_');
    }

    private void addVertex(int time, String text, double height, String[] phones) {
        this.newTx();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{T.id, this.getRandomId(), "text", text, "time", time, "height", height});
        for (String phone : phones) {
            v.property("phone", (Object)phone);
        }
        this.newTx();
    }

    private Parameter getTextMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXT)) {
            return Mapping.TEXT.asParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.asParameter();
        }
        throw new AssertionError((Object)"Text mapping not supported");
    }

    private Parameter getFieldMap(PropertyKey key) {
        return ParameterType.MAPPED_NAME.getParameter((Object)key.name());
    }

    @Test
    public void testBasic() {
        this.open(true, true);
        PropertyKey p1 = this.makeKey("p1", String.class);
        PropertyKey p2 = this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", Long.class);
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(p1, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("mi", Vertex.class).addKey(p2, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX2);
        this.mgmt.buildIndex("theIndex", Edge.class).addKey(p3).buildMixedIndex(INDEX);
        this.finishSchema();
        Assertions.assertEquals((long)0L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p1", (Object)"val1").has("p2", (Object)"val2").count().next()));
        JanusGraphVertex v1 = this.tx.addVertex(new Object[]{T.id, this.getRandomId(), "p1", "val1", "p2", "val2"});
        JanusGraphVertex v2 = this.tx.addVertex(new Object[]{T.id, this.getRandomId(), "p1", "val1"});
        JanusGraphVertex v3 = this.tx.addVertex(new Object[]{T.id, this.getRandomId(), "p2", "val2"});
        v1.addEdge("connects", (Vertex)v2, new Object[]{"p3", 1});
        v2.addEdge("connects", (Vertex)v3, new Object[]{"p3", 2});
        this.tx.commit();
        this.clopen(JanusGraphCustomIdIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        Assertions.assertEquals((long)2L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p1", (Object)"val1").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p2", (Object)"val2").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p1", (Object)"val1").has("p2", (Object)"val2").count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"p1", (Object)"val1"), __.has((String)"p2", (Object)"val2")}).count().next()));
        Assertions.assertEquals((int)3, (int)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"p1", (Object)"val1"), __.has((String)"p2", (Object)"val2")}).toList().size());
        Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().E(new Object[0]).has("p3", (Object)1).count().next()));
        Assertions.assertEquals((int)1, (int)this.tx.traversal().E(new Object[0]).has("p3", (Object)1).toList().size());
    }

    @Test
    public void testIndexUpdatesWithoutReindex() throws InterruptedException, ExecutionException {
        this.open(true, true);
        Object[] settings = new Object[]{JanusGraphCustomIdIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphCustomIdIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphCustomIdIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L)};
        this.clopen(settings);
        this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.makePropertyKey("height").dataType(Double.class).make();
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            this.mgmt.makePropertyKey("phone").dataType(String.class).cardinality(Cardinality.LIST).make();
        }
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(text, new Parameter[]{this.getTextMapping(), this.getFieldMap(text)}).buildMixedIndex(INDEX);
        this.finishSchema();
        String defText = "Mountain rocks are great friends";
        int defTime = 5;
        double defHeight = 101.1;
        String[] defPhones = new String[]{"1234", "5678"};
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey time = this.mgmt.getPropertyKey("time");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), time, new Parameter[]{this.getFieldMap(time)});
        this.finishSchema();
        this.newTx();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        Assertions.assertFalse((boolean)((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REGISTER_INDEX).get();
        this.mgmt.commit();
        ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX).get();
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 3, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey height = this.mgmt.getPropertyKey("height");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), height, new Parameter[0]);
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            PropertyKey phone = this.mgmt.getPropertyKey("phone");
            this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), phone, new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)});
        }
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        JanusGraphIndex index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)index.getIndexStatus(key));
        }
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 4, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        }
        this.newTx();
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REINDEX).get();
        this.mgmt.commit();
        this.finishSchema();
        this.clopen(settings);
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
            JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        }
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.DISABLE_INDEX).get();
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)index.getIndexStatus(key));
        }
        this.newTx();
        JanusGraphCustomIdIndexTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{false, true}, new String[0]);
    }
}

