/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph;

import com.google.common.base.Joiner;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DaemonRunner<S> {
    private static final Logger log = LoggerFactory.getLogger(DaemonRunner.class);
    private Thread killerHook;

    protected abstract String getDaemonShortName();

    protected abstract void killImpl(S var1) throws IOException;

    protected abstract S startImpl() throws IOException;

    protected abstract S readStatusFromDisk();

    public synchronized S start() {
        S stat = this.readStatusFromDisk();
        if (stat != null) {
            log.info("{} already started", (Object)this.getDaemonShortName());
            return stat;
        }
        try {
            stat = this.startImpl();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.registerKillerHook(stat);
        return stat;
    }

    public synchronized void stop() {
        S stat = this.readStatusFromDisk();
        if (null == stat) {
            log.info("{} is not running", (Object)this.getDaemonShortName());
            return;
        }
        this.killAndUnregisterHook(stat);
    }

    private synchronized void registerKillerHook(S stat) {
        if (null != this.killerHook) {
            log.debug("Daemon killer hook already registered: {}", (Object)this.killerHook);
            return;
        }
        this.killerHook = new Thread(() -> this.killAndUnregisterHook(stat));
        Runtime.getRuntime().addShutdownHook(this.killerHook);
        log.debug("Registered daemon killer hook: {}", (Object)this.killerHook);
    }

    private synchronized void killAndUnregisterHook(S stat) {
        try {
            this.killImpl(stat);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (null != this.killerHook) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.killerHook);
                log.debug("Unregistered killer hook: {}", (Object)this.killerHook);
            }
            catch (IllegalStateException e) {
                log.debug("Could not unregister killer hook: {}", (Object)this.killerHook.getName(), (Object)e);
            }
            this.killerHook = null;
        }
    }

    public static void runCommand(String ... argv) {
        Process startup;
        String cmd = Joiner.on((String)" ").join((Object[])argv);
        log.info("Executing {}", (Object)cmd);
        ProcessBuilder pb = new ProcessBuilder(argv);
        pb.redirectErrorStream(true);
        try {
            startup = pb.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start process in " + System.getProperty("user.dir") + ": " + e.getMessage(), e);
        }
        StreamLogger sl = new StreamLogger(startup.getInputStream());
        sl.setDaemon(true);
        sl.start();
        DaemonRunner.waitForProcessAndCheckStatus(cmd, startup);
        try {
            sl.join(1000L);
        }
        catch (InterruptedException e) {
            log.warn("Failed to cleanup stdin handler thread after running command \"{}\"", (Object)cmd, (Object)e);
        }
    }

    private static void waitForProcessAndCheckStatus(String cmd, Process startup) {
        try {
            int exitCode = startup.waitFor();
            if (0 != exitCode) {
                throw new RuntimeException("Command \"" + cmd + "\" exited with status " + exitCode);
            }
            log.info("Command \"{}\" exited with status 0", (Object)cmd);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamLogger
    extends Thread {
        private final BufferedReader reader;
        private static final Logger log = LoggerFactory.getLogger(StreamLogger.class);

        private StreamLogger(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is));
        }

        @Override
        public void run() {
            try {
                String line;
                while (null != (line = this.reader.readLine())) {
                    log.info("> {}", (Object)line);
                    if (!Thread.currentThread().isInterrupted()) continue;
                }
                log.info("End of stream.");
            }
            catch (IOException e) {
                log.error("Unexpected IOException while reading stream {}", (Object)this.reader, (Object)e);
            }
        }
    }
}

