/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ElementValueComparator;
import org.apache.tinkerpop.gremlin.process.traversal.util.Metrics;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.EdgeLabel;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphElement;
import org.janusgraph.core.JanusGraphException;
import org.janusgraph.core.JanusGraphFactory;
import org.janusgraph.core.JanusGraphIndexQuery;
import org.janusgraph.core.JanusGraphQuery;
import org.janusgraph.core.JanusGraphTransaction;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.Transaction;
import org.janusgraph.core.VertexLabel;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.log.TransactionRecovery;
import org.janusgraph.core.schema.Index;
import org.janusgraph.core.schema.JanusGraphIndex;
import org.janusgraph.core.schema.JanusGraphManagement;
import org.janusgraph.core.schema.JanusGraphSchemaElement;
import org.janusgraph.core.schema.JanusGraphSchemaType;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.core.schema.SchemaAction;
import org.janusgraph.core.schema.SchemaStatus;
import org.janusgraph.core.util.ManagementUtil;
import org.janusgraph.diskstorage.Backend;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BackendTransaction;
import org.janusgraph.diskstorage.configuration.ConfigElement;
import org.janusgraph.diskstorage.configuration.ReadConfiguration;
import org.janusgraph.diskstorage.configuration.WriteConfiguration;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexInformation;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexTransaction;
import org.janusgraph.diskstorage.log.kcvs.KCVSLog;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.example.GraphOfTheGodsFactory;
import org.janusgraph.graphdb.JanusGraphBaseTest;
import org.janusgraph.graphdb.JanusGraphTest;
import org.janusgraph.graphdb.TestMockIndexProvider;
import org.janusgraph.graphdb.configuration.GraphDatabaseConfiguration;
import org.janusgraph.graphdb.database.IndexRecordEntry;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.index.IndexMutationType;
import org.janusgraph.graphdb.database.index.IndexUpdate;
import org.janusgraph.graphdb.database.management.GraphIndexStatusWatcher;
import org.janusgraph.graphdb.database.management.ManagementSystem;
import org.janusgraph.graphdb.database.util.IndexRecordUtil;
import org.janusgraph.graphdb.database.util.StaleIndexRecordUtil;
import org.janusgraph.graphdb.internal.ElementCategory;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.log.StandardTransactionLogProcessor;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.index.ThresholdBasedIndexSelectionStrategy;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphMixedIndexAggStep;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphStep;
import org.janusgraph.graphdb.tinkerpop.optimize.strategy.JanusGraphMixedIndexCountStrategy;
import org.janusgraph.graphdb.transaction.StandardJanusGraphTx;
import org.janusgraph.graphdb.types.MixedIndexType;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.graphdb.types.StandardEdgeLabelMaker;
import org.janusgraph.graphdb.types.vertices.JanusGraphSchemaVertex;
import org.janusgraph.graphdb.vertices.CacheVertex;
import org.janusgraph.testutil.JanusGraphAssert;
import org.janusgraph.testutil.TestGraphConfigs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JanusGraphIndexTest
extends JanusGraphBaseTest {
    private static final ElementValueComparator ORDER_AGE_DESC = new ElementValueComparator("age", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc);
    private static final ElementValueComparator ORDER_AGE_ASC = new ElementValueComparator("age", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.asc);
    private static final ElementValueComparator ORDER_LENGTH_DESC = new ElementValueComparator("length", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.desc);
    private static final ElementValueComparator ORDER_LENGTH_ASC = new ElementValueComparator("length", (Comparator)org.apache.tinkerpop.gremlin.process.traversal.Order.asc);
    public static final String INDEX = "search";
    public static final String VINDEX = "vsearch";
    public static final String EINDEX = "esearch";
    public static final String PINDEX = "psearch";
    public static final String INDEX2 = "search2";
    private static final int RETRY_COUNT = 30;
    private static final long RETRY_INTERVAL = 1000L;
    public final boolean supportsGeoPoint;
    public final boolean supportsNumeric;
    public final boolean supportsText;
    public IndexFeatures indexFeatures;
    private static final Logger log = LoggerFactory.getLogger(JanusGraphIndexTest.class);

    protected JanusGraphIndexTest(boolean supportsGeoPoint, boolean supportsNumeric, boolean supportsText) {
        this.supportsGeoPoint = supportsGeoPoint;
        this.supportsNumeric = supportsNumeric;
        this.supportsText = supportsText;
    }

    protected String[] getIndexBackends() {
        return new String[]{INDEX, INDEX2};
    }

    private Parameter getStringMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.STRING)) {
            return Mapping.STRING.asParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.asParameter();
        }
        throw new AssertionError((Object)"String mapping not supported");
    }

    private Parameter getTextMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXT)) {
            return Mapping.TEXT.asParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.asParameter();
        }
        throw new AssertionError((Object)"Text mapping not supported");
    }

    private Parameter getFieldMap(PropertyKey key) {
        return ParameterType.MAPPED_NAME.getParameter((Object)key.name());
    }

    public abstract boolean supportsLuceneStyleQueries();

    public abstract boolean supportsWildcardQuery();

    public abstract boolean supportsGeoPointExistsQuery();

    public abstract boolean supportsGeoShapePrefixTreeMapping();

    public String getStringField(String propertyKey) {
        return propertyKey;
    }

    public String getTextField(String propertyKey) {
        return propertyKey;
    }

    @Override
    public void open(WriteConfiguration config) {
        super.open(config);
        this.indexFeatures = (IndexFeatures)this.graph.getBackend().getIndexFeatures().get(INDEX);
    }

    @Override
    public void clopen(Object ... settings) {
        this.graph.tx().commit();
        super.clopen(settings);
    }

    @Test
    public void testGraphOfTheGods() {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph);
        JanusGraphIndexTest.assertGraphOfTheGods((JanusGraph)this.graph);
    }

    public static void assertGraphOfTheGods(JanusGraph graphOfTheGods) {
        JanusGraphAssert.assertCount(12, graphOfTheGods.query().vertices());
        JanusGraphAssert.assertCount(3, graphOfTheGods.query().has(LABEL_NAME, (Object)"god").vertices());
        JanusGraphVertex h = JanusGraphIndexTest.getOnlyVertex(graphOfTheGods.query().has("name", (Object)"hercules"));
        Assertions.assertEquals((int)30, (int)((Integer)h.value("age")));
        Assertions.assertEquals((Object)"demigod", (Object)h.label());
        JanusGraphAssert.assertCount(5, h.query().direction(Direction.BOTH).edges());
        graphOfTheGods.tx().commit();
    }

    @Test
    public void testUpdateSchemaChangeNameForPropertyKey() {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
        this.finishSchema();
        this.graph.addVertex(new Object[]{"name", "original"});
        this.graph.tx().commit();
        PropertyKey prop = this.mgmt.getPropertyKey("name");
        this.mgmt.changeName((JanusGraphSchemaElement)prop, "oldName");
        Assertions.assertEquals((Object)"oldName", (Object)prop.name());
        this.finishSchema();
        Assertions.assertTrue((boolean)this.mgmt.containsPropertyKey("oldName"));
        Assertions.assertFalse((boolean)this.mgmt.containsPropertyKey("name"));
        this.graph.addVertex(new Object[]{"oldName", "old"});
        this.graph.tx().commit();
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("oldName", (Object)"old").hasNext());
        name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.finishSchema();
        this.graph.addVertex(new Object[]{"name", "new"});
        JanusGraphException ex = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> this.graph.traversal().V(new Object[0]).has("name", (Object)"new").hasNext());
        Assertions.assertEquals((Object)"Could not find a suitable index to answer graph query and graph scans are disabled: [(name = new)]:VERTEX", (Object)ex.getMessage());
        this.clopen(new Object[0]);
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has("name", (Object)"new").hasNext());
        this.finishSchema();
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("mixed"), this.mgmt.getPropertyKey("name"), new Parameter[]{this.getStringMapping()});
        this.mgmt.commit();
        this.graph.addVertex(new Object[]{"name", "new"});
        ex = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> this.graph.tx().commit());
        Assertions.assertEquals((Object)"Duplicate index field names found, likely you have multiple properties mapped to the same index field", (Object)ex.getCause().getMessage());
    }

    @Test
    public void testMultipleIndexBackends() {
        PropertyKey p1 = this.makeKey("p1", String.class);
        PropertyKey p2 = this.makeKey("p2", String.class);
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(p1, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("mi", Vertex.class).addKey(p2, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX2);
        this.finishSchema();
        Assertions.assertEquals((long)0L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p1", (Object)"val1").has("p2", (Object)"val2").count().next()));
        this.tx.addVertex(new Object[]{"p1", "val1", "p2", "val2"});
        this.tx.addVertex(new Object[]{"p1", "val1"});
        this.tx.addVertex(new Object[]{"p2", "val2"});
        this.tx.commit();
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        Assertions.assertEquals((long)2L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p1", (Object)"val1").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p2", (Object)"val2").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("p1", (Object)"val1").has("p2", (Object)"val2").count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"p1", (Object)"val1"), __.has((String)"p2", (Object)"val2")}).count().next()));
    }

    @Test
    public void testNullQueries() {
        this.makeKey("p2", String.class);
        PropertyKey p3 = this.makeKey("p3", String.class);
        PropertyKey p4 = this.makeKey("p4", String.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(p3).buildCompositeIndex();
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(p4, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p4", P.neq((Object)"v")).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has("p4", P.neq(null)).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("p4", null).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).hasNot("p4").hasNext());
        Assertions.assertTrue((boolean)this.tx.query().hasNot("p4").vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p4", null).vertices().iterator().hasNext());
        Assertions.assertFalse((boolean)this.tx.query().hasNot("p4", (Object)"value").vertices().iterator().hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).not((Traversal)__.has((String)"p4")).hasNext());
    }

    @Test
    public void testClearStorage() throws Exception {
        GraphOfTheGodsFactory.load((JanusGraph)this.graph);
        this.tearDown();
        this.config.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.DROP_ON_CLEAR, (String[])new String[0]), (Object)true);
        Backend backend = JanusGraphIndexTest.getBackend(this.config, false);
        JanusGraphIndexTest.assertStorageExists(backend, true);
        JanusGraphIndexTest.clearGraph(this.config);
        try {
            backend.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (Backend newBackend = JanusGraphIndexTest.getBackend(this.config, false);){
            JanusGraphIndexTest.assertStorageExists(newBackend, false);
        }
    }

    private static void assertStorageExists(Backend backend, boolean exists) throws Exception {
        String suffix = exists ? "should exist before clearing" : "should not exist after clearing";
        Assertions.assertEquals((Object)backend.getStoreManager().exists(), (Object)exists, (String)("graph " + suffix));
        for (IndexInformation index : backend.getIndexInformation().values()) {
            Assertions.assertEquals((Object)((IndexProvider)index).exists(), (Object)exists, (String)("index " + suffix));
        }
    }

    @Test
    public void testGeoshapeExistsQuery() {
        if (!this.supportsGeoPointExistsQuery()) {
            return;
        }
        PropertyKey geoshape = this.mgmt.makePropertyKey("geoshape").dataType(Geoshape.class).make();
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(geoshape).buildMixedIndex(INDEX);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"geoshape", Geoshape.point((double)37.97, (double)23.72)});
        this.tx.addVertex(new Object[0]);
        this.tx.commit();
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("geoshape").count().next()));
    }

    @Test
    public void testExistsQuery() {
        PropertyKey compositeInt = this.mgmt.makePropertyKey("compositeInt").dataType(Integer.class).make();
        PropertyKey mixedInt = this.mgmt.makePropertyKey("mixedInt").dataType(Integer.class).make();
        PropertyKey stringKey = this.mgmt.makePropertyKey("string").dataType(String.class).make();
        PropertyKey textKey = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        PropertyKey boolKey = this.mgmt.makePropertyKey("bool").dataType(Boolean.class).make();
        PropertyKey longKey = this.mgmt.makePropertyKey("long").dataType(Long.class).make();
        PropertyKey byteKey = this.mgmt.makePropertyKey("byte").dataType(Byte.class).make();
        PropertyKey shortKey = this.mgmt.makePropertyKey("short").dataType(Short.class).make();
        PropertyKey floatKey = this.mgmt.makePropertyKey("float").dataType(Float.class).make();
        PropertyKey dateKey = this.mgmt.makePropertyKey("date").dataType(Date.class).make();
        PropertyKey instant = this.mgmt.makePropertyKey("instant").dataType(Instant.class).make();
        PropertyKey uuid = this.mgmt.makePropertyKey("uuid").dataType(UUID.class).make();
        this.mgmt.buildIndex("int", Vertex.class).addKey(compositeInt).buildCompositeIndex();
        this.mgmt.buildIndex("namev", Vertex.class).addKey(stringKey, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(textKey, new Parameter[]{Mapping.TEXT.asParameter()}).addKey(longKey).addKey(instant).addKey(boolKey).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("mi", Vertex.class).addKey(mixedInt).addKey(floatKey).addKey(uuid).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(floatKey).addKey(byteKey).addKey(shortKey).addKey(dateKey).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"string", "", "compositeInt", 30, "text", "male", "mixedInt", 0, "short", 0, "float", 0.0, "date", new Date(), "instant", Instant.ofEpochMilli(1L), "uuid", UUID.randomUUID()});
        v.property("compositeInt").property("bool2", (Object)true);
        this.tx.addVertex(new Object[]{"string", "robert", "text", "female", "long", 12345678L, "float", 100000.5, "instant", Instant.ofEpochMilli(100L), "uuid", UUID.randomUUID(), "bool", true});
        this.tx.addVertex(new Object[]{"text", "prefer not to say", "long", 23456789L, "byte", (byte)-128, "uuid", UUID.randomUUID()});
        this.tx.addVertex(new Object[]{T.label, "person", "mixedInt", 2, "short", 1});
        this.tx.commit();
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        JanusGraphAssert.assertCount(2, this.tx.query().has("string").vertices());
        JanusGraphAssert.assertCount(3, this.tx.query().has("text").vertices());
        JanusGraphAssert.assertCount(2, this.tx.query().has("mixedInt").vertices());
        JanusGraphAssert.assertCount(2, this.tx.query().has("short").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("byte").vertices());
        JanusGraphAssert.assertCount(2, this.tx.query().has("float").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("date").vertices());
        JanusGraphAssert.assertCount(2, this.tx.query().has("instant").vertices());
        JanusGraphAssert.assertCount(3, this.tx.query().has("uuid").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("bool").vertices());
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("string").as("v", new String[0]).select("v").count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("text").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("mixedInt").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("short").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("byte").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("float").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("date").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("instant").count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("uuid").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("bool").count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)this.graph.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"string"), __.has((String)"text")}).count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).and(new Traversal[]{__.has((String)"string"), __.has((String)"text")}).count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("text").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("long").count().next()));
        Assertions.assertEquals((long)3L, (Long)((Long)this.graph.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"text"), __.has((String)"long")}).count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).and(new Traversal[]{__.has((String)"text"), __.has((String)"long")}).count().next()));
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), false);
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("compositeInt").count().next()));
        Vertex vertex = (Vertex)this.graph.traversal().V(new Object[0]).has("compositeInt").next();
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).hasId(vertex.id(), new Object[0]).has("string").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[]{vertex}).has("string").count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)this.graph.traversal().V(new Object[0]).hasId(vertex.id(), new Object[0]).has("byte").count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)this.graph.traversal().V(new Object[]{vertex}).has("byte").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).hasLabel("person", new String[0]).has("short").count().next()));
        Assertions.assertEquals((long)0L, (Long)((Long)this.graph.traversal().V(new Object[0]).hasLabel("person", new String[0]).has("string").count().next()));
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"string"), __.has((String)"compositeInt")}).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).and(new Traversal[]{__.has((String)"string"), __.has((String)"compositeInt")}).count().next()));
        Assertions.assertNotNull((Object)this.graph.traversal().V(new Object[0]).has("compositeInt").properties(new String[]{"compositeInt"}).has("bool2").next());
        Assertions.assertNotNull((Object)this.graph.traversal().V(new Object[0]).has("compositeInt").properties(new String[]{"compositeInt"}).as("p", new String[0]).has("bool2").select("p").next());
    }

    @Test
    public void testSimpleUpdate() {
        PropertyKey name = this.makeKey("name", String.class);
        this.makeLabel("knows");
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("namee", Edge.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        JanusGraphEdge e = v.addEdge("knows", (Vertex)v, new Object[]{"name", "Hulu Bubab"});
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new Object[0])) {
            Assertions.assertEquals((Object)"Marko Rodriguez", (Object)u.value("name"));
        }
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new Object[0])) {
            Assertions.assertEquals((Object)"Marko Rodriguez", (Object)u.value("name"));
        }
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.single, "name", (Object)"Marko", new Object[0]);
        e = JanusGraphIndexTest.getOnlyEdge(v.query().direction(Direction.OUT));
        e.property("name", (Object)"Tubu Rubu");
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Rubu").edges());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new Object[0])) {
            Assertions.assertEquals((Object)"Marko", (Object)u.value("name"));
        }
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Rubu").edges());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Hulu").edges());
        for (Vertex u : this.tx.getVertices(new Object[0])) {
            Assertions.assertEquals((Object)"Marko", (Object)u.value("name"));
        }
    }

    @Test
    public void testListUpdate() {
        if (!this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING);
        PropertyKey alias = this.mgmt.makePropertyKey("alias").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).addKey(alias, new Parameter[]{this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) ? Mapping.TEXTSTRING.asParameter() : Mapping.DEFAULT.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.list, "alias", (Object)"Marko", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.list, "alias", (Object)"mRodriguez", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Marko").vertices());
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"mRodriguez").vertices());
        }
    }

    @Test
    public void testSetUpdate() {
        if (!this.indexFeatures.supportsCardinality(Cardinality.SET)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey alias = this.mgmt.makePropertyKey("alias").dataType(String.class).cardinality(Cardinality.SET).make();
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).addKey(alias, new Parameter[]{this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) ? Mapping.TEXTSTRING.asParameter() : Mapping.DEFAULT.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.set, "alias", (Object)"Marko", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"marko"));
        v.property(VertexProperty.Cardinality.set, "alias", (Object)"mRodriguez", new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"mRodriguez").vertices());
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Marko").vertices());
            JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Cmp.EQUAL, (Object)"mRodriguez").vertices());
        }
    }

    @Test
    public void testListDeleteAddInOneTransaction() {
        if (!this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey aliasKey = this.mgmt.makePropertyKey("alias").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).addKey(aliasKey, new Parameter[]{this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) ? Mapping.TEXTSTRING.asParameter() : Mapping.DEFAULT.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"name", "Marko Rodriguez"});
        this.clopen(new Object[0]);
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko Rodriguez"));
        v.property("alias", (Object)"Marko");
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        v = JanusGraphIndexTest.getOnlyVertex(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko Rodriguez"));
        v.property("alias").remove();
        v.property("alias", (Object)"Marko1");
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko1").vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(1, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko1").vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("alias", (JanusGraphPredicate)Text.CONTAINS, (Object)"Marko").vertices());
    }

    @Test
    public void testIndexing() throws InterruptedException {
        int numV;
        PropertyKey text = this.makeKey("text", String.class);
        this.createExternalVertexIndex(text, INDEX);
        this.createExternalEdgeIndex(text, INDEX);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.addIndexKey(this.getExternalIndex(Vertex.class, INDEX), name, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.TEXT)});
        this.mgmt.addIndexKey(this.getExternalIndex(Edge.class, INDEX), name, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.TEXT)});
        PropertyKey location = this.makeKey("location", Geoshape.class);
        this.createExternalVertexIndex(location, INDEX);
        this.createExternalEdgeIndex(location, INDEX);
        PropertyKey boundary = this.makeKey("boundary", Geoshape.class);
        if (this.supportsGeoShapePrefixTreeMapping()) {
            this.mgmt.addIndexKey(this.getExternalIndex(Vertex.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.PREFIX_TREE), Parameter.of((String)"index-geo-dist-error-pct", (Object)0.0025)});
            this.mgmt.addIndexKey(this.getExternalIndex(Edge.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.PREFIX_TREE), Parameter.of((String)"index-geo-dist-error-pct", (Object)0.0025)});
        } else {
            this.mgmt.addIndexKey(this.getExternalIndex(Vertex.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.BKD)});
            this.mgmt.addIndexKey(this.getExternalIndex(Edge.class, INDEX), boundary, new Parameter[]{Parameter.of((String)"mapping", (Object)Mapping.BKD)});
        }
        PropertyKey time = this.makeKey("time", Long.class);
        this.createExternalVertexIndex(time, INDEX);
        this.createExternalEdgeIndex(time, INDEX);
        PropertyKey category = this.makeKey("category", Integer.class);
        this.mgmt.buildIndex("vcategory", Vertex.class).addKey(category).buildCompositeIndex();
        this.mgmt.buildIndex("ecategory", Edge.class).addKey(category).buildCompositeIndex();
        PropertyKey group = this.makeKey("group", Byte.class);
        this.createExternalVertexIndex(group, INDEX);
        this.createExternalEdgeIndex(group, INDEX);
        this.makeVertexIndexedKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new PropertyKey[]{time}).signature(new PropertyKey[]{location, boundary}).make();
        this.finishSchema();
        this.clopen(new Object[0]);
        String[] words = new String[]{"world", "aurelius", "janusgraph", "graph"};
        int numCategories = 5;
        int numGroups = 10;
        int originalNumV = numV = 100;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex v = this.tx.addVertex(new Object[0]);
            v.property(VertexProperty.Cardinality.single, "uid", (Object)i, new Object[0]);
            v.property(VertexProperty.Cardinality.single, "category", (Object)(i % 5), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "group", (Object)(i % 10), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "text", (Object)("Vertex " + words[i % words.length]), new Object[0]);
            v.property(VertexProperty.Cardinality.single, "name", (Object)words[i % words.length], new Object[0]);
            v.property(VertexProperty.Cardinality.single, "time", (Object)i, new Object[0]);
            double offset = (double)(i % 2 == 0 ? 1 : -1) * ((double)i * 50.0 / (double)numV);
            v.property(VertexProperty.Cardinality.single, "location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)), new Object[0]);
            if (i % 2 == 0) {
                v.property(VertexProperty.Cardinality.single, "boundary", (Object)Geoshape.line(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1})), new Object[0]);
            } else {
                v.property(VertexProperty.Cardinality.single, "boundary", (Object)Geoshape.polygon(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1}, {offset - 0.1, offset - 0.1})), new Object[0]);
            }
            JanusGraphEdge e = v.addEdge("knows", (Vertex)this.getVertex("uid", (Object)Math.max(0, i - 1)), new Object[0]);
            e.property("text", (Object)("Vertex " + words[i % words.length]));
            e.property("name", (Object)words[i % words.length]);
            e.property("time", (Object)i);
            e.property("category", (Object)(i % 5));
            e.property("group", (Object)(i % 10));
            e.property("location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)));
            if (i % 2 == 0) {
                e.property("boundary", (Object)Geoshape.line(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1})));
                continue;
            }
            e.property("boundary", (Object)Geoshape.polygon(Arrays.asList({offset - 0.1, offset - 0.1}, {offset + 0.1, offset - 0.1}, {offset + 0.1, offset + 0.1}, {offset - 0.1, offset + 0.1}, {offset - 0.1, offset - 0.1})));
        }
        this.checkIndexingCounts(words, numV, originalNumV, true);
        int status = 1;
        for (int retry = 0; retry < 30 && status > 0; ++retry) {
            this.clopen(new Object[0]);
            try {
                this.checkIndexingCounts(words, numV, originalNumV, true);
                status = 0;
                continue;
            }
            catch (AssertionError e) {
                if (retry >= 29) {
                    throw e;
                }
                Thread.sleep(1000L);
            }
        }
        this.newTx();
        int numDelete = 12;
        for (int i = numV - 12; i < numV; ++i) {
            this.getVertex("uid", (Object)i).remove();
        }
        this.checkIndexingCounts(words, numV -= 12, originalNumV, false);
    }

    private void checkIndexingCounts(String[] words, int numV, int originalNumV, boolean checkOrder) {
        int i;
        for (String word : words) {
            int expectedSize = numV / words.length;
            JanusGraphAssert.assertCount(expectedSize, this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).vertices());
            JanusGraphAssert.assertCount(expectedSize, this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).edges());
            if (!checkOrder) continue;
            for (String orderKey : new String[]{"time", "category"}) {
                for (Order order : Order.values()) {
                    for (JanusGraphQuery traversal : ImmutableList.of((Object)this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).orderBy(orderKey, order.getTP()), (Object)this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)word).orderBy(orderKey, order.getTP()))) {
                        JanusGraphIndexTest.verifyElementOrder(traversal.vertices(), orderKey, order, expectedSize);
                    }
                }
            }
        }
        JanusGraphAssert.assertCount(3, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.asc).limit(3).vertices());
        JanusGraphAssert.assertCount(3, this.tx.query().has("group", (Object)3).orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc).limit(3).edges());
        for (i = 0; i < numV / 2; i += numV / 10) {
            JanusGraphAssert.assertCount(i, this.tx.query().has("time", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)(i + i)).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("time", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)(i + i)).edges());
        }
        for (i = 0; i < numV; i += 5) {
            this.testGeo(i, originalNumV, numV);
        }
        JanusGraphAssert.assertCount(4, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).vertices());
        JanusGraphAssert.assertCount(4, this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).edges());
        JanusGraphAssert.assertCount(5, this.tx.query().has("time", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)30).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        double offset = 950.0 / (double)originalNumV;
        double distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        JanusGraphAssert.assertCount(5, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        JanusGraphAssert.assertCount(5, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)words[0]).vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().edges());
        JanusGraphAssert.assertCount(numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"world").vertices());
        JanusGraphAssert.assertCount(numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"world").edges());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"world").vertices());
        JanusGraphAssert.assertCount(0, this.tx.query().has("name", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"world").edges());
        JanusGraphAssert.assertCount(numV - numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"world").vertices());
        JanusGraphAssert.assertCount(numV - numV / words.length, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"world").edges());
        JanusGraphAssert.assertCount(numV, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"world").vertices());
        JanusGraphAssert.assertCount(numV, this.tx.query().has("name", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"world").edges());
    }

    @Test
    public void testBooleanIndexing() {
        PropertyKey name = this.makeKey("visible", Boolean.class);
        this.mgmt.buildIndex("booleanIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("visible", (Object)true);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("visible", (Object)false);
        JanusGraphAssert.assertCount(2, this.graph.vertices(new Object[0]));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)true)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)false)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)true)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)false)));
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(2, this.graph.vertices(new Object[0]));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)true)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (Object)false)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)true)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("visible", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)false)));
    }

    @Test
    public void testDateIndexing() {
        PropertyKey name = this.makeKey("date", Date.class);
        this.mgmt.buildIndex("dateIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("date", (Object)new Date(1L));
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("date", (Object)new Date(2000L));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.EQUAL, (Object)new Date(1L))));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)new Date(1L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)new Date(1L)).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)new Date(2000L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)new Date(2000L)).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)new Date(1L))));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.EQUAL, (Object)new Date(1L))));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)new Date(1L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)new Date(1L)).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)new Date(2000L))));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("date", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)new Date(2000L)).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("date", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)new Date(1L))));
    }

    @Test
    public void testInstantIndexing() {
        PropertyKey name = this.makeKey("instant", Instant.class);
        this.mgmt.buildIndex("instantIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        Instant firstTimestamp = Instant.ofEpochMilli(1L);
        Instant secondTimestamp = Instant.ofEpochMilli(2000L);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("instant", (Object)firstTimestamp);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("instant", (Object)secondTimestamp);
        this.testInstant(firstTimestamp, secondTimestamp, v1, v2);
        firstTimestamp = Instant.ofEpochSecond(0L, 1L);
        v1 = (JanusGraphVertex)this.graph.vertices(new Object[]{v1.id()}).next();
        v1.property("instant", (Object)firstTimestamp);
        if (this.indexFeatures.supportsNanoseconds()) {
            this.testInstant(firstTimestamp, secondTimestamp, v1, v2);
        } else {
            this.clopen(new Object[0]);
            try {
                Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
                Assertions.fail((String)"Should have failed to update the index");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void testInstant(Instant firstTimestamp, Instant secondTimestamp, JanusGraphVertex v1, JanusGraphVertex v2) {
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)firstTimestamp).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)secondTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)secondTimestamp).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)firstTimestamp)));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.EQUAL, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)firstTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)firstTimestamp).vertices()));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN, (Object)secondTimestamp)));
        Assertions.assertEquals((Object)Sets.newHashSet((Object[])new JanusGraphVertex[]{v1, v2}), (Object)Sets.newHashSet((Iterable)this.graph.query().has("instant", (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)secondTimestamp).vertices()));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("instant", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)firstTimestamp)));
    }

    @Test
    public void testUUIDIndexing() {
        PropertyKey name = this.makeKey("uid", UUID.class);
        this.mgmt.buildIndex("uuidIndex", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        UUID uid1 = UUID.randomUUID();
        UUID uid2 = UUID.randomUUID();
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property("uid", (Object)uid1);
        JanusGraphVertex v2 = this.graph.addVertex(new Object[0]);
        v2.property("uid", (Object)uid2);
        JanusGraphAssert.assertCount(2, this.graph.query().vertices());
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid1)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid2)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid1)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid2)));
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount(2, this.graph.query().vertices());
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid1)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (Object)uid2)));
        Assertions.assertEquals((Object)v2, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid1)));
        Assertions.assertEquals((Object)v1, (Object)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has("uid", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)uid2)));
    }

    @Test
    public void testConditionalIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("org").make();
        JanusGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
        JanusGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).indexOnly((JanusGraphSchemaType)person).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        JanusGraphIndex index3 = this.mgmt.buildIndex("index3", Vertex.class).indexOnly((JanusGraphSchemaType)org).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        JanusGraphAssert.assertCount(3, this.mgmt.getGraphIndexes(Vertex.class));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assertions.assertEquals((Object)"index2", (Object)index2.name());
        Assertions.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assertions.assertFalse((boolean)index2.isUnique());
        Assertions.assertEquals((int)2, (int)index3.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)index1.getFieldKeys().length);
        Assertions.assertEquals((int)3, (int)index3.getParametersFor(text).length);
        Assertions.assertEquals((int)2, (int)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        Assertions.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assertions.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        JanusGraphAssert.assertCount(3, this.mgmt.getGraphIndexes(Vertex.class));
        Assertions.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assertions.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assertions.assertEquals((Object)"index2", (Object)index2.name());
        Assertions.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assertions.assertFalse((boolean)index2.isUnique());
        Assertions.assertEquals((int)2, (int)index3.getFieldKeys().length);
        Assertions.assertEquals((int)1, (int)index1.getFieldKeys().length);
        Assertions.assertEquals((int)3, (int)index3.getParametersFor(text).length);
        Assertions.assertEquals((int)2, (int)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        weight = this.tx.getPropertyKey("weight");
        int numV = 200;
        String[] strings = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] stringsTwo = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsTwo[i] = strings[i] + " " + strings[i];
        }
        int modulo = 5;
        Assertions.assertEquals((int)0, (int)(200 % (5 * strings.length * 2)));
        for (int i = 0; i < 200; ++i) {
            JanusGraphVertex v = this.tx.addVertex(i % 2 == 0 ? "person" : "org");
            v.property("name", (Object)strings[i % strings.length]);
            v.property("text", (Object)strings[i % strings.length]);
            v.property("weight", (Object)((double)(i % 5) + 0.5));
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[1]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / (5 * strings.length), new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.ASC, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[1]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"org").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.DESC, index3.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / (5 * strings.length), new boolean[]{true, true}, index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[2]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person"), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has(LABEL_NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"person").orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{true, true}, weight, Order.ASC, index1.name(), index2.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).orderBy("weight", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 200 / strings.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
    }

    @Test
    public void testGraphCentricQueryProfiling() {
        Metrics nested;
        Metrics mMixedOr;
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey prop = this.makeKey("prop", String.class);
        PropertyKey description = this.makeKey("desc", String.class);
        PropertyKey pet = this.makeKey("pet", String.class);
        PropertyKey height = this.makeKey("height", Integer.class);
        PropertyKey weight = this.makeKey("weight", Float.class);
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(name, new Parameter[]{Mapping.STRING.asParameter()}).addKey(prop, new Parameter[]{Mapping.STRING.asParameter()}).addKey(height).addKey(weight).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("mi", Vertex.class).addKey(description).addKey(pet).buildMixedIndex(INDEX2);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "bob", "prop", "val", "desc", "he likes coding", "pet", "he likes dogs", "age", 20, "height", 170, "weight", 72.3});
        this.tx.addVertex(new Object[]{"name", "bob", "prop", "val2", "desc", "he likes coding", "pet", "he likes cats", "age", 25, "height", 175, "weight", 102.5});
        this.tx.addVertex(new Object[]{"name", "alex", "prop", "val", "desc", "he likes debugging", "pet", "he likes cats", "age", 20, "height", 190, "weight", 55.3});
        this.tx.commit();
        if (this.indexFeatures.supportNotQueryNormalForm()) {
            this.newTx();
            Assertions.assertEquals((long)3L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).count().next()));
            Assertions.assertEquals((int)3, (int)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).toList().size());
            Assertions.assertEquals((Object)190, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).values(new String[]{"height"}).max().next());
            Assertions.assertEquals((Object)25, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).values(new String[]{"age"}).max().next());
            Assertions.assertEquals((Object)170, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).values(new String[]{"height"}).min().next());
            Assertions.assertEquals((Object)535L, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).values(new String[]{"height"}).sum().next());
            Assertions.assertEquals((Object)178.33333333333334, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).values(new String[]{"height"}).mean().next());
            mMixedOr = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val")}).profile().next()).getMetrics(0);
            Assertions.assertEquals((Object)"Or(JanusGraphStep([],[name.eq(bob)]),JanusGraphStep([],[prop.eq(val)]))", (Object)mMixedOr.getName());
            Assertions.assertTrue((mMixedOr.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            Assertions.assertEquals((int)2, (int)mMixedOr.getNested().size());
            nested = (Metrics)mMixedOr.getNested().toArray()[0];
            Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
            Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            nested = (Metrics)mMixedOr.getNested().toArray()[1];
            Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
            Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            HashMap annotations = new HashMap(){
                {
                    this.put("condition", "((name = bob) OR (prop = val))");
                    this.put("orders", "[]");
                    this.put("isFitted", "true");
                    this.put("isOrdered", "true");
                    this.put("query", "[((name = bob) OR (prop = val))]:mixed");
                    this.put("index", "mixed");
                    this.put("index_impl", JanusGraphIndexTest.INDEX);
                }
            };
            Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
            this.newTx();
            Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val2")}).or(new Traversal[]{__.has((String)"name", (Object)"alex"), __.has((String)"prop", (Object)"val")}).count().next()));
            Assertions.assertEquals((int)1, (int)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val2")}).or(new Traversal[]{__.has((String)"name", (Object)"alex"), __.has((String)"prop", (Object)"val")}).toList().size());
            Metrics mMixedOr2 = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"prop", (Object)"val2")}).or(new Traversal[]{__.has((String)"name", (Object)"alex"), __.has((String)"prop", (Object)"val")}).profile().next()).getMetrics(0);
            Assertions.assertEquals((Object)"Or(JanusGraphStep([],[name.eq(bob)]),JanusGraphStep([],[prop.eq(val2)])).Or(JanusGraphStep([],[name.eq(alex)]),JanusGraphStep([],[prop.eq(val)]))", (Object)mMixedOr2.getName());
            Assertions.assertTrue((mMixedOr2.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            Assertions.assertEquals((int)2, (int)mMixedOr2.getNested().size());
            nested = (Metrics)mMixedOr2.getNested().toArray()[0];
            Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
            Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            nested = (Metrics)mMixedOr2.getNested().toArray()[1];
            Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
            Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            annotations = new HashMap(){
                {
                    this.put("condition", "(((name = bob) OR (prop = val2)) AND ((name = alex) OR (prop = val)))");
                    this.put("orders", "[]");
                    this.put("isFitted", "true");
                    this.put("isOrdered", "true");
                    this.put("query", "[(((name = bob) OR (prop = val2)) AND ((name = alex) OR (prop = val)))]:mixed");
                    this.put("index", "mixed");
                    this.put("index_impl", JanusGraphIndexTest.INDEX);
                }
            };
            Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
            this.newTx();
            Assertions.assertEquals((long)2L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"alex"), __.has((String)"prop", (Object)"val2")}).or(new Traversal[]{__.has((String)"desc", (P)Text.textContains((Object)"coding")), __.has((String)"pet", (P)Text.textContains((Object)"cats"))}).count().next()));
            Assertions.assertEquals((int)2, (int)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"alex"), __.has((String)"prop", (Object)"val2")}).or(new Traversal[]{__.has((String)"desc", (P)Text.textContains((Object)"coding")), __.has((String)"pet", (P)Text.textContains((Object)"cats"))}).toList().size());
            Metrics mMixedOr3 = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"alex"), __.has((String)"prop", (Object)"val2")}).or(new Traversal[]{__.has((String)"desc", (P)Text.textContains((Object)"coding")), __.has((String)"pet", (P)Text.textContains((Object)"cats"))}).profile().next()).getMetrics(0);
            Assertions.assertEquals((Object)"Or(JanusGraphStep([],[name.eq(alex)]),JanusGraphStep([],[prop.eq(val2)])).Or(JanusGraphStep([],[desc.textContains(coding)]),JanusGraphStep([],[pet.textContains(cats)]))", (Object)mMixedOr3.getName());
            Assertions.assertTrue((mMixedOr3.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            Assertions.assertEquals((int)2, (int)mMixedOr3.getNested().size());
            nested = (Metrics)mMixedOr3.getNested().toArray()[0];
            Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
            Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            nested = (Metrics)mMixedOr3.getNested().toArray()[1];
            Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
            Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
            Map metricsAnnotations = nested.getAnnotations();
            Assertions.assertEquals((int)5, (int)metricsAnnotations.size());
            Assertions.assertEquals((Object)"(((name = alex) OR (prop = val2)) AND ((desc textContains coding) OR (pet textContains cats)))", metricsAnnotations.get("condition"));
            Assertions.assertEquals((Object)"[]", metricsAnnotations.get("orders"));
            Assertions.assertEquals((Object)"true", metricsAnnotations.get("isFitted"));
            Assertions.assertEquals((Object)"true", metricsAnnotations.get("isOrdered"));
            Assertions.assertTrue((metricsAnnotations.get("query").equals("[mixed:[(((name = alex) OR (prop = val2)))]:mixed, mi:[(((desc textContains coding) OR (pet textContains cats)))]:mi]") || metricsAnnotations.get("query").equals("[mi:[(((desc textContains coding) OR (pet textContains cats)))]:mi, mixed:[(((name = alex) OR (prop = val2)))]:mixed]") ? 1 : 0) != 0);
        }
        this.newTx();
        Assertions.assertEquals((long)3L, (Long)((Long)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"age", (Object)20)}).count().next()));
        Assertions.assertEquals((int)3, (int)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"age", (Object)20)}).toList().size());
        Assertions.assertEquals((Object)190, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"age", (Object)20)}).values(new String[]{"height"}).max().next());
        Assertions.assertEquals((Object)170, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"age", (Object)20)}).values(new String[]{"height"}).min().next());
        Assertions.assertEquals((Object)535L, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"age", (Object)20)}).values(new String[]{"height"}).sum().next());
        Assertions.assertEquals((Object)178.33333333333334, (Object)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"age", (Object)20)}).values(new String[]{"height"}).mean().next());
        mMixedOr = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"bob"), __.has((String)"age", (Object)20)}).profile().next()).getMetrics(0);
        Assertions.assertEquals((Object)"Or(JanusGraphStep([],[name.eq(bob)]),JanusGraphStep([],[age.eq(20)]))", (Object)mMixedOr.getName());
        Assertions.assertTrue((mMixedOr.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)5, (int)mMixedOr.getNested().size());
        nested = (Metrics)mMixedOr.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mMixedOr.getNested().toArray()[1];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mMixedOr.getNested().toArray()[2];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        final String nameKey = this.getStringField("name");
        HashMap annotations = new HashMap(){
            {
                this.put("condition", "(name = bob)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", String.format("[(%s = bob)]:mixed", nameKey));
                this.put("index", "mixed");
                this.put("index_impl", JanusGraphIndexTest.INDEX);
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
        nested = (Metrics)mMixedOr.getNested().toArray()[3];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mMixedOr.getNested().toArray()[4];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        annotations = new HashMap(){
            {
                this.put("condition", "(age = 20)");
                this.put("orders", "[]");
                this.put("isFitted", "false");
                this.put("isOrdered", "true");
                this.put("query", "[]");
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
        nested = (Metrics)nested.getNested().toArray()[0];
        HashMap fullScanAnnotations = new HashMap(){
            {
                this.put("query", "[]");
                this.put("fullscan", "true");
                this.put("condition", "VERTEX");
            }
        };
        Assertions.assertEquals((Object)fullScanAnnotations, (Object)nested.getAnnotations());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        this.newTx();
        Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").count().next()));
        Assertions.assertEquals((int)1, (int)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").toList().size());
        Assertions.assertEquals((Object)170, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).max().next());
        Assertions.assertEquals((Object)170, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).min().next());
        Assertions.assertEquals((Object)170L, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).sum().next());
        Assertions.assertEquals((Object)170.0, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).mean().next());
        Assertions.assertEquals((double)174.8, (double)((Double)((Number)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").values(new String[]{"weight"}).sum().next())), (double)0.001);
        Metrics mMixedAnd = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").profile().next()).getMetrics(0);
        Assertions.assertEquals((Object)"JanusGraphStep([],[name.eq(bob), prop.eq(val)])", (Object)mMixedAnd.getName());
        Assertions.assertTrue((mMixedAnd.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)mMixedAnd.getNested().size());
        nested = (Metrics)mMixedAnd.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mMixedAnd.getNested().toArray()[1];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        final String propKey = this.getStringField("prop");
        annotations = new HashMap(){
            {
                this.put("condition", "(name = bob AND prop = val)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", String.format("[(%s = bob AND %s = val)]:mixed", nameKey, propKey));
                this.put("index", "mixed");
                this.put("index_impl", JanusGraphIndexTest.INDEX);
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
        this.newTx();
        Assertions.assertEquals((long)1L, (Long)((Long)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").count().next()));
        Assertions.assertEquals((int)1, (int)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").toList().size());
        Assertions.assertEquals((Object)170, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).max().next());
        Assertions.assertEquals((Object)170, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).min().next());
        Assertions.assertEquals((Object)170L, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).sum().next());
        Assertions.assertEquals((Object)170.0, (Object)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").values(new String[]{"height"}).mean().next());
        Metrics mMixedAnd2 = ((TraversalMetrics)this.tx.traversal().V(new Object[0]).has("name", (Object)"bob").has("prop", (Object)"val").has("desc", (P)Text.textContains((Object)"coding")).profile().next()).getMetrics(0);
        Assertions.assertEquals((Object)"JanusGraphStep([],[name.eq(bob), prop.eq(val), desc.textContains(coding)])", (Object)mMixedAnd2.getName());
        Assertions.assertTrue((mMixedAnd2.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((int)2, (int)mMixedAnd2.getNested().size());
        nested = (Metrics)mMixedAnd2.getNested().toArray()[0];
        Assertions.assertEquals((Object)"constructGraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        nested = (Metrics)mMixedAnd2.getNested().toArray()[1];
        Assertions.assertEquals((Object)"GraphCentricQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        final String descKey = this.getTextField("desc");
        annotations = new HashMap(){
            {
                this.put("condition", "(name = bob AND prop = val AND desc textContains coding)");
                this.put("orders", "[]");
                this.put("isFitted", "true");
                this.put("isOrdered", "true");
                this.put("query", String.format("[mixed:[(%s = bob AND %s = val)]:mixed, mi:[(%s textContains coding)]:mi]", nameKey, propKey, descKey));
            }
        };
        Assertions.assertEquals((Object)annotations, (Object)nested.getAnnotations());
    }

    @Test
    public void testIndexSelectStrategy() {
        PropertyKey name = this.makeKey("name", String.class);
        JanusGraphIndex compositeNameIndex = this.mgmt.buildIndex("composite", Vertex.class).addKey(name).buildCompositeIndex();
        compositeNameIndex.name();
        PropertyKey prop = this.makeKey("prop", String.class);
        JanusGraphIndex mixedIndex = this.mgmt.buildIndex("mixed", Vertex.class).addKey(name, new Parameter[]{Mapping.STRING.asParameter()}).addKey(prop, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX);
        mixedIndex.name();
        this.finishSchema();
        Assertions.assertEquals((long)1L, (long)this.getIndexSelectResultNum(new Object[0]));
        Assertions.assertEquals((long)1L, (long)this.getIndexSelectResultNum(JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_SELECT_STRATEGY, new String[0]), ThresholdBasedIndexSelectionStrategy.class.getName()));
        Assertions.assertEquals((long)1L, (long)this.getIndexSelectResultNum(JanusGraphIndexTest.option(ThresholdBasedIndexSelectionStrategy.INDEX_SELECT_BRUTE_FORCE_THRESHOLD, new String[0]), 10, JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_SELECT_STRATEGY, new String[0]), "threshold-based"));
        Assertions.assertEquals((long)2L, (long)this.getIndexSelectResultNum(JanusGraphIndexTest.option(ThresholdBasedIndexSelectionStrategy.INDEX_SELECT_BRUTE_FORCE_THRESHOLD, new String[0]), 0, JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_SELECT_STRATEGY, new String[0]), "threshold-based"));
        Assertions.assertEquals((long)1L, (long)this.getIndexSelectResultNum(JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_SELECT_STRATEGY, new String[0]), "brute-force"));
        Assertions.assertEquals((long)2L, (long)this.getIndexSelectResultNum(JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_SELECT_STRATEGY, new String[0]), "approximate"));
    }

    private long getIndexSelectResultNum(Object ... settings) {
        this.clopen(settings);
        GraphTraversalSource g = this.graph.traversal();
        Metrics metrics = ((TraversalMetrics)g.V(new Object[0]).has("name", (Object)"value").has("prop", (Object)"value").profile().next()).getMetrics(0);
        return this.getBackendQueriesNum(metrics);
    }

    private long getBackendQueriesNum(Metrics metrics) {
        if (metrics.getName().equals("backend-query")) {
            return 1L;
        }
        int sum = 0;
        for (Metrics subMetrics : metrics.getNested()) {
            sum = (int)((long)sum + this.getBackendQueriesNum(subMetrics));
        }
        return sum;
    }

    @Test
    public void testCompositeVsMixedIndexing() {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        PropertyKey intId = this.makeKey("intId", Integer.class);
        PropertyKey intId2 = this.makeKey("intId2", Integer.class);
        PropertyKey verboseId = this.makeKey("verboseId", Integer.class);
        this.mgmt.buildIndex("composite", Vertex.class).addKey(intId).addKey(verboseId).buildCompositeIndex();
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(intId2).addKey(verboseId).buildMixedIndex(INDEX);
        this.finishSchema();
        this.tx.addVertex(new Object[]{"intId", 123, "intId2", 234});
        this.newTx();
        Exception ex = (Exception)Assertions.assertThrows(JanusGraphException.class, () -> this.tx.traversal().V(new Object[0]).has("intId", (Object)123).hasNext());
        Assertions.assertEquals((Object)"Could not find a suitable index to answer graph query and graph scans are disabled: [(intId = 123)]:VERTEX", (Object)ex.getMessage());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has("intId2", (Object)234).hasNext());
    }

    @Test
    public void testCompositeAndMixedIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey text = this.makeKey("text", String.class);
        this.makeKey("flag", Boolean.class);
        JanusGraphIndex composite = this.mgmt.buildIndex("composite", Vertex.class).addKey(name).addKey(weight).buildCompositeIndex();
        JanusGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(weight).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        mixed.name();
        composite.name();
        this.finishSchema();
        int numV = 100;
        String[] strings = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] stringsTwo = new String[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsTwo[i] = strings[i] + " " + strings[i];
        }
        int modulo = 5;
        int divisor = 5 * strings.length;
        for (int i = 0; i < 100; ++i) {
            JanusGraphVertex v = this.tx.addVertex(new Object[0]);
            v.property("name", (Object)strings[i % strings.length]);
            v.property("text", (Object)strings[i % strings.length]);
            v.property("weight", (Object)((double)(i % 5) + 0.5));
            v.property("flag", (Object)true);
        }
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("flag"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name(), composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name(), composite.name());
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[0]).has("flag"), ElementCategory.VERTEX, 100 / strings.length, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[0]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[2]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)2.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.name(), composite.name());
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)strings[3]).has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[3]).has("weight", (JanusGraphPredicate)Cmp.EQUAL, (Object)3.5).has("flag"), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.name(), composite.name());
    }

    private void setupChainGraph(int numV, String[] strings, boolean sameNameMapping) {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_NAME_MAPPING, INDEX), sameNameMapping);
        JanusGraphIndex vindex = this.getExternalIndex(Vertex.class, INDEX);
        JanusGraphIndex eindex = this.getExternalIndex(Edge.class, INDEX);
        JanusGraphIndex pindex = this.getExternalIndex(JanusGraphVertexProperty.class, INDEX);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.addIndexKey(vindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(eindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(pindex, name, new Parameter[]{this.getStringMapping(), Parameter.of((String)"mapped-name", (Object)"xstr")});
        PropertyKey text = this.makeKey("text", String.class);
        this.mgmt.addIndexKey(vindex, text, new Parameter[]{this.getTextMapping(), Parameter.of((String)"mapped-name", (Object)"xtext")});
        this.mgmt.addIndexKey(eindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.addIndexKey(pindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.makeEdgeLabel("knows").signature(new PropertyKey[]{name}).make();
        this.mgmt.makePropertyKey("uid").dataType(String.class).signature(new PropertyKey[]{text}).make();
        PropertyKey number = this.makeKey("number", Integer.class);
        PropertyKey flag = this.makeKey("flag", Boolean.class);
        PropertyKey date = this.makeKey("date", Date.class);
        PropertyKey geo = this.makeKey("geo", Geoshape.class);
        PropertyKey uuid = this.makeKey("uuid", UUID.class);
        this.mgmt.addIndexKey(vindex, number, new Parameter[0]);
        this.mgmt.addIndexKey(vindex, flag, new Parameter[0]);
        this.mgmt.addIndexKey(vindex, date, new Parameter[0]);
        this.mgmt.addIndexKey(vindex, geo, new Parameter[0]);
        this.mgmt.addIndexKey(vindex, uuid, new Parameter[0]);
        this.finishSchema();
        JanusGraphVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            JanusGraphVertex v = this.graph.addVertex(new Object[]{"name", strings[i % strings.length], "text", strings[i % strings.length]});
            v.addEdge("knows", (Vertex)(previous == null ? v : previous), new Object[]{"name", strings[i % strings.length], "text", strings[i % strings.length]});
            v.property("uid", (Object)("v" + i), new Object[]{"name", strings[i % strings.length], "text", strings[i % strings.length]});
            previous = v;
        }
    }

    @Test
    public void testIndexParameters() {
        int numV = 1000;
        String[] strings = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(1000, strings, false);
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, 1000 / strings.length * 2, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, 1000 / strings.length, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, 1000 / strings.length * 2, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, 1000 / strings.length, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, 1000 / strings.length * 2, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").properties());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, 1000 / strings.length, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has(LABEL_NAME, (Object)"uid").has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties());
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, 1000 / strings.length * 2, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, 1000 / strings.length, new boolean[]{true, true}, VINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).vertices());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").vertices());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, 1000 / strings.length * 2, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, 1000 / strings.length, new boolean[]{true, true}, EINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).edges());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).edges());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").edges());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").edges());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, 1000 / strings.length * 2, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"beautiful").properties());
        JanusGraphTest.evaluateQuery(this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, 1000 / strings.length, new boolean[]{true, true}, PINDEX);
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"lolipop").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)strings[1]).properties());
        JanusGraphAssert.assertCount(1000 / strings.length * (strings.length - 1), this.graph.query().has(LABEL_NAME, (Object)"uid").has("name", (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)strings[2]).properties());
        JanusGraphAssert.assertCount(0, this.graph.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"farm").properties());
        JanusGraphAssert.assertCount(1000 / strings.length, this.graph.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"ducks").properties());
        JanusGraphAssert.assertCount(1000 / strings.length * 2, this.graph.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties());
        if (this.supportsLuceneStyleQueries()) {
            JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "xtext:ducks").vertexStream());
            JanusGraphAssert.assertCount(0L, this.graph.indexQuery(EINDEX, "xtext:ducks").edgeStream());
        }
    }

    private void checkMixedIndexCountProfiling(TraversalMetrics profile, Map<String, String> annotations) {
        Metrics metrics = profile.getMetrics(0);
        Assertions.assertTrue((metrics.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)metrics.getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Metrics nested = (Metrics)metrics.getNested().toArray()[0];
        Assertions.assertEquals((Object)"MixedIndexCountQuery", (Object)nested.getName());
        Assertions.assertTrue((nested.getDuration(TimeUnit.MICROSECONDS) > 0L ? 1 : 0) != 0);
        Assertions.assertEquals(annotations, (Object)nested.getAnnotations());
    }

    @Test
    public void testMixedIndexQueryFollowedByCount() {
        int numV = 100;
        String[] strings = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(100, strings, true);
        this.clopen(new Object[0]);
        long total = 100 / strings.length * 2;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(VINDEX, "v.text:ducks").vertexTotals());
        TraversalMetrics profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("text", (P)Text.textContains((Object)"ducks")).count().profile().next();
        String xtextKey = "xtext";
        HashMap annotations = new HashMap(){
            {
                this.put("query", String.format("[(%s textContains ducks)]:vsearch", "xtext"));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("text", (P)Text.textContains((Object)"ducks")).count().next()));
        total = 100 / strings.length * 2;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(EINDEX, "e.text:ducks").edgeTotals());
        profile = (TraversalMetrics)this.graph.traversal().E(new Object[0]).has("text", (P)Text.textContains((Object)"ducks")).count().profile().next();
        final String textKey = this.getTextField("text");
        annotations = new HashMap(){
            {
                this.put("query", String.format("[(%s textContains ducks)]:esearch", textKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().E(new Object[0]).has("text", (P)Text.textContains((Object)"ducks")).count().next()));
        total = 100 / strings.length;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(VINDEX, "v.text:farm AND v.name:\"Uncle Berry has a farm\"").vertexTotals());
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("text", (P)Text.textContains((Object)"farm")).has("name", (Object)"Uncle Berry has a farm").count().profile().next();
        final String nameKey = this.getStringField("name");
        annotations = new HashMap(){
            {
                this.put("query", String.format("[(%s textContains farm AND %s = Uncle Berry has a farm)]:vsearch", "xtext", nameKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("text", (P)Text.textContains((Object)"farm")).has("name", (Object)"Uncle Berry has a farm").count().next()));
        total = 100 / strings.length;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(EINDEX, "e.text:farm AND e.name:\"Uncle Berry has a farm\"").edgeTotals());
        profile = (TraversalMetrics)this.graph.traversal().E(new Object[0]).has("text", (P)Text.textContains((Object)"farm")).has("name", (Object)"Uncle Berry has a farm").count().profile().next();
        annotations = new HashMap(){
            {
                this.put("query", String.format("[(%s textContains farm AND %s = Uncle Berry has a farm)]:esearch", textKey, nameKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().E(new Object[0]).has("text", (P)Text.textContains((Object)"farm")).has("name", (Object)"Uncle Berry has a farm").count().next()));
        total = 100 / strings.length * 2;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(VINDEX, "v.name:(\"Uncle Berry has a farm\", \"ducks are beautiful animals\")").vertexTotals());
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("name", P.within((Object[])new String[]{"Uncle Berry has a farm", "ducks are beautiful animals"})).count().profile().next();
        annotations = new HashMap(){
            {
                this.put("query", String.format("[((%s = Uncle Berry has a farm OR %s = ducks are beautiful animals))]:vsearch", nameKey, nameKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name", P.within((Object[])new String[]{"Uncle Berry has a farm", "ducks are beautiful animals"})).count().next()));
        total = 100 / strings.length * 2;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(EINDEX, "e.name:(\"Uncle Berry has a farm\", \"ducks are beautiful animals\")").edgeTotals());
        profile = (TraversalMetrics)this.graph.traversal().E(new Object[0]).has("name", P.within((Object[])new String[]{"Uncle Berry has a farm", "ducks are beautiful animals"})).count().profile().next();
        Assertions.assertTrue((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().E(new Object[0]).has("name", P.within((Object[])new String[]{"Uncle Berry has a farm", "ducks are beautiful animals"})).count().next()));
        total = 100 / strings.length * 2;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(VINDEX, "v.name:(\"Uncle Berry has a farm\", \"and on his farm he has five ducks\")").vertexTotals());
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Uncle Berry has a farm"), __.has((String)"name", (Object)"and on his farm he has five ducks")}).count().profile().next();
        annotations = new HashMap(){
            {
                this.put("query", String.format("[((%s = Uncle Berry has a farm OR %s = and on his farm he has five ducks))]:vsearch", nameKey, nameKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Uncle Berry has a farm"), __.has((String)"name", (Object)"and on his farm he has five ducks")}).count().next()));
        total = 100 / strings.length * 2;
        Assertions.assertEquals((long)total, (Long)this.graph.indexQuery(EINDEX, "e.name:(\"Uncle Berry has a farm\", \"and on his farm he has five ducks\")").edgeTotals());
        profile = (TraversalMetrics)this.graph.traversal().E(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Uncle Berry has a farm"), __.has((String)"name", (Object)"and on his farm he has five ducks")}).count().profile().next();
        Assertions.assertTrue((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().E(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Uncle Berry has a farm"), __.has((String)"name", (Object)"and on his farm he has five ducks")}).count().next()));
        if (this.indexFeatures.supportNotQueryNormalForm()) {
            total = 100 / strings.length * 2;
            profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Uncle Berry has a farm"), __.has((String)"text", (P)Text.textContains((Object)"and on his farm he has five ducks"))}).count().profile().next();
            annotations = new HashMap(){
                {
                    this.put("query", String.format("[((%s = Uncle Berry has a farm) OR (%s textContains and on his farm he has five ducks))]:vsearch", nameKey, "xtext"));
                }
            };
            this.checkMixedIndexCountProfiling(profile, annotations);
            Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Uncle Berry has a farm"), __.has((String)"text", (P)Text.textContains((Object)"and on his farm he has five ducks"))}).count().next()));
        }
        total = 100L;
        this.graph.addVertex(new Object[]{"text", "adhoc text", "number", 1, "flag", false, "date", new Date(), "geo", Geoshape.point((double)1.0, (double)0.0), "uuid", UUID.randomUUID()});
        this.graph.tx().commit();
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("name", P.neq((Object)"value")).count().profile().next();
        annotations = new HashMap(){
            {
                this.put("query", String.format("[(%s <> value)]:vsearch", nameKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)(total + 1L), (Long)((Long)this.graph.traversal().V(new Object[0]).not((Traversal)__.has((String)"name", (P)P.eq((Object)"value"))).count().next()));
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name", P.neq((Object)"value")).count().next()));
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name", P.not((P)P.eq((Object)"value"))).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("number", P.neq((Object)0)).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("flag", P.neq((Object)true)).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("date", P.neq((Object)new Date())).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("geo", P.neq((Object)Geoshape.point((double)0.0, (double)0.0))).count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("uuid", P.neq((Object)UUID.randomUUID())).count().next()));
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("name", P.neq(null)).count().profile().next();
        annotations = new HashMap(){
            {
                this.put("query", String.format("[(%s <> null)]:vsearch", nameKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name", P.neq(null)).count().next()));
        this.graph.traversal().V(new Object[0]).has("text", (P)Text.textContains((Object)"adhoc")).drop().iterate();
        this.graph.tx().commit();
        total = 100L;
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("name").count().profile().next();
        annotations = new HashMap(){
            {
                this.put("query", String.format("[(%s <> null)]:vsearch", nameKey));
            }
        };
        this.checkMixedIndexCountProfiling(profile, annotations);
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name").count().next()));
        total = 100 / strings.length;
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("name", (Object)"Uncle Berry has a farm").out(new String[0]).count().profile().next();
        Assertions.assertFalse((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Assertions.assertTrue((boolean)profile.getMetrics(0).getName().contains(JanusGraphStep.class.getSimpleName()));
        Assertions.assertEquals((long)total, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name", (Object)"Uncle Berry has a farm").out(new String[0]).count().next()));
        PropertyKey ageProperty = this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("ageidx", Vertex.class).addKey(ageProperty).buildCompositeIndex();
        this.finishSchema();
        for (int i = 0; i < 10; ++i) {
            this.tx.addVertex(new Object[]{"age", i % 2, "name", "anonymous"});
        }
        this.newTx();
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("age", (Object)0).count().profile().next();
        Assertions.assertFalse((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Assertions.assertTrue((boolean)profile.getMetrics(0).getName().contains(JanusGraphStep.class.getSimpleName()));
        Assertions.assertEquals((long)5L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("age", (Object)0).count().next()));
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("age").count().profile().next();
        Assertions.assertFalse((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Assertions.assertTrue((boolean)profile.getMetrics(0).getName().contains(JanusGraphStep.class.getSimpleName()));
        Assertions.assertEquals((long)10L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("age").count().next()));
        Assertions.assertEquals((long)10L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name").has("age").count().next()));
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("name").has("age").count().profile().next();
        Assertions.assertFalse((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Assertions.assertEquals((long)5L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name").has("age", (Object)0).count().next()));
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("name").has("age", (Object)0).count().profile().next();
        Assertions.assertFalse((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        profile = (TraversalMetrics)this.graph.traversal().V(new Object[0]).has("age").has("name").count().profile().next();
        Assertions.assertFalse((boolean)profile.getMetrics(0).getName().contains(JanusGraphMixedIndexAggStep.class.getSimpleName()));
        Assertions.assertEquals((long)11000L, (Long)((Long)this.graph.traversal().V(new Object[0]).V(new Object[0]).has("text").count().next()));
        Assertions.assertEquals((Long)((Long)this.graph.traversal().withoutStrategies(new Class[]{JanusGraphMixedIndexCountStrategy.class}).V(new Object[0]).V(new Object[0]).has("text").count().next()), (Long)((Long)this.graph.traversal().V(new Object[0]).V(new Object[0]).has("text").count().next()));
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("name").count().count().next()));
        Assertions.assertEquals((Long)((Long)this.graph.traversal().withoutStrategies(new Class[]{JanusGraphMixedIndexCountStrategy.class}).V(new Object[0]).has("name").count().count().next()), (Long)((Long)this.graph.traversal().V(new Object[0]).has("name").count().count().next()));
        Assertions.assertEquals((long)100L, (Long)((Long)this.graph.traversal().V(new Object[0]).barrier().has("text").count().next()));
        Assertions.assertEquals((Long)((Long)this.graph.traversal().withoutStrategies(new Class[]{JanusGraphMixedIndexCountStrategy.class}).V(new Object[0]).barrier().has("text").count().next()), (Long)((Long)this.graph.traversal().V(new Object[0]).barrier().has("text").count().next()));
        Assertions.assertEquals((long)100L, (Long)((Long)this.graph.traversal().V(new Object[0]).has("text").identity().count().barrier().identity().next()));
        Assertions.assertEquals((Long)((Long)this.graph.traversal().withoutStrategies(new Class[]{JanusGraphMixedIndexCountStrategy.class}).V(new Object[0]).has("text").identity().count().barrier().identity().next()), (Long)((Long)this.graph.traversal().V(new Object[0]).has("text").identity().count().barrier().identity().next()));
    }

    @Test
    public void testRawQueries() {
        if (!this.supportsLuceneStyleQueries()) {
            return;
        }
        int numV = 1000;
        String[] strings = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(1000, strings, true);
        this.clopen(new Object[0]);
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "v.text:ducks").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry)").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length), this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry) AND v.name:\"Uncle Berry has a farm\"").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2 - 10), this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").offset(10).vertexStream());
        long total = this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(Integer.MAX_VALUE).vertexStream().count();
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).vertexStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).vertexTotals());
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(10).vertexStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(10).vertexTotals());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(1000).vertexStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(1000).vertexTotals());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "xtext:ducks").vertexStream());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(VINDEX, "text:ducks").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(VINDEX, "$v$text:ducks").setElementIdentifier("$v$").vertexStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "e.text:ducks").edgeStream());
        total = this.graph.indexQuery(EINDEX, "e.text:ducks").limit(Integer.MAX_VALUE).edgeStream().count();
        Assertions.assertEquals((float)total, (float)(1000L / (long)strings.length * 2L), (float)this.graph.indexQuery(EINDEX, "e.text:ducks").edgeTotals().longValue());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry)").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length), this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry) AND e.name:\"Uncle Berry has a farm\"").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2 - 10), this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").offset(10).edgeStream());
        total = this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(Integer.MAX_VALUE).edgeStream().count();
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).edgeStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).edgeTotals());
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(10).edgeStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(10).edgeTotals());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(1000).edgeStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(1000).edgeTotals());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(EINDEX, "text:ducks").edgeStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "p.text:ducks").propertyStream());
        total = this.graph.indexQuery(PINDEX, "p.text:ducks").limit(Integer.MAX_VALUE).propertyStream().count();
        Assertions.assertEquals((float)total, (float)(1000L / (long)strings.length * 2L), (float)this.graph.indexQuery(PINDEX, "p.text:ducks").propertyTotals().longValue());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry)").propertyStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length), this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry) AND p.name:\"Uncle Berry has a farm\"").propertyStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").propertyStream());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2 - 10), this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").offset(10).propertyStream());
        total = this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(Integer.MAX_VALUE).propertyStream().count();
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).propertyStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).propertyTotals());
        JanusGraphAssert.assertCount(10L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(10).propertyStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(10).propertyTotals());
        JanusGraphAssert.assertCount(0L, this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(1000).propertyStream());
        Assertions.assertEquals((long)total, (long)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(1000).propertyTotals());
        JanusGraphAssert.assertCount((long)(1000 / strings.length * 2), this.graph.indexQuery(PINDEX, "text:ducks").propertyStream());
    }

    @Test
    public void testRawQueriesWithParameters() {
        String backend;
        if (!this.supportsLuceneStyleQueries()) {
            return;
        }
        Parameter asc_sort_p = null;
        Parameter desc_sort_p = null;
        switch (backend = (String)this.readConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX})) {
            case "elasticsearch": {
                HashMap<String, String> sortAsc = new HashMap<String, String>();
                sortAsc.put("_score", "asc");
                asc_sort_p = new Parameter("sort", Collections.singletonList(sortAsc));
                HashMap<String, String> sortDesc = new HashMap<String, String>();
                sortDesc.put("_score", "desc");
                desc_sort_p = new Parameter("sort", Collections.singletonList(sortDesc));
                break;
            }
            case "solr": {
                asc_sort_p = new Parameter("sort", (Object)new String[]{"score asc"});
                desc_sort_p = new Parameter("sort", (Object)new String[]{"score desc"});
                break;
            }
            case "lucene": {
                return;
            }
            default: {
                Assertions.fail((String)("Unknown index backend:" + backend));
            }
        }
        PropertyKey field1Key = this.mgmt.makePropertyKey("field1").dataType(String.class).make();
        this.mgmt.buildIndex("store1", Vertex.class).addKey(field1Key).buildMixedIndex(INDEX);
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v1.property("field1", (Object)"Hello Hello Hello Hello Hello Hello Hello Hello world");
        v2.property("field1", (Object)"Hello blue and yellow meet green");
        v3.property("field1", (Object)"Hello Hello world world");
        this.tx.commit();
        List vertices = this.graph.indexQuery("store1", "v.field1:(Hello)").addParameter(asc_sort_p).vertexStream().map(JanusGraphIndexQuery.Result::getElement).collect(Collectors.toList());
        JanusGraphAssert.assertNotEmpty(vertices);
        AtomicInteger idx = new AtomicInteger(vertices.size() - 1);
        this.graph.indexQuery("store1", "v.field1:(Hello)").addParameter(desc_sort_p).vertexStream().map(JanusGraphIndexQuery.Result::getElement).forEachOrdered(e -> Assertions.assertEquals(vertices.get(idx.getAndDecrement()), (Object)e));
    }

    @Test
    public void testDualMapping() {
        if (!this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        JanusGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(name, new Parameter[]{Mapping.TEXTSTRING.asParameter()}).buildMixedIndex(INDEX);
        mixed.name();
        this.finishSchema();
        this.tx.addVertex(new Object[]{"name", "Long John Don"});
        this.tx.addVertex(new Object[]{"name", "Long Little Lewis"});
        this.tx.addVertex(new Object[]{"name", "Middle Sister Mabel"});
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Cmp.EQUAL, (Object)"Long John Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"Lon"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"Lit*le"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.REGEX, (Object)"Long.*"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"Middle"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.FUZZY, (Object)"Long john Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS_FUZZY, (Object)"Midle"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().orderBy("name", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 3, new boolean[]{false, false}, this.tx.getPropertyKey("name"), Order.ASC, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().orderBy("name", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 3, new boolean[]{false, false}, this.tx.getPropertyKey("name"), Order.DESC, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long").orderBy("name", org.apache.tinkerpop.gremlin.process.traversal.Order.asc), ElementCategory.VERTEX, 2, new boolean[]{true, true}, this.tx.getPropertyKey("name"), Order.ASC, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long").orderBy("name", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 2, new boolean[]{true, true}, this.tx.getPropertyKey("name"), Order.DESC, "mixed");
        for (Vertex u : this.tx.getVertices(new Object[0])) {
            String n = (String)u.value("name");
            if (n.endsWith("Don")) {
                u.remove();
                continue;
            }
            if (n.endsWith("Lewis")) {
                u.property(VertexProperty.Cardinality.single, "name", (Object)"Big Brother Bob", new Object[0]);
                continue;
            }
            if (!n.endsWith("Mabel")) continue;
            u.property("name").remove();
        }
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.PREFIX, (Object)"Middle"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mixed");
    }

    @Tag(value="BRITTLE_TESTS")
    @Test
    public void testIndexReplay() throws Exception {
        TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        Instant startTime = times.getTime();
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), Duration.ofMillis(250L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), Duration.ofSeconds(1L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.STORAGE_WRITE_WAITTIME, new String[0]), Duration.ofMillis(300L), JanusGraphIndexTest.option(TestMockIndexProvider.INDEX_BACKEND_PROXY, INDEX), this.readConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX}), JanusGraphIndexTest.option(GraphDatabaseConfiguration.INDEX_BACKEND, INDEX), TestMockIndexProvider.class.getName(), JanusGraphIndexTest.option(TestMockIndexProvider.INDEX_MOCK_FAILADD, INDEX), true);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey age = this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("mi", Vertex.class).addKey(name, new Parameter[]{this.getTextMapping()}).addKey(age).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex[] vs = new JanusGraphVertex[4];
        vs[0] = this.tx.addVertex(new Object[]{"name", "Big Boy Bobson", "age", 55});
        this.newTx();
        vs[1] = this.tx.addVertex(new Object[]{"name", "Long Little Lewis", "age", 35});
        vs[2] = this.tx.addVertex(new Object[]{"name", "Tall Long Tiger", "age", 75});
        vs[3] = this.tx.addVertex(new Object[]{"name", "Long John Don", "age", 15});
        this.newTx();
        vs[2] = JanusGraphIndexTest.getV((Transaction)this.tx, vs[2]);
        vs[2].remove();
        vs[3] = JanusGraphIndexTest.getV((Transaction)this.tx, vs[3]);
        vs[3].property(VertexProperty.Cardinality.single, "name", (Object)"Bad Boy Badsy", new Object[0]);
        vs[3].property("age").remove();
        this.newTx();
        vs[0] = JanusGraphIndexTest.getV((Transaction)this.tx, vs[0]);
        vs[0].property(VertexProperty.Cardinality.single, "age", (Object)66, new Object[0]);
        this.newTx();
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        TransactionRecovery recovery = JanusGraphFactory.startTransactionRecovery((JanusGraph)this.graph, (Instant)startTime);
        Thread.sleep(12000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"long"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"long").interval("age", (Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(40)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("age", (Object)75), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"boy").interval("age", (Comparable)Integer.valueOf(60), (Comparable)Integer.valueOf(70)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("age", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        Assertions.assertEquals((long)1L, (long)recoveryStats[0]);
        Assertions.assertEquals((long)4L, (long)recoveryStats[1]);
    }

    @Test
    public void testIndexUpdatesWithoutReindex() throws InterruptedException, ExecutionException {
        Object[] settings = new Object[]{JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ofMillis(0L), JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L)};
        this.clopen(settings);
        String defText = "Mountain rocks are great friends";
        int defTime = 5;
        double defHeight = 101.1;
        String[] defPhones = new String[]{"1234", "5678"};
        this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.makePropertyKey("height").dataType(Double.class).make();
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            this.mgmt.makePropertyKey("phone").dataType(String.class).cardinality(Cardinality.LIST).make();
        }
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(text, new Parameter[]{this.getTextMapping(), this.getFieldMap(text)}).buildMixedIndex(INDEX);
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey time = this.mgmt.getPropertyKey("time");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), time, new Parameter[]{this.getFieldMap(time)});
        this.finishSchema();
        this.newTx();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        Assertions.assertFalse((boolean)((GraphIndexStatusWatcher)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").status(new SchemaStatus[]{SchemaStatus.ENABLED})).timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call().getSucceeded());
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REGISTER_INDEX).get();
        this.mgmt.commit();
        ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"theIndex").timeout(10L, (TemporalUnit)ChronoUnit.SECONDS)).call();
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX).get();
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 3, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        }
        this.newTx();
        this.finishSchema();
        PropertyKey height = this.mgmt.getPropertyKey("height");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), height, new Parameter[0]);
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            PropertyKey phone = this.mgmt.getPropertyKey("phone");
            this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), phone, new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)});
        }
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        JanusGraphIndex index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assertions.assertEquals((Object)SchemaStatus.ENABLED, (Object)index.getIndexStatus(key));
        }
        this.addVertex(5, "Mountain rocks are great friends", 101.1, defPhones);
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 4, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        }
        this.newTx();
        this.finishSchema();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.REINDEX).get();
        this.mgmt.commit();
        this.finishSchema();
        this.clopen(settings);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"1234"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
            JanusGraphTest.evaluateQuery(this.tx.query().has("phone", (JanusGraphPredicate)Cmp.EQUAL, (Object)"5678"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        }
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("theIndex"), SchemaAction.DISABLE_INDEX).get();
        this.tx.commit();
        this.mgmt.commit();
        ManagementUtil.awaitGraphIndexUpdate((JanusGraph)this.graph, (String)"theIndex", (long)10L, (TemporalUnit)ChronoUnit.SECONDS);
        this.finishSchema();
        index = this.mgmt.getGraphIndex("theIndex");
        for (PropertyKey key : index.getFieldKeys()) {
            Assertions.assertEquals((Object)SchemaStatus.DISABLED, (Object)index.getIndexStatus(key));
        }
        this.newTx();
        JanusGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 5, new boolean[]{false, true}, new String[0]);
    }

    private void addVertex(int time, String text, double height, String[] phones) {
        this.newTx();
        JanusGraphVertex v = this.tx.addVertex(new Object[]{"text", text, "time", time, "height", height});
        for (String phone : phones) {
            v.property("phone", (Object)phone);
        }
        this.newTx();
    }

    @Test
    public void testVertexTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel event = this.mgmt.makeVertexLabel("event").setStatic().make();
        int eventTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((JanusGraphSchemaType)event, Duration.ofSeconds(eventTTLSeconds));
        this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Vertex.class).indexOnly((JanusGraphSchemaType)event).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)time));
        Assertions.assertEquals((Object)Duration.ofSeconds(eventTTLSeconds), (Object)this.mgmt.getTTL((JanusGraphSchemaType)event));
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex("event");
        v1.property(VertexProperty.Cardinality.single, "name", (Object)"first event", new Object[0]);
        v1.property(VertexProperty.Cardinality.single, "text", (Object)"this text will help to identify the first event", new Object[0]);
        long time1 = System.currentTimeMillis();
        v1.property(VertexProperty.Cardinality.single, "time", (Object)time1, new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex("event");
        v2.property(VertexProperty.Cardinality.single, "name", (Object)"second event", new Object[0]);
        v2.property(VertexProperty.Cardinality.single, "text", (Object)"this text won't match", new Object[0]);
        long time2 = time1 + 1L;
        v2.property(VertexProperty.Cardinality.single, "time", (Object)time2, new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        this.clopen(new Object[0]);
        Object v1Id = v1.id();
        Object v2Id = v2.id();
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1Id);
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v1Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)eventTTLSeconds * 1.25), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)eventTTLSeconds * 1.25), TimeUnit.SECONDS));
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"event"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "index2");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.VERTEX, 0, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1Id);
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v2Id);
        Assertions.assertNull((Object)v1);
        Assertions.assertNull((Object)v2);
    }

    @Test
    public void testEdgeTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        PropertyKey time = this.makeKey("time", Long.class);
        EdgeLabel label = this.mgmt.makeEdgeLabel("likes").make();
        int likesTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((JanusGraphSchemaType)label, Duration.ofSeconds(likesTTLSeconds));
        this.mgmt.buildIndex("index1", Edge.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Edge.class).indexOnly((JanusGraphSchemaType)label).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assertions.assertEquals((Object)Duration.ZERO, (Object)this.mgmt.getTTL((JanusGraphSchemaType)name));
        Assertions.assertEquals((Object)Duration.ofSeconds(likesTTLSeconds), (Object)this.mgmt.getTTL((JanusGraphSchemaType)label));
        this.finishSchema();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        JanusGraphEdge e1 = v1.addEdge("likes", (Vertex)v2, new Object[]{"name", "v1 likes v2", "text", "this will help to identify the edge"});
        long time1 = System.currentTimeMillis();
        e1.property("time", (Object)time1);
        JanusGraphEdge e2 = v2.addEdge("likes", (Vertex)v3, new Object[]{"name", "v2 likes v3", "text", "this won't match anything"});
        long time2 = time1 + 1L;
        e2.property("time", (Object)time2);
        this.tx.commit();
        this.clopen(new Object[0]);
        Object e1Id = e1.id();
        e2.id();
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"likes"), ElementCategory.EDGE, 1, new boolean[]{true, true}, "index2");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.EDGE, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1.id());
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v2.id());
        v3 = JanusGraphIndexTest.getV((Transaction)this.tx, v3.id());
        e1 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        e2 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v3);
        Assertions.assertNotNull((Object)e1);
        Assertions.assertNotNull((Object)e2);
        JanusGraphAssert.assertNotEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertNotEmpty(v2.query().direction(Direction.OUT).edges());
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)likesTTLSeconds * 1.25), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        JanusGraphTest.evaluateQuery(this.tx.query().has("text", (JanusGraphPredicate)Text.CONTAINS, (Object)"help").has(LABEL_NAME, (Object)"likes"), ElementCategory.EDGE, 0, new boolean[]{true, true}, "index2");
        JanusGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy("time", org.apache.tinkerpop.gremlin.process.traversal.Order.desc), ElementCategory.EDGE, 0, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC, "index1");
        v1 = JanusGraphIndexTest.getV((Transaction)this.tx, v1.id());
        v2 = JanusGraphIndexTest.getV((Transaction)this.tx, v2.id());
        v3 = JanusGraphIndexTest.getV((Transaction)this.tx, v3.id());
        e1 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        e2 = JanusGraphIndexTest.getE((Transaction)this.tx, e1Id);
        Assertions.assertNotNull((Object)v1);
        Assertions.assertNotNull((Object)v2);
        Assertions.assertNotNull((Object)v3);
        Assertions.assertNull((Object)e1);
        Assertions.assertNull((Object)e2);
        JanusGraphAssert.assertEmpty(v1.query().direction(Direction.OUT).edges());
        JanusGraphAssert.assertEmpty(v2.query().direction(Direction.OUT).edges());
    }

    @Test
    public void testDeleteVertexThenDeleteProperty(TestInfo testInfo) throws BackendException {
        this.testNestedWrites("x", null, testInfo);
    }

    @Test
    public void testDeleteVertexThenAddProperty(TestInfo testInfo) throws BackendException {
        this.testNestedWrites(null, "y", testInfo);
    }

    @Test
    public void testDeleteVertexThenModifyProperty(TestInfo testInfo) throws BackendException {
        this.testNestedWrites("x", "y", testInfo);
    }

    @Test
    public void testIndexQueryWithScore() throws InterruptedException {
        PropertyKey textKey = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.buildIndex("store1", Vertex.class).addKey(textKey).buildMixedIndex(INDEX);
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v2 = this.tx.addVertex(new Object[0]);
        JanusGraphVertex v3 = this.tx.addVertex(new Object[0]);
        v1.property("text", (Object)"Hello Hello Hello Hello Hello Hello Hello Hello world");
        v2.property("text", (Object)"Hello abab abab fsdfsd sfdfsd sdffs fsdsdf fdf fsdfsd aera fsad abab abab fsdfsd sfdf");
        v3.property("text", (Object)"Hello Hello world world");
        this.tx.commit();
        Set scores = this.graph.indexQuery("store1", "v.text:(Hello)").vertexStream().map(JanusGraphIndexQuery.Result::getScore).collect(Collectors.toSet());
        Assertions.assertEquals((int)3, (int)scores.size());
    }

    @Test
    public void testContainsWithMultipleValues() throws Exception {
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.buildIndex("store1", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.commit();
        JanusGraphVertex v1 = this.tx.addVertex(new Object[0]);
        v1.property("name", (Object)"hercules was here");
        this.tx.commit();
        JanusGraphVertex r = (JanusGraphVertex)Iterables.get((Iterable)this.graph.query().has("name", (JanusGraphPredicate)Text.CONTAINS, (Object)"hercules here").vertices(), (int)0);
        Assertions.assertEquals((Object)r.property("name").value(), (Object)"hercules was here");
    }

    private void testNestedWrites(String initialValue, String updatedValue, TestInfo testInfo) throws BackendException {
        try (Backend b = this.graph.getConfiguration().getBackend();){
            if (b.getStoreFeatures().hasTxIsolation()) {
                log.info("Skipping " + this.getClass().getSimpleName() + "." + testInfo.getTestMethod().toString());
                return;
            }
        }
        String propName = "foo";
        PropertyKey prop = this.makeKey("foo", String.class);
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(prop, new Parameter[]{Mapping.STRING.asParameter()}).buildMixedIndex(INDEX);
        this.finishSchema();
        JanusGraphVertex v = this.graph.addVertex(new Object[0]);
        if (null != initialValue) {
            v.property(VertexProperty.Cardinality.single, "foo", (Object)initialValue, new Object[0]);
        }
        this.graph.tx().commit();
        Object id = v.id();
        JanusGraphTransaction vertexDeleter = this.graph.newTransaction();
        JanusGraphTransaction propDeleter = this.graph.newTransaction();
        JanusGraphIndexTest.getV((Transaction)vertexDeleter, id).remove();
        if (null == updatedValue) {
            JanusGraphIndexTest.getV((Transaction)propDeleter, id).property("foo").remove();
        } else {
            JanusGraphIndexTest.getV((Transaction)propDeleter, id).property(VertexProperty.Cardinality.single, "foo", (Object)updatedValue, new Object[0]);
        }
        vertexDeleter.commit();
        propDeleter.commit();
        this.graph.tx().rollback();
        Assertions.assertNull((Object)JanusGraphIndexTest.getV((Transaction)this.graph, id));
        Assertions.assertTrue((boolean)this.verticesRemoved(this.graph.query().has("foo").vertices()));
        if (null != updatedValue) {
            Assertions.assertTrue((boolean)this.verticesRemoved(this.graph.query().has("foo", (Object)updatedValue).vertices()));
        }
        this.graph.tx().rollback();
    }

    private boolean verticesRemoved(Iterable<JanusGraphVertex> vertices) {
        if (Iterables.isEmpty(vertices)) {
            return true;
        }
        StandardJanusGraphTx queryTx = (StandardJanusGraphTx)this.graph.newTransaction();
        for (JanusGraphVertex v : vertices) {
            if (this.graph.edgeQuery(v.id(), this.graph.vertexExistenceQuery, queryTx.getTxHandle()).isEmpty()) continue;
            queryTx.rollback();
            return false;
        }
        queryTx.rollback();
        return true;
    }

    @Test
    public void testWidcardQuery() {
        if (this.supportsWildcardQuery()) {
            PropertyKey p1 = this.makeKey("p1", String.class);
            PropertyKey p2 = this.makeKey("p2", String.class);
            this.mgmt.buildIndex("mixedIndex", Vertex.class).addKey(p1).addKey(p2).buildMixedIndex(INDEX);
            this.finishSchema();
            this.clopen(new Object[0]);
            JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
            v1.property("p1", (Object)"test1");
            v1.property("p2", (Object)"test2");
            this.clopen(new Object[0]);
            Assertions.assertEquals((Object)v1, (Object)((JanusGraphIndexQuery.Result)this.graph.indexQuery("mixedIndex", "v.*:\"test1\"").vertexStream().findFirst().orElseThrow(IllegalStateException::new)).getElement());
            Assertions.assertEquals((Object)v1, (Object)((JanusGraphIndexQuery.Result)this.graph.indexQuery("mixedIndex", "v.*:\"test2\"").vertexStream().findFirst().orElseThrow(IllegalStateException::new)).getElement());
        }
    }

    @Test
    public void testListIndexing() {
        this.testIndexing(Cardinality.LIST);
    }

    protected abstract boolean supportsCollections();

    protected boolean supportsGeoCollections() {
        return true;
    }

    @Test
    public void testSetIndexing() {
        this.testIndexing(Cardinality.SET);
    }

    private void testIndexing(Cardinality cardinality) {
        if (this.supportsCollections()) {
            String backend;
            PropertyKey stringProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(cardinality).make();
            PropertyKey intProperty = this.mgmt.makePropertyKey("age").dataType(Integer.class).cardinality(cardinality).make();
            PropertyKey longProperty = this.mgmt.makePropertyKey("long").dataType(Long.class).cardinality(cardinality).make();
            PropertyKey uuidProperty = this.mgmt.makePropertyKey("uuid").dataType(UUID.class).cardinality(cardinality).make();
            JanusGraphManagement.IndexBuilder indexBuilder = this.mgmt.buildIndex("collectionIndex", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).addKey(intProperty).addKey(longProperty).addKey(uuidProperty);
            if (this.supportsGeoCollections()) {
                PropertyKey geopointProperty = this.mgmt.makePropertyKey("geopoint").dataType(Geoshape.class).cardinality(cardinality).make();
                indexBuilder.addKey(geopointProperty);
            }
            indexBuilder.buildMixedIndex(INDEX);
            this.finishSchema();
            this.testCollection(cardinality, "name", "Totoro", "Hiro");
            this.testCollection(cardinality, "age", 1, 2);
            this.testCollection(cardinality, "long", 1L, 2L);
            if (this.supportsGeoCollections()) {
                this.testCollection(cardinality, "geopoint", Geoshape.point((double)1.0, (double)1.0), Geoshape.point((double)2.0, (double)2.0));
            }
            if (!"solr".equals(backend = (String)this.readConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX}))) {
                this.testCollection(cardinality, "uuid", UUID.randomUUID(), UUID.randomUUID());
            }
        } else {
            try {
                PropertyKey stringProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(cardinality).make();
                this.mgmt.buildIndex("collectionIndex", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
                Assertions.fail((String)"Should have thrown an exception");
            }
            catch (JanusGraphException janusGraphException) {
                // empty catch block
            }
        }
    }

    private void testCollection(Cardinality cardinality, String property, Object value1, Object value2) {
        this.clopen(new Object[0]);
        JanusGraphVertex v1 = this.graph.addVertex(new Object[0]);
        v1.property(property, value1);
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.property(property, value2);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.properties(new String[]{property}).forEachRemaining(p -> {
            if (p.value().equals(value1)) {
                p.remove();
            }
        });
        Assertions.assertFalse((boolean)this.graph.query().has(property, value1).vertices().iterator().hasNext());
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        Assertions.assertFalse((boolean)this.graph.query().has(property, value1).vertices().iterator().hasNext());
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.property(property, value1);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        v1 = JanusGraphIndexTest.getV((Transaction)this.graph, v1.id());
        v1.property(property, value1);
        Assertions.assertEquals((int)(Cardinality.SET.equals((Object)cardinality) ? 2 : 3), (int)Iterators.size((Iterator)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has(property, value1)).properties(new String[]{property})));
        this.clopen(new Object[0]);
        Assertions.assertEquals((int)(Cardinality.SET.equals((Object)cardinality) ? 2 : 3), (int)Iterators.size((Iterator)JanusGraphIndexTest.getOnlyVertex(this.graph.query().has(property, value1)).properties(new String[]{property})));
        this.graph.vertices(new Object[0]).forEachRemaining(Element::remove);
        v1 = this.graph.addVertex(new Object[0]);
        v1.property(property, value1);
        v1.property(property, value2);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        this.clopen(new Object[0]);
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value1).vertices()));
        Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, value2).vertices()));
        if (value1 instanceof Geoshape && this.supportsGeoCollections()) {
            Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)1.0, (double)1.0, (double)0.1)).vertices()));
            Assertions.assertEquals((Object)v1, JanusGraphIndexTest.getOnlyElement(this.graph.query().has(property, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)2.0, (double)2.0, (double)0.1)).vertices()));
        }
        GraphTraversalSource g = this.graph.traversal();
        g.V(new Object[0]).drop().iterate();
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        v1 = (Vertex)g.addV().property((Object)property, value1, new Object[0]).property((Object)property, value2, new Object[0]).next();
        g.addV().property((Object)property, value1, new Object[0]).property((Object)property, value2, new Object[0]).next();
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        Assertions.assertEquals((int)2, (int)g.V(new Object[0]).has(property, value1).toList().size());
        g.V(new Object[0]).properties(new String[0]).drop().iterate();
        this.clopen(new Object[0]);
        g = this.graph.traversal();
        Assertions.assertFalse((boolean)g.V(new Object[0]).has(property, value1).hasNext());
        Assertions.assertFalse((boolean)g.V(new Object[0]).has(property, value2).hasNext());
    }

    private void testGeo(int i, int origNumV, int numV) {
        double offset = (double)i * 50.0 / (double)origNumV;
        double bufferKm = 20.0;
        double distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        if (i > 0) {
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)(distance - 20.0))).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)(distance - 20.0))).edges());
        }
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges());
        if (this.indexFeatures.supportsGeoContains()) {
            JanusGraphAssert.assertCount(i % 2, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.CONTAINS, (Object)Geoshape.point((double)(-offset), (double)(-offset))).vertices());
            JanusGraphAssert.assertCount(i % 2, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.CONTAINS, (Object)Geoshape.point((double)(-offset), (double)(-offset))).edges());
        }
        double buffer = 0.18018018018018017;
        double min = -Math.abs(offset);
        double max = Math.abs(offset);
        Geoshape bufferedBox = Geoshape.box((double)(min - 0.18018018018018017), (double)(min - 0.18018018018018017), (double)(max + 0.18018018018018017), (double)(max + 0.18018018018018017));
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.WITHIN, (Object)bufferedBox).edges());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("location", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("location", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).edges());
        if (i > 0) {
            Geoshape exactBox = Geoshape.box((double)min, (double)min, (double)max, (double)max);
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactBox).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactBox).edges());
        }
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedBox).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedBox).edges());
        Geoshape bufferedPoly = Geoshape.polygon(Arrays.asList({min - 0.18018018018018017, min - 0.18018018018018017}, {max + 0.18018018018018017, min - 0.18018018018018017}, {max + 0.18018018018018017, max + 0.18018018018018017}, {min - 0.18018018018018017, max + 0.18018018018018017}, {min - 0.18018018018018017, min - 0.18018018018018017}));
        if (i > 0) {
            Geoshape exactPoly = Geoshape.polygon(Arrays.asList({min, min}, {max, min}, {max, max}, {min, max}, {min, min}));
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactPoly).vertices());
            JanusGraphAssert.assertCount(i, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.WITHIN, (Object)exactPoly).edges());
        }
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedPoly).vertices());
        JanusGraphAssert.assertCount(i + 1, this.tx.query().has("boundary", (JanusGraphPredicate)Geo.INTERSECT, (Object)bufferedPoly).edges());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedPoly).vertices());
        JanusGraphAssert.assertCount(numV - (i + 1), this.tx.query().has("boundary", (JanusGraphPredicate)Geo.DISJOINT, (Object)bufferedPoly).edges());
    }

    @Test
    public void shouldAwaitMultipleStatuses() throws InterruptedException, ExecutionException {
        PropertyKey key1 = this.makeKey("key1", String.class);
        JanusGraphIndex index = this.mgmt.buildIndex("randomMixedIndex", Vertex.class).addKey(key1).buildMixedIndex(INDEX);
        if (index.getIndexStatus(key1) == SchemaStatus.INSTALLED) {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("randomMixedIndex"), SchemaAction.REGISTER_INDEX).get();
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("randomMixedIndex"), SchemaAction.ENABLE_INDEX).get();
        } else if (index.getIndexStatus(key1) == SchemaStatus.REGISTERED) {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex("randomMixedIndex"), SchemaAction.ENABLE_INDEX).get();
        }
        PropertyKey key2 = this.makeKey("key2", String.class);
        this.mgmt.addIndexKey(index, key2, new Parameter[0]);
        this.mgmt.commit();
        try {
            ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)"randomMixedIndex").status(new SchemaStatus[]{SchemaStatus.REGISTERED, SchemaStatus.ENABLED})).call();
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed to awaitGraphIndexStatus on multiple statuses.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAndForceIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey nameProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("oridx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).addKey(ageProperty).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            GraphTraversalSource g = customGraph.traversal();
            g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).next();
            g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
            customGraph.tx().commit();
            JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("name", (Object)"Totoro"));
            JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("age", (Object)2));
            JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"age", (Object)2)}));
            JanusGraphAssert.assertCount(0, (Traversal)g.V(new Object[0]).and(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}));
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexUniqueMixedIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey nameProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey lengthProperty = management.makePropertyKey("length").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("oridx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).addKey(ageProperty).addKey(lengthProperty).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            this.testOr((Graph)customGraph);
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexMixedAndCompositeIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey nameProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey lengthProperty = management.makePropertyKey("length").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("nameidx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
            management.buildIndex("ageridx", Vertex.class).addKey(ageProperty).buildCompositeIndex();
            management.buildIndex("lengthidx", Vertex.class).addKey(lengthProperty).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            this.testOr((Graph)customGraph);
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    @Test
    public void testOrPartialIndex() {
        PropertyKey nameProperty = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey lengthProperty = this.mgmt.makePropertyKey("length").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("otheridx", Vertex.class).addKey(nameProperty, new Parameter[]{this.getStringMapping()}).addKey(lengthProperty).buildMixedIndex(INDEX);
        this.finishSchema();
        this.clopen(new Object[0]);
        this.testOr((Graph)this.graph);
    }

    private void testOr(Graph aGraph) {
        GraphTraversalSource g = aGraph.traversal();
        Vertex hiro = (Vertex)g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).property((Object)"length", (Object)90, new Object[0]).next();
        Vertex totoro = (Vertex)g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
        Vertex john = (Vertex)g.addV().property((Object)"name", (Object)"John", new Object[0]).property((Object)"age", (Object)3, new Object[0]).property((Object)"length", (Object)110, new Object[0]).next();
        Vertex mike = (Vertex)g.addV().property((Object)"name", (Object)"Mike", new Object[0]).property((Object)"age", (Object)4, new Object[0]).property((Object)"length", (Object)130, new Object[0]).next();
        aGraph.tx().commit();
        JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("name", (Object)"Totoro"));
        JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).has("age", (Object)2));
        JanusGraphAssert.assertCount(1, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertCount(2, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertCount(2, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro").has("age", (Object)1), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertCount(2, (Traversal)g.V(new Object[0]).or(new Traversal[]{__.and((Traversal[])new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)1)}), __.has((String)"age", (Object)2)}));
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.lte((Object)100)).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (P)P.gte((Object)2))}), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (P)P.gte((Object)2))}).has("length", P.lte((Object)100)), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}).order().by((Comparator)ORDER_AGE_DESC), (Element[])new Vertex[]{hiro, totoro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{totoro, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"age", (Object)2)}).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_DESC)}), (Element[])new Vertex[]{totoro, john, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_ASC)}), (Element[])new Vertex[]{totoro, hiro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"John"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_ASC)}), (Element[])new Vertex[]{john, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_AGE_DESC)}), (Element[])new Vertex[]{totoro, john, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_AGE_ASC)}), (Element[])new Vertex[]{totoro, hiro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_DESC)}).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{totoro, hiro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120)).order().by((Comparator)ORDER_LENGTH_ASC)}).order().by((Comparator)ORDER_AGE_DESC), (Element[])new Vertex[]{john, hiro, totoro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120))}).order().by((Comparator)ORDER_AGE_ASC).limit(2L), (Element[])new Vertex[]{totoro, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)120))}).order().by((Comparator)ORDER_AGE_ASC).range(2L, 3L), (Element[])new Vertex[]{john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).limit(1L)}), (Element[])new Vertex[]{totoro, hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Hiro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).limit(1L)}), (Element[])new Vertex[]{hiro});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).range(1L, 2L)}), (Element[])new Vertex[]{totoro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"length", (P)P.lte((Object)130)).order().by((Comparator)ORDER_LENGTH_ASC).range(1L, 3L)}).limit(2L), (Element[])new Vertex[]{totoro, john});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.gte((Object)130).or((Predicate)P.lt((Object)100))).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro, mike});
        JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.gte((Object)80).and((Predicate)P.gte((Object)130).or((Predicate)P.lt((Object)100)))).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro, mike});
        if (this.indexFeatures.supportNotQueryNormalForm()) {
            JanusGraphAssert.assertTraversal((GraphTraversal)g.V(new Object[0]).has("length", P.gte((Object)80).and((Predicate)P.gte((Object)130)).or((Predicate)P.gte((Object)80).and((Predicate)P.lt((Object)100)))).order().by((Comparator)ORDER_AGE_ASC), (Element[])new Vertex[]{hiro, mike});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexPartialIndex() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            PropertyKey stringProperty = management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("oridx", Vertex.class).addKey(stringProperty, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
            management.commit();
            customGraph.tx().commit();
            GraphTraversalSource g = customGraph.traversal();
            g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).next();
            g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
            customGraph.tx().commit();
            g.V(new Object[0]).or(new Traversal[]{__.has((String)"name", (Object)"Totoro"), __.has((String)"age", (Object)2)}).hasNext();
            Assertions.fail((String)"should fail");
        }
        catch (JanusGraphException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Could not find a suitable index to answer graph query and graph scans are disabled"));
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    @Test
    public void testIndexDataRetrievalWithLimitLessThenBatch() throws Exception {
        WriteConfiguration config = this.getConfiguration();
        config.set("index.search.max-result-set-size", (Object)10);
        JanusGraph customGraph = this.getForceIndexGraph(config);
        JanusGraphManagement management = customGraph.openManagement();
        PropertyKey num = management.makePropertyKey("num").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        management.buildIndex("oridx", Vertex.class).addKey(num).buildMixedIndex(INDEX);
        management.commit();
        customGraph.tx().commit();
        GraphTraversalSource g = customGraph.traversal();
        g.addV().property((Object)"num", (Object)1, new Object[0]).next();
        g.addV().property((Object)"num", (Object)2, new Object[0]).next();
        customGraph.tx().commit();
        Assertions.assertEquals((int)2, (int)customGraph.traversal().V(new Object[0]).has("num", P.lt((Object)3)).limit(4L).toList().size());
        JanusGraphFactory.close((Graph)customGraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrForceIndexComposite() throws Exception {
        JanusGraph customGraph = null;
        try {
            customGraph = this.getForceIndexGraph();
            JanusGraphManagement management = customGraph.openManagement();
            management.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
            PropertyKey ageProperty = management.makePropertyKey("age").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            management.buildIndex("ageridx", Vertex.class).addKey(ageProperty).buildCompositeIndex();
            management.commit();
            customGraph.tx().commit();
            GraphTraversalSource g = customGraph.traversal();
            g.addV().property((Object)"name", (Object)"Hiro", new Object[0]).property((Object)"age", (Object)2, new Object[0]).next();
            g.addV().property((Object)"name", (Object)"Totoro", new Object[0]).property((Object)"age", (Object)1, new Object[0]).next();
            customGraph.tx().commit();
            g.V(new Object[0]).has("age", P.gte((Object)4).or((Predicate)P.lt((Object)2))).hasNext();
            Assertions.fail((String)"should fail");
        }
        catch (JanusGraphException e) {
            Assertions.assertTrue((boolean)e.getMessage().contains("Could not find a suitable index to answer graph query and graph scans are disabled"));
        }
        finally {
            if (customGraph != null) {
                JanusGraphFactory.close((Graph)customGraph);
            }
        }
    }

    @Test
    public void testOrderByWithRange() {
        PropertyKey age = this.makeKey("age", Integer.class);
        JanusGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(age).buildMixedIndex(INDEX);
        this.finishSchema();
        for (int i = 0; i < 100; ++i) {
            this.tx.addVertex(new Object[]{"age", i});
        }
        this.tx.commit();
        Supplier<GraphTraversal> common = () -> this.graph.traversal().V(new Object[0]).has("age", P.gte((Object)0)).order();
        Supplier<GraphTraversal> traversal = () -> ((GraphTraversal)common.get()).by((Comparator)ORDER_AGE_ASC).limit(30L).values(new String[]{"age"});
        JanusGraphAssert.assertBackendHit((TraversalMetrics)traversal.get().profile().next());
        JanusGraphAssert.assertIntRange(traversal.get(), 0, 30);
        traversal = () -> ((GraphTraversal)common.get()).by((Comparator)ORDER_AGE_DESC).limit(30L).values(new String[]{"age"});
        JanusGraphAssert.assertBackendHit((TraversalMetrics)traversal.get().profile().next());
        JanusGraphAssert.assertIntRange(traversal.get(), 99, 69);
        traversal = () -> ((GraphTraversal)common.get()).by((Comparator)ORDER_AGE_ASC).limit(30L).values(new String[]{"age"});
        JanusGraphAssert.assertNoBackendHit((TraversalMetrics)traversal.get().profile().next());
        JanusGraphAssert.assertIntRange(traversal.get(), 0, 30);
        traversal = () -> this.graph.traversal().V(new Object[0]).has("age", P.gte((Object)0)).limit(30L).order().by((Comparator)ORDER_AGE_ASC).values(new String[]{"age"});
        JanusGraphAssert.assertBackendHit((TraversalMetrics)traversal.get().profile().next());
        JanusGraphAssert.assertNoBackendHit((TraversalMetrics)traversal.get().profile().next());
        traversal = () -> ((GraphTraversal)common.get()).by((Comparator)ORDER_AGE_DESC).range(10L, 20L).values(new String[]{"age"});
        JanusGraphAssert.assertNoBackendHit((TraversalMetrics)traversal.get().profile().next());
        JanusGraphAssert.assertIntRange(traversal.get(), 89, 79);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RepeatedIfExceptionsTest(repeats=4, minSuccess=2)
    public void shouldUpdateIndexFieldsAfterIndexModification() throws InterruptedException, ExecutionException {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true, JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(5000L));
        String key1 = "testKey1";
        String key2 = "testKey2";
        String key3 = "testKey3";
        String vertexL = "testVertexLabel";
        String indexName = "mixed";
        PropertyKey p1 = this.mgmt.makePropertyKey(key1).dataType(Long.class).make();
        PropertyKey p2 = this.mgmt.makePropertyKey(key2).dataType(Long.class).make();
        this.mgmt.makeVertexLabel(vertexL).make();
        JanusGraphIndex index = this.mgmt.buildIndex(indexName, Vertex.class).indexOnly((JanusGraphSchemaType)this.mgmt.getVertexLabel(vertexL)).addKey(this.mgmt.getPropertyKey(key1)).addKey(this.mgmt.getPropertyKey(key2)).buildMixedIndex(INDEX);
        if (index.getIndexStatus(p1) == SchemaStatus.INSTALLED) {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.REGISTER_INDEX).get();
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.ENABLE_INDEX).get();
        } else if (index.getIndexStatus(p1) == SchemaStatus.REGISTERED) {
            this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.ENABLE_INDEX).get();
        }
        this.mgmt.commit();
        JanusGraphVertex vertex = this.graph.addVertex(vertexL);
        vertex.property(key1, (Object)111L);
        vertex.property(key2, (Object)222L);
        this.graph.tx().commit();
        Thread.sleep(1500L);
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).hasLabel(vertexL, new String[0]).has(key1, (Object)111L).count().next()));
        Assertions.assertEquals((int)1, (int)this.graph.traversal().V(new Object[0]).hasLabel(vertexL, new String[0]).has(key1, (Object)111L).toList().size());
        JanusGraph graph2 = JanusGraphFactory.open((ReadConfiguration)this.config);
        Assertions.assertEquals((long)1L, (Long)((Long)graph2.traversal().V(new Object[0]).hasLabel(vertexL, new String[0]).has(key1, (Object)111L).count().next()));
        Assertions.assertEquals((int)1, (int)graph2.traversal().V(new Object[0]).hasLabel(vertexL, new String[0]).has(key1, (Object)111L).toList().size());
        this.mgmt = this.graph.openManagement();
        PropertyKey testKey3 = this.mgmt.makePropertyKey(key3).dataType(Long.class).make();
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex(indexName), testKey3, new Parameter[0]);
        this.mgmt.commit();
        ((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED, SchemaStatus.ENABLED})).call();
        this.mgmt = this.graph.openManagement();
        this.mgmt.updateIndex((Index)this.mgmt.getGraphIndex(indexName), SchemaAction.REINDEX).get();
        this.mgmt.commit();
        this.graph.addVertex(new Object[]{T.label, vertexL, key1, 1L, key2, 2L, key3, 3L});
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).hasLabel(vertexL, new String[0]).has(key3, (Object)3L).hasNext());
        try {
            graph2.addVertex(new Object[]{T.label, vertexL, key1, 1L, key2, 2L, key3, 3L});
            JanusGraphException ex = (JanusGraphException)Assertions.assertThrows(JanusGraphException.class, () -> graph2.tx().commit());
            Assertions.assertEquals((Object)"testKey3 is not available in mixed index mixed", (Object)ex.getCause().getMessage());
            Thread.sleep(5000L);
            graph2.tx().commit();
            Assertions.assertTrue((boolean)graph2.traversal().V(new Object[0]).hasLabel(vertexL, new String[0]).has(key3, (Object)3L).hasNext());
        }
        finally {
            graph2.close();
        }
    }

    private void testMultipleOrClauses() {
        if (this.indexFeatures.supportNotQueryNormalForm()) {
            this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        }
        Vertex v1 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)true, new Object[0]).property((Object)"b", (Object)true, new Object[0]).property((Object)"c", (Object)true, new Object[0]).property((Object)"d", (Object)true, new Object[0]).next();
        Vertex v2 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)true, new Object[0]).property((Object)"b", (Object)false, new Object[0]).property((Object)"c", (Object)true, new Object[0]).property((Object)"d", (Object)false, new Object[0]).next();
        Vertex v3 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)false, new Object[0]).property((Object)"b", (Object)true, new Object[0]).property((Object)"c", (Object)false, new Object[0]).property((Object)"d", (Object)true, new Object[0]).next();
        Vertex v4 = (Vertex)this.tx.traversal().addV("test").property((Object)"a", (Object)false, new Object[0]).property((Object)"b", (Object)false, new Object[0]).property((Object)"c", (Object)true, new Object[0]).property((Object)"d", (Object)false, new Object[0]).next();
        this.newTx();
        List vertices = this.tx.traversal().V(new Object[0]).or(new Traversal[]{__.has((String)"a", (Object)true), __.has((String)"b", (Object)true)}).or(new Traversal[]{__.has((String)"c", (Object)false), __.has((String)"d", (Object)true)}).toList();
        Assertions.assertTrue((boolean)vertices.contains(v1));
        Assertions.assertFalse((boolean)vertices.contains(v2));
        Assertions.assertTrue((boolean)vertices.contains(v3));
        Assertions.assertFalse((boolean)vertices.contains(v4));
        Assertions.assertEquals((int)2, (int)vertices.size());
    }

    @Test
    public void testMultipleOrClausesMixed() {
        PropertyKey a = this.makeKey("a", Boolean.class);
        PropertyKey b = this.makeKey("b", Boolean.class);
        PropertyKey c = this.makeKey("c", Boolean.class);
        PropertyKey d = this.makeKey("d", Boolean.class);
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(a).addKey(b).addKey(c).addKey(d).buildMixedIndex(INDEX);
        this.finishSchema();
        this.testMultipleOrClauses();
    }

    @Test
    public void testMultipleOrClausesMultipleMixed() {
        PropertyKey a = this.makeKey("a", Boolean.class);
        PropertyKey b = this.makeKey("b", Boolean.class);
        PropertyKey c = this.makeKey("c", Boolean.class);
        PropertyKey d = this.makeKey("d", Boolean.class);
        this.mgmt.buildIndex("mixed", Vertex.class).addKey(a).addKey(b).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("mi", Vertex.class).addKey(c).addKey(d).buildMixedIndex(INDEX);
        this.finishSchema();
        this.testMultipleOrClauses();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStaleGraphIndexForceRemoveVertex(boolean withLabelConstraint) throws BackendException {
        String vertexLabelName;
        this.clopen(new Object[0]);
        String namePropKeyStr = "name";
        String indexName = "mixed";
        String nameValue = "testValue";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        JanusGraphManagement.IndexBuilder indexBuilder = this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp, new Parameter[]{this.getStringMapping()});
        if (withLabelConstraint) {
            vertexLabelName = "testVertexLabel";
            VertexLabel vertexLabel = this.mgmt.makeVertexLabel(vertexLabelName).make();
            indexBuilder = indexBuilder.indexOnly((JanusGraphSchemaType)vertexLabel);
        } else {
            vertexLabelName = null;
        }
        indexBuilder.buildMixedIndex(INDEX);
        this.finishSchema();
        if (vertexLabelName == null) {
            this.tx.addVertex(new Object[0]).property(namePropKeyStr, (Object)nameValue);
        } else {
            this.tx.addVertex(vertexLabelName).property(namePropKeyStr, (Object)nameValue);
        }
        this.newTx();
        Vertex testVertex = (Vertex)this.getV(namePropKeyStr, nameValue, vertexLabelName).next();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        MixedIndexType index = (MixedIndexType)indexChangeVertex.asIndexType();
        JanusGraphVertexProperty indexedProperty = (JanusGraphVertexProperty)testVertex.property(namePropKeyStr);
        long propertyId = indexedProperty.longId();
        PropertyKey propertyKey = indexedProperty.propertyKey();
        IndexRecordEntry[] record = new IndexRecordEntry[]{new IndexRecordEntry(propertyId, (Object)nameValue, propertyKey)};
        this.getV(namePropKeyStr, nameValue, vertexLabelName).drop().iterate();
        this.newTx();
        CacheVertex element = new CacheVertex((StandardJanusGraphTx)this.tx, (Object)((JanusGraphElement)testVertex).longId(), 1);
        IndexUpdate update = IndexRecordUtil.getMixedIndexUpdate((JanusGraphElement)element, (PropertyKey)propertyKey, (Object)nameValue, (MixedIndexType)index, (IndexMutationType)IndexMutationType.ADD);
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        IndexTransaction indexTransaction = transaction.getIndexTransaction(index.getBackingIndexName());
        indexTransaction.add(index.getStoreName(), (String)update.getKey(), (IndexEntry)update.getEntry(), true);
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{testVertex.id()}).hasNext());
        Assertions.assertTrue((boolean)this.getV(namePropKeyStr, nameValue, vertexLabelName).hasNext());
        Assertions.assertThrows(Exception.class, () -> {
            Vertex cfr_ignored_0 = (Vertex)this.getV(namePropKeyStr, nameValue, vertexLabelName).drop().next();
        });
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{testVertex.id()}).hasNext());
        Assertions.assertTrue((boolean)this.getV(namePropKeyStr, nameValue, vertexLabelName).hasNext());
        StaleIndexRecordUtil.forceRemoveElementFromGraphIndex((JanusGraphElement)element, (IndexRecordEntry[])record, (StandardJanusGraph)this.graph, (String)indexName);
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{testVertex.id()}).hasNext());
        Assertions.assertFalse((boolean)this.getV(namePropKeyStr, nameValue, vertexLabelName).hasNext());
    }

    @Test
    public void testStaleMixedIndexForceFullVertexRemove() throws BackendException {
        this.clopen(new Object[0]);
        String namePropKeyStr = "name";
        String agePropKeyStr = "age";
        String indexName = "mixed";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey ageProp = this.mgmt.makePropertyKey(agePropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp, new Parameter[]{this.getStringMapping()}).addKey(ageProp).buildMixedIndex(INDEX);
        this.finishSchema();
        this.tx.traversal().addV().property((Object)namePropKeyStr, (Object)"vertex2", new Object[0]).property((Object)agePropKeyStr, (Object)123, new Object[0]).iterate();
        this.newTx();
        Vertex vertex2 = (Vertex)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).next();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        MixedIndexType index = (MixedIndexType)indexChangeVertex.asIndexType();
        JanusGraphVertexProperty indexedNameProperty = (JanusGraphVertexProperty)vertex2.property(namePropKeyStr);
        PropertyKey namePropertyKey = indexedNameProperty.propertyKey();
        JanusGraphVertexProperty indexedAgeProperty = (JanusGraphVertexProperty)vertex2.property(agePropKeyStr);
        PropertyKey agePropertyKey = indexedAgeProperty.propertyKey();
        this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).drop().iterate();
        this.newTx();
        CacheVertex element = new CacheVertex((StandardJanusGraphTx)this.tx, (Object)((JanusGraphElement)vertex2).longId(), 1);
        IndexUpdate nameUpdate = IndexRecordUtil.getMixedIndexUpdate((JanusGraphElement)element, (PropertyKey)namePropertyKey, (Object)"vertex2", (MixedIndexType)index, (IndexMutationType)IndexMutationType.ADD);
        IndexUpdate ageUpdate = IndexRecordUtil.getMixedIndexUpdate((JanusGraphElement)element, (PropertyKey)agePropertyKey, (Object)123, (MixedIndexType)index, (IndexMutationType)IndexMutationType.ADD);
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        IndexTransaction indexTransaction = transaction.getIndexTransaction(index.getBackingIndexName());
        indexTransaction.add(index.getStoreName(), (String)nameUpdate.getKey(), (IndexEntry)nameUpdate.getEntry(), true);
        indexTransaction.add(index.getStoreName(), (String)ageUpdate.getKey(), (IndexEntry)ageUpdate.getEntry(), true);
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertThrows(Exception.class, () -> {
            Vertex cfr_ignored_0 = (Vertex)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).drop().next();
        });
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).hasNext());
        StaleIndexRecordUtil.forceRemoveElementFromMixedIndex((Object)element.id(), (JanusGraph)this.graph, (String)indexName);
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).hasNext());
    }

    @Test
    public void testStaleMixedIndexForcePartialEdgeRemove() throws BackendException {
        this.clopen(new Object[0]);
        String namePropKeyStr = "name";
        String agePropKeyStr = "age";
        String edgeKeyStr = "testEdge";
        String indexName = "mixed";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey ageProp = this.mgmt.makePropertyKey(agePropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel(edgeKeyStr).make();
        this.mgmt.buildIndex(indexName, Edge.class).addKey(nameProp, new Parameter[]{this.getStringMapping()}).addKey(ageProp).buildMixedIndex(INDEX);
        this.finishSchema();
        Vertex vertex1 = (Vertex)this.tx.traversal().addV().next();
        Vertex vertex2 = (Vertex)this.tx.traversal().addV().next();
        this.tx.traversal().addE("testEdge").from(vertex1).to(vertex2).property((Object)namePropKeyStr, (Object)"vertex2", new Object[0]).property((Object)agePropKeyStr, (Object)123, new Object[0]).iterate();
        this.newTx();
        Edge edge = (Edge)this.tx.traversal().E(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).next();
        this.tx.traversal().E(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).drop().iterate();
        this.newTx();
        this.graph.tx().rollback();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        MixedIndexType index = (MixedIndexType)indexChangeVertex.asIndexType();
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        IndexTransaction indexTransaction = transaction.getIndexTransaction(index.getBackingIndexName());
        String elementIndexId = IndexRecordUtil.element2String((Object)edge.id());
        String nameIndexField = IndexRecordUtil.key2Field((MixedIndexType)index, (PropertyKey)managementSystem.getPropertyKey(namePropKeyStr));
        String ageIndexField = IndexRecordUtil.key2Field((MixedIndexType)index, (PropertyKey)managementSystem.getPropertyKey(agePropKeyStr));
        Assertions.assertEquals((long)0L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2").edgeTotals());
        Assertions.assertEquals((long)0L, (Long)this.graph.indexQuery(indexName, ageIndexField + ":123").edgeTotals());
        Assertions.assertEquals((long)0L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2 AND " + ageIndexField + ":123").edgeTotals());
        indexTransaction.add(index.getStoreName(), elementIndexId, nameIndexField, (Object)"vertex2", true);
        indexTransaction.add(index.getStoreName(), elementIndexId, ageIndexField, (Object)123, true);
        this.newTx();
        this.graph.tx().rollback();
        Assertions.assertFalse((boolean)this.tx.traversal().E(new Object[]{edge.id()}).hasNext());
        Assertions.assertEquals((long)1L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2").edgeTotals());
        Assertions.assertEquals((long)1L, (Long)this.graph.indexQuery(indexName, ageIndexField + ":123").edgeTotals());
        Assertions.assertEquals((long)1L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2 AND " + ageIndexField + ":123").edgeTotals());
        Assertions.assertThrows(Exception.class, () -> {
            Edge cfr_ignored_0 = (Edge)this.tx.traversal().E(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).drop().next();
        });
        this.newTx();
        this.graph.tx().rollback();
        Assertions.assertFalse((boolean)this.tx.traversal().E(new Object[]{edge.id()}).hasNext());
        Assertions.assertEquals((long)1L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2").edgeTotals());
        Assertions.assertEquals((long)1L, (Long)this.graph.indexQuery(indexName, ageIndexField + ":123").edgeTotals());
        Assertions.assertEquals((long)1L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2 AND " + ageIndexField + ":123").edgeTotals());
        this.newTx();
        this.graph.tx().rollback();
        managementSystem = (ManagementSystem)this.graph.openManagement();
        nameProp = managementSystem.getPropertyKey(namePropKeyStr);
        IndexRecordEntry[] record = new IndexRecordEntry[]{new IndexRecordEntry(nameProp.longId(), (Object)"vertex2", nameProp)};
        StaleIndexRecordUtil.forceRemoveElementFromMixedIndex((Object)edge.id(), (IndexRecordEntry[])record, (JanusGraph)this.graph, (String)indexName);
        managementSystem.rollback();
        this.graph.tx().rollback();
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().E(new Object[]{edge.id()}).hasNext());
        Assertions.assertEquals((long)0L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2").edgeTotals());
        Assertions.assertEquals((long)0L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":vertex2 AND " + ageIndexField + ":123").edgeTotals());
        Assertions.assertEquals((long)1L, (Long)this.graph.indexQuery(indexName, ageIndexField + ":123").edgeTotals());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testStaleGraphIndexForcePartialVertexRemoveByPropertyMap(boolean useMixedIndexMethod) throws BackendException {
        this.clopen(new Object[0]);
        String namePropKeyStr = "name";
        String agePropKeyStr = "age";
        String indexName = "mixed";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey ageProp = this.mgmt.makePropertyKey(agePropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp, new Parameter[]{this.getStringMapping()}).addKey(ageProp).buildMixedIndex(INDEX);
        this.finishSchema();
        this.tx.traversal().addV().property((Object)namePropKeyStr, (Object)"vertex2", new Object[0]).property((Object)agePropKeyStr, (Object)123, new Object[0]).iterate();
        this.newTx();
        Vertex vertex2 = (Vertex)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).next();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        MixedIndexType index = (MixedIndexType)indexChangeVertex.asIndexType();
        JanusGraphVertexProperty indexedNameProperty = (JanusGraphVertexProperty)vertex2.property(namePropKeyStr);
        PropertyKey namePropertyKey = indexedNameProperty.propertyKey();
        JanusGraphVertexProperty indexedAgeProperty = (JanusGraphVertexProperty)vertex2.property(agePropKeyStr);
        PropertyKey agePropertyKey = indexedAgeProperty.propertyKey();
        this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).drop().iterate();
        this.newTx();
        CacheVertex element = new CacheVertex((StandardJanusGraphTx)this.tx, (Object)((JanusGraphElement)vertex2).longId(), 1);
        IndexUpdate nameUpdate = IndexRecordUtil.getMixedIndexUpdate((JanusGraphElement)element, (PropertyKey)namePropertyKey, (Object)"vertex2", (MixedIndexType)index, (IndexMutationType)IndexMutationType.ADD);
        IndexUpdate ageUpdate = IndexRecordUtil.getMixedIndexUpdate((JanusGraphElement)element, (PropertyKey)agePropertyKey, (Object)123, (MixedIndexType)index, (IndexMutationType)IndexMutationType.ADD);
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        IndexTransaction indexTransaction = transaction.getIndexTransaction(index.getBackingIndexName());
        indexTransaction.add(index.getStoreName(), (String)nameUpdate.getKey(), (IndexEntry)nameUpdate.getEntry(), true);
        indexTransaction.add(index.getStoreName(), (String)ageUpdate.getKey(), (IndexEntry)ageUpdate.getEntry(), true);
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertThrows(Exception.class, () -> {
            Vertex cfr_ignored_0 = (Vertex)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).drop().next();
        });
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).hasNext());
        if (useMixedIndexMethod) {
            StaleIndexRecordUtil.forceRemoveElementFromMixedIndex((Object)element.id(), Collections.singletonMap(namePropertyKey.name(), "vertex2"), (JanusGraph)this.graph, (String)indexName);
        } else {
            StaleIndexRecordUtil.forceRemoveVertexFromGraphIndex((Object)((Long)element.id()), Collections.singletonMap(namePropertyKey.name(), "vertex2"), (JanusGraph)this.graph, (String)indexName);
        }
        this.newTx();
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[]{vertex2.id()}).hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").hasNext());
        Assertions.assertFalse((boolean)this.tx.traversal().V(new Object[0]).has(namePropKeyStr, (Object)"vertex2").has(agePropKeyStr, (Object)123).hasNext());
        Assertions.assertTrue((boolean)this.tx.traversal().V(new Object[0]).has(agePropKeyStr, (Object)123).hasNext());
    }

    @Test
    public void testForceRemoveElementFromMixedIndexShouldFailOnCompositeIndex() {
        this.clopen(new Object[0]);
        String namePropKeyStr = "name";
        String indexName = "mixed";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(nameProp).buildCompositeIndex();
        this.finishSchema();
        Assertions.assertThrows(IllegalArgumentException.class, () -> StaleIndexRecordUtil.forceRemoveElementFromMixedIndex((Object)123L, (JanusGraph)this.graph, (String)indexName));
    }

    @Test
    public void testForceRemoveElementFromMixedIndexShouldFailOnWrongPropertiesUsed() throws BackendException {
        this.clopen(new Object[0]);
        String fooPropKeyStr = "foo";
        String barPropKeyStr = "bar";
        String foobarPropKeyStr = "foobar";
        String indexName = "mixed";
        PropertyKey fooProp = this.mgmt.makePropertyKey(fooPropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey barProp = this.mgmt.makePropertyKey(barPropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makePropertyKey(foobarPropKeyStr).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex(indexName, Vertex.class).addKey(fooProp).addKey(barProp).buildMixedIndex(INDEX);
        this.finishSchema();
        StaleIndexRecordUtil.forceRemoveElementFromMixedIndex((Object)123L, Collections.singletonMap(fooPropKeyStr, 123), (JanusGraph)this.graph, (String)indexName);
        Assertions.assertThrows(IllegalArgumentException.class, () -> StaleIndexRecordUtil.forceRemoveElementFromMixedIndex((Object)123L, Collections.singletonMap(foobarPropKeyStr, 123), (JanusGraph)this.graph, (String)indexName));
        StaleIndexRecordUtil.forceRemoveElementFromMixedIndex((Object)123L, Collections.singletonMap(barPropKeyStr, 123), (JanusGraph)this.graph, (String)indexName);
    }

    private GraphTraversal<Vertex, Vertex> getV(String propertyName, Object value, String vertexLabel) {
        GraphTraversal traversal = this.tx.traversal().V(new Object[0]);
        if (vertexLabel != null) {
            traversal = traversal.hasLabel(vertexLabel, new String[0]);
        }
        return traversal.has(propertyName, value);
    }

    @Test
    public void testDisableAndDiscardManuallyAndDropEnabledIndex() throws Exception {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "mixed";
        String propertyName = "prop";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
        this.disableIndex(indexName);
        this.markIndexDiscarded(indexName);
        this.dropIndex(indexName);
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
    }

    @Test
    public void testDiscardManuallyAndDropRegisteredIndex() throws Exception {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "mixed";
        String propertyName = "prop";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.markIndexDiscarded(indexName);
        this.dropIndex(indexName);
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
    }

    @Test
    public void testDiscardAndDropRegisteredIndex() throws ExecutionException, InterruptedException {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "mixed";
        String propertyName = "prop";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.discardIndex(indexName);
        this.dropIndex(indexName);
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
    }

    @Test
    public void testReenableDisabledIndex() throws ExecutionException, InterruptedException {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "mixed";
        String propertyName = "prop";
        String propertyValue = "value";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        this.disableIndex(indexName);
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        this.enableIndex(indexName);
        Assertions.assertEquals((long)1L, (Long)((Long)this.graph.traversal().V(new Object[0]).has(propertyName, (P)Text.textContains((Object)propertyValue)).count().next()));
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        Assertions.assertEquals((long)2L, (Long)((Long)this.graph.traversal().V(new Object[0]).has(propertyName, (P)Text.textContains((Object)propertyValue)).count().next()));
    }

    @Test
    public void testCreateMixedIndexThatPreviouslyExisted() throws ExecutionException, InterruptedException {
        this.clopen(JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "janusgraph"), Duration.ZERO, JanusGraphIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "janusgraph"), Duration.ofMillis(50L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "janusgraph"), Duration.ofMillis(250L), JanusGraphIndexTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        String indexName = "mixed";
        String propertyName = "prop";
        String propertyValue = "value";
        this.makeKey(propertyName, String.class);
        this.finishSchema();
        this.graph.getOpenTransactions().forEach(JanusGraphTransaction::rollback);
        this.mgmt = this.graph.openManagement();
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has(propertyName, (P)Text.textContains((Object)propertyValue)).hasNext());
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        this.disableIndex(indexName);
        this.discardIndex(indexName);
        this.dropIndex(indexName);
        this.registerIndex(indexName, Vertex.class, propertyName);
        this.enableIndex(indexName);
        Assertions.assertFalse((boolean)this.graph.traversal().V(new Object[0]).has(propertyName, (P)Text.textContains((Object)propertyValue)).hasNext());
        this.graph.addVertex(new Object[]{propertyName, propertyValue});
        this.graph.tx().commit();
        Assertions.assertTrue((boolean)this.graph.traversal().V(new Object[0]).has(propertyName, (P)Text.textContains((Object)propertyValue)).hasNext());
    }

    protected void registerIndex(String indexName, Class<? extends Element> type, String ... propertyNames) throws InterruptedException {
        JanusGraphManagement.IndexBuilder builder = this.mgmt.buildIndex(indexName, type);
        for (String prop : propertyNames) {
            builder.addKey(this.mgmt.getPropertyKey(prop));
        }
        builder.buildMixedIndex(INDEX);
        this.mgmt.commit();
        Assertions.assertTrue((boolean)((GraphIndexStatusWatcher)ManagementSystem.awaitGraphIndexStatus((JanusGraph)this.graph, (String)indexName).status(new SchemaStatus[]{SchemaStatus.REGISTERED})).call().getSucceeded());
        this.mgmt = this.graph.openManagement();
    }

    @Test
    public void testStaleEdgesAreSkippedFromMixedIndex() {
        this.clopen(new Object[0]);
        String namePropKeyStr = "name";
        String edgeKeyStr = "testEdge";
        String indexName = "mixed";
        PropertyKey nameProp = this.mgmt.makePropertyKey(namePropKeyStr).dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel(edgeKeyStr).multiplicity(Multiplicity.MULTI).make();
        this.mgmt.buildIndex(indexName, Edge.class).addKey(nameProp, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
        this.finishSchema();
        String nameValue = "NameTestValue";
        Vertex vertex1 = (Vertex)this.tx.traversal().addV().next();
        Vertex vertex2 = (Vertex)this.tx.traversal().addV().next();
        this.tx.traversal().addE("testEdge").from(vertex1).to(vertex2).property((Object)namePropKeyStr, (Object)nameValue, new Object[0]).iterate();
        this.newTx();
        Edge edge = (Edge)this.tx.traversal().E(new Object[0]).has(namePropKeyStr, (Object)nameValue).next();
        Object edgeId = edge.id();
        edge.remove();
        this.newTx();
        this.graph.tx().rollback();
        ManagementSystem managementSystem = (ManagementSystem)this.graph.openManagement();
        JanusGraphIndex janusGraphIndex = managementSystem.getGraphIndex(indexName);
        JanusGraphSchemaVertex indexChangeVertex = managementSystem.getSchemaVertex((JanusGraphSchemaElement)janusGraphIndex);
        MixedIndexType index = (MixedIndexType)indexChangeVertex.asIndexType();
        BackendTransaction transaction = ((StandardJanusGraphTx)this.tx).getTxHandle();
        IndexTransaction indexTransaction = transaction.getIndexTransaction(index.getBackingIndexName());
        String elementIndexId = IndexRecordUtil.element2String((Object)edgeId);
        String nameIndexField = IndexRecordUtil.key2Field((MixedIndexType)index, (PropertyKey)managementSystem.getPropertyKey(namePropKeyStr));
        Assertions.assertEquals((long)0L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":" + nameValue).edgeTotals());
        indexTransaction.add(index.getStoreName(), elementIndexId, nameIndexField, (Object)nameValue, true);
        this.newTx();
        this.graph.tx().rollback();
        this.tx.traversal().addE("testEdge").from((Vertex)this.tx.traversal().V(new Object[]{vertex1}).next()).to((Vertex)this.tx.traversal().V(new Object[]{vertex2}).next()).property((Object)namePropKeyStr, (Object)nameValue, new Object[0]).iterate();
        this.newTx();
        this.graph.tx().rollback();
        Assertions.assertFalse((boolean)this.tx.traversal().E(new Object[]{edgeId}).hasNext());
        Assertions.assertEquals((long)2L, (Long)this.graph.indexQuery(indexName, nameIndexField + ":" + nameValue).edgeTotals());
        Assertions.assertEquals((int)1, (int)this.tx.traversal().E(new Object[0]).has(namePropKeyStr, (Object)nameValue).toList().size());
    }
}

