/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.indexing;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.github.artsok.RepeatedIfExceptionsTest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.attribute.Cmp;
import org.janusgraph.core.attribute.Geo;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.core.attribute.Text;
import org.janusgraph.core.schema.Mapping;
import org.janusgraph.core.schema.Parameter;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.BaseTransaction;
import org.janusgraph.diskstorage.BaseTransactionConfig;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.diskstorage.indexing.IndexEntry;
import org.janusgraph.diskstorage.indexing.IndexFeatures;
import org.janusgraph.diskstorage.indexing.IndexProvider;
import org.janusgraph.diskstorage.indexing.IndexQuery;
import org.janusgraph.diskstorage.indexing.IndexTransaction;
import org.janusgraph.diskstorage.indexing.KeyInformation;
import org.janusgraph.diskstorage.indexing.RawQuery;
import org.janusgraph.diskstorage.indexing.StandardKeyInformation;
import org.janusgraph.diskstorage.util.StandardBaseTransactionConfig;
import org.janusgraph.diskstorage.util.time.TimestampProvider;
import org.janusgraph.diskstorage.util.time.TimestampProviders;
import org.janusgraph.graphdb.internal.Order;
import org.janusgraph.graphdb.query.JanusGraphPredicate;
import org.janusgraph.graphdb.query.condition.And;
import org.janusgraph.graphdb.query.condition.Condition;
import org.janusgraph.graphdb.query.condition.Not;
import org.janusgraph.graphdb.query.condition.Or;
import org.janusgraph.graphdb.query.condition.PredicateCondition;
import org.janusgraph.graphdb.types.ParameterType;
import org.janusgraph.testutil.RandomGenerator;
import org.junit.Assume;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeFactory;
import org.mockito.Mockito;

public abstract class IndexProviderTest {
    private static final Random random = new Random();
    private static final Parameter<?>[] NO_PARAS = new Parameter[0];
    protected IndexProvider index;
    protected IndexFeatures indexFeatures;
    protected IndexTransaction tx;
    protected Map<String, KeyInformation> allKeys;
    protected KeyInformation.IndexRetriever indexRetriever;
    public static final String TEXT = "text";
    public static final String TIME = "time";
    public static final String WEIGHT = "weight";
    public static final String LOCATION = "location";
    public static final String BOUNDARY = "boundary";
    public static final String NAME = "name";
    public static final String PHONE_LIST = "phone_list";
    public static final String PHONE_SET = "phone_set";
    public static final String DATE = "date";
    public static final String TIME_TICK = "time_tick";
    public static final String STRING = "string";
    public static final String ANALYZED = "analyzed";
    public static final String FULL_TEXT = "full_text";
    public static final String KEYWORD = "keyword";
    public static final String TEXT_STRING = "text_string";
    public static final String BOOLEAN = "boolean";
    private final String defStore = "store1";
    private final String defDoc = "docx1-id";
    private final String defTextValue = "the quick brown fox jumps over the lazy dog";

    public static StandardKeyInformation of(Class<?> clazz, Cardinality cardinality, Parameter<?> ... paras) {
        return new StandardKeyInformation(clazz, cardinality, paras);
    }

    public static KeyInformation.IndexRetriever getIndexRetriever(final Map<String, KeyInformation> mappings) {
        return new KeyInformation.IndexRetriever(){

            public KeyInformation get(String store, String key) {
                return (KeyInformation)mappings.get(key);
            }

            public KeyInformation.StoreRetriever get(String store) {
                return mappings::get;
            }

            public void invalidate(String store) {
                mappings.remove(store);
            }
        };
    }

    public static Map<String, KeyInformation> getMapping(final IndexFeatures indexFeatures, final String englishAnalyzerName, final String keywordAnalyzerName, final Mapping fullGeoShapeMapping) {
        Preconditions.checkArgument((indexFeatures.supportsStringMapping(Mapping.TEXTSTRING) || indexFeatures.supportsStringMapping(Mapping.TEXT) && indexFeatures.supportsStringMapping(Mapping.STRING) ? 1 : 0) != 0, (Object)"Index must support string and text mapping");
        final Parameter textParameter = indexFeatures.supportsStringMapping(Mapping.TEXT) ? Mapping.TEXT.asParameter() : Mapping.TEXTSTRING.asParameter();
        final Parameter stringParameter = indexFeatures.supportsStringMapping(Mapping.STRING) ? Mapping.STRING.asParameter() : Mapping.TEXTSTRING.asParameter();
        return new HashMap<String, KeyInformation>(){
            {
                this.put(IndexProviderTest.BOOLEAN, new StandardKeyInformation(Boolean.class, Cardinality.SINGLE, new Parameter[0]));
                this.put(IndexProviderTest.TEXT, new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{textParameter}));
                this.put(IndexProviderTest.TIME, new StandardKeyInformation(Long.class, Cardinality.SINGLE, new Parameter[0]));
                this.put(IndexProviderTest.WEIGHT, new StandardKeyInformation(Double.class, Cardinality.SINGLE, new Parameter[]{Mapping.DEFAULT.asParameter()}));
                this.put(IndexProviderTest.LOCATION, new StandardKeyInformation(Geoshape.class, Cardinality.SINGLE, new Parameter[0]));
                this.put(IndexProviderTest.BOUNDARY, new StandardKeyInformation(Geoshape.class, Cardinality.SINGLE, new Parameter[]{fullGeoShapeMapping.asParameter()}));
                this.put(IndexProviderTest.NAME, new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{stringParameter}));
                if (indexFeatures.supportsCardinality(Cardinality.LIST)) {
                    this.put(IndexProviderTest.PHONE_LIST, new StandardKeyInformation(String.class, Cardinality.LIST, new Parameter[]{stringParameter}));
                    this.put(IndexProviderTest.TIME_TICK, new StandardKeyInformation(Date.class, Cardinality.LIST, new Parameter[0]));
                }
                if (indexFeatures.supportsCardinality(Cardinality.SET)) {
                    this.put(IndexProviderTest.PHONE_SET, new StandardKeyInformation(String.class, Cardinality.SET, new Parameter[]{stringParameter}));
                }
                this.put(IndexProviderTest.DATE, new StandardKeyInformation(Instant.class, Cardinality.SINGLE, new Parameter[0]));
                this.put(IndexProviderTest.STRING, new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{stringParameter, new Parameter(ParameterType.STRING_ANALYZER.getName(), (Object)englishAnalyzerName)}));
                this.put(IndexProviderTest.ANALYZED, new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{textParameter, new Parameter(ParameterType.TEXT_ANALYZER.getName(), (Object)englishAnalyzerName)}));
                if (indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
                    this.put(IndexProviderTest.FULL_TEXT, new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{Mapping.TEXTSTRING.asParameter(), new Parameter(ParameterType.STRING_ANALYZER.getName(), (Object)englishAnalyzerName), new Parameter(ParameterType.TEXT_ANALYZER.getName(), (Object)englishAnalyzerName)}));
                    this.put(IndexProviderTest.TEXT_STRING, new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{Mapping.TEXTSTRING.asParameter()}));
                }
                this.put(IndexProviderTest.KEYWORD, new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{textParameter, new Parameter(ParameterType.TEXT_ANALYZER.getName(), (Object)keywordAnalyzerName)}));
            }
        };
    }

    public abstract IndexProvider openIndex() throws BackendException;

    public abstract boolean supportsLuceneStyleQueries();

    public abstract String getEnglishAnalyzerName();

    public abstract String getKeywordAnalyzerName();

    @BeforeEach
    public void setUp() throws Exception {
        this.index = this.openIndex();
        this.index.clearStorage();
        this.index.close();
        this.open();
    }

    public abstract Mapping preferredGeoShapeMapping();

    public void open() throws BackendException {
        this.index = this.openIndex();
        this.indexFeatures = this.index.getFeatures();
        this.allKeys = IndexProviderTest.getMapping(this.indexFeatures, this.getEnglishAnalyzerName(), this.getKeywordAnalyzerName(), this.preferredGeoShapeMapping());
        this.indexRetriever = IndexProviderTest.getIndexRetriever(this.allKeys);
        this.newTx();
    }

    public void newTx() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.tx = this.openTx();
    }

    public IndexTransaction openTx() throws BackendException {
        StandardBaseTransactionConfig config = StandardBaseTransactionConfig.of((TimestampProvider)TimestampProviders.MILLI);
        return new IndexTransaction(this.index, this.indexRetriever, (BaseTransactionConfig)config, Duration.ofMillis(2000L));
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.close();
    }

    public void close() throws BackendException {
        if (this.tx != null) {
            this.tx.commit();
        }
        this.index.close();
    }

    public void clopen() throws BackendException {
        this.close();
        this.open();
    }

    @Test
    public void openClose() {
    }

    @Test
    public void singleStore() throws Exception {
        this.storeTest("vertex");
    }

    @Test
    public void multipleStores() throws Exception {
        this.storeTest("vertex", "edge");
    }

    private void storeTest(String ... stores) throws Exception {
        List result;
        Multimap<String, Object> doc1 = this.getDocument("Hello world", 1001L, 5.2, Geoshape.point((double)48.0, (double)0.0), Geoshape.polygon(Arrays.asList({-0.1, 47.9}, {0.1, 47.9}, {0.1, 48.1}, {-0.1, 48.1}, {-0.1, 47.9})), Arrays.asList("1", "2", "3"), Sets.newHashSet((Object[])new String[]{"1", "2"}), Instant.ofEpochSecond(1L), false);
        Multimap<String, Object> doc2 = this.getDocument("Tomorrow is the world", 1010L, 8.5, Geoshape.point((double)49.0, (double)1.0), Geoshape.line(Arrays.asList({0.9, 48.9}, {0.9, 49.1}, {1.1, 49.1}, {1.1, 48.9})), Arrays.asList("4", "5", "6"), Sets.newHashSet((Object[])new String[]{"4", "5"}), Instant.ofEpochSecond(2L), true);
        Multimap<String, Object> doc3 = this.getDocument("Hello Bob, are you there?", -500L, 10.1, Geoshape.point((double)47.0, (double)10.0), Geoshape.box((double)46.9, (double)9.9, (double)47.1, (double)10.1), Arrays.asList("7", "8", "9"), Sets.newHashSet((Object[])new String[]{"7", "8"}), Instant.ofEpochSecond(3L), false);
        for (String store : stores) {
            this.initialize(store);
            this.add(store, "doc1", doc1, true);
            this.add(store, "doc2", doc2, true);
            this.add(store, "doc3", doc3, false);
        }
        ImmutableList orderTimeAsc = ImmutableList.of((Object)new IndexQuery.OrderEntry(TIME, Order.ASC, Integer.class));
        ImmutableList orderWeightAsc = ImmutableList.of((Object)new IndexQuery.OrderEntry(WEIGHT, Order.ASC, Double.class));
        ImmutableList orderTimeDesc = ImmutableList.of((Object)new IndexQuery.OrderEntry(TIME, Order.DESC, Integer.class));
        ImmutableList orderWeightDesc = ImmutableList.of((Object)new IndexQuery.OrderEntry(WEIGHT, Order.DESC, Double.class));
        ImmutableList jointOrder = ImmutableList.of((Object)new IndexQuery.OrderEntry(WEIGHT, Order.DESC, Double.class), (Object)new IndexQuery.OrderEntry(TIME, Order.DESC, Integer.class));
        ImmutableList orderNameAsc = ImmutableList.of((Object)new IndexQuery.OrderEntry(NAME, Order.ASC, String.class));
        ImmutableList orderNameDesc = ImmutableList.of((Object)new IndexQuery.OrderEntry(NAME, Order.DESC, String.class));
        ImmutableList orderDateAsc = ImmutableList.of((Object)new IndexQuery.OrderEntry(DATE, Order.ASC, Instant.class));
        ImmutableList orderDateDesc = ImmutableList.of((Object)new IndexQuery.OrderEntry(DATE, Order.DESC, Instant.class));
        ImmutableList orderBooleanDesc = ImmutableList.of((Object)new IndexQuery.OrderEntry(BOOLEAN, Order.DESC, Boolean.class));
        ImmutableList orderBooleanAsc = ImmutableList.of((Object)new IndexQuery.OrderEntry(BOOLEAN, Order.ASC, Boolean.class));
        this.clopen();
        for (String store : stores) {
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            Assertions.assertEquals((Object)ImmutableSet.copyOf(result), this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"wOrLD"))).collect(Collectors.toSet()));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"bob"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"worl"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tomorrow world"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"WorLD HELLO"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_FUZZY, (Object)"boby"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"A"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"z"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"world"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"A"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"z"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"world"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"A"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"z"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"world"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"A"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"z"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"world"))).count());
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderTimeDesc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new RawQuery(store, "text:\"world\"", orderTimeDesc, NO_PARAS)).map(RawQuery.Result::getResult).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderWeightDesc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new RawQuery(store, "text:\"world\"", orderWeightDesc, NO_PARAS)).map(RawQuery.Result::getResult).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderTimeAsc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), result);
            result = this.tx.queryStream(new RawQuery(store, "text:\"world\"", orderTimeAsc, NO_PARAS)).map(RawQuery.Result::getResult).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderWeightAsc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), result);
            result = this.tx.queryStream(new RawQuery(store, "text:\"world\"", orderWeightAsc, NO_PARAS)).map(RawQuery.Result::getResult).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), jointOrder)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderNameAsc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderNameDesc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderDateAsc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderDateDesc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderBooleanDesc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc2", (Object)"doc1"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), orderBooleanAsc)).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableList.of((Object)"doc1", (Object)"doc2"), result);
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"w"))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"wOr"))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"bobi"))).count());
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Text.CONTAINS_REGEX)) {
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"he[l]+(.*)"))).collect(Collectors.toList());
                Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)ImmutableSet.copyOf(result));
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"[h]+e[l]+(.*)"))).collect(Collectors.toList());
                Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)ImmutableSet.copyOf(result));
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"he[l]+"))).collect(Collectors.toList());
                Assertions.assertTrue((boolean)result.isEmpty());
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"e[l]+(.*)"))).collect(Collectors.toList());
                Assertions.assertTrue((boolean)result.isEmpty());
            }
            for (Text tp : new Text[]{Text.PREFIX, Text.REGEX}) {
                try {
                    Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)tp, (Object)"tzubull"))).count());
                    if (!this.indexFeatures.supportsStringMapping(Mapping.TEXT)) continue;
                    Assertions.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tomorrow is the world"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"world"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)"bob"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Text.PREFIX, (Object)"Tomorrow"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Text.PREFIX, (Object)"wor"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Text.FUZZY, (Object)"Tomorow is the world"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"A"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"z"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"Hello world"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"A"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"z"))).count());
            Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"Hello world"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"A"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"z"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"Hello world"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"A"))).count());
            Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"z"))).count());
            Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"Hello world"))).count());
            try {
                this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)((JanusGraphPredicate)Mockito.mock(Cmp.class)), (Object)"value")));
                Assertions.fail((String)"should fail");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            for (Text tp : new Text[]{Text.CONTAINS, Text.CONTAINS_PREFIX, Text.CONTAINS_REGEX}) {
                try {
                    Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)tp, (Object)"tzubull"))).count());
                    if (!this.indexFeatures.supportsStringMapping(Mapping.STRING)) continue;
                    Assertions.fail();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Text.REGEX)) {
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Text.REGEX, (Object)"Tomo[r]+ow is.*world"))).count());
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Text.REGEX, (Object)"Tomorrow"))).count());
            }
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class, Cardinality.SINGLE, new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Text.REGEX)) {
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Text.REGEX, (Object)"Tomo[r]+ow is.*world"))).count());
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Text.REGEX, (Object)"Tomorrow"))).count());
            }
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"hello")}))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc1", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)-500))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{Or.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)1001), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)-500)})}))).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)result.size());
            result = this.tx.queryStream(new IndexQuery(store, (Condition)Not.of((Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world")))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)-500), Not.of((Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"))}))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{Or.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)1001), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)-500)}), PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world")}))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc1", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"Bob"))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"Bob")}))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"bob"))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc3", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)6.0)}))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc2", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.box((double)46.5, (double)-0.5, (double)50.5, (double)10.5)))).collect(Collectors.toList());
            Assertions.assertEquals((int)3, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2", (Object)"doc3"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0)))).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.box((double)46.5, (double)-0.5, (double)50.5, (double)10.5)))).collect(Collectors.toList());
            Assertions.assertEquals((int)3, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2", (Object)"doc3"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0)))).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.polygon(Arrays.asList({-5.0, 47.0}, {5.0, 47.0}, {5.0, 50.0}, {-5.0, 50.0}, {-5.0, 47.0}))))).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            if (this.index.supports((KeyInformation)new StandardKeyInformation(Geoshape.class, Cardinality.SINGLE, new Parameter[]{this.preferredGeoShapeMapping().asParameter()}), (JanusGraphPredicate)Geo.DISJOINT)) {
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.box((double)46.5, (double)-0.5, (double)50.5, (double)10.5)))).collect(Collectors.toList());
                Assertions.assertEquals((int)0, (int)result.size());
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0)))).collect(Collectors.toList());
                Assertions.assertEquals((int)1, (int)result.size());
                Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc3"), (Object)ImmutableSet.copyOf(result));
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.DISJOINT, (Object)Geoshape.polygon(Arrays.asList({-5.0, 47.0}, {5.0, 47.0}, {5.0, 50.0}, {-5.0, 50.0}, {-5.0, 47.0}))))).collect(Collectors.toList());
                Assertions.assertEquals((int)1, (int)result.size());
                Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc3"), (Object)ImmutableSet.copyOf(result));
            }
            if (this.indexFeatures.supportsGeoContains()) {
                result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.CONTAINS, (Object)Geoshape.point((double)47.0, (double)10.0)))).collect(Collectors.toList());
                Assertions.assertEquals((int)1, (int)result.size());
                Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc3"), (Object)ImmutableSet.copyOf(result));
            }
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.box((double)48.0, (double)-1.0, (double)49.0, (double)2.0)))).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0)))).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.polygon(Arrays.asList({-1.0, 48.0}, {2.0, 48.0}, {2.0, 49.0}, {-1.0, 49.0}, {-1.0, 48.0}))))).collect(Collectors.toList());
            Assertions.assertEquals((int)2, (int)result.size());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"tomorrow"), PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0)), PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)200.0))}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc2"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)-1000), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)1010), PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0)), PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10.0)}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc3"), (Object)ImmutableSet.copyOf(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)"blah", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10.0)}))).collect(Collectors.toList());
            Assertions.assertEquals((int)0, (int)result.size());
            if (this.supportsLuceneStyleQueries()) {
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "text:\"Hello Bob\"", NO_PARAS)).count());
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new RawQuery(store, "text:\"Hello Bob\"", NO_PARAS).setOffset(1)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "text:(world AND tomorrow)", NO_PARAS)).count());
                Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS).setLimit(1)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS).setLimit(1).setOffset(1)).count());
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new RawQuery(store, "text:(you there Hello Bob)", NO_PARAS).setLimit(1).setOffset(2)).count());
                Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new RawQuery(store, "text:\"world\"", NO_PARAS)).count());
                Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new RawQuery(store, "time:[1000 TO 1020]", NO_PARAS)).count());
                Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new RawQuery(store, "time:[1000 TO *]", NO_PARAS)).count());
                Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new RawQuery(store, "time:[* TO *]", NO_PARAS)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "weight:[5.1 TO 8.3]", NO_PARAS)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "weight:5.2", NO_PARAS)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "text:world AND time:1001", NO_PARAS)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "name:\"Hello world\"", NO_PARAS)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "boolean:true", NO_PARAS)).count());
                Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new RawQuery(store, "boolean:false", NO_PARAS)).count());
                Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new RawQuery(store, "date:{1970-01-01T00:00:01Z TO 1970-01-01T00:00:03Z]", NO_PARAS)).count());
                Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new RawQuery(store, "date:[1970-01-01T00:00:01Z TO *]", NO_PARAS)).count());
                Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new RawQuery(store, "date:\"1970-01-01T00:00:02Z\"", NO_PARAS)).count());
            }
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class, Cardinality.LIST, new Parameter[]{Mapping.STRING.asParameter()}), (JanusGraphPredicate)Cmp.EQUAL)) {
                Assertions.assertEquals((Object)"doc1", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"1"))).findFirst().get());
                Assertions.assertEquals((Object)"doc1", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"2"))).findFirst().get());
                Assertions.assertEquals((Object)"doc2", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"4"))).findFirst().get());
                Assertions.assertEquals((Object)"doc2", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"5"))).findFirst().get());
                Assertions.assertEquals((Object)"doc3", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"7"))).findFirst().get());
                Assertions.assertEquals((Object)"doc3", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"8"))).findFirst().get());
                Assertions.assertEquals((Object)"doc1", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"1"))).findFirst().get());
                Assertions.assertEquals((Object)"doc1", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"2"))).findFirst().get());
                Assertions.assertEquals((Object)"doc2", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"4"))).findFirst().get());
                Assertions.assertEquals((Object)"doc2", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"5"))).findFirst().get());
                Assertions.assertEquals((Object)"doc3", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"7"))).findFirst().get());
                Assertions.assertEquals((Object)"doc3", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"8"))).findFirst().get());
                this.remove(store, "doc1", (Multimap<String, Object>)ImmutableMultimap.of((Object)PHONE_LIST, (Object)"1"), false);
                this.clopen();
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"1"))).count());
                Assertions.assertEquals((Object)"doc1", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"2"))).findFirst().get());
                this.remove(store, "doc2", (Multimap<String, Object>)ImmutableMultimap.of((Object)PHONE_SET, (Object)"4"), false);
                this.clopen();
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"4"))).count());
                Assertions.assertEquals((Object)"doc2", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"5"))).findFirst().get());
            }
            Assertions.assertEquals((Object)"doc1", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.EQUAL, (Object)Instant.ofEpochSecond(1L)))).findFirst().get());
            Assertions.assertEquals((Object)"doc2", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.EQUAL, (Object)Instant.ofEpochSecond(2L)))).findFirst().get());
            Assertions.assertEquals((Object)"doc3", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.EQUAL, (Object)Instant.ofEpochSecond(3L)))).findFirst().get());
            Assertions.assertEquals((Object)"doc3", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)Instant.ofEpochSecond(2L)))).findFirst().get());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc2", (Object)"doc3"), this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)Instant.ofEpochSecond(2L)))).collect(Collectors.toSet()));
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1"), this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)Instant.ofEpochSecond(2L)))).collect(Collectors.toSet()));
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc2"), this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)Instant.ofEpochSecond(2L)))).collect(Collectors.toSet()));
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)Instant.ofEpochSecond(2L)))).collect(Collectors.toSet()));
            this.add(store, "doc4", this.getDocument("It's all a big Bob", -100L, 11.2, Geoshape.point((double)-48.0, (double)8.0), Geoshape.point((double)-48.0, (double)8.0), Arrays.asList("10", "11", "12"), Sets.newHashSet((Object[])new String[]{"10", "11"}), Instant.ofEpochSecond(4L), false), true);
            this.remove(store, "doc2", doc2, true);
            this.remove(store, "doc3", (Multimap<String, Object>)ImmutableMultimap.of((Object)WEIGHT, (Object)10.1), false);
            this.add(store, "doc3", (Multimap<String, Object>)ImmutableMultimap.of((Object)TIME, (Object)2000, (Object)TEXT, (Object)"Bob owns the world"), false);
            this.remove(store, "doc1", (Multimap<String, Object>)ImmutableMultimap.of((Object)TIME, (Object)1001), false);
            this.add(store, "doc1", (Multimap<String, Object>)ImmutableMultimap.of((Object)TIME, (Object)1005, (Object)WEIGHT, (Object)11.1, (Object)LOCATION, (Object)Geoshape.point((double)-48.0, (double)0.0), (Object)BOUNDARY, (Object)Geoshape.circle((double)-48.0, (double)0.0, (double)1.0)), false);
            Geoshape multiPoint = Geoshape.geoshape((Shape)((ShapeFactory.MultiPointBuilder)((ShapeFactory.MultiPointBuilder)Geoshape.getShapeFactory().multiPoint().pointXY(60.0, 60.0)).pointXY(120.0, 60.0)).build());
            this.add(store, "doc5", this.getDocument("A Full Yes", -100L, -11.2, Geoshape.point((double)48.0, (double)8.0), multiPoint, Arrays.asList("10", "11", "12"), Sets.newHashSet((Object[])new String[]{"10", "11"}), Instant.ofEpochSecond(400L), false), true);
            Geoshape multiLine = Geoshape.geoshape((Shape)Geoshape.getShapeFactory().multiLineString().add((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)Geoshape.getShapeFactory().lineString().pointXY(59.0, 60.0)).pointXY(61.0, 60.0)).add((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)Geoshape.getShapeFactory().lineString().pointXY(119.0, 60.0)).pointXY(121.0, 60.0)).build());
            this.add(store, "doc6", this.getDocument("A Full Yes", -100L, -11.2, Geoshape.point((double)48.0, (double)8.0), multiLine, Arrays.asList("10", "11", "12"), Sets.newHashSet((Object[])new String[]{"10", "11"}), Instant.ofEpochSecond(400L), false), true);
            Geoshape multiPolygon = Geoshape.geoshape((Shape)Geoshape.getShapeFactory().multiPolygon().add((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)Geoshape.getShapeFactory().polygon().pointXY(59.0, 59.0)).pointXY(61.0, 59.0)).pointXY(61.0, 61.0)).pointXY(59.0, 61.0)).pointXY(59.0, 59.0)).add((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)((ShapeFactory.PolygonBuilder)Geoshape.getShapeFactory().polygon().pointXY(119.0, 59.0)).pointXY(121.0, 59.0)).pointXY(121.0, 61.0)).pointXY(119.0, 61.0)).pointXY(119.0, 59.0)).build());
            this.add(store, "doc7", this.getDocument("A Full Yes", -100L, -11.2, Geoshape.point((double)48.0, (double)8.0), multiPolygon, Arrays.asList("10", "11", "12"), Sets.newHashSet((Object[])new String[]{"10", "11"}), Instant.ofEpochSecond(400L), false), true);
            Geoshape geometryCollection = Geoshape.geoshape((Shape)Geoshape.getGeometryCollectionBuilder().add((Shape)Geoshape.getShapeFactory().pointXY(60.0, 60.0)).add(((ShapeFactory.LineStringBuilder)((ShapeFactory.LineStringBuilder)Geoshape.getShapeFactory().lineString().pointXY(119.0, 60.0)).pointXY(121.0, 60.0)).build()).build());
            this.add(store, "doc8", this.getDocument("A Full Yes", -100L, -11.2, Geoshape.point((double)48.0, (double)8.0), geometryCollection, Arrays.asList("10", "11", "12"), Sets.newHashSet((Object[])new String[]{"10", "11"}), Instant.ofEpochSecond(400L), false), true);
        }
        this.clopen();
        for (String store : stores) {
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc3"), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"world"), PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)6.0)}))).collect(Collectors.toList());
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)"doc1", result.get(0));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)-48.5, (double)0.5, (double)200.0)))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1"), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)-48.5, (double)0.5, (double)200.0)))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1"), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"tomorrow"), PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)-48.5, (double)0.5, (double)200.0))}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of(), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"tomorrow"), PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)-48.5, (double)0.5, (double)200.0))}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of(), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)-1000), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)1010), PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)-48.5, (double)0.5, (double)1000.0))}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc4"), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)-1000), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)1010), PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)-48.5, (double)0.5, (double)1000.0))}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc4"), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10.0)}))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc1", (Object)"doc4"), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)"blah", (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)10.0)}))).collect(Collectors.toList());
            Assertions.assertEquals((int)0, (int)result.size());
            if (this.index.supports((KeyInformation)new StandardKeyInformation(String.class, Cardinality.LIST, new Parameter[]{new Parameter("mapping", (Object)Mapping.STRING)}), (JanusGraphPredicate)Cmp.EQUAL)) {
                for (int suffix = 4; suffix <= 8; ++suffix) {
                    String suffixString = "doc" + suffix;
                    Assertions.assertTrue((boolean)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"10"))).anyMatch(suffixString::equals));
                    Assertions.assertTrue((boolean)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"11"))).anyMatch(suffixString::equals));
                    Assertions.assertTrue((boolean)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"10"))).anyMatch(suffixString::equals));
                    Assertions.assertTrue((boolean)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"11"))).anyMatch(suffixString::equals));
                }
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"4"))).count());
                Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"5"))).count());
            }
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.EQUAL, (Object)Instant.ofEpochSecond(2L)))).count());
            Assertions.assertEquals((Object)"doc4", this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.EQUAL, (Object)Instant.ofEpochSecond(4L)))).findFirst().get());
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)59.0, (double)59.0, (double)200.0)))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc5", (Object)"doc6", (Object)"doc7", (Object)"doc8"), (Object)Sets.newHashSet(result));
            result = this.tx.queryStream(new IndexQuery(store, (Condition)PredicateCondition.of((Object)BOUNDARY, (JanusGraphPredicate)Geo.INTERSECT, (Object)Geoshape.circle((double)59.0, (double)119.0, (double)200.0)))).collect(Collectors.toList());
            Assertions.assertEquals((Object)ImmutableSet.of((Object)"doc5", (Object)"doc6", (Object)"doc7", (Object)"doc8"), (Object)Sets.newHashSet(result));
        }
    }

    @Test
    public void testCommonSupport() {
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXT))));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.STRING))));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.STRING)), (JanusGraphPredicate)Cmp.GREATER_THAN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.STRING)), (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.STRING)), (JanusGraphPredicate)Cmp.LESS_THAN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.STRING)), (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXT)), (JanusGraphPredicate)Cmp.GREATER_THAN));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXT)), (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXT)), (JanusGraphPredicate)Cmp.LESS_THAN));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXT)), (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.DEFAULT)), (JanusGraphPredicate)Cmp.GREATER_THAN));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.DEFAULT)), (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.DEFAULT)), (JanusGraphPredicate)Cmp.LESS_THAN));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.DEFAULT)), (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL));
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXTSTRING)), (JanusGraphPredicate)Cmp.GREATER_THAN));
            Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXTSTRING)), (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL));
            Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXTSTRING)), (JanusGraphPredicate)Cmp.LESS_THAN));
            Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(String.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXTSTRING)), (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL));
        }
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXT))));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Long.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Long.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.DEFAULT))));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Integer.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Short.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Byte.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Float.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Object.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Exception.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Cmp.EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Cmp.GREATER_THAN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Cmp.LESS_THAN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.DEFAULT)), (JanusGraphPredicate)Cmp.LESS_THAN));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter("mapping", (Object)Mapping.TEXT)), (JanusGraphPredicate)Cmp.LESS_THAN));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Double.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Geo.INTERSECT));
        Assertions.assertFalse((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Long.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Text.CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, Cardinality.SINGLE, new Parameter[0])));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Geo.WITHIN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, Cardinality.SINGLE, new Parameter[0]), (JanusGraphPredicate)Geo.INTERSECT));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, Cardinality.SINGLE, new Parameter("mapping", (Object)this.preferredGeoShapeMapping())), (JanusGraphPredicate)Geo.WITHIN));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, Cardinality.SINGLE, new Parameter("mapping", (Object)this.preferredGeoShapeMapping())), (JanusGraphPredicate)Geo.CONTAINS));
        Assertions.assertTrue((boolean)this.index.supports((KeyInformation)IndexProviderTest.of(Geoshape.class, Cardinality.SINGLE, new Parameter("mapping", (Object)this.preferredGeoShapeMapping())), (JanusGraphPredicate)Geo.INTERSECT));
    }

    @Test
    public void largeTest() throws Exception {
        int numDoc = 30000;
        String store = "vertex";
        this.initialize("vertex");
        for (int i = 1; i <= 30000; ++i) {
            this.add("vertex", "doc" + i, IndexProviderTest.getRandomDocument(), true);
        }
        this.clopen();
        long time = System.currentTimeMillis();
        Stream result = this.tx.queryStream(new IndexQuery("vertex", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0.2), PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)0.6), PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))})));
        long oldResultSize = result.count();
        System.out.println(oldResultSize + " vs " + 73.867869045);
        System.out.println("Query time on 30000 docs (ms): " + (System.currentTimeMillis() - time));
        result = this.tx.queryStream(new IndexQuery("vertex", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0.2), PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)0.6), PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))}), 30));
        Assertions.assertEquals((long)30L, (long)result.count());
        result = this.tx.queryStream(new IndexQuery("vertex", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)0.2), PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)0.6), PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.circle((double)48.5, (double)0.5, (double)1000.0))}), 3000));
        Assertions.assertEquals((long)oldResultSize, (long)result.count());
    }

    @Test
    public void testRestore() throws Exception {
        String store1 = "store1";
        String store2 = "store2";
        this.initialize("store1");
        this.initialize("store2");
        this.add("store1", "restore-doc1", (Multimap<String, Object>)ImmutableMultimap.of((Object)NAME, (Object)"first", (Object)TIME, (Object)1L, (Object)WEIGHT, (Object)10.2), true);
        this.add("store1", "restore-doc2", (Multimap<String, Object>)ImmutableMultimap.of((Object)NAME, (Object)"second", (Object)TIME, (Object)2L, (Object)WEIGHT, (Object)4.7), true);
        this.clopen();
        Set results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)2, (int)results.size());
        this.index.restore((Map)new HashMap<String, Map<String, List<IndexEntry>>>(){
            {
                this.put("store1", new HashMap<String, List<IndexEntry>>(){
                    {
                        this.put("restore-doc1", Collections.emptyList());
                        this.put("restore-doc2", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"not-second"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)2.1));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)0L));
                            }
                        });
                        this.put("restore-doc3", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"third"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)11.5));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)3L));
                            }
                        });
                    }
                });
            }
        }, this.indexRetriever, (BaseTransaction)this.tx);
        this.clopen();
        results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("restore-doc3"));
        results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"third"), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)3L)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("restore-doc3"));
        results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"not-second"), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)0L)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("restore-doc2"));
        this.index.restore((Map)new HashMap<String, Map<String, List<IndexEntry>>>(){
            {
                this.put("store1", new HashMap<String, List<IndexEntry>>(){
                    {
                        this.put("restore-doc1", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"first-restored"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)7.0));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)4L));
                            }
                        });
                    }
                });
                this.put("store2", new HashMap<String, List<IndexEntry>>(){
                    {
                        this.put("restore-doc1", new ArrayList<IndexEntry>(){
                            {
                                this.add(new IndexEntry(IndexProviderTest.NAME, (Object)"first-in-second-store"));
                                this.add(new IndexEntry(IndexProviderTest.WEIGHT, (Object)4.0));
                                this.add(new IndexEntry(IndexProviderTest.TIME, (Object)5L));
                            }
                        });
                    }
                });
            }
        }, this.indexRetriever, (BaseTransaction)this.tx);
        this.clopen();
        results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("restore-doc1"));
        Assertions.assertTrue((boolean)results.contains("restore-doc3"));
        results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"first-restored"), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)4L)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("restore-doc1"));
        results = this.tx.queryStream(new IndexQuery("store2", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("restore-doc1"));
        results = this.tx.queryStream(new IndexQuery("store2", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"first-in-second-store"), PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)5L)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("restore-doc1"));
    }

    @RepeatedIfExceptionsTest(repeats=4, minSuccess=2)
    public void testTTL() throws Exception {
        if (!this.index.getFeatures().supportsDocumentTTL()) {
            return;
        }
        String store = "store1";
        this.initialize("store1");
        this.add("store1", "expiring-doc1", (Multimap<String, Object>)ImmutableMultimap.of((Object)NAME, (Object)"first", (Object)TIME, (Object)1L, (Object)WEIGHT, (Object)10.2), true, 2);
        this.add("store1", "expiring-doc2", (Multimap<String, Object>)ImmutableMultimap.of((Object)NAME, (Object)"second", (Object)TIME, (Object)2L, (Object)WEIGHT, (Object)4.7), true);
        this.add("store1", "expiring-doc3", (Multimap<String, Object>)ImmutableMultimap.of((Object)NAME, (Object)"third", (Object)TIME, (Object)3L, (Object)WEIGHT, (Object)5.2), true, 2);
        this.add("store1", "expiring-doc4", (Multimap<String, Object>)ImmutableMultimap.of((Object)NAME, (Object)"fourth", (Object)TIME, (Object)3L, (Object)WEIGHT, (Object)7.7), true, 7);
        this.clopen();
        Set results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)4, (int)results.size());
        Thread.sleep(6000L);
        results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)2, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("expiring-doc2"));
        Assertions.assertTrue((boolean)results.contains("expiring-doc4"));
        Thread.sleep(5000L);
        results = this.tx.queryStream(new IndexQuery("store1", (Condition)And.of((Condition[])new Condition[]{PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)4.0)}))).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)results.size());
        Assertions.assertTrue((boolean)results.contains("expiring-doc2"));
    }

    private void runConflictingTx(TxJob job1, TxJob job2) throws Exception {
        this.initialize("store1");
        ImmutableMultimap initialProps = ImmutableMultimap.of((Object)TEXT, (Object)"the quick brown fox jumps over the lazy dog");
        this.add("store1", "docx1-id", (Multimap<String, Object>)initialProps, true);
        this.clopen();
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), "docx1-id");
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"periwinkle")), null);
        IndexTransaction tx1 = this.openTx();
        IndexTransaction tx2 = this.openTx();
        job1.run(tx1);
        tx1.commit();
        job2.run(tx2);
        tx2.commit();
        this.clopen();
    }

    private void checkResult(IndexQuery query, String containedDoc) throws Exception {
        List result = this.tx.queryStream(query).collect(Collectors.toList());
        if (containedDoc != null) {
            Assertions.assertEquals((int)1, (int)result.size());
            Assertions.assertEquals((Object)containedDoc, result.get(0));
        } else {
            Assertions.assertEquals((int)0, (int)result.size());
        }
    }

    @Test
    public void testDeleteDocumentThenDeleteField() throws Exception {
        this.runConflictingTx(tx -> tx.delete("store1", "docx1-id", TEXT, (Object)ImmutableMap.of(), true), tx -> tx.delete("store1", "docx1-id", TEXT, (Object)"the quick brown fox jumps over the lazy dog", false));
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), null);
    }

    @Test
    public void testDeleteDocumentThenModifyField() throws Exception {
        this.runConflictingTx(tx -> tx.delete("store1", "docx1-id", TEXT, (Object)ImmutableMap.of(), true), tx -> tx.add("store1", "docx1-id", TEXT, (Object)"the slow brown fox jumps over the lazy dog", false));
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), "docx1-id");
    }

    @Test
    public void testDeleteDocumentThenAddField() throws Exception {
        String nameValue = "jm keynes";
        this.runConflictingTx(tx -> tx.delete("store1", "docx1-id", TEXT, (Object)ImmutableMap.of(), true), tx -> tx.add("store1", "docx1-id", NAME, (Object)"jm keynes", false));
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"jm keynes")), "docx1-id");
    }

    @Test
    public void testAddFieldThenDeleteDoc() throws Exception {
        String nameValue = "jm keynes";
        this.runConflictingTx(tx -> tx.add("store1", "docx1-id", NAME, (Object)"jm keynes", false), tx -> tx.delete("store1", "docx1-id", TEXT, (Object)ImmutableMap.of(), true));
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"jm keynes")), null);
    }

    @Test
    public void testConflictingAdd() throws Exception {
        String doc2 = "docy2";
        this.runConflictingTx(tx -> {
            ImmutableMultimap initialProps = ImmutableMultimap.of((Object)TEXT, (Object)"sugar sugar");
            this.add("store1", "docy2", (Multimap<String, Object>)initialProps, true);
        }, tx -> {
            ImmutableMultimap initialProps = ImmutableMultimap.of((Object)TEXT, (Object)"honey honey");
            this.add("store1", "docy2", (Multimap<String, Object>)initialProps, true);
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), "docx1-id");
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"sugar")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"honey")), "docy2");
    }

    @Test
    public void testLastWriteWins() throws Exception {
        this.runConflictingTx(tx -> {
            tx.delete("store1", "docx1-id", TEXT, (Object)"the quick brown fox jumps over the lazy dog", false);
            tx.add("store1", "docx1-id", TEXT, (Object)"sugar sugar", false);
        }, tx -> {
            tx.delete("store1", "docx1-id", TEXT, (Object)"the quick brown fox jumps over the lazy dog", false);
            tx.add("store1", "docx1-id", TEXT, (Object)"honey honey", false);
        });
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"sugar")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"honey")), "docx1-id");
    }

    @Test
    public void testUpdateAddition() throws Exception {
        String revisedText = "its a sunny day";
        this.runConflictingTx(tx -> tx.add("store1", "docx1-id", TEXT, (Object)"its a sunny day", false), tx -> {});
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), null);
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"sunny")), "docx1-id");
    }

    @Test
    public void testUpdateDeletion() throws Exception {
        this.runConflictingTx(tx -> tx.delete("store1", "docx1-id", TEXT, (Object)ImmutableMap.of(), false), tx -> {});
        this.checkResult(new IndexQuery("store1", (Condition)PredicateCondition.of((Object)TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"brown")), null);
    }

    @Test
    public void testCustomAnalyzer() throws Exception {
        if (!this.indexFeatures.supportsCustomAnalyzer()) {
            return;
        }
        String store = "vertex";
        this.initialize("vertex");
        HashMultimap initialDoc = HashMultimap.create();
        initialDoc.put((Object)STRING, (Object)"Tom and Jerry");
        initialDoc.put((Object)ANALYZED, (Object)"Tom and Jerry");
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            initialDoc.put((Object)FULL_TEXT, (Object)"Tom and Jerry");
        }
        initialDoc.put((Object)KEYWORD, (Object)"Tom and Jerry");
        this.add("vertex", "docId", (Multimap<String, Object>)initialDoc, true);
        this.clopen();
        IndexQuery query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tom and Jerry"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tom"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)"Tom"));
        Assertions.assertEquals((long)0L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Cmp.NOT_EQUAL, (Object)"Tom Jerry"));
        Assertions.assertEquals((long)0L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tom Jerry"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tom or Jerry"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Text.PREFIX, (Object)"jerr"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Text.REGEX, (Object)"jer.*"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)ANALYZED, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tom and Jerry"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)ANALYZED, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tom Jerry"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)ANALYZED, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tom"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)ANALYZED, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tom or Jerry"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)ANALYZED, (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"jerr"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)ANALYZED, (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"jer.*"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tom and Jerry"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tom Jerry"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Tom or Jerry"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Text.PREFIX, (Object)"jerr"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Text.REGEX, (Object)"jer.*"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tom and Jerry"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tom Jerry"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Text.CONTAINS, (Object)"Tom or Jerry"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"jerr"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)"jer.*"));
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"a"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"z"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN, (Object)"Tom and Jerry"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"a"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"z"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.GREATER_THAN_EQUAL, (Object)"Tom and Jerry"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"a"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"z"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.LESS_THAN, (Object)"Tom and Jerry"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"a"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"z"))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)FULL_TEXT, (JanusGraphPredicate)Cmp.LESS_THAN_EQUAL, (Object)"Tom and Jerry"))).count());
        }
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)KEYWORD, (JanusGraphPredicate)Text.CONTAINS_PREFIX, (Object)"Tom"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
        query = new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)KEYWORD, (JanusGraphPredicate)Text.CONTAINS_REGEX, (Object)".*Jer.*"));
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(query).count(), (String)query.toString());
    }

    @Test
    public void testScroll() throws BackendException {
        String store = "vertex";
        this.initialize("vertex");
        this.add("vertex", "doc1", this.getDocument(1001L, 5.2), true);
        this.add("vertex", "doc2", this.getDocument(1001L, 5.2), true);
        this.add("vertex", "doc3", this.getDocument(1001L, 6.2), true);
        this.add("vertex", "doc4", this.getDocument(1002L, 7.2), true);
        this.add("vertex", "doc5", this.getDocument(1002L, 8.2), true);
        this.add("vertex", "doc6", this.getDocument(1002L, 9.2), true);
        this.add("vertex", "doc7", this.getDocument(1002L, 10.2), true);
        this.clopen();
        Assertions.assertEquals((long)2L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.EQUAL, (Object)5.2))).count());
        Assertions.assertEquals((long)3L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)1001))).count());
        Assertions.assertEquals((long)7L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Hello world"))).count());
        Assertions.assertEquals((long)4L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)1002), 4)).count());
        Assertions.assertEquals((long)6L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"Hello world"), 6)).count());
    }

    @Test
    public void testPersistentIndexData() throws BackendException {
        String store = "vertex";
        ArrayListMultimap initialDoc = ArrayListMultimap.create();
        initialDoc.put((Object)DATE, (Object)Instant.ofEpochSecond(1L));
        double latitude = 30.0;
        double longitude = 60.0;
        initialDoc.put((Object)LOCATION, (Object)Geoshape.point((double)latitude, (double)longitude));
        initialDoc.put((Object)STRING, (Object)"network");
        initialDoc.put((Object)ANALYZED, (Object)"network");
        initialDoc.put((Object)KEYWORD, (Object)"network");
        initialDoc.put((Object)NAME, (Object)"network");
        initialDoc.put((Object)TIME, (Object)1L);
        initialDoc.put((Object)WEIGHT, (Object)1.5);
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            initialDoc.put((Object)PHONE_LIST, (Object)"one");
            initialDoc.put((Object)PHONE_LIST, (Object)"two");
        }
        if (this.indexFeatures.supportsCardinality(Cardinality.SET)) {
            initialDoc.put((Object)PHONE_SET, (Object)"three");
            initialDoc.put((Object)PHONE_SET, (Object)"four");
            initialDoc.put((Object)TIME_TICK, (Object)new Date(1L));
            initialDoc.put((Object)TIME_TICK, (Object)new Date(2L));
            initialDoc.put((Object)TIME_TICK, (Object)new Date(2L));
            initialDoc.put((Object)TIME_TICK, (Object)new Date(3L));
        }
        this.initialize("vertex");
        this.add("vertex", "doc1", (Multimap<String, Object>)initialDoc, true);
        this.clopen();
        this.tx.add("vertex", "doc1", TEXT, (Object)"update", false);
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            this.tx.delete("vertex", "doc1", TIME_TICK, (Object)new Date(2L), false);
            this.tx.delete("vertex", "doc1", TIME_TICK, (Object)new Date(3L), false);
        }
        this.tx.commit();
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)DATE, (JanusGraphPredicate)Cmp.EQUAL, (Object)Instant.ofEpochSecond(1L)))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)LOCATION, (JanusGraphPredicate)Geo.WITHIN, (Object)Geoshape.box((double)(latitude - 1.0), (double)(longitude - 1.0), (double)(latitude + 1.0), (double)(longitude + 1.0))))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)WEIGHT, (JanusGraphPredicate)Cmp.EQUAL, (Object)1.5))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)TIME, (JanusGraphPredicate)Cmp.EQUAL, (Object)1L))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)STRING, (JanusGraphPredicate)Cmp.EQUAL, (Object)"network"))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)KEYWORD, (JanusGraphPredicate)Text.CONTAINS, (Object)"network"))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)ANALYZED, (JanusGraphPredicate)Text.CONTAINS, (Object)"network"))).count());
        Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)NAME, (JanusGraphPredicate)Cmp.EQUAL, (Object)"network"))).count());
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"one"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)PHONE_LIST, (JanusGraphPredicate)Cmp.EQUAL, (Object)"two"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)TIME_TICK, (JanusGraphPredicate)Cmp.EQUAL, (Object)new Date(1L)))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)TIME_TICK, (JanusGraphPredicate)Cmp.EQUAL, (Object)new Date(2L)))).count());
            Assertions.assertEquals((long)0L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)TIME_TICK, (JanusGraphPredicate)Cmp.EQUAL, (Object)new Date(3L)))).count());
        }
        if (this.indexFeatures.supportsCardinality(Cardinality.SET)) {
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"three"))).count());
            Assertions.assertEquals((long)1L, (long)this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)PHONE_SET, (JanusGraphPredicate)Cmp.EQUAL, (Object)"four"))).count());
        }
    }

    @Test
    public void clearStorageTest() throws Exception {
        String store = "vertex";
        this.initialize("vertex");
        Multimap<String, Object> doc1 = this.getDocument("Hello world", 1001L, 5.2, Geoshape.point((double)48.0, (double)0.0), Geoshape.polygon(Arrays.asList({-0.1, 47.9}, {0.1, 47.9}, {0.1, 48.1}, {-0.1, 48.1}, {-0.1, 47.9})), Arrays.asList("1", "2", "3"), Sets.newHashSet((Object[])new String[]{"1", "2"}), Instant.ofEpochSecond(1L), false);
        this.add("vertex", "doc1", doc1, true);
        this.clopen();
        Assertions.assertTrue((boolean)this.index.exists());
        this.tearDown();
        this.setUp();
        Assertions.assertFalse((boolean)this.index.exists());
    }

    @ParameterizedTest
    @MethodSource(value={"org.janusgraph.core.attribute.TextArgument#text"})
    public void testTextPredicate(JanusGraphPredicate predicate, boolean expected, String value, String condition) throws BackendException {
        this.assumeIndexSupportFor(Mapping.TEXT, predicate);
        if (value != null) {
            this.initializeWithDoc("vertex", "test1", TEXT, value, true);
        } else {
            this.initializeWithDoc("vertex", "test1", BOOLEAN, true, true);
        }
        this.testPredicateByCount(expected ? 1L : 0L, predicate, TEXT, condition);
    }

    @ParameterizedTest
    @MethodSource(value={"org.janusgraph.core.attribute.TextArgument#string"})
    public void testStringPredicate(JanusGraphPredicate predicate, boolean expected, String value, String condition) throws BackendException {
        this.assumeIndexSupportFor(Mapping.STRING, predicate);
        if (value != null) {
            this.initializeWithDoc("vertex", "test1", NAME, value, true);
        } else {
            this.initializeWithDoc("vertex", "test1", BOOLEAN, true, true);
        }
        this.testPredicateByCount(expected ? 1L : 0L, predicate, NAME, condition);
    }

    private void initializeWithDoc(String store, String docId, String field, Object value, boolean isNew) throws BackendException {
        this.initialize(store);
        HashMultimap doc = HashMultimap.create();
        doc.put((Object)field, value);
        this.add(store, docId, (Multimap<String, Object>)doc, isNew);
        this.clopen();
    }

    protected void assumeIndexSupportFor(Mapping mapping, JanusGraphPredicate predicate) {
        Assume.assumeThat((String)("Index supports mapping" + mapping), (Object)this.indexFeatures.supportsStringMapping(mapping), (Matcher)Matchers.is((Object)true));
        Assume.assumeThat((String)("Index supports predicate " + predicate + " for mapping " + mapping), (Object)this.supportsPredicateFor(mapping, predicate), (Matcher)Matchers.is((Object)true));
    }

    protected boolean supportsPredicateFor(Mapping mapping, Class<?> dataType, Cardinality cardinality, JanusGraphPredicate predicate) {
        return this.index.supports((KeyInformation)new StandardKeyInformation(dataType, cardinality, new Parameter[]{mapping.asParameter()}), predicate);
    }

    protected boolean supportsPredicateFor(Mapping mapping, Class<?> dataType, JanusGraphPredicate predicate) {
        return this.supportsPredicateFor(mapping, dataType, Cardinality.SINGLE, predicate);
    }

    protected boolean supportsPredicateFor(Mapping mapping, JanusGraphPredicate predicate) {
        return this.supportsPredicateFor(mapping, String.class, Cardinality.SINGLE, predicate);
    }

    protected long getDocCountByPredicate(JanusGraphPredicate predicate, String field, String condition) throws BackendException {
        return this.tx.queryStream(new IndexQuery("vertex", (Condition)PredicateCondition.of((Object)field, (JanusGraphPredicate)predicate, (Object)condition))).count();
    }

    private void testPredicateByCount(long expectation, JanusGraphPredicate predicate, String field, String condition) throws BackendException {
        Assertions.assertEquals((long)expectation, (long)this.getDocCountByPredicate(predicate, field, condition));
    }

    protected void initialize(String store) throws BackendException {
        for (Map.Entry<String, KeyInformation> info : this.allKeys.entrySet()) {
            KeyInformation keyInfo = info.getValue();
            if (!this.index.supports(keyInfo)) continue;
            this.index.register(store, info.getKey(), keyInfo, (BaseTransaction)this.tx);
        }
    }

    protected void add(String store, String documentId, Multimap<String, Object> doc, boolean isNew) {
        this.add(store, documentId, doc, isNew, 0);
    }

    private void add(String store, String documentId, Multimap<String, Object> doc, boolean isNew, int ttlInSeconds) {
        for (Map.Entry kv : doc.entries()) {
            if (!this.index.supports(this.allKeys.get(kv.getKey()))) continue;
            IndexEntry idx = new IndexEntry((String)kv.getKey(), kv.getValue());
            if (ttlInSeconds > 0) {
                idx.setMetaData(EntryMetaData.TTL, (Object)ttlInSeconds);
            }
            this.tx.add(store, documentId, idx, isNew);
        }
    }

    private void remove(String store, String documentId, Multimap<String, Object> doc, boolean deleteAll) {
        for (Map.Entry kv : doc.entries()) {
            if (!this.index.supports(this.allKeys.get(kv.getKey()))) continue;
            this.tx.delete(store, documentId, (String)kv.getKey(), kv.getValue(), deleteAll);
        }
    }

    public Multimap<String, Object> getDocument(String txt, long time, double weight, Geoshape location, Geoshape boundary, List<String> phoneList, Set<String> phoneSet, Instant date, Boolean bool) {
        HashMultimap values = HashMultimap.create();
        values.put((Object)TEXT, (Object)txt);
        values.put((Object)NAME, (Object)txt);
        values.put((Object)TIME, (Object)time);
        values.put((Object)WEIGHT, (Object)weight);
        values.put((Object)LOCATION, (Object)location);
        values.put((Object)BOUNDARY, (Object)boundary);
        values.put((Object)DATE, (Object)date);
        values.put((Object)BOOLEAN, (Object)bool);
        if (this.indexFeatures.supportsCardinality(Cardinality.LIST)) {
            for (String phone : phoneList) {
                values.put((Object)PHONE_LIST, (Object)phone);
            }
        }
        if (this.indexFeatures.supportsCardinality(Cardinality.SET)) {
            for (String phone : phoneSet) {
                values.put((Object)PHONE_SET, (Object)phone);
            }
        }
        return values;
    }

    public static Multimap<String, Object> getRandomDocument() {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            s.append(RandomGenerator.randomString(5, 8)).append(" ");
        }
        HashMultimap values = HashMultimap.create();
        values.put((Object)TEXT, (Object)s.toString());
        values.put((Object)NAME, (Object)s.toString());
        values.put((Object)TIME, (Object)Math.abs(random.nextLong()));
        values.put((Object)WEIGHT, (Object)random.nextDouble());
        values.put((Object)LOCATION, (Object)Geoshape.point((double)(random.nextDouble() * 180.0 - 90.0), (double)(random.nextDouble() * 360.0 - 180.0)));
        return values;
    }

    public static void printResult(Iterable<RawQuery.Result<String>> result) {
        for (RawQuery.Result<String> r : result) {
            System.out.println((String)r.getResult() + ":" + r.getScore());
        }
    }

    private Multimap<String, Object> getDocument(long time, double weight) {
        HashMultimap toReturn = HashMultimap.create();
        toReturn.put((Object)NAME, (Object)"Hello world");
        toReturn.put((Object)TIME, (Object)time);
        toReturn.put((Object)WEIGHT, (Object)weight);
        return toReturn;
    }

    private static interface TxJob {
        public void run(IndexTransaction var1);
    }
}

