/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.example;

import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.janusgraph.example.GraphApp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TinkerGraphApp
extends GraphApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinkerGraphApp.class);

    public TinkerGraphApp(String fileName) {
        super(fileName);
        this.supportsSchema = true;
        this.supportsTransactions = false;
        this.supportsGeoshape = false;
    }

    public void createSchema() {
        LOGGER.info("creating schema");
        TinkerGraph tinkerGraph = (TinkerGraph)this.graph;
        if (!tinkerGraph.getIndexedKeys(Vertex.class).iterator().hasNext()) {
            tinkerGraph.createIndex("name", Vertex.class);
        }
    }

    public static void main(String[] args) {
        String fileName = args != null && args.length > 0 ? args[0] : null;
        TinkerGraphApp app = new TinkerGraphApp(fileName);
        app.runApp();
    }
}

