/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.example;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.util.system.ConfigurationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphApp {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphApp.class);
    protected String propFileName;
    protected Configuration conf;
    protected Graph graph;
    protected GraphTraversalSource g;
    protected boolean supportsTransactions;
    protected boolean supportsSchema;
    protected boolean supportsGeoshape;

    public GraphApp(String fileName) {
        this.propFileName = fileName;
    }

    public GraphTraversalSource openGraph() throws ConfigurationException, IOException {
        LOGGER.info("opening graph");
        this.conf = ConfigurationUtil.loadPropertiesConfig((String)this.propFileName);
        this.graph = GraphFactory.open((Configuration)this.conf);
        this.g = this.graph.traversal();
        return this.g;
    }

    public void closeGraph() throws Exception {
        LOGGER.info("closing graph");
        try {
            if (this.g != null) {
                this.g.close();
            }
            if (this.graph != null) {
                this.graph.close();
            }
        }
        finally {
            this.g = null;
            this.graph = null;
        }
    }

    public void dropGraph() throws Exception {
    }

    public void createSchema() {
    }

    public void createElements() {
        block7: {
            try {
                if (this.g.V(new Object[0]).has("name", (Object)"saturn").hasNext()) {
                    if (this.supportsTransactions) {
                        this.g.tx().rollback();
                    }
                    return;
                }
                LOGGER.info("creating elements");
                Vertex saturn = (Vertex)this.g.addV("titan").property((Object)"name", (Object)"saturn", new Object[0]).property((Object)"age", (Object)10000, new Object[0]).next();
                Vertex sky = (Vertex)this.g.addV("location").property((Object)"name", (Object)"sky", new Object[0]).next();
                Vertex sea = (Vertex)this.g.addV("location").property((Object)"name", (Object)"sea", new Object[0]).next();
                Vertex jupiter = (Vertex)this.g.addV("god").property((Object)"name", (Object)"jupiter", new Object[0]).property((Object)"age", (Object)5000, new Object[0]).next();
                Vertex neptune = (Vertex)this.g.addV("god").property((Object)"name", (Object)"neptune", new Object[0]).property((Object)"age", (Object)4500, new Object[0]).next();
                Vertex hercules = (Vertex)this.g.addV("demigod").property((Object)"name", (Object)"hercules", new Object[0]).property((Object)"age", (Object)30, new Object[0]).next();
                Vertex alcmene = (Vertex)this.g.addV("human").property((Object)"name", (Object)"alcmene", new Object[0]).property((Object)"age", (Object)45, new Object[0]).next();
                Vertex pluto = (Vertex)this.g.addV("god").property((Object)"name", (Object)"pluto", new Object[0]).property((Object)"age", (Object)4000, new Object[0]).next();
                Vertex nemean = (Vertex)this.g.addV("monster").property((Object)"name", (Object)"nemean", new Object[0]).next();
                Vertex hydra = (Vertex)this.g.addV("monster").property((Object)"name", (Object)"hydra", new Object[0]).next();
                Vertex cerberus = (Vertex)this.g.addV("monster").property((Object)"name", (Object)"cerberus", new Object[0]).next();
                Vertex tartarus = (Vertex)this.g.addV("location").property((Object)"name", (Object)"tartarus", new Object[0]).next();
                this.g.V(new Object[]{jupiter}).as("a", new String[0]).V(new Object[]{saturn}).addE("father").from("a").next();
                this.g.V(new Object[]{jupiter}).as("a", new String[0]).V(new Object[]{sky}).addE("lives").property((Object)"reason", (Object)"loves fresh breezes", new Object[0]).from("a").next();
                this.g.V(new Object[]{jupiter}).as("a", new String[0]).V(new Object[]{neptune}).addE("brother").from("a").next();
                this.g.V(new Object[]{jupiter}).as("a", new String[0]).V(new Object[]{pluto}).addE("brother").from("a").next();
                this.g.V(new Object[]{neptune}).as("a", new String[0]).V(new Object[]{sea}).addE("lives").property((Object)"reason", (Object)"loves waves", new Object[0]).from("a").next();
                this.g.V(new Object[]{neptune}).as("a", new String[0]).V(new Object[]{jupiter}).addE("brother").from("a").next();
                this.g.V(new Object[]{neptune}).as("a", new String[0]).V(new Object[]{pluto}).addE("brother").from("a").next();
                this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{jupiter}).addE("father").from("a").next();
                this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{alcmene}).addE("mother").from("a").next();
                if (this.supportsGeoshape) {
                    this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{nemean}).addE("battled").property((Object)"time", (Object)1, new Object[0]).property((Object)"place", (Object)Geoshape.point((double)38.1f, (double)23.7f), new Object[0]).from("a").next();
                    this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{hydra}).addE("battled").property((Object)"time", (Object)2, new Object[0]).property((Object)"place", (Object)Geoshape.point((double)37.7f, (double)23.9f), new Object[0]).from("a").next();
                    this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{cerberus}).addE("battled").property((Object)"time", (Object)12, new Object[0]).property((Object)"place", (Object)Geoshape.point((double)39.0, (double)22.0), new Object[0]).from("a").next();
                } else {
                    this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{nemean}).addE("battled").property((Object)"time", (Object)1, new Object[0]).property((Object)"place", (Object)this.getGeoFloatArray(38.1f, 23.7f), new Object[0]).from("a").next();
                    this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{hydra}).addE("battled").property((Object)"time", (Object)2, new Object[0]).property((Object)"place", (Object)this.getGeoFloatArray(37.7f, 23.9f), new Object[0]).from("a").next();
                    this.g.V(new Object[]{hercules}).as("a", new String[0]).V(new Object[]{cerberus}).addE("battled").property((Object)"time", (Object)12, new Object[0]).property((Object)"place", (Object)this.getGeoFloatArray(39.0f, 22.0f), new Object[0]).from("a").next();
                }
                this.g.V(new Object[]{pluto}).as("a", new String[0]).V(new Object[]{jupiter}).addE("brother").from("a").next();
                this.g.V(new Object[]{pluto}).as("a", new String[0]).V(new Object[]{neptune}).addE("brother").from("a").next();
                this.g.V(new Object[]{pluto}).as("a", new String[0]).V(new Object[]{tartarus}).addE("lives").property((Object)"reason", (Object)"no fear of death", new Object[0]).from("a").next();
                this.g.V(new Object[]{pluto}).as("a", new String[0]).V(new Object[]{cerberus}).addE("pet").from("a").next();
                this.g.V(new Object[]{cerberus}).as("a", new String[0]).V(new Object[]{tartarus}).addE("lives").from("a").next();
                if (this.supportsTransactions) {
                    this.g.tx().commit();
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                if (!this.supportsTransactions) break block7;
                this.g.tx().rollback();
            }
        }
    }

    protected float[] getGeoFloatArray(float lat, float lon) {
        return new float[]{lat, lon};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readElements() {
        try {
            if (this.g == null) {
                return;
            }
            LOGGER.info("reading elements");
            Optional v = this.g.V(new Object[0]).has("name", (Object)"jupiter").valueMap(true, new String[0]).tryNext();
            if (v.isPresent()) {
                LOGGER.info(((Map)v.get()).toString());
            } else {
                LOGGER.warn("jupiter not found");
            }
            Optional edge = this.g.V(new Object[0]).has("name", (Object)"hercules").outE(new String[]{"battled"}).as("e", new String[0]).inV().has("name", (Object)"hydra").select("e").valueMap(true, new String[0]).tryNext();
            if (edge.isPresent()) {
                LOGGER.info(((Map)edge.get()).toString());
            } else {
                LOGGER.warn("hercules battled hydra not found");
            }
            List list = this.g.V(new Object[0]).has("age", P.gte((Object)5000)).values(new String[]{"age"}).toList();
            LOGGER.info(list.toString());
            boolean plutoExists = this.g.V(new Object[0]).has("name", (Object)"pluto").hasNext();
            if (plutoExists) {
                LOGGER.info("pluto exists");
            } else {
                LOGGER.warn("pluto not found");
            }
            List brothers = this.g.V(new Object[0]).has("name", (Object)"jupiter").both(new String[]{"brother"}).values(new String[]{"name"}).dedup(new String[0]).toList();
            LOGGER.info("jupiter's brothers: " + brothers.toString());
        }
        finally {
            if (this.supportsTransactions) {
                this.g.tx().rollback();
            }
        }
    }

    public void updateElements() {
        block4: {
            try {
                if (this.g == null) {
                    return;
                }
                LOGGER.info("updating elements");
                long ts = System.currentTimeMillis();
                this.g.V(new Object[0]).has("name", (Object)"jupiter").property((Object)"ts", (Object)ts, new Object[0]).iterate();
                if (this.supportsTransactions) {
                    this.g.tx().commit();
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                if (!this.supportsTransactions) break block4;
                this.g.tx().rollback();
            }
        }
    }

    public void deleteElements() {
        block4: {
            try {
                if (this.g == null) {
                    return;
                }
                LOGGER.info("deleting elements");
                this.g.V(new Object[0]).has("name", (Object)"pluto").drop().iterate();
                if (this.supportsTransactions) {
                    this.g.tx().commit();
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                if (!this.supportsTransactions) break block4;
                this.g.tx().rollback();
            }
        }
    }

    public void runApp() {
        try {
            this.openGraph();
            if (this.supportsSchema) {
                this.createSchema();
            }
            this.createElements();
            this.readElements();
            for (int i = 0; i < 3; ++i) {
                try {
                    Thread.sleep((long)(Math.random() * 500.0) + 500L);
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                this.updateElements();
                this.readElements();
            }
            this.deleteElements();
            this.readElements();
            this.closeGraph();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

