/*
 * Decompiled with CFR 0.152.
 */
package org.jamel.kladr.utils;

import org.jamel.kladr.utils.NumberUtils;

public final class KladrCodeUtils {
    private static final byte ZERO = 48;

    private KladrCodeUtils() {
    }

    public static boolean isValid(byte[] code) {
        int len = code.length;
        return code[len - 1] == 48 && code[len - 2] == 48;
    }

    public static byte getRegionId(byte[] code) {
        return (byte)((code[0] - 48) * 10 + (code[1] - 48));
    }

    public static int getDistrictId(byte[] code) {
        return (code[2] - 48) * 100 + (code[3] - 48) * 10 + (code[4] - 48);
    }

    public static int getDistrictCode(byte[] code) {
        return NumberUtils.parseInt(code, 0, 5);
    }

    public static int getCityId(byte[] code) {
        return (code[5] - 48) * 100 + (code[6] - 48) * 10 + (code[7] - 48);
    }

    public static long getCityCode(byte[] code) {
        return NumberUtils.parseLong(code, 0, 8);
    }

    public static int getCountryId(byte[] code) {
        return (code[8] - 48) * 100 + (code[9] - 48) * 10 + (code[10] - 48);
    }

    public static long getCountryCode(byte[] code) {
        return NumberUtils.parseLong(code, 0, 11);
    }

    public static int getStreetId(byte[] code) {
        return (code[11] - 48) * 1000 + (code[12] - 48) * 100 + (code[13] - 48) * 10 + (code[14] - 48);
    }

    public static long getStreetCode(byte[] code) {
        return NumberUtils.parseLong(code, 0, 15);
    }

    public static boolean isCityRegion(byte regionCode) {
        return regionCode == 77 || regionCode == 78 || regionCode == 99;
    }
}

